<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="ametys">

	<xsl:import href="plugin:faq://stylesheets/content/faq/faq-main.xsl"/>	
	
    <xsl:template name="common-content-head-js">
        <script type="text/javascript">
            $j(document).ready(function(){
                $j("#faq-<xsl:value-of select="$uniqueId"/> .toggle .ametys-richtext-title-4").click(function (e) {

                    if ($j(this).next('.expandable-element').is(":visible")) {
                        $j(this).find('.icon-chevron').css('transform', 'rotate(90deg)');
                        $j(this).removeClass('open');
                        $j(this).next('.expandable-element').removeClass('open');
                    } else {
                        $j(this).find('.icon-chevron').css('transform', 'rotate(270deg)');
                        $j(this).addClass('open');
                        $j(this).next('.expandable-element').addClass('open');
                    }

                    $j(this).next('.expandable-element').slideToggle();
                });
            });
        </script>
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
        <!-- Image -->
        <xsl:if test="not($zone = 'default') or not(ametys:pageId())">
            <xsl:call-template name="common-content-body-image-bigsize"/>    
        </xsl:if>
    
        <!-- Rich content -->
        <xsl:call-template name="common-content-body-content-rich"/>
        
        <div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
    
        <div id="faq-{$uniqueId}">
            <!-- FAQ -->
            <xsl:call-template name="faq-details"/>
        </div>
        
        <!-- Comments -->
        <xsl:call-template name="common-content-body-comments"/>     
    </xsl:template>  
    
    <xsl:template name="faq-details">
        <xsl:if test="metadata/questions/entry[question != '']">
            <xsl:call-template name="questions-list-details"/>
        </xsl:if>
    </xsl:template>
    
	<xsl:template name="questions-list-details">
        <div class="toggle">
            <xsl:apply-templates select="metadata/questions/entry[question != '']">
                <xsl:with-param name="prefix" select="concat('content-', @name)"/>
            </xsl:apply-templates>
        </div>      
    </xsl:template>
    
    <xsl:template name="question-anwser">
        <div class="expandable-element">
	        <xsl:call-template name="common-content-body-content-rich">
	        	<xsl:with-param name="content" select="answer"/>
	        	<xsl:with-param name="level" select="2"/>
	        </xsl:call-template>
	      
	        <div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
	        
	        <xsl:call-template name="question-link"/>
	            
	        <xsl:call-template name="question-additionalinfo"/>
        </div>      
        
    </xsl:template>
    
    <xsl:template name="question-title">
        <h3 class="ametys-richtext-title-4"><xsl:value-of select="question"/><i class="fas fa-chevron-down"></i><i class="fas fa-chevron-up"></i></h3>  
    </xsl:template>
    
    <xsl:template match="entry">
    	<xsl:param name="prefix"/>

        <xsl:call-template name="question-title"/>
        
        <xsl:call-template name="question-anwser"/>
    </xsl:template>
	
</xsl:stylesheet>
