<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
            	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
            	xmlns:docbook="http://docbook.org/ns/docbook"
            	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
            	xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
            	xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
            	exclude-result-prefixes="docbook resolver">
    
    <xsl:import href="jobOffer.xsl" />
    <xsl:import href="skin://stylesheets/content/common-abstract.xsl"/> 
    
    <xsl:template name="common-content-body">
        <xsl:choose>
            <xsl:when test="$zone = 'default' or $zone = 'secondary'">
                <div class="ametys-cms-content {$common-content-css-class-name} wrapper">
                    <xsl:call-template name="common-content-body-title"/>
                    <xsl:call-template name="common-content-body-content"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="page-id"><xsl:call-template name="get-page-id" /></xsl:variable>
                <a href="{resolver:resolve('page', $page-id, false)}">
                    <section>
                        <xsl:call-template name="job-tag"/>
                        <xsl:call-template name="job-start-date"/>
                        <xsl:call-template name="job-title"/>
                    </section>
                    <xsl:call-template name="job-closing-date"/>
                </a>     
            </xsl:otherwise>
        </xsl:choose>  
    </xsl:template>
    
    <xsl:template name="job-tag">
        <!-- You can define a tag here (field issue of a reference table for example) -->
        <!-- <span class="tag">Direction des finances publiques</span> -->
    </xsl:template>
    
    <xsl:template name="job-start-date">
        <xsl:if test="metadata/startDate">
            <div class="date-container">
                <xsl:call-template name="dates">
                    <xsl:with-param name="startDate" select="metadata/startDate"/>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-title">
        <span class="title"><xsl:value-of select="metadata/title"/></span>
    </xsl:template>
    
    <xsl:template name="job-closing-date">
        <xsl:if test="metadata/closingDate">
            <span class="excerpt">
                <i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_ABSTRACT_START_DATE" i18n:catalogue="skin.{$skin}"/>
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="metadata/closingDate"/>
                </xsl:call-template>
            </span>
        </xsl:if>
    </xsl:template>

    <xsl:template name="content-default-image">
        <img class="svg" src="{ametys:skinURL('templates/common/img/icon/recherche/emploi.svg')}"/>
    </xsl:template>
    
    <xsl:template name="content-dates">
        <xsl:if test="metadata/closingDate">
            <div class="date-container">
                <xsl:call-template name="dates">
                    <xsl:with-param name="startDate" select="metadata/closingDate"/>
                    <xsl:with-param name="textBefore"><i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_ABSTRACT_START_DATE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
