<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="ametys">

	<xsl:import href="plugin:myfavorites://stylesheets/content/myfavorites/myfavorites-main.xsl"/>	
	<xsl:import href="myfavorites.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">ametys-cms-service kiosque-section</xsl:variable>
	
    <xsl:template name="common-content-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/zone_kiosque.css')}"/>
    </xsl:template>
    
	<xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        
        <xsl:choose>
            <xsl:when test="$template = 'index'">
                <div class="flex-title">
                    <h1 class="service-title"><xsl:value-of select="$title"/></h1>
                    
                    <xsl:if test="$subtitle">
                        <div class="ametys-content-subtitle">
    		           		<xsl:value-of select="$subtitle"/>
    		            </div>
                    </xsl:if>
                </div>
            </xsl:when>
            <xsl:when test="not($zone = 'default') or not(ametys:pageId())">
                <h1 class="ametys-content-title">
                    <xsl:value-of select="$title"/>
                </h1>
                
                <xsl:if test="$subtitle">
                    <div class="ametys-content-subtitle">
    	           		<xsl:value-of select="$subtitle"/>
    	            </div>
                </xsl:if>
            </xsl:when>
        </xsl:choose>
    </xsl:template>	
    
	<xsl:template name="common-content-body-content">
        <xsl:param name="title" select="metadata/title"/>
    
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
    	
    	<xsl:choose>
    		<xsl:when test="$template = 'fullpage' or $template = 'page'">
    			<div class="container">
    				<xsl:call-template name="entries"/>
    			</div>
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:call-template name="entries"/>
    		</xsl:otherwise>
    	</xsl:choose>
        
		<script type="text/javascript">
	        var owlKiosque = $j('#kiosk-<xsl:value-of select="$uniqueId"/>').owlCarousel({
	            loop: false,
	            margin: 10,
	            nav: false,
	            dots: true,
	            slideBy: 1,
	            autoplayHoverPause: true,
	            autoplayTimeout: 2000,
	            autoplayHoverPause: true,
	            responsive: {
	                0: {
	                    items: 1,
	                    slideBy: 1
	                },
	                500: {
	                    items: 2,
	                    slideBy: 1
	                },
	                700: {
	                    items: 3,
	                    slideBy: 1
	                },
	                1024: {
	                    items: 5,
	                    slideBy: 1
	                }
	            }
	        })
	    </script>
    </xsl:template>	
	
</xsl:stylesheet>
