<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:text="http://ametys.org/text/3.0"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              exclude-result-prefixes="docbook"
                              extension-element-prefixes="text resolver ametys">

	
   <xsl:template match="entry"> 
		<div>
	       	<xsl:attribute name="class">kioske-item item</xsl:attribute>
			<a onclick="window.open(this.href); return false;" href="{url}" title="{link-title}">
	            <xsl:apply-templates select="." mode="image"/>
                <xsl:apply-templates select="." mode="icon"/>
	        </a>
		</div>
	</xsl:template>	
    
    <xsl:template match="entry" mode="image">
        <xsl:choose>
            <xsl:when test="link-illustration/link-image">
                <img src="{resolver:resolveCroppedImage(link-illustration/link-image/@type, link-illustration/link-image/@path, 204, 144)}" width="144" height="204" alt="{link-illustration/link-alt-text}" class="thumbnail"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="default-image"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template> 
    
    <xsl:template name="default-image">
        <div class="thumbnail"/>
    </xsl:template>
    
    <xsl:template match="entry" mode="icon">
        <svg xmlns="http://www.w3.org/2000/svg" width="34.937" height="35" viewBox="0 0 34.937 35">
          <defs>
            <style>
              .cls-1 {
                fill: #0896a7;
                fill-rule: evenodd;
              }
            </style>
          </defs>
          <path id="icon-play" class="cls-1" d="M470.278,2118.99a0.48,0.48,0,0,1-.21.2c-1.073.6-1.867,1.06-2.38,1.36a0.3,0.3,0,0,1-.28.09,0.587,0.587,0,0,1-.21-0.26l-0.14-.39c-0.14-.35-0.233-0.61-0.28-0.77a18.772,18.772,0,0,1-.91-6.51,16.638,16.638,0,0,1,.525-3.78,16.821,16.821,0,0,1,4.06-7.35,17.34,17.34,0,0,1,10.465-5.46,1.907,1.907,0,0,1,.508-0.05,0.179,0.179,0,0,1,.157.14,2.523,2.523,0,0,1,.035.54c0,1.07.012,1.88,0.035,2.42a0.342,0.342,0,0,1-.35.38,13.371,13.371,0,0,0-5.407,1.96,14.353,14.353,0,0,0-4.183,3.99,13.347,13.347,0,0,0-2.205,5.29,13.7,13.7,0,0,0,.735,7.91A0.463,0.463,0,0,1,470.278,2118.99Zm29.19,1.14a1.21,1.21,0,0,1-.315.53,1.393,1.393,0,0,1-.6-0.21q-1.4-.84-2.1-1.23a0.348,0.348,0,0,1-.192-0.21,0.549,0.549,0,0,1,.052-0.28,13.7,13.7,0,0,0,1.033-5.67,14.09,14.09,0,0,0-1.33-5.6,13.729,13.729,0,0,0-3.448-4.58,13.965,13.965,0,0,0-7.245-3.33,0.347,0.347,0,0,1-.262-0.12,0.629,0.629,0,0,1-.053-0.3,26.446,26.446,0,0,0,0-2.73,0.385,0.385,0,0,1,.088-0.31,0.377,0.377,0,0,1,.3-0.04l1.26,0.21a19.36,19.36,0,0,1,6.055,2.52,17.368,17.368,0,0,1,6.755,21.35h0Zm-2.012,3.68a0.411,0.411,0,0,1-.123.28l-0.805.98a19.242,19.242,0,0,1-5.215,3.95,17.951,17.951,0,0,1-3.535,1.44,17.434,17.434,0,0,1-18.34-6.27,1.754,1.754,0,0,1-.28-0.44,0.2,0.2,0,0,1,.053-0.21,2.827,2.827,0,0,1,.437-0.29l2.1-1.19a0.344,0.344,0,0,1,.245-0.09,0.436,0.436,0,0,1,.245.19,13.345,13.345,0,0,0,4.375,3.73,14.245,14.245,0,0,0,5.513,1.64,13.542,13.542,0,0,0,5.687-.68,13.839,13.839,0,0,0,6.545-4.58,0.331,0.331,0,0,1,.21-0.16,0.464,0.464,0,0,1,.28.09c0.513,0.32,1.307.79,2.38,1.4A0.368,0.368,0,0,1,497.456,2123.81Zm-23.573-16.07a10.8,10.8,0,0,1,4.13-3.83,11.034,11.034,0,0,1,10.8.12,10.846,10.846,0,0,1-.1,18.99,10.838,10.838,0,0,1-5.373,1.35,10.727,10.727,0,0,1-5.425-1.39,10.912,10.912,0,0,1-4.06-3.83,10.778,10.778,0,0,1-1.575-5.7,10.615,10.615,0,0,1,1.61-5.71h0Zm6.335,11.69,9.485-5.84q-2.7-1.62-7.98-4.87c-0.677-.42-1.178-0.73-1.5-0.94v11.65Z" transform="translate(-465.875 -2096.06)"/>
        </svg>
    </xsl:template> 
	
	<xsl:template name="entries"> 
        <xsl:if test="metadata/link/entry[url != '']">
            <div id="kiosk-{$uniqueId}" class="kioske owl-carousel">
                <xsl:apply-templates select="metadata/link/entry[url != '']"/>
            </div>
        </xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
