<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2017 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="ametys docbook">

    <xsl:import href="plugin:user-directory://stylesheets/content/udorgunit/udorgunit-main.xsl"/>  

    <xsl:template name="common-content-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/page_orgunit.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-content-body-title-content"/>
    
    <xsl:template name="common-content-body-content">
    
        <xsl:if test="not(ametys:pageId())">
            <h1 class="ametys-richtext-title-1"><xsl:value-of select="metadata/title"/></h1>
        </xsl:if>
        
        <xsl:variable name="truelevel">
            <xsl:choose>
                <xsl:when test="not(ametys:pageId())">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>   
            
        <xsl:call-template name="main-users">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>    
        
        <xsl:call-template name="orgUnit-presentation" />
        
        <xsl:call-template name="child-orgUnits">
             <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        <xsl:call-template name="other-users">
             <xsl:with-param name="truelevel" select="$truelevel"/>
             <xsl:with-param name="metadataSetName" select="'abstract'"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="main-users-list" >
        <xsl:param name="metadataSetName">abstract</xsl:param>
        <xsl:param name="truelevel"/>
        
        <xsl:for-each select="//users/user[@role and @metadataSetName=$metadataSetName]">
                <xsl:call-template name="main-user">
                    <xsl:with-param name="truelevel" select="$truelevel"/>
                </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="main-user">
        <xsl:param name="truelevel"/>
        
        <div class="main-user">
            <span class="role"><xsl:value-of select="@role"/></span>
            <xsl:call-template name="content">
                <xsl:with-param name="content" select="content"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="child-orgUnits-title">
        <xsl:param name="truelevel"/>
        <xsl:element name="h{$truelevel}">
            <xsl:attribute name="class">ametys-richtext-title-<xsl:value-of select="$truelevel"/></xsl:attribute>
            <i18n:text i18n:key="PLUGINS_USER_DIRECTORY_CONTENT_TYPE_ORGUNIT_DISPLAY_TITLE_LABEL" i18n:catalogue="plugin.user-directory"/>
        </xsl:element>
    </xsl:template>
    
    <xsl:template name="child-orgUnits-list">
        <xsl:param name="truelevel"/>
        <ul class="child-orgUnits-list">
            <xsl:for-each select="//orgUnits/orgUnit">
                <li>
                    <xsl:attribute name="class"><xsl:call-template name="common-utils-class"/></xsl:attribute>
                    <i class="fas fa-chevron-right"></i>
                    <xsl:call-template name="content">
                        <xsl:with-param name="content" select="content"/>
                        <xsl:with-param name="level" select="$truelevel + 1"/>
                    </xsl:call-template>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name="other-users-title" >
        <xsl:param name="truelevel"/>
        <xsl:element name="h{$truelevel}">
            <xsl:attribute name="class">ametys-richtext-title-<xsl:value-of select="$truelevel"/></xsl:attribute>
           <i18n:text i18n:key="PLUGINS_USER_DIRECTORY_CONTENT_TYPE_ORGUNIT_USERS_DISPLAY_TITLE_LABEL" i18n:catalogue="plugin.user-directory"/>
        </xsl:element>
    </xsl:template>
    
    <xsl:template name="other-users-list" >
        <xsl:param name="truelevel"/>
        <xsl:param name="metadataSetName"/>
                
        <ul class="other-users-list test">
            <xsl:for-each select="//users/user[not(@role) and @metadataSetName=$metadataSetName]">
                <li>
                    <xsl:attribute name="class"><xsl:call-template name="common-utils-class"/></xsl:attribute>
                    <xsl:call-template name="content">
                        <xsl:with-param name="content" select="content"/>
                        <xsl:with-param name="level" select="$truelevel + 1"/>
                    </xsl:call-template>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
</xsl:stylesheet>