<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	            xmlns:datetime="http://ametys.org/datetime/4.2"
                xmlns:dateutils="org.ametys.core.util.DateUtils"
	            extension-element-prefixes="datetime dateutils ametys">
   
   <xsl:import href="plugin:core://stylesheets/helper/datetime.xsl"/>
   
   <xsl:variable name="date-time-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_DATE_TIME_FORMAT'))"></xsl:variable>
   <xsl:variable name="date-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_DATE_FORMAT'))"></xsl:variable>
   
   <xsl:template name="dates">
        <xsl:param name="startDate"/>
        <xsl:param name="endDate"/>
        <xsl:param name="textBefore"/>
        
        <xsl:if test="$startDate or $endDate">
            <xsl:call-template name="dates-icon"/>
            
            <span class="date">
                <xsl:copy-of select="$textBefore"/>
	            <xsl:call-template name="dates-inner">
                    <xsl:with-param name="startDate" select="$startDate"/>
                    <xsl:with-param name="endDate" select="$endDate"/>
                </xsl:call-template>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="dates-inner">
        <xsl:param name="startDate"/>
        <xsl:param name="endDate"/>
        
        <xsl:choose>
            <xsl:when test="$startDate and not($endDate)">
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="$startDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$endDate and not($startDate)">
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="$endDate"/>
                    <xsl:with-param name="role" select="'dtend'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$startDate and $endDate and datetime:sameDateTime($startDate, $endDate)">
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="$startDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$startDate and $endDate">
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="$startDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
                </xsl:call-template>
                <xsl:call-template name="date-separator"/>
                <xsl:call-template name="date-pattern">
                    <xsl:with-param name="date" select="$endDate"/>
                    <xsl:with-param name="role" select="'dtend'"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="dates-icon">
        <svg version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg"
             xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
             viewBox="0 0 512 492" style="enable-background:new 0 0 512 492;"
             xml:space="preserve">
            <g>
                <defs>
                    <rect id="SVGID_1_" width="512" height="492" />
                </defs>
                <clipPath id="SVGID_2_">
                    <use xlink:href="#SVGID_1_" style="overflow:visible;" />
                </clipPath>
                    <path class="st0" d="M452,0H60C26.9,0,0,26.9,0,60v332c0,44.1,35.9,80,80,80h226c11,0,20-9,20-20c0-11-9-20-20-20H80
                    c-22.1,0-40-17.9-40-40V121h432v184c0,11,9,20,20,20c11,0,20-9,20-20V60C512,26.9,485.1,0,452,0 M371,40c11,0,20,9,20,20
                    c0,11-9,20-20,20c-11,0-20-9-20-20C351,49,360,40,371,40 M471,60c0,11-9,20-20,20c-11,0-20-9-20-20c0-11,9-20,20-20
                    C462,40,471,49,471,60 M40,60c0-11,9-20,20-20h254.4c-2.2,6.3-3.4,13-3.4,20c0,7.4,1.3,14.5,3.8,21H40V60z M384.9,279.8
                    c-2.3-2.3-5.2-4.1-8.3-5l-78.7-23.9c-7-2.1-14.6-0.3-19.8,4.8c-5.2,5.1-7.3,12.6-5.3,19.7l22.4,80.7c0.9,3.3,2.7,6.4,5.1,8.8
                    l109.4,109.6c11.7,11.7,27.1,17.5,42.4,17.5c15.4,0,30.7-5.9,42.4-17.5c23.4-23.4,23.4-61.5,0-84.8L384.9,279.8z M321,299.7
                    l39.1,11.9l73.9,74.1L405.7,414l-73.5-73.7L321,299.7z M466.1,446.1c-7.8,7.8-20.5,7.8-28.3,0l-3.9-3.9l28.3-28.3l3.9,3.9
                    C473.9,425.7,473.9,438.3,466.1,446.1" />
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="date-pattern">
        <xsl:param name="date"/>
        <xsl:param name="role"/>
        
        <xsl:if test="$role = 'dtstart' or $role = 'dtend'">
            <span class="value-title" title="{$date}"></span>
        </xsl:if>
        
        <xsl:choose>
            <xsl:when test="dateutils:isAtMidnight($date, '')">
                <!-- If hour is 00:00 do not display hours -->
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-format}" value="{$date}"/>
            </xsl:when>
            <xsl:otherwise>
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{$date}"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="date-separator">
        <xsl:text>&#160; > &#160;</xsl:text>
    </xsl:template>             
</xsl:stylesheet>