<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:math="java.lang.Math" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:str="http://exslt.org/strings"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                exclude-result-prefixes="xalan math str ametys resolver user">  
    
    <xsl:import href="skin://stylesheets/search.xsl"/>
    <xsl:import href="skin://stylesheets/menus.xsl"/>
    <xsl:import href="plugin:link-directory://pages/services/directory/utils/thumbnails_utils.xsl"/>
           
    <xsl:template name="header">
        <header>
            <xsl:call-template name="header-class"/>
            <div class="main">
                
                <xsl:call-template name="header-logo"/>
                
                <xsl:call-template name="header-sticky-mode"/>
                
                <xsl:call-template name="search-form"/>
                
                <xsl:call-template name="notifications-links"/>
            </div>
            
            <xsl:call-template name="header-menu"/>
        </header>
    </xsl:template>  
    
    <xsl:template name="header-class">
        <xsl:attribute name="class">header</xsl:attribute>
    </xsl:template>       
    
    <xsl:template name="header-logo">
        <div class="logo">
            <a href="{$site-uri-prefix}/{$lang}/index.html">
                <img src="{ametys:skinURL('templates/common/img/logo-colorful.svg')}" class="logo" alt="{ametys:siteParameter('title')}" />
            </a>
        </div>   
    </xsl:template>     
    
    <xsl:template name="header-sticky-mode">
        <div class="sticky-copy"></div>
        <xsl:call-template name="header-sticky-search"/>
    </xsl:template>
    
    <xsl:template name="header-sticky-search">
        <div class="search-fixed" onclick="openSearchFixed()">
	        <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg"
	            xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 310.4 310.4"
	            style="enable-background:new 0 0 310.4 310.4;" xml:space="preserve">
	            <g>
	                <g>
	                    <path d="M273.6,215c49.1-49.1,49.1-129,0-178.1c-49.1-49.1-129-49.1-178.1,0c-41.7,41.7-48,103.6-18.9,152c0,0,2.1,3.5-0.7,6.3
	                   c-16.1,16.1-64.3,64.3-64.3,64.3c-12.8,12.8-15.8,30.7-4.5,42l2,2c11.3,11.3,29.2,8.3,42-4.5c0,0,48.1-48.1,64.1-64.1
	                    c3-3,6.4-0.9,6.4-0.9C170,262.9,231.9,256.6,273.6,215z M118.7,191.7c-36.3-36.3-36.3-95.3,0-131.6c36.3-36.3,95.3-36.3,131.6,0 
	                    c36.3,36.3,36.3,95.3,0,131.6C214,228,155,228,118.7,191.7z" />
	                    <g>
	                        <path
	                            d="M126.8,118.4c-1.7,0-3.4-0.3-5.1-1c-6.6-2.8-9.7-10.4-6.9-17c17.6-41.6,65.7-61.1,107.3-43.5c6.6,2.8,9.7,10.4,6.9,17
	                        c-2.8,6.6-10.4,9.7-17,6.9c-28.4-12-61.2,1.3-73.2,29.7C136.6,115.4,131.8,118.4,126.8,118.4z" /> 
	                    </g>
	                </g>
	            </g>
	        </svg>
        </div>
        
        <script type="text/javascript">
	        function openSearchFixed() {
	            $j(".search-copy").addClass('fixed');
	            $j(".overlay-sticky").addClass('active');
	        }
        </script>
    </xsl:template>
    
    <xsl:template name="notifications-links">
        <ul class="icons">
            <!-- Alerts-->
            <!-- <xsl:call-template name="alerts-mobile"/> -->
            <xsl:call-template name="alerts"/>
            
            <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='notifications']/links/link" mode="notification-link"/>
            
            <li class="icon mobile" onclick="openSecondMobile()">
                <span class="material-icons">menu</span>
            </li>
        </ul>
        <script type="text/javascript">
            function openSecondMobile() {
                $j('.second').addClass('open');
            }
        </script>
    </xsl:template>
    
    <xsl:template name="alertes-icon">
        <svg version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg"
             xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 34.3 32.4"
             style="enable-background:new 0 0 34.3 32.4;" xml:space="preserve">
             <g>
                 <defs>
                     <rect id="SVGID_1_" y="0" width="34.3" height="32.4" />
                 </defs>
                 <clipPath id="SVGID_2_">
                     <use xlink:href="#SVGID_1_" style="overflow:visible;" />
                 </clipPath>
                 <path d="M16.5,15.1c-0.4,0-0.7-0.3-0.7-0.7V6.6c0-0.4,0.3-0.7,0.7-0.7c0.4,0,0.7,0.3,0.7,0.7v7.8
                    C17.3,14.8,16.9,15.1,16.5,15.1" />
                 <path d="M33.5,12.6h-3.1c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7h3.1c0.4,0,0.7,0.3,0.7,0.7
                    C34.3,12.3,34,12.6,33.5,12.6" />
                 <path d="M29.8,5.4c-0.3,0-0.6-0.2-0.7-0.6C29,4.4,29.2,4,29.6,3.9l3.1-0.7c0.4-0.1,0.8,0.2,0.9,0.6
                    c0.1,0.4-0.2,0.8-0.6,0.9l-3.1,0.7C29.9,5.4,29.8,5.4,29.8,5.4" />
                 <path d="M32.8,20.5c-0.1,0-0.1,0-0.2,0l-3.1-0.7c-0.4-0.1-0.6-0.5-0.6-0.9c0.1-0.4,0.5-0.6,0.9-0.6L33,19
                    c0.4,0.1,0.6,0.5,0.6,0.9C33.5,20.3,33.2,20.5,32.8,20.5" />
                 <path d="M9.4,32.4c-2.3,0-4.2-1.9-4.2-4.2v-9.9c-1.2-0.2-2.4-0.7-3.3-1.6c-1.3-1.3-2-3-2-4.9C0,9.9,0.7,8.2,2,7
                    c1.1-1.1,2.5-1.7,4-1.7h0c0.9,0,6.3,0.3,9.4,0.6c0.6,0,1.3-0.1,1.8-0.5L24,0.4c0.6-0.4,1.3-0.5,2-0.2c0.7,0.3,1.1,0.9,1.2,1.6
                    c0.9,6.7,0.9,13.5,0,20.2c-0.1,0.7-0.6,1.4-1.2,1.6c-0.7,0.3-1.4,0.2-2-0.2l-6.8-5c-0.5-0.4-1.2-0.6-1.8-0.5l-1.8,0.1v10.3
                    C13.6,30.5,11.7,32.4,9.4,32.4 M6,16.9c0.2,0,0.4,0.1,0.5,0.2c0.1,0.1,0.2,0.3,0.2,0.5v10.6c0,1.5,1.2,2.7,2.7,2.7
                    c1.5,0,2.7-1.2,2.7-2.7V18L10.6,18c-0.4,0-0.8-0.3-0.8-0.7c0-0.4,0.3-0.8,0.7-0.8l4.8-0.2c1-0.1,2,0.2,2.8,0.8l6.8,5
                    c0.2,0.2,0.5,0.1,0.5,0.1c0.1,0,0.3-0.2,0.3-0.5c0.9-6.5,0.9-13.2,0-19.8c0-0.3-0.3-0.4-0.3-0.5c-0.1,0-0.3-0.1-0.6,0.1l-6.8,4.9
                    c-0.8,0.6-1.8,0.9-2.8,0.8C10.1,7,6.6,6.8,5.9,6.8C4.9,6.7,3.9,7.2,3,8c-1,1-1.5,2.3-1.5,3.8c0,1.5,0.5,2.8,1.5,3.8
                    C3.9,16.5,4.9,16.9,6,16.9L6,16.9z" />
                 <path
                     d="M8.5,22H6.4c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7h2.1c0.4,0,0.7,0.3,0.7,0.7C9.3,21.6,8.9,22,8.5,22" />
                 <path d="M12.4,25.1h-2.1c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7h2.1c0.4,0,0.7,0.3,0.7,0.7
                    C13.2,24.8,12.8,25.1,12.4,25.1" />
                 <path
                     d="M8.5,28.3H6.4c-0.4,0-0.7-0.3-0.7-0.7s0.3-0.7,0.7-0.7h2.1c0.4,0,0.7,0.3,0.7,0.7S8.9,28.3,8.5,28.3" />
             </g>
         </svg>
    </xsl:template>
    
    <xsl:template name="alerts">
        <li class="icon alertes_simple" id="mes_alertes">
	        <span class="flex">
	             <xsl:call-template name="alertes-icon"/>
	             
                 <xsl:call-template name="badge"> 
                    <xsl:with-param name="count" select="count(/cms/inputData/Model/alerts/content)"/>
                 </xsl:call-template>
                        
                  <xsl:choose>
                    <xsl:when test="/cms/inputData/Model/alerts/content">
                        <span class="dropdown">
                            
                            <xsl:call-template name="alerts-title"/> 
                            
                            <xsl:for-each select="/cms/inputData/Model/alerts/content">
	                            <span class="link-info-item alert">
	                                <xsl:copy-of select="html/body/node()"/>
	                            </span>
	                        </xsl:for-each>
                            
                            <xsl:call-template name="alerts-all-link"/> 
                        </span>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="alerts-none"/>
                    </xsl:otherwise>
                </xsl:choose>
            </span>
	    </li>
    </xsl:template>
    
    <xsl:template name="alerts-title">
        <span class="link-info-long-value"><i18n:text i18n:key="SKIN_ALERTS_TITLE" i18n:catalogue="skin.{$skin}"/></span>
    </xsl:template>
    
    <xsl:template name="alerts-all-link">
        <xsl:variable name="allalertes" select="ametys:findPagesIdsByTag('ALL_FLASH_INFO')"/>
        <xsl:if test="$allalertes">
            <span>
               <a href="{resolver:resolve('page', $allalertes/@id)}" class="btn">  
                    <span class="plus">+</span>          
                   <span><i18n:text i18n:key="SKIN_ALERTS_ALL_ALERTS" i18n:catalogue="skin.{$skin}"/></span>
               </a>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="alerts-none">
        <span class="dropdown empty">
            <span class="link-info-long-value"><i18n:text i18n:key="SKIN_ALERTS_NO_ALERT" i18n:catalogue="skin.{$skin}"/></span>
        </span>
    </xsl:template>
    
    <xsl:template name="badge">
        <xsl:param name="count">0</xsl:param>
        
        <span class="badge"> 
            <xsl:value-of select="$count"/>
        </span>
    </xsl:template>
    
    <xsl:template name="alerts-mobile">
        <xsl:variable name="allalertes" select="ametys:findPagesIdsByTag('ALL_FLASH_INFO')"/>
        <li class="icon alertes_mobiles" id="mes_alertes">
            <a href="{resolver:resolve('page', $allalertes/@id)}">
                <span class="flex">
                    <xsl:call-template name="alertes-icon"/>
                
                    <xsl:if test="count(/cms/inputData/Model/alerts/content) != 0">
                        <span class="badge"> 
                            <xsl:value-of select="count(/cms/inputData/Model/alerts/content)"/>
                        </span>
                    </xsl:if>
                </span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="header-menu">
        <div class="second-height">
            <div class="second-container">
                <div class="second">
                    <div class="close" onclick="closeSecondMobile()">
                        <span class="material-icons">close</span>
                    </div>
                    
                    <xsl:call-template name="search-form">
                        <xsl:with-param name="cssClass">search</xsl:with-param>
                    </xsl:call-template>
                        
                    <xsl:call-template name="main-menu"/>
                </div>
                <script type="text/javascript">
                    function closeSecondMobile() {
                        $j('.second').removeClass('open');
                    }
                </script>
            </div>
        </div>
    </xsl:template>
    
    <!-- Copy of mode="thumbnail" to change CSS class for li and a -->
    <xsl:template match="link[@url != '' and @isHidden = 'false']" mode="notification-link">
        <xsl:param name="height"/>
        <xsl:param name="width"/>
        <xsl:param name="showThemes"/>
        <xsl:param name="showUrl"/>
        <xsl:param name="showTitle">true</xsl:param>
        <xsl:param name="uniqueId" select="$uniqueId"/>
        
        <li class="icon">
            <xsl:choose>
                <xsl:when test="@urlType = 'PAGE'">
                    <a href="{resolver:resolve('page', @url)}" class="flex">
                         <xsl:call-template name="link-status" />
                    
                         <xsl:call-template name="link-title">
                            <xsl:with-param name="showThemes" select="$showThemes"/>
                            <xsl:with-param name="showUrl" select="$showUrl"/>
                         </xsl:call-template>
                         <xsl:call-template name="link-picture">
                            <xsl:with-param name="height" select="$height"/>
                            <xsl:with-param name="width" select="$width"/>
                         </xsl:call-template>
                         <xsl:call-template name="link-dynamic-info">
                            <xsl:with-param name="uniqueId" select="$uniqueId" />
                         </xsl:call-template>
                    </a>    
                </xsl:when>
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="@disabled">
                            <span class="flex">
                                 <xsl:call-template name="link-title">
                                    <xsl:with-param name="showThemes" select="$showThemes"/>
                                    <xsl:with-param name="showUrl" select="$showUrl"/>
                                 </xsl:call-template>
                                 <xsl:call-template name="link-picture">
                                    <xsl:with-param name="height" select="$height"/>
                                    <xsl:with-param name="width" select="$width"/>
                                 </xsl:call-template>
                            </span>
                        </xsl:when>
                        <xsl:otherwise>
                            <a href="{@url}" onclick="window.open(this.href); return false;" class="flex">
                                 <xsl:call-template name="link-status" />
                            
                                 <xsl:call-template name="link-title">
                                    <xsl:with-param name="showThemes" select="$showThemes"/>
                                    <xsl:with-param name="showUrl" select="$showUrl"/>
                                 </xsl:call-template>
                                 <xsl:call-template name="link-picture">
                                    <xsl:with-param name="height" select="$height"/>
                                    <xsl:with-param name="width" select="$width"/>
                                 </xsl:call-template>
                                 <xsl:call-template name="link-dynamic-info">
                                    <xsl:with-param name="uniqueId" select="$uniqueId" />
                                 </xsl:call-template>
                            </a>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
</xsl:stylesheet>