<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:html="http://www.w3.org/1999/xhtml"
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:forms="org.ametys.plugins.forms.xslt.FormsXSLTHelper"
				xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:docbook="http://docbook.org/ns/docbook" 
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="docbook xlink resolver ametys">
                
    
    <xsl:import href="plugin:web://stylesheets/io/docbook2html.xsl"/>
    
    <!-- Remove pirobox (use fancybox) -->
    <xsl:template name="image-wrapper">
      <xsl:variable name="src-full" select="resolver:resolve(docbook:imagedata/@type, docbook:imagedata/@fileref)"/>

      <span style="display: inline-block; text-align: center" class="image-wrapper {../@class}">
			<span style="display: inline-block; " class="image-container">
                <xsl:choose>
                    <xsl:when test="../@zoomable and not($src-full = '') and not(ancestor::docbook:link)">
                        <a href="{$src-full}" class="js-fancybox" data-fancybox="lightbox-gallery-{$uniqueId}" rel="single" title="{../docbook:caption}" data-overlay-bg="rgba(0, 0, 0, 1)">
                            <xsl:call-template name="image-wrapper-link-attributes"/>
                            <xsl:call-template name="image" />
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="image" />
                    </xsl:otherwise>
                </xsl:choose>          
            </span>
            <xsl:if test="../docbook:caption">
                <br style="clear: both"/>
            
                <span class="legend">
                    <xsl:variable name="width"><xsl:value-of select="substring-before(docbook:imagedata/@width, 'px')" /></xsl:variable>
                    <xsl:attribute name="style">display: inline-block;<xsl:if test="$width != ''"> width: <xsl:value-of select="$width"/>px;</xsl:if></xsl:attribute>
                    
                    <xsl:value-of select="../docbook:caption" />
                </span>
            </xsl:if>
        </span>
    </xsl:template>
    
     <xsl:template match="docbook:article" priority="1000">
    	<xsl:param name="level" select="1"/>
    
        <xsl:apply-templates>
            <xsl:with-param name="level" select="$level"/>
            <xsl:with-param name="localLevel" select="1"/>
        </xsl:apply-templates>
        
        <script type="text/javascript">
            <xsl:if test=".//html:form">
                $j(document).ready(function () {
                    $j(".ametys-cms-content form select:not([multiple])").selectmenu();
                    
                    $j('.ametys-cms-content form select[multiple]').each(function (){
                        var $this = $j(this);
                        $this.multiselect({
                            columns: 4,
                            texts: {
                                placeholder: $this.attr("placeholder") || $this.closest('.field').find('label').text() ||  "<i18n:text i18n:key="SKIN_FORMS_MULTISELECT_DEFAULT_PLACEHOLDER" i18n:catalogue="skin.{$skin}"/>",
                                selectedOptions: ' <i18n:text i18n:key="SKIN_SERVICE_SEARCH_SELECTED_OPTS" i18n:catalogue="skin.{$skin}"/>'
                            }
                        });
                    })
                });
                
                <xsl:if test="//html:input[@type='file']">
                    function form_changeFile($event, id) {
                        var input = $event;
                        var url = $j($event).val()
                        var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
                        var parts = url.split("\\");
                        var fileName = parts[parts.length - 1];
                        $j('.download-' + id).find('label span').html(fileName);
        
                        if(fileName == '') {
                            $j($event).val('');
                            $j('.download-' + id).find('label span').html("<i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/>");
                            $j('.download-' + id).find('.close').fadeOut();
                        } else {
                            $j('.download-' + id).find('.close').fadeIn();
                        }
                    }
        
                    function form_removeFile(e) {
                        const parent = $j(e).parent();
                        $j(parent).find('input').val('');
                        $j(parent).find('label span').html("<i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/>");
                        $j(parent).find('.close').fadeOut();
                    }
                </xsl:if>
            </xsl:if>
        </script>
    </xsl:template>
   
    <xsl:template match="html:input[@type='file']">
        <xsl:variable name="id" select="@id"/>
        <xsl:variable name="label" select="//html:label[@for = $id]"/>
        
        <div class="input download-item download-{$id}">
            <xsl:if test="@width">
                <xsl:attribute name="style">width: <xsl:value-of select="@width"/>px;</xsl:attribute>
            </xsl:if>
                 
            <div class="close" onclick="form_removeFile(this)">
                <span class="material-icons">close</span>
            </div>
            <h2 class="ametys-richtext-title-4">
                <i18n:text i18n:key="SKIN_FORMS_FILE_DOWNLOAD" i18n:catalogue="skin.{$skin}"/>
                <xsl:value-of select="$label" />
                <xsl:if test="@mandatory">
                    <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                </xsl:if>
            </h2>
            <div> 
                <label>
                    <xsl:call-template name="form-input"/>	
                    <xsl:call-template name="download-icon"/>
                    <span><i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/></span>
                </label>
                <script>
                    $j('#<xsl:value-of select="@id"/>').on('change', function(){
                        form_changeFile(this, '<xsl:value-of select="@id"/>')
                    })
                </script>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="download-icon">
        <svg version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512"
                    style="enable-background:new 0 0 512 512;" xml:space="preserve">
                    <g id="Solid">
                        <path
                            d="M239,385c9.4,9.4,24.6,9.4,33.9,0c0,0,0,0,0,0l90.5-90.5c9.4-9.4,9.4-24.6,0-33.9c-9.4-9.4-24.6-9.4-33.9,0L280,310.1V48
c0-13.3-10.7-24-24-24c-13.3,0-24,10.7-24,24v262.1l-49.5-49.5c-9.4-9.4-24.6-9.4-33.9,0c-9.4,9.4-9.4,24.6,0,33.9L239,385z"
                                                fill="#FC7D85" />
                        <path d="M464,232c-13.3,0-24,10.7-24,24v184H72V256c0-13.3-10.7-24-24-24s-24,10.7-24,24v192c0,22.1,17.9,40,40,40h384
c22.1,0,40-17.9,40-40V256C488,242.7,477.3,232,464,232z" fill="#FC7D85" />
                    </g>
                </svg>
    </xsl:template>
    
</xsl:stylesheet>
