<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:math="java.lang.Math"
                            xmlns:exslt="http://exslt.org/common"
                            xmlns:exsl="http://exslt.org/common"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                            xmlns:date="http://exslt.org/dates-and-times"
                            xmlns:stringutils="org.apache.commons.lang.StringUtils"
                            exclude-result-prefixes="sitemap resolver ametys date stringutils exslt">
    
    <xsl:import href="skin://stylesheets/head.xsl" />
    <xsl:import href="skin://stylesheets/zones.xsl" />
    <xsl:import href="skin://stylesheets/header.xsl" />
    <xsl:import href="skin://stylesheets/footer.xsl" />
    <xsl:import href="skin://stylesheets/others.xsl" />
    <xsl:import href="skin://stylesheets/utils.xsl" />
    <xsl:import href="skin://stylesheets/user-menu.xsl" />
    <xsl:import href="skin://stylesheets/menus.xsl" />
    
    <xsl:import href="plugin:link-directory://pages/services/directory/utils/inputdata_utils.xsl"/> 
    
    <xsl:variable name="sitemap" select="/cms/inputData/sitemap"/>
    <xsl:variable name="user" select="ametys:user()"/>
    
    <xsl:template name="template">
        <html class="accessible-on">
            <xsl:call-template name="head"/>
            
            <body>
                <div class="overlay" onclick="closeMenu()"></div>
                <div class="overlay-settings" onclick="closeModalSettings()"></div>
                
                <xsl:call-template name="search-on-scroll"/>
                
                <xsl:call-template name="blocking-alerts"/>
            
                <xsl:call-template name="user-menu"/>
                
                <xsl:call-template name="navinterieur"/>
                    
                <xsl:call-template name="header"/>
                
                <xsl:call-template name="main-zone"/>

                <xsl:call-template name="footer"/>
                
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="blocking-alerts">
        <!-- +
             | Two available modes for blocking alerts 
             | Call "blocking-alerts-banner" for a top banner.  In this mode, alert filters should be configured with "link" view.
             | Call "blocking-alerts-popup" to show alerts in the popup. In this mode, alert filters should be configured with "main" view.
             + -->
        <xsl:call-template name="blocking-alerts-banner"/>
        <!-- <xsl:call-template name="blocking-alerts-popup"/> -->
    </xsl:template>
    
    <!-- + 
         | OTHERS
         + -->
    <xsl:template name="template-title">        
        <h1 class="hidden-L"><xsl:value-of select="/cms/page/@title"/></h1>
    </xsl:template>
    
    
    <xsl:template name="blocking-alerts-banner">
        <xsl:if test="/cms/inputData/Model/blocking-alerts/content">
            <div class="wrapper bandeau-warning" style="display: none;">
                <xsl:for-each select="/cms/inputData/Model/blocking-alerts/content">
                    <div class="bandeau-warning-inner" data-flashinfo-id="{@id}@{@lastModifiedAt}">
                        <xsl:copy-of select="html/body/node()"/>
                    </div>
                </xsl:for-each>
                <div class="bandeau-warning-buttons">
                    <a href="#" class="close" onclick="AmetysFlashInfo.showLater()"><i18n:text i18n:key="SKIN_ALERTS_BANNER_CLOSE" i18n:catalogue="skin.{$skin}" /></a>
                    <a href="#" class="donotshowagain" onclick="AmetysFlashInfo.markAsRead()"><i18n:text i18n:key="SKIN_ALERTS_BANNER_DONOTSHOWAGAIN" i18n:catalogue="skin.{$skin}" /></a>
                </div> 
            </div>
            <script type="text/javascript">
                function hideBanner() {
                    $j('.bandeau-warning').remove();
                    if ($j(window).scrollTop() == 0)
                    {
                        // reposition submenu
                        let secondContainerPosition = $j('.second-container').position();
                        let secondContainerHeight = $j('.second-container').height();
                        let topPosition = secondContainerPosition.top + secondContainerHeight;
                        $j('.submenu').css('top', `${topPosition}px`);
                    }
                }
                
                function showBanner() {
                    $j('.bandeau-warning').show();
                    // reposition submenu
                    let secondContainerPosition = $j('.second-container').position();
                    let secondContainerHeight = $j('.second-container').height();
                    let topPosition = secondContainerPosition.top + secondContainerHeight;
                    $j('.submenu').css('top', `${topPosition}px`);
                }
                
                $j().ready(function() {
                    // Init and show flash info popup
                    AmetysFlashInfo.initialize(".bandeau-warning", showBanner, hideBanner, "<xsl:value-of select="ametys:siteUriPrefix()"/>");
                });
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="blocking-alerts-popup">
        <xsl:if test="/cms/inputData/Model/blocking-alerts/content">
            <div class="flashinfo-popup"  style="display: none;">
                <h2  class="flashinfo-header">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" style="enable-background:new 0 0 34.3 32.4;" viewBox="0 0 34.3 32.4" y="0px" x="0px" id="Calque_1" version="1.1">
                     <g>
                         <defs>
                             <rect height="32.4" width="34.3" y="0" id="SVGID_1_"></rect>
                         </defs>
                         <clipPath id="SVGID_2_">
                             <use style="overflow:visible;" xlink:href="#SVGID_1_"></use>
                         </clipPath>
                         <path d="M16.5,15.1c-0.4,0-0.7-0.3-0.7-0.7V6.6c0-0.4,0.3-0.7,0.7-0.7c0.4,0,0.7,0.3,0.7,0.7v7.8                     C17.3,14.8,16.9,15.1,16.5,15.1"></path>
                         <path d="M33.5,12.6h-3.1c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7h3.1c0.4,0,0.7,0.3,0.7,0.7                     C34.3,12.3,34,12.6,33.5,12.6"></path>
                         <path d="M29.8,5.4c-0.3,0-0.6-0.2-0.7-0.6C29,4.4,29.2,4,29.6,3.9l3.1-0.7c0.4-0.1,0.8,0.2,0.9,0.6                     c0.1,0.4-0.2,0.8-0.6,0.9l-3.1,0.7C29.9,5.4,29.8,5.4,29.8,5.4"></path>
                         <path d="M32.8,20.5c-0.1,0-0.1,0-0.2,0l-3.1-0.7c-0.4-0.1-0.6-0.5-0.6-0.9c0.1-0.4,0.5-0.6,0.9-0.6L33,19                     c0.4,0.1,0.6,0.5,0.6,0.9C33.5,20.3,33.2,20.5,32.8,20.5"></path>
                         <path d="M9.4,32.4c-2.3,0-4.2-1.9-4.2-4.2v-9.9c-1.2-0.2-2.4-0.7-3.3-1.6c-1.3-1.3-2-3-2-4.9C0,9.9,0.7,8.2,2,7                     c1.1-1.1,2.5-1.7,4-1.7h0c0.9,0,6.3,0.3,9.4,0.6c0.6,0,1.3-0.1,1.8-0.5L24,0.4c0.6-0.4,1.3-0.5,2-0.2c0.7,0.3,1.1,0.9,1.2,1.6                     c0.9,6.7,0.9,13.5,0,20.2c-0.1,0.7-0.6,1.4-1.2,1.6c-0.7,0.3-1.4,0.2-2-0.2l-6.8-5c-0.5-0.4-1.2-0.6-1.8-0.5l-1.8,0.1v10.3                     C13.6,30.5,11.7,32.4,9.4,32.4 M6,16.9c0.2,0,0.4,0.1,0.5,0.2c0.1,0.1,0.2,0.3,0.2,0.5v10.6c0,1.5,1.2,2.7,2.7,2.7                     c1.5,0,2.7-1.2,2.7-2.7V18L10.6,18c-0.4,0-0.8-0.3-0.8-0.7c0-0.4,0.3-0.8,0.7-0.8l4.8-0.2c1-0.1,2,0.2,2.8,0.8l6.8,5                     c0.2,0.2,0.5,0.1,0.5,0.1c0.1,0,0.3-0.2,0.3-0.5c0.9-6.5,0.9-13.2,0-19.8c0-0.3-0.3-0.4-0.3-0.5c-0.1,0-0.3-0.1-0.6,0.1l-6.8,4.9                     c-0.8,0.6-1.8,0.9-2.8,0.8C10.1,7,6.6,6.8,5.9,6.8C4.9,6.7,3.9,7.2,3,8c-1,1-1.5,2.3-1.5,3.8c0,1.5,0.5,2.8,1.5,3.8                     C3.9,16.5,4.9,16.9,6,16.9L6,16.9z"></path>
                         <path d="M8.5,22H6.4c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7h2.1c0.4,0,0.7,0.3,0.7,0.7C9.3,21.6,8.9,22,8.5,22"></path>
                         <path d="M12.4,25.1h-2.1c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7h2.1c0.4,0,0.7,0.3,0.7,0.7                     C13.2,24.8,12.8,25.1,12.4,25.1"></path>
                         <path d="M8.5,28.3H6.4c-0.4,0-0.7-0.3-0.7-0.7s0.3-0.7,0.7-0.7h2.1c0.4,0,0.7,0.3,0.7,0.7S8.9,28.3,8.5,28.3"></path>
                     </g>
                 </svg>
                <i18n:text i18n:key="SKIN_ALERTS_POPUP_TITLE" i18n:catalogue="skin.{$skin}" /></h2>
                
                <!-- Iterate over flash info contents -->
                <xsl:for-each select="/cms/inputData/Model/blocking-alerts/content">
                    <div class="flashinfo-content" data-flashinfo-id="{@id}@{@lastModifiedAt}">
                        <xsl:apply-templates select="html/body/node()" mode="move-hierarchy">
                             <xsl:with-param name="level" select="3"/>
                         </xsl:apply-templates>
                    </div>
                </xsl:for-each>
                <div class="flashinfo-bottom">
                    <a href="#" class="btn close" onclick="AmetysFlashInfo.showLater()"><span><i18n:text i18n:key="SKIN_ALERTS_BANNER_CLOSE" i18n:catalogue="skin.{$skin}" /></span></a>
                    <a href="#" class="btn donotshowagain" onclick="AmetysFlashInfo.markAsRead()"><span><i18n:text i18n:key="SKIN_ALERTS_BANNER_DONOTSHOWAGAIN" i18n:catalogue="skin.{$skin}" /></span></a>
                </div>                            
            </div>
            <div class="flashinfo-popup-overlay"></div>
            
            <script type="text/javascript">
                function hideBanner() {
                    $j('.flashinfo-popup').remove();
                    $j('.flashinfo-popup-overlay').remove();
                }
                
                function showBanner() {
                    $j('.flashinfo-popup').show();
                    $j('.flashinfo-popup-overlay').show();
                }
                
                $j().ready(function() {
                    // Init and show flash info popup
                  AmetysFlashInfo.initialize(".flashinfo-popup", showBanner, hideBanner, "<xsl:value-of select="ametys:siteUriPrefix()"/>");
                });
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="header-js">
        <script type="text/javascript">
            
         $j(document).ready(function () {

            var second = $j('.second-container').html();
            var searchHeader = $j('.search-header').html();
            var access = $j('.access').html();

            $j(".sticky-copy").html(second);
            $j(".access-copy").html(access);
            $j(".search-copy form").html(searchHeader).show();
            $j(".search-copy form input[data-renewid]")[0].id += "-copy";
            var f = $j(".search-copy form label[data-renewfor]");
            f.attr("for", f.attr("for") + "-copy");
            
            <xsl:call-template name="quick-access-js"/>
            var position = $j('header.header').offset();
            
            var scroll = $j(window).scrollTop();
            if (scroll >= position.top + 1) {
                $j('header.header').addClass('fixed');
                var issetBandeau = $j('.bandeau-warning');
                var innerHeightHeader = $j('header.header').innerHeight();
                if (issetBandeau.length > 0) {
                    let heightBandeau = $j('.bandeau-warning').height();
                    var paddingTop = innerHeightHeader + heightBandeau;
                    $j('body').css('padding-top', paddingTop + 'px');
                } else {
                    $j('body').css('padding-top', `{$innerHeightHeader}px`);
                }
            
                $j('.bandeau-warning').hide();
                let heightHeader = $j('header.header').height();
                $j('.submenu').css('top', `${heightHeader}px`);
            } else {
                setTimeout(function () {
                    $j('header.header').removeClass('fixed');
                    $j('body').css('padding-top', '0px');
                    $j('.bandeau-warning').show();
            
                    let secondContainerPosition = $j('.second-container').position();
                    let secondContainerHeight = $j('.second-container').height();
                    let topPosition = secondContainerPosition.top + secondContainerHeight;
                    $j('.submenu').css('top', `${topPosition}px`);
                
                }, 800);
            }
        
            $j(window).scroll(function () {
                var scroll = $j(window).scrollTop();
                if (scroll >= position.top + 1) {
                    $j('header.header').addClass('fixed');
                    var issetBandeau = $j('.bandeau-warning');
                    let heightBandeau = $j('.bandeau-warning').height();
                    let innerHeightHeader = $j('header.header').innerHeight();
                    if (issetBandeau.length > 0) {
                        let heightBandeau = $j('.bandeau-warning').height();
                        var paddingTop = innerHeightHeader + heightBandeau;
                        $j('body').css('padding-top', paddingTop + 'px');
                    } else {
                        $j('body').css('padding-top', ` ${innerHeightHeader}px`);
                    }
            
                    $j('.bandeau-warning').hide();
                    let heightHeader = $j('header.header').height();
                    $j('.submenu').css('top', `${heightHeader}px`);
                } else {
                    $j('header.header').removeClass('fixed');
                    $j('body').css('padding-top', '0px');
                    $j('.bandeau-warning').show();
            
                    let secondContainerPosition = $j('.second-container').position();
                    let secondContainerHeight = $j('.second-container').height();
                    let topPosition = secondContainerPosition.top + secondContainerHeight;
                    $j('.submenu').css('top', `${topPosition}px`);
                }
            });
        });
        </script>
    </xsl:template>
    
    <xsl:template name="quick-access-js"/>
    
    <xsl:template name="search-on-scroll">
        <div class="overlay-sticky" onclick="closeSearch();"></div>
        <div class="search-copy">
            <form action="{resolver:resolve('page', /cms/inputData/sitemap//page[@PLUGIN_TAGS_SEARCH]/@sitemap:id)}" method="post">
            </form>
        </div>
        
        <script type="text/javascript">
            function closeSearch() {
                $j(".search-copy").removeClass('fixed');
                $j(".overlay-sticky").removeClass('active');
            }
        </script>
    </xsl:template>
    
    <!-- Pirobox replace by fancybox -->
    <xsl:template name="head-js-pirobox"/>
    <xsl:template name="head-css-pirobox"/>
    
    <xsl:template name="head-css-fancybox">
        <link rel="stylesheet" href="{ametys:skinURL('plugins/fancybox/jquery.fancybox.css')}"/>
    </xsl:template>
    
    <xsl:template name="head-js-fancybox">
        <script src="{ametys:skinURL('plugins/fancybox/jquery.fancybox.js')}"></script>
        <script type="text/javascript">
          $j(document).on('ready', function () {
            $j('.js-fancybox').fancybox();
          });
        </script>
    </xsl:template>
    
</xsl:stylesheet>
