<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">
	
    
    <xsl:template name="main-menu">
		<xsl:if test="/cms/inputData/sitemap/page[@PLUGIN_TAGS_SECTION and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
			<a name="menu"></a>
			
            <ul>
                <xsl:apply-templates select="/cms/inputData/sitemap/page[@PLUGIN_TAGS_SECTION and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]" mode="menu-item-level1"/>
			
                <!-- Quick access for mobile -->
                <div class="access-copy"></div>
            </ul>
            
            <xsl:call-template name="main-menu-js"/>
		</xsl:if>
	</xsl:template>
    
    <xsl:template match="page" mode="menu-item-level1">
        <li>
            <xsl:if test="position() = last()"><xsl:attribute name="class">last</xsl:attribute></xsl:if>
        
            <a onclick="return openSubMenuMobile(this)" href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:if test="@sitemap:in-path = 'true'">
                    <xsl:attribute name="class">active</xsl:attribute>
                    <xsl:attribute name="title">skin.<xsl:value-of select="$skin"/>:SKIN_MENU_ACTIVE</xsl:attribute>
                    <xsl:attribute name="i18n:attr">title</xsl:attribute>
                </xsl:if>
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes">
                        <xsl:with-param name="title" select="@sitemap:title"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:value-of select="@sitemap:title" />
            </a>
                    
            <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                <div class="submenu">
                     <div class="close" onclick="closeSubMenuMobile(this)">
                        <span class="material-icons">close</span>
                    </div>
                    <!-- Repeat main section for mobile -->
                     <div class="section-title"> 
                        <a class="" href="{resolver:resolve('page', @sitemap:id)}">
                            <xsl:value-of select="@sitemap:title" />
                        </a>
                     </div>
                     <div class="container">
                        <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="menu-item-level2"/>
                    </div>  
                </div>
            </xsl:if>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="menu-item-level2">
        <ul>
            <li class="title">
                <a href="{resolver:resolve('page', @sitemap:id)}">
                    <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                        <xsl:call-template name="external-link-attributes">
                            <xsl:with-param name="title" select="@sitemap:title"/>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:apply-templates select="." mode="menu-item-level2-icon"/>
                    <span><xsl:value-of select="@sitemap:title" /></span>
                </a>
            </li>
            
            <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="menu-item-level3"/>
        </ul>
    </xsl:template>
    
    <xsl:template match="page" mode="menu-item-level2-icon">
        <svg xmlns="http://www.w3.org/2000/svg"
             xmlns:xlink="http://www.w3.org/1999/xlink" width="45.312" height="32.78"
             viewBox="0 0 45.312 32.78">
            <defs>
                <filter id="filter" filterUnits="userSpaceOnUse">
                    <feFlood result="flood" flood-color="#fff" />
                    <feComposite result="composite" operator="in" in2="SourceGraphic" />
                    <feBlend result="blend" in2="SourceGraphic" />
                </filter>
            </defs>
            <g id="FLECHE">
                <path id="Rectangle_arrondi_15" data-name="Rectangle arrondi 15"
                    d="M281.062,1213.33a2.307,2.307,0,0,1,3.276,0l12.283,12.28a2.318,2.318,0,1,1-3.276,3.28l-12.283-12.29A2.31,2.31,0,0,1,281.062,1213.33Z"
                    transform="translate(-253.5 -1211.16)" />
                <path id="Rectangle_arrondi_15_copie"
                    data-name="Rectangle arrondi 15 copie"
                    d="M279.505,1238.48l12.283-12.28a2.318,2.318,0,0,1,3.276,3.28l-12.284,12.28A2.318,2.318,0,0,1,279.505,1238.48Z"
                    transform="translate(-253.5 -1211.16)" />
                <circle cx="20.031" cy="16.655" r="4.125" />
                <circle id="Ellipse_2_copie" data-name="Ellipse 2 copie" cx="5.625"
                    cy="16.655" r="4.125" />
            </g>
        </svg>
    </xsl:template>
        
	<xsl:template match="page" mode="menu-item-level3">
        <li>
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes">
                        <xsl:with-param name="title" select="@sitemap:title"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:apply-templates select="." mode="menu-item-level3-icon"/>
                <span><xsl:value-of select="@sitemap:title" /></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="menu-item-level3-icon"/>
    
    <xsl:template name="navinterieur">
    
        <xsl:call-template name="nav-burger"/>
    
        <div class="navinterieur-menu">
            <div class="close" onclick="closeNavInterieur()"> <img src="{ametys:skinURL('templates/common/img/icon/close.svg')}" alt="close" /></div>
            
            <section class="first">
                <xsl:apply-templates select="/cms/inputData/sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]" mode="navinterieur"/>
            </section>
        </div>
    
        <xsl:call-template name="navinterieur-js"/>
    </xsl:template>
    
    <!-- Menu nav intérieur -->
    <xsl:template match="page" mode="navinterieur">
        <xsl:param name="level">2</xsl:param>
        
        <div>
            <xsl:attribute name="class">
                <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">has-submenu</xsl:if>
            </xsl:attribute>
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:attribute name="class">
                    <xsl:if test="@sitemap:current='true'">current</xsl:if>
                </xsl:attribute>
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes">
                        <xsl:with-param name="title" select="@sitemap:title"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:value-of select="@sitemap:title" />
                
                <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                    <div class="chevron">
                       <img src="{ametys:skinURL('templates/common/img/icon/chevron.svg')}" alt="chevron" />
                    </div>
                </xsl:if>
            </a>
        </div>
        
        <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
            <section class="level-{$level}">
                <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="navinterieur">
                    <xsl:with-param name="level" select="$level+1"/>
                </xsl:apply-templates>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="nav-burger">
        <xsl:if test="not(ametys:renderingContext() = 'back')">
	        <div class="navinterieur-link" onclick="openNavInterieur()">
	            <i class="fas fa-bars"></i>
	            <span class="navinterieur-link__menu"><i18n:text i18n:key="SKIN_NAV_INTERIEUR_MENU" i18n:catalogue="skin.{$skin}"/></span>
	            <span class="navinterieur-link__descri"><i18n:text i18n:key="SKIN_NAV_INTERIEUR_EXPLORER" i18n:catalogue="skin.{$skin}"/></span>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="navinterieur-js">
        <script type="text/javascript">
             $j(function () {
                const current = $j('.navinterieur-menu .current');
                if (current.length &gt; 0) {
                    const $section = current.parent().parent();
                    
                    if ($section.hasClass('first'))
                    {
                        let previousSubmenu = current.closest('.has-submenu');
                        previousSubmenu.addClass('open');
                        previousSubmenu.next('section').show();
                    }
                    else
                    {
                        const levelClass = $section.attr('class');
                        const [level, number] = levelClass.split('-');
                        let previousSubmenu;
                        previousSubmenu = $section.prev();
                        previousSubmenu.addClass('open');
                        previousSubmenu.next('section').show();
        
                        for (let i = number; i &gt; 1; i--) {
                            previousSubmenu = previousSubmenu.parent().prev();
                            previousSubmenu.addClass('open');
                            previousSubmenu.next('section').show();
                        }
                    }
                    
                }
            });
            
            $j('.navinterieur-menu .has-submenu .chevron').click(function (e) {
                e.preventDefault();
    
                var $parent = $j(this).closest('.has-submenu');
                
                if ($parent.hasClass('open')) {
                    $parent.removeClass('open');
                    $parent.next('section').hide();
                    $parent.children('section').hide();
                } else {
                    $parent.parent().find('section').hide();
                    $parent.parent().find('div').removeClass('open');
    
                    $parent.addClass('open');
                    $parent.next('section').show();
    
                }
            });
    
            function openNavInterieur() {
                $j('.overlay').addClass('active');
                $j('.navinterieur-menu').addClass('open');
            }
    
            function closeNavInterieur() {
                $j('.overlay').removeClass('active');
                $j('.navinterieur-menu').removeClass('open');
            }
        </script>
    </xsl:template>
    
    <xsl:template name="main-menu-js">
        <script type="text/javascript">
            function openSubMenuMobile(e) {
                var isMobile = window.innerWidth &lt; 1024;
                if (isMobile)
                {
                    $j(e).next('.submenu').addClass('active');
                    return false;
                }
            }
    
            function closeSubMenuMobile(e) {
                $j(e).parent().removeClass('active');
            }
        </script>
    </xsl:template>
	
</xsl:stylesheet>