<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
				xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
				exclude-result-prefixes="sitemap resolver ametys">

	<!-- + 
	     | BREADCRUMB
	     + -->
	<xsl:template name="breadcrumb">
		<a name="breadcrumb"></a>
		<ul class="breadcrumb">
			<xsl:if test="/cms/inputData/sitemap/page[@sitemap:name = 'index']">
				<li class="first">
					<a href="{$site-uri-prefix}/{$lang}/index.html"><xsl:value-of select="/cms/inputData/sitemap/page[@sitemap:name = 'index']/@sitemap:title"/></a>
					<xsl:call-template name="breadcrumb-separator"/>
				</li>
			</xsl:if>
            
            <xsl:apply-templates select="/cms/inputData/sitemap//page[not(@sitemap:path = 'index') and @sitemap:in-path = 'true']" mode="breadcrumb"/>
		</ul>
	</xsl:template>
    
    <xsl:template name="breadcrumb-separator">
        <span class="delimiter"><xsl:text>&#160;/&#160;</xsl:text></span>
    </xsl:template>
    
    <xsl:template match="page[@sitemap:current = 'true']" mode="breadcrumb">
        <li>
            <span class="noLink"><xsl:value-of select="@sitemap:long-title" /></span>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="breadcrumb">
        <li>
            <a href="{$site-uri-prefix}/{$lang}/{@sitemap:path}.html"><xsl:value-of select="@sitemap:title" /></a>
            <xsl:call-template name="breadcrumb-separator"/>
        </li>
    </xsl:template>
    
    <!-- +
         | QUICK ACCESS
         + -->
    <xsl:template name="quick-access">
        <xsl:choose>
            <xsl:when test="/cms/inputData/linkDirectory[@id='quickAccess']/links/link">
                 <div class="right">
                    <div class="access">
                        <h2 class="service-title"><i18n:text i18n:key="SKIN_QUICK_ACCESS_TITLE" i18n:catalogue="skin.{$skin}"/><br/></h2>
                        
                        <ul>
                            <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='quickAccess']/links/link" mode="quick-access"/>
                        </ul>
                    </div>
                    
                 </div>
            </xsl:when>
            <xsl:when test="$rendering-context = 'back'">
                <div class="right">
                    <div class="access">
                        <span class="empty-hint"><i18n:text i18n:key="SKIN_QUICK_ACCESS_BO_EMPTY" i18n:catalogue="skin.{$skin}"/></span>
                    </div>
                </div>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="link[@urlType='PAGE']" mode="quick-access">
        <li>
            <a href="{resolver:resolve('page', @url)}">
                <xsl:apply-templates select="." mode="quick-access-link-icon"/>
                <xsl:apply-templates select="." mode="quick-access-link-title"/>
            </a>
       </li>
     </xsl:template>
     
     <xsl:template match="link" mode="quick-access">  
        <li>                            
            <a href="{@url}" target="_blank">
                <xsl:apply-templates select="." mode="quick-access-link-icon"/>
                <xsl:apply-templates select="." mode="quick-access-link-title"/>
            </a>
        </li>
    </xsl:template>
     
     <xsl:template match="link" mode="quick-access-link-title">
        <span class="link">
            <xsl:value-of select="@title"/>
        </span>
     </xsl:template>
     
     <xsl:template match="link" mode="quick-access-link-icon">
         <xsl:choose>
            <xsl:when test="@pictureType = 'glyph'">
    			<span class="picture link-glyph {@pictureGlyph}"></span>
    		</xsl:when>
            <xsl:when test="@pictureType != ''">
                <xsl:variable name="id">
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'resource'">
                            <xsl:value-of select="@pictureId"/>
                        </xsl:when>
                        <xsl:when test="@pictureType = 'external'">
                            <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $id, 28, 28)}" alt="{@pictureAlternative}"/>
            </xsl:when>
        </xsl:choose>
     </xsl:template>  
</xsl:stylesheet>
