<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		exclude-result-prefixes="ametys">

	<xsl:import href="skin://stylesheets/main.xsl" />
	
    <xsl:template name="additionnal-script">
        <script type="text/javascript">
            $j(document).ready(function () {
               $j(".login-user-populations select:not([multiple])").selectmenu({ 
                change: function( event, ui ) { 
                    this.onchange();
                }
              });
            });
        </script>
    </xsl:template>
    
    <xsl:template name="additionnal-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/page_connexion.css')}" />
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
    </xsl:template>
    
     <xsl:template name="template">
        <html class="accessible-on">
            <xsl:call-template name="head"/>
            
            <body>
                <xsl:call-template name="main-zone"/>
            </body>
        </html>
    </xsl:template>
    
	<xsl:template name="main-zone">
		<zone name="default" level="1"/>
	</xsl:template>
    
</xsl:stylesheet>