<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="resolver ametys">

    <xsl:import href="skin://welcome/index.xsl"/>
    
    <xsl:template name="welcome-head-title">
        <title>Aide</title>
    </xsl:template>
    
    <xsl:template name="ametys-community">
        <h2>Communauté</h2>
        <p>Ametys est un logiciel OpenSource, n'hésitez pas à suivre l'avancement du projet et à faire part de vos remarques sur :</p>
        <ul>
            <li><a target="_blank" href="http://www.ametys.org/forum">Le forum Ametys</a></li>
            <li><a target="_blank" href="http://docs.ametys.org/">Documentations Ametys</a></li>
            <li><a target="_blank" href="https://issues.ametys.org/browse/CMS">L'outil de suivi d'anomalie ou de demandes d'amélioration (en anglais)</a></li>
        </ul>
        <p>Retrouvez toutes ces informations ainsi que d'autres sur <a target="_blank" href="http://www.ametys.org">www.ametys.org</a>.</p>
    </xsl:template>
    
    <xsl:template name="print">
        <div class="print">
            <a href="javascript:window.print()" title="Imprimer"><i class="fas fa-print"/></a>
        </div>
    </xsl:template>
    
    <xsl:template name="main-presentation">
         <h1>Bienvenue sur Ametys Intranet</h1>
         <p>
            Vous êtes dans l'espace de contribution du site <a target="_blank" href="{$siteUrl}"><b><xsl:value-of select="ametys:siteParameter('title')"/></b></a> utilisant la charte <b><xsl:value-of select="$skin"/></b>.
        </p>
    </xsl:template>
    
    <xsl:template name="get-started">
        <h1>Commencer</h1>
        <p>
            Utilisez l'outil
            <b>
                <i>Plan du site</i>
            </b>
            à gauche pour commencer à créer des pages ou les modifier.
            <br />
            Double-cliquez sur une page pour l'ouvrir.
        </p>
        
        <h1>Besoin d'aide sur une fonction ?</h1>
        <p>Renseignez les mots clés correspondant à la fonction sur laquelle vous souhaitez de l'aide dans la barre de recherche "Recherche une fonctionnalité" du ruban.<br/>
        Utilisez l'aide en ligne en appuyant sur la <strong>touche F1</strong> au survol d'un bouton ou d'un outil, ou en cliquant sur le lien <strong>En savoir plus</strong> de l'info-bulle.</p>
    </xsl:template>
    
    
    <xsl:template name="skin-presentation">
        <h1>Les gabarits</h1>
        <h2>Accueil</h2>
        <div class="flex">
            <img src="{$uri-prefix}/skins/{$skin}/templates/index/resources/thumbnail.png" alt="Page d'accueil"/>
            <div>
                <p>
                    Le gabarit <i>accueil</i> est réservé à la page d'accueil, nommée "index". <br/>
                    Ce gabarit d'accueil est composé de plusieurs lames.<br/>
                    Chaque lame peut contenir un ou deux services de recherche (carousel des actualités, documents, kiosques, offre d'emplois, petites annonces, ...).<br/>
                </p>
                <p>
                    Les autres éléments graphiques qui composent la page d'accueil sont :<br/>
                    <ul>
                        <li><strong>Accès rapides: </strong>liens de l'annuaire avec la thématique "Accès rapide"</li>
                        <li><strong>Liens à la Une: </strong> liens de l'annuaire avec la thématique "A la Une"</li>
                    </ul>
                </p>
            </div>
        </div>
        
        <h2>Page</h2>
        <div class="flex">
            <img src="{$uri-prefix}/skins/{$skin}/templates/page/resources/thumbnail.png" alt="Page"/>
            <div>
                <p>Le gabarit <i>page</i> est utilisé pour la majorité des pages du sites.<br/>
                Il comprend 2 zones centrales et une zone latérale.
                </p>
            </div>
        </div>
        
        <h1>Autres éléments graphiques</h1>
        <h2>Entête</h2>
        <p>Le bandeau d'entête est composé:
            <ul>
                <li>des liens de notifications (liens de l'annuaire avec la thématique "Notification")</li>
                <li>d'un champ de recherche</li>
                <li>de la navigation dans rubriques principales</li>
            </ul>
        </p>
        
        <h2>Pied de page</h2>
        <p>Les liens du pied de page sont constitués des pages étiquetées avec une étiquette de la catégorie <i>Pages spéciales > Pied de page</i></p>
        
        <h1>Les différents types de contenus</h1>
                    
        <h2>Les articles</h2>
        <p>Ils sont utilisés pour la plupart des contenus des pages : Présentation, Contact, Références...</p>
        <h2>Les actualités</h2>
        <p>Les actualités sont utilisées pour les différents évènements :
            nouveautés produits, actualités de toute sorte, manifestations...
        </p>
        <h2>FAQ</h2>
        <p>Le type de contenu "FAQ" est utilisé présenter pour une foire aux questions (liste de questions/réponses)</p>
        <h2>Les documents</h2>
        <p>Les types de contenu "Document" (PDF, video, audio, ...) sont utilisés pour présenter des documents de tout type et construire des kiosques, galeries, ...</p>
    </xsl:template>
    
</xsl:stylesheet>                        
