<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:exsl="http://exslt.org/common"
    xmlns:math="java.lang.Math"
    xmlns:date="http://exslt.org/dates-and-times"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
    xmlns:encoder="java.net.URLEncoder"
    xmlns:event="org.ametys.plugins.calendar.events.EventHelper"
    extension-element-prefixes="resolver exsl math escaper ametys encoder event">
    
    <xsl:import href="plugin:calendar://pages/services/calendar/calendar_1.3.xsl"/>
    
    <xsl:variable name="eventTemplateName">search</xsl:variable>
    <xsl:variable name="nbResultsPerPage">
    	<xsl:choose>
    		<xsl:when test="ametys:serviceViewParameter('nbResultsPerPage') != ''">
    			<xsl:value-of select="ametys:serviceViewParameter('nbResultsPerPage')"/>
    		</xsl:when>
    		<xsl:otherwise>4 <!-- Default value --></xsl:otherwise>
    	</xsl:choose>
	</xsl:variable>
    
    <xsl:variable name="common-service-css-class-name"> events-calendar </xsl:variable>
    
     <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/agenda/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-head-other">
	    <script type="text/javascript" src="{ametys:skinURL('plugins/js/owl-carousel.min.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
    	<xsl:if test="$title != ''">
	    	<div class="flex">
	    		<h1 class="service-title"><xsl:copy-of select="$title"/></h1>
			    <xsl:call-template name="link-top"/>
			</div>
		</xsl:if>
    </xsl:template>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
    	<div class="events-calendar-flex">
	        <!-- Display calendar -->
	        <div class="agenda-datepicker">
                <div class="agenda-datepicker-inside">
	        	  <xsl:call-template name="calendar"/>
                </div>
	        </div>
	        
	        <xsl:if test="$contents-on-same-page = 'true'">
		        <!-- Display events list -->
		    	<div id="day-events-{$uniqueId}" class="agenda-list-carousel">
		    		<div class="agenda-list-owl-carousel owl-carousel events">
		    	
				        <xsl:call-template name="all-news"/>        
				        
				        <!-- If current day has not event, select next events -->
					   	<xsl:call-template name="next-events"/>
					   	
					   	<!-- Display news of the selected date -->
						<xsl:call-template name="news-list"/>
				
					</div>
				</div>
			</xsl:if>
        </div>
        <xsl:call-template name="link-bottom"/>
    </xsl:template>
    
     <!-- Template used for calendar -->
    <xsl:template name="calendar">    
        <div id="calendar-{$uniqueId}" class="calendar"/>
    </xsl:template>
    
    <xsl:template name="next-events">
    	<xsl:variable name="currentDay" select="translate(substring(date:date-time(), 1, 10), '-', '')"/>
    	<xsl:variable name="nextEvents" select="/events/contents/event[translate(@end, '-', '') &gt; $currentDay or translate(@start, '-', '') &gt; $currentDay]"/>
    	
        <div id="next-events-{$uniqueId}">
            <xsl:choose>
                <xsl:when test="$nextEvents">
                     <ul class="list">
                         <xsl:for-each select="$nextEvents">
                            <xsl:sort select="@start" order="ascending"/>
                             <li class="event">
                                  <xsl:copy-of select="view/content/html/body/node()"/>
                             </li>
                         </xsl:for-each>
                     </ul>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="no-next-event"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="no-next-event">
        <div id="no-event-{$uniqueId}" class="no-event"><i18n:text i18n:key="SKIN_SERVICE_CALENDAR_NO_NEXT_EVENT" i18n:catalogue="skin.{$skin}"/></div>
    </xsl:template>
    
    <xsl:template name="display-calendar-js">
    	$j(function() {
            $j("#all-events-<xsl:value-of select="$uniqueId"/>").hide();
            $j("#calendar-<xsl:value-of select="$uniqueId"/>").datepicker({
                <!-- Range -->
                minDate: $j.datepicker.parseDate('yy-mm-dd', '<xsl:value-of select="/events/@start"/>'),
                maxDate: $j.datepicker.parseDate('yy-mm-dd', '<xsl:value-of select="/events/@end"/>'),
                
                <!-- Display dates in other months (non-selectable) -->
                showOtherMonths: true,
                <!-- To select dates in other months -->
                selectOtherMonths: true,
                
                <!-- Date format -->
                dateFormat: 'yy-mm-dd',
                <!-- Event handlers. -->
                beforeShowDay: beforeShowDay<xsl:value-of select="$uniqueId"/>,
                
                <!-- OVERRIDDEN -->
                <xsl:choose>
                	<xsl:when test="$contents-on-same-page = 'true'">onSelect: onSelectCatch<xsl:value-of select="$uniqueId"/></xsl:when>
                	<xsl:otherwise>onSelect: onSelect<xsl:value-of select="$uniqueId"/></xsl:otherwise>
                </xsl:choose>
                
            });
        });
        
        function onSelectCatch<xsl:value-of select="$uniqueId"/>() {
        	var div = $j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel')[0].outerHTML;
        	    div = div.substring(0, div.indexOf('>') + 1) + "&lt;ul class=\"list\">&lt;/ul>&lt;/div>"
			var kar = $j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel')
						.after(div)
						.remove();
						
        	onSelect<xsl:value-of select="$uniqueId"/>.apply(this, arguments);
        	
			orderNews<xsl:value-of select="$uniqueId"/>();
        }
        
        $j().ready(function() {
      		$j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel #all-events-<xsl:value-of select="$uniqueId"/>').insertBefore('.agenda-list-owl-carousel');
      		$j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel #next-events-<xsl:value-of select="$uniqueId"/>').insertBefore('.agenda-list-owl-carousel').hide();
            $j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel script').remove();
        	onSelectCatch<xsl:value-of select="$uniqueId"/>("<xsl:value-of select='substring(date:date-time(), 1, 10)'/>");
        });
        
         function orderNews<xsl:value-of select="$uniqueId"/>() {
                let countA = $j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel a').length;
                
                // If no results for current day, displays next events
                if (countA == 0)
                {
                    // show next events
                    $j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel').show();
                    
                    let countNextEvents = $j("#next-events-<xsl:value-of select="$uniqueId"/> ul li").length;
                    if (countNextEvents == 0)
                    {
                        // No next event
                        $j("#no-event-<xsl:value-of select="$uniqueId"/>").appendTo($j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel'));
                    }
                    else
                    {
                        $j("#next-events-<xsl:value-of select="$uniqueId"/> ul li").appendTo($j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel ul'));
                        countA = $j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel a').length;
                    }
                }
                
                let nbItems = Math.ceil(countA / <xsl:value-of select="$nbResultsPerPage"/>);

                for (i = 0; i &lt; nbItems; i++) {
                        $j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel').append(`&lt;div class="item" data-item="${i}"&gt;&lt;/div&gt;`)
                    }

                let count = 0;
                $j("#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel a")
                        .each(function () {
                            count++;
                            let itemNumber = Math.ceil(count / <xsl:value-of select="$nbResultsPerPage"/>);
                            $j(this).appendTo(
                                `#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel .item:nth-of-type(${itemNumber})`)

                        });

                        $j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel ul').remove();
                    
                     var owl = $j('#day-events-<xsl:value-of select="$uniqueId"/> .agenda-list-owl-carousel').owlCarousel({
                        loop: true,
                        margin: 10,
                        nav: false,
                        autoplay: false,
                        dots: true,
                        responsive: {
                            0: {
                                items: 1
                            }
                        }
                    })
            };
    </xsl:template>
    
    <!-- Template used to display "all news" on the top -->        
    <xsl:template name="link-top">
    	<xsl:call-template name="link"/>
    </xsl:template>
    
    <!-- Template used to display "all news" on the bottom : with linkCssClass : btn white -->
    <xsl:template name="link-bottom">
<!--     	<xsl:call-template name="link"> -->
<!--     		<xsl:with-param name="linkCssClass">btn white</xsl:with-param> -->
<!--     	</xsl:call-template> -->
    </xsl:template>
    
    <xsl:template name="link">
    	<xsl:param name="linkCssClass">btn</xsl:param>
    	
        <xsl:if test="starts-with($link, 'page://')">
            <xsl:variable name="url" select="resolver:resolve('page', $link)"/>
            <xsl:if test="$url != ''">
                <div class="link">
                    <a href="{$url}" class="{$linkCssClass}">
                    	<span class="plus" aria-hidden="true">+</span>
                    	<span>
                          <xsl:choose>
                            <xsl:when test="$link-title != ''">
                                <xsl:value-of select="$link-title"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="ametys:pageTitle($link)"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </span>
                    </a>
                </div>
            </xsl:if>
        </xsl:if>    
    </xsl:template>
    
</xsl:stylesheet>
