<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="ametys resolver">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <xsl:variable name="is-empty" select="count(/subscriptions/subscription) = 0"/>    
    
    <!-- Refresh delay for unread pages -->
    <xsl:variable name="pageFollowRefreshDelay" select="ametys:siteParameter('page-follow-refresh-delay') * 60000"/><!-- refresh delay in min -->
    
    <xsl:variable name="dataSettings">{}</xsl:variable><!-- define number of rows displayed on load -->
                 
    <xsl:variable name="common-service-css-class-name">zone-abo</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/animate.css')}" type="text/css" />

        <link rel="stylesheet" href="{ametys:skinURL('zones/index-tools-abo/scss/main.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-tools-abo/scss/print.css')}"/>
    </xsl:template> 
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:skinURL(concat('plugins/js/ametys-tools.', ametys:lang(), '.js'))}"></script>
        
        <!-- Tooltip -->
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/poppers.min.js')}" />
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min')}" />
        
        <script type="text/javascript" src="{concat(ametys:uriPrefix(), '/plugins/page-subscription/resources/js/AmetysFront/UserPageSubscriptions.', ametys:lang(), '.js')}"/>   
        
        <script type="text/javascript">
            $j(document).ready(function(){
                var pageFollowTimer = null;
                
                AmetysFront.Event.listen("followed-pages-opened", function(data) {
                    // On open get unread pages
                    AmetysFront.UserPageSubscriptions.getUnreadPages('#tool-ametys_followedPages', updateTooltip_followedPages);
                    
                    pageFollowTimer = setInterval(function() {
                        AmetysFront.UserPageSubscriptions.getUnreadPages('#tool-ametys_followedPages', updateTooltip_followedPages);
                      }, <xsl:value-of select="$pageFollowRefreshDelay"/>);
                })
                
                AmetysFront.Event.listen("followed-pages-closed", function(data) {
                    clearInterval(pageFollowTimer);
                    pageFollowTimer = null;
                })
            });
            
            // Tippy plugin to hide tooltip on ESC
            const hideTooltipOnEsc_followedPages = {
              name: 'hideOnEsc',
              defaultValue: true,
              fn({hide}) {
                function onKeyDown(event) {
                  if (event.keyCode === 27) {
                    hide();
                  }
                }
                return {
                  onShow() {
                    document.addEventListener('keydown', onKeyDown);
                  },
                  onHide() {
                    document.removeEventListener('keydown', onKeyDown);
                  },
                };
              },
            };
            
            function updateTooltip_followedPages(unreadPages)
            {
                $j.each(unreadPages, function(i, unreadPage) {
                
                    // Destroy tooltips
                    $j('[' + AmetysFront.UserPageSubscriptions.PAGE_NOTIFICATION_ID_ATTR + ']').each(function(i, el) {
                        if ($j(el).get(0)._tippy)
                        {
                            $j(el).get(0)._tippy.destroy();
                        }
                    })
                    
                    $j.each(unreadPages, function(i, unreadPage) {
                        let $el = $j('[' + AmetysFront.UserPageSubscriptions.PAGE_NOTIFICATION_ID_ATTR + '="' + unreadPage.pageId + '"]');
                        
                        // Create tooltip
                        tippy('[' + AmetysFront.UserPageSubscriptions.PAGE_NOTIFICATION_ID_ATTR + '="' + unreadPage.pageId + '"]', {
                            allowHTML: true,
                            content: $el.html(),
                            placement: 'bottom-end',
                            plugins: [hideTooltipOnEsc_followedPages],
                            theme: 'notification'
                        });
                        
                        $el.attr("tabindex", 0); // to show tooltip on focus
                    });
                });
            }
            
            // Unsubscribe
            function deleteLink_ametys_followedPages(event, target)
            {
                let subscriptionId = $j(target).attr("data-ametys-subscription-id");
                AmetysFront.UserPageSubscriptions.unsubscribe('<xsl:value-of select="$uniqueId"/>', subscriptionId, null, true /* skipConfirm */)
            };
            
            function reinitModalFocus_followedPages(e, removeEl, addedEl)
            {
                AmetysFront.Accessibility.trapFocus($j('.menu-fixed .right').get(0), false);
                // Replace focus on configure button
                $j('.zone-abo .flex button').focus();
            }
            
            // Empty function. Not used.
            function deactivateLink_ametys_followedPages(event, target) {}
            function activateLink_ametys_followedPages(event, target) {}
            function moveLink_ametys_followedPages(event, target) {}
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <div class="flex">
             <h2 class="h3">
                <xsl:choose>
                    <xsl:when test="$header">
                        <xsl:copy-of select="$header"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="header-default-title"/>
                    </xsl:otherwise>
                </xsl:choose>
            </h2>
            <xsl:call-template name="configure-button"/>
        </div>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <div id="tool-ametys_followedPages" data-settings="{normalize-space($dataSettings)}">
			<input data-edit-mode-toggle="" type="checkbox" id="tool-toggle-ametys_followedPages" class="ametys-toggle__check ametys-edit-mode-checker"/>
            
            <!-- Selected links -->
            <div class="">
                <p data-no-items-text="" class="ametys-tools-no-items-text" data-ametys-subscription-page-role="no-result"><i18n:text i18n:key="SERVICE_PAGE_SUBSCRIPTION_NOSUBSCRIPTION" i18n:catalogue="skin.{$skin}"/></p>

                <div id="selected-links-ametys_{$uniqueId}" data-list-wrap="" class="ametys-tools-list-wrap ametys-animated-heigth ametys-abonnements-tools-list" data-ametys-subscriptions="{$uniqueId}">
                    <ul data-list="" class="ametys-tools-list ametys-tools-list_editable">
                        <xsl:apply-templates select="/subscriptions/subscription"/>
                    </ul>
                </div>
                
                <p class="sr-only" role="status" data-ametys-subscription-page-role="status"></p>
            </div>
                
            <!-- Modal -->
            <xsl:call-template name="unsubscribe-modal">
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
            </xsl:call-template>
		</div>
    </xsl:template>
    
    <xsl:template name="header-default-title">
        <i18n:text i18n:key="SKIN_USER_MENU_FOLLOWED_PAGES" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="configure-button">
        <button type="button" onclick="toggleCheckbox_ametys_followedPages(this)">
            <span><i18n:text i18n:key="SKIN_USER_MENU_CONFIGURE" i18n:catalogue="skin.{$skin}"/></span>
            <svg
                aria-hidden="true"
                version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg"
                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512"
                style="enable-background:new 0 0 512 512;" xml:space="preserve">
                <g>
                    <g>
                        <path d="M256,176c-44.1,0-80,35.9-80,80s35.9,80,80,80s80-35.9,80-80S300.1,176,256,176z M256,296c-22.1,0-40-17.9-40-40
               s17.9-40,40-40s40,17.9,40,40S278.1,296,256,296z" />
                    </g>
                </g>
                <g>
                    <g>
                        <path d="M502.2,315.6L450.4,276c1.5-13.7,1.4-27,0-39.9l51.8-39.7c8-6.2,10.2-17.3,5.1-26l-50.2-85c-5-8.5-15.4-12-24.6-8.4
               l-61.4,24.2c-11.2-8-23.2-14.8-35.9-20.3l-9.2-63.6C324.5,7.3,316.1,0,306.2,0H205.8c-9.9,0-18.4,7.3-19.8,17.1l-9.2,63.6
               c-12.7,5.5-24.7,12.3-35.9,20.3L79.5,76.9c-9.2-3.6-19.6,0-24.6,8.4l-50.2,85c-5.1,8.7-3,19.9,5.1,26L61.6,236
               c-1.5,13.7-1.4,27,0,39.9L9.8,315.6c-8,6.2-10.2,17.3-5.1,26l50.2,85c5,8.5,15.4,12,24.6,8.4l61.4-24.2
               c11.2,8,23.2,14.8,35.9,20.3l9.2,63.6c1.4,9.8,9.9,17.1,19.8,17.1h100.3c9.9,0,18.4-7.3,19.8-17.1l9.2-63.6
               c12.7-5.5,24.7-12.3,35.9-20.3l61.4,24.2c9.1,3.6,19.6,0,24.6-8.4l50.2-85C512.4,333,510.2,321.8,502.2,315.6z M431.3,391.6
               l-56-22.1c-6.7-2.6-14.3-1.5-19.9,3.1c-13.5,11-28.7,19.6-45.1,25.5c-6.9,2.5-11.9,8.6-13,15.9l-8.4,57.9h-65.7l-8.4-57.9
               c-1.1-7.3-6-13.4-13-15.9c-16.4-6-31.6-14.5-45.1-25.5c-5.6-4.5-13.2-5.7-19.9-3.1l-56,22.1l-32.5-55l47-36
               c5.9-4.5,8.8-11.9,7.5-19.3c-2.9-17.1-2.8-34.2,0-50.7c1.3-7.3-1.6-14.8-7.5-19.3l-47-36l32.5-55l56,22.1
               c6.7,2.6,14.3,1.5,19.9-3.1c13.5-11,28.7-19.6,45.1-25.5c6.9-2.5,11.9-8.6,13-15.9l8.4-57.9h65.7l8.4,57.9c1.1,7.3,6,13.4,13,15.9
               c16.4,6,31.6,14.5,45.1,25.5c5.6,4.5,13.2,5.7,19.9,3.1l56-22.1l32.5,55l-47,36c-5.9,4.5-8.8,11.9-7.5,19.3
               c2.9,17.1,2.8,34.2,0,50.7c-1.3,7.3,1.6,14.8,7.5,19.3l47,36L431.3,391.6z" />
                    </g>
                </g>
            </svg>
        </button>
        <script type="text/javascript">
            function toggleCheckbox_ametys_followedPages(el) {
                $j("#tool-toggle-ametys_followedPages").trigger('click');
                $j(el).toggleClass('active');

                if ($j(el).hasClass('active')) {
                    $j(el).find('span').html("<i18n:text i18n:key="SKIN_USER_MENU_CLOSE_CONFIGURATION" i18n:catalogue="skin.{$skin}"/>");
                    $j(el).attr("aria-label", "<i18n:text i18n:key="SKIN_USER_MENU_CLOSE_CONFIGURATION" i18n:catalogue="skin.{$skin}"/>");
                    
                    $j(".ametys-tools-list__link")
                        .each(function () {
                            $j(this).attr('data-href', $j(this).attr('href'));
                            $j(this).attr('href', 'javascript:void(0)');
                            $j(this).removeAttr('target');
                        });
                
                } else {
                    $j(el).find('span').html("<i18n:text i18n:key="SKIN_USER_MENU_CONFIGURE" i18n:catalogue="skin.{$skin}"/>");
                    $j(el).attr("aria-label", "<i18n:text i18n:key="SKIN_USER_MENU_CONFIGURE" i18n:catalogue="skin.{$skin}"/>");
                    $j(".ametys-tools-list__link")
                        .each(function () {
                            $j(this).attr('href', $j(this).attr('data-href'));
                            $j(this).attr('target', '_blank');
                        });
                }
                
                 // Visible elements have changed, re-trap focus without changing focus
                 // Wait for slideToggle occured
                setTimeout(function () {
                    AmetysFront.Accessibility.trapFocus($j('.menu-fixed .right').get(0), false);
                }, 500);
            }
        </script>
    </xsl:template>
    
    <xsl:template match="subscription">
        <li class="ametys-tools-list__item ametys-tools-list__abo" data-list-item="" data-app-type="custom" data-ametys-subscription-id="{@id}">
            <a class="ametys-tools-list__link"
               href="{resolver:resolve('page', page/@id, false)}"
               data-list-link="">
                                  
              <div class="ametys-abonnements">
                   <xsl:apply-templates select="." mode="breadcrumb"/>     
                   <xsl:apply-templates select="." mode="title"/>  
                   <xsl:apply-templates select="." mode="notification"/>    
              </div>
           </a>
                                  
           <button type="button" aria-label="skin.{$skin}:SERVICE_PAGE_SUBSCRIPTION_UNSUBSCRIBE" i18n:attr="aria-label" class="material-icons ametys-tools-list__action">close</button>
        </li>
    </xsl:template>
    
    <xsl:template match="subscription" mode="breadcrumb">
        <p class="ametys-abonnements__breadcrumb">
            <xsl:if test="ametys:pageExists($site, $lang, 'index')">
                <xsl:value-of select="ametys:pageTitle($site, $lang, 'index')"/>
            </xsl:if>
            <xsl:variable name="breadcrumb" select="ametys:breadcrumb(page/@id)"/>
            <xsl:for-each select="$breadcrumb[position() &lt;= 2]">
                <xsl:text> / </xsl:text>
                <xsl:value-of select="ametys:pageTitle(.)"/>
            </xsl:for-each>
            <xsl:if test="count($breadcrumb) &gt; 2">
                <xsl:if test="count($breadcrumb) &gt; 3"><xsl:text> / ...</xsl:text></xsl:if>
                <xsl:text> / </xsl:text>
                <xsl:value-of select="ametys:pageTitle($breadcrumb[position() = last()])"/>
            </xsl:if>
          </p>
    </xsl:template>
    
    <xsl:template match="subscription" mode="title">
        <h3 class="ametys-abonnements__title">
          <xsl:value-of select="page"/> 
        </h3>
    </xsl:template>
    
    <xsl:template match="subscription" mode="notification">
        <div class="ametys-abonnement__circle" data-ametys-page-notification-id="{page/@id}" style="display: none">
            <div class="ametys-abonnement__last-edit">
                <span class="ametys-abonnement__last-edit__date" data-ametys-page-notification-role="date"></span>
                <div class="ametys-abonnement__last-edit__user">
                    <img alt="" data-ametys-page-notification-role="author-img"/>
                    <div class="ametys-abonnement__last-edit__user__info">
                        <span class="ametys-abonnement__last-edit__user__info__name" data-ametys-page-notification-role="author-name"></span>
                        <span class="ametys-abonnement__last-edit__user__info__action">
                            <i18n:text i18n:key="SERVICE_PAGE_SUBSCRIPTION_PAGE_MODIFIED" i18n:catalogue="skin.{$skin}"/>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="unsubscribe-modal">
        <!-- Delete confirm -->
         <div id="data-delete-modal-ametys_followedPages" class="modal-confirm" style="display: none;"
            data-delete-modal="" aria-labelledby="delete-modal-ametys_title_followedPages" role="dialog" aria-modal="true">
            <h1 id="delete-modal-ametys_title_followedPages"><i18n:text i18n:key="PAGE_SUBSCRIPTION_HELPER_UNSUBSCRIBE_CONFIRM_MSG" i18n:catalogue="plugin.page-subscription"/></h1>
            <button data-delete-modal-close="" class="close" aria-label="skin.{$skin}:SKIN_USER_MENU_CLOSE" i18n:attr="aria-label"><i aria-hidden="true" class="fas fa-times"></i></button>
            
            <div class="">
                <button class="btn full" data-delete-modal-confirm=""><span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_YES" i18n:catalogue="skin.{$skin}"/></span></button>
                <button class="btn" data-delete-modal-close=""><span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_NO" i18n:catalogue="skin.{$skin}"/></span></button>
            </div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
