<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="http://exslt.org/math" 
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                extension-element-prefixes="math ametys resolver">

    <xsl:import href="plugin:syndication://pages/services/feed/feed2xhtml_1.2.xsl"/>

    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">feed syndication syndication-by-date</xsl:variable>

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/feed/scss/main.css')}" />
        <xsl:if test="ametys:renderingContext() = 'back'">
            <link href="{ametys:pluginResourceURL('syndication', 'css/bo-error.css')}" rel="stylesheet" type="text/css" />
        </xsl:if>    
    </xsl:template> 
    
   	<!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:param name="title" select="$header"/>
        
        <xsl:choose>
        	<xsl:when test="$zone = 'user-menu-1'">
        		<div class="flex-title">
        			 <h1 class="service-title">
            			<xsl:copy-of select="$title"/>
        			</h1>
        			<xsl:call-template name="link-top-custom"/>
        		</div>
        	</xsl:when>
        	<xsl:when test="$title != ''">
        		<div class="flex">
        			 <h1 class="service-title">
            			<xsl:copy-of select="$title"/>
        			</h1>
        		</div>
        	</xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title-empty">
    </xsl:template>
    
    <xsl:template name="link-top"/>
   	
   	<xsl:template name="configure-links-btn-text">
   		<xsl:if test="$zone != 'user-menu-1'">
   			<xsl:call-template name="configure-links-btn-icon"/>
   		</xsl:if>
        <span><i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_POPUP_CONFIG" i18n:catalogue="plugin.syndication"/></span>
        <xsl:if test="$zone = 'user-menu-1'">
   			<span>
                <xsl:call-template name="configure-links-btn-icon"/>
            </span>
   		</xsl:if>
    </xsl:template>
    
    <xsl:template name="configure-links-btn-icon">
        <svg aria-hidden="true"
            version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg"
            xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512"
            style="enable-background:new 0 0 512 512;" xml:space="preserve">
            <g>
                <g>
                    <path d="M256,176c-44.1,0-80,35.9-80,80s35.9,80,80,80s80-35.9,80-80S300.1,176,256,176z M256,296c-22.1,0-40-17.9-40-40
           s17.9-40,40-40s40,17.9,40,40S278.1,296,256,296z" />
                </g>
            </g>
            <g>
                <g>
                    <path d="M502.2,315.6L450.4,276c1.5-13.7,1.4-27,0-39.9l51.8-39.7c8-6.2,10.2-17.3,5.1-26l-50.2-85c-5-8.5-15.4-12-24.6-8.4
           l-61.4,24.2c-11.2-8-23.2-14.8-35.9-20.3l-9.2-63.6C324.5,7.3,316.1,0,306.2,0H205.8c-9.9,0-18.4,7.3-19.8,17.1l-9.2,63.6
           c-12.7,5.5-24.7,12.3-35.9,20.3L79.5,76.9c-9.2-3.6-19.6,0-24.6,8.4l-50.2,85c-5.1,8.7-3,19.9,5.1,26L61.6,236
           c-1.5,13.7-1.4,27,0,39.9L9.8,315.6c-8,6.2-10.2,17.3-5.1,26l50.2,85c5,8.5,15.4,12,24.6,8.4l61.4-24.2
           c11.2,8,23.2,14.8,35.9,20.3l9.2,63.6c1.4,9.8,9.9,17.1,19.8,17.1h100.3c9.9,0,18.4-7.3,19.8-17.1l9.2-63.6
           c12.7-5.5,24.7-12.3,35.9-20.3l61.4,24.2c9.1,3.6,19.6,0,24.6-8.4l50.2-85C512.4,333,510.2,321.8,502.2,315.6z M431.3,391.6
           l-56-22.1c-6.7-2.6-14.3-1.5-19.9,3.1c-13.5,11-28.7,19.6-45.1,25.5c-6.9,2.5-11.9,8.6-13,15.9l-8.4,57.9h-65.7l-8.4-57.9
           c-1.1-7.3-6-13.4-13-15.9c-16.4-6-31.6-14.5-45.1-25.5c-5.6-4.5-13.2-5.7-19.9-3.1l-56,22.1l-32.5-55l47-36
           c5.9-4.5,8.8-11.9,7.5-19.3c-2.9-17.1-2.8-34.2,0-50.7c1.3-7.3-1.6-14.8-7.5-19.3l-47-36l32.5-55l56,22.1
           c6.7,2.6,14.3,1.5,19.9-3.1c13.5-11,28.7-19.6,45.1-25.5c6.9-2.5,11.9-8.6,13-15.9l8.4-57.9h65.7l8.4,57.9c1.1,7.3,6,13.4,13,15.9
           c16.4,6,31.6,14.5,45.1,25.5c5.6,4.5,13.2,5.7,19.9,3.1l56-22.1l32.5,55l-47,36c-5.9,4.5-8.8,11.9-7.5,19.3
           c2.9,17.1,2.8,34.2,0,50.7c-1.3,7.3,1.6,14.8,7.5,19.3l47,36L431.3,391.6z" />
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="configure-links-btn">
	    <span class="feed-config-link" id="feed-config-header-{$uniqueId}"><xsl:call-template name="configure-links-btn-text"/></span>
	    <script type="text/javascript">
	    	<xsl:choose>
	    		<xsl:when test="$zone = 'user-menu-1'">
	    			$j("#feed-config-header-<xsl:value-of select="$uniqueId"/>").wrapInner('&lt;button aria-haspopup="dialog" onclick="feed_config_form_popup_<xsl:value-of select="$uniqueId"/>()"&gt;&lt;/button&gt;')
	    		</xsl:when>
	    		<xsl:otherwise>
	    			$j("#feed-config-header-<xsl:value-of select="$uniqueId"/>").wrapInner('&lt;button aria-haspopup="dialog" class="btn" onclick="feed_config_form_popup_<xsl:value-of select="$uniqueId"/>()"&gt;&lt;/button&gt;')
	    		</xsl:otherwise>
	    	</xsl:choose>
	        
	    </script>
    </xsl:template>
   	
    <xsl:template name="link-top-custom">
    	<xsl:if test="$zone = 'user-menu-1'">
    		<div class="actions">
    			<xsl:call-template name="link"/>
    			
	    		<!-- Link to edit user RSS feed preferences -->
		        <xsl:call-template name="feed-config-link"/>
		    </div>
    	</xsl:if>
    </xsl:template>
    
    <xsl:template name="link-bottom">
    	<xsl:if test="$zone != 'user-menu-1'">
            <div class="actions--bottom">
        		<xsl:call-template name="link"/>
        		
    	    	<!-- Link to edit user RSS feed preferences -->
    	        <xsl:call-template name="feed-config-link"/>
            </div>
	    </xsl:if>
    </xsl:template>
    
    <!-- Template used for link "all contents" -->
    <xsl:template name="link">
        <xsl:if test="starts-with($link, 'page://')">
            <a href="{resolver:resolve('page', $link)}">
            	<xsl:if test="$zone != 'user-menu-1'">
       				<xsl:attribute name="class">btn</xsl:attribute>
       				<span class="plus" aria-hidden="true">+</span>
        		</xsl:if>
        		
                <xsl:choose>
                    <xsl:when test="normalize-space($link-title) != ''">
                        <span><xsl:value-of select="$link-title"/></span>
                    </xsl:when>
                    <xsl:otherwise>
                    	<span><i18n:text i18n:key="PLUGINS_WEB_SERVICE_FILTERED_CONTENTS_LINK_TITLE_DEFAULT" i18n:catalogue="plugin.web"/></span>
                    </xsl:otherwise>
                </xsl:choose>
                
                <xsl:if test="$zone = 'user-menu-1'">
       				<span class="plus" aria-hidden="true">+</span>
        		</xsl:if>
            </a>
        </xsl:if>    
    </xsl:template>
    
    <!-- Template for each item -->    
	<xsl:template name="entry"> 
		<li>
            <xsl:attribute name="class"><xsl:call-template name="common-utils-class"/></xsl:attribute>
            
            <xsl:choose>
               <xsl:when test="@link">
                   <a href="{@link}" class="item-link">
			            <xsl:apply-templates select="image"/>
			            <xsl:call-template name="item-title"/>
			            <xsl:call-template name="item-date"/>
			            <xsl:call-template name="item-description"/>
			            <xsl:call-template name="item-attachments"/>
			            <xsl:call-template name="item-author"/>
			        </a>
			   </xsl:when>
               <xsl:otherwise>
               	    <xsl:apply-templates select="image"/>
			        <xsl:call-template name="item-title"/>
			        <xsl:call-template name="item-date"/>
			        <xsl:call-template name="item-description"/>
			        <xsl:call-template name="item-attachments"/>
			        <xsl:call-template name="item-author"/>
			     </xsl:otherwise>
           </xsl:choose>
		</li>
	</xsl:template>
	
	<!-- Title of RSS entry -->
    <xsl:template name="item-title">
   	   <h2 class="rss-title">
           <xsl:value-of select="@title"/>
   	   </h2>
    </xsl:template>
    
</xsl:stylesheet>
