<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:ugc="org.ametys.plugins.ugc.transformation.xslt.UgcXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/common/home-search.xsl"/>
    
    <!-- Set to true to active autoplay. This is not recommended for accessibility purpose  -->
    <xsl:variable name="autoplay">false</xsl:variable>
    
    <!-- Autoplay speed in milliseconds. Only use if autoplay is et to true -->
    <xsl:variable name="autoplaySpeed">2000</xsl:variable>
    
    <!-- Enable/disable arrows navigation -->
    <xsl:variable name="arrows" select="ametys:serviceViewParameter('arrowNavigation')" />
    
    <xsl:template name="common-service-head-css">
        <!-- BEGIN head-css-slick-carousel -->
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick.css')}" type="text/css" />
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick-theme.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/accessible-slick-theme.css')}" type="text/css" />
    	<!-- END head-css-slick-carousel -->
    	
    	<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/documents-grid/scss/main.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
    	<script type="text/javascript" src="{ametys:skinURL('plugins/slick/slick.js')}"></script>
    	<script type="text/javascript">
		  $j(document).ready(function(){
		    $j('#documents-<xsl:value-of select="$uniqueId"/>').slick({
                regionLabel: "<i18n:text i18n:key="SKIN_DOCUMENTS_VIEW_GRID_REGION_LABEL" i18n:catalogue="skin.{$skin}"/>",
                infinite: false,
		        slidesToShow: 5,
		        slidesToScroll: 5,
		        autoplay: <xsl:value-of select="$autoplay"/>, 
		        autoplaySpeed: <xsl:value-of select="$autoplaySpeed"/>, 
		        arrows: '<xsl:value-of select="$arrows"/>' == 'true',
		        prevArrow: '&lt;button class="slick-prev" type="button" role="presentation">'
                            + '&lt;span class="slick-prev-icon" aria-hidden="true">&lt;/span>'
                            + '&lt;span class="slick-sr-only"><i18n:text i18n:key="SKIN_DOCUMENTS_VIEW_GRID_NAV_PREV" i18n:catalogue="skin.{$skin}"/>&lt;/span>'
                         + '&lt;/button>',
                nextArrow: '&lt;button class="slick-next" type="button" role="presentation">'
                        + '&lt;span class="slick-next-icon" aria-hidden="true">&lt;/span>'
                        + '&lt;span class="slick-sr-only"><i18n:text i18n:key="SKIN_DOCUMENTS_VIEW_GRID_NAV_NEXT" i18n:catalogue="skin.{$skin}"/>&lt;/span>'
                     + '&lt;/button>',
		        dots: true,
		        
		        ametysSlidePrefixLabel: "<i18n:text i18n:key="SKIN_DOCUMENTS_VIEW_GRID_SLIDE_PREFIX" i18n:catalogue="skin.{$skin}"/>",
		        ametysDotsBtnPrefixLabel : "<i18n:text i18n:key="SKIN_DOCUMENTS_VIEW_GRID_DOTS_PREFIX" i18n:catalogue="skin.{$skin}"/>",
		        responsive: [
		            {
		                breakpoint: 1280, // Point de rupture pour les écrans de 1280 pixels de largeur et plus
		                settings: {
		                    slidesToShow: 4,
                            slidesToScroll: 4
		                }
		            },
		            {
		                breakpoint: 1024, // Point de rupture pour les écrans de 1024 pixels de largeur
		                settings: {
		                    slidesToShow: 3,
                            slidesToScroll: 3
		                }
		            },
		            {
		                breakpoint: 800, // Point de rupture pour les écrans de 800 pixels de largeur
		                settings: {
		                    slidesToShow: 2,
                            slidesToScroll: 2
		                }
		            },
		            {
		                breakpoint: 500, // Point de rupture pour les écrans de 500 pixels de largeur
		                settings: {
		                    slidesToShow: 1,
                            slidesToScroll: 1
		                }
		            }
		        ]
		    });
		});
		</script>
    </xsl:template>
    
    <xsl:variable name="common-service-css-class-name">documents-section-grid</xsl:variable>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
   
    <xsl:template name="hits">
        <div class="documents" data-ametys-search-role="hits" id="documents-{$uniqueId}">
            <xsl:choose>
                <xsl:when test="/search/hits/hit">
                    <xsl:for-each select="/search/hits/hit">
                        <xsl:call-template name="hit"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="/search/hits">
                    <xsl:call-template name="no-result"/>
                </xsl:when>
            </xsl:choose>
        </div>
        
        <xsl:call-template name="link-mobile"/> 
    </xsl:template>
    
    <xsl:template name="hit">
        <div>
            <xsl:apply-templates select="."/>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>document<xsl:text> </xsl:text>
    </xsl:template>

    <xsl:template name="link">
        <xsl:if test="/search/link/page">
            <xsl:call-template name="link-tag"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <a class="btn desktop">
                <xsl:attribute name="href">
                    <xsl:call-template name="link-href"/>
                </xsl:attribute>
                <span class="plus" aria-hidden="true">+</span>
                <xsl:call-template name="link-attribute"/>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-mobile">
        <xsl:if test="/search/link/page">
            <xsl:call-template name="link-tag-mobile"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-tag-mobile">
        <xsl:if test="/search/link/page">
            <a class="btn mobile">
                <xsl:attribute name="href">
                    <xsl:call-template name="link-href"/>
                </xsl:attribute>
                <span class="plus" aria-hidden="true">+</span>
                <xsl:call-template name="link-attribute"/>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="no-result">
        <div class="no-result" data-ametys-search-role="no-result">
            <i18n:text i18n:key="SKIN_SERVICE_SEARCH_DOCUMENTS_NORESULT" i18n:catalogue="skin.{$skin}"/>
        </div>
    </xsl:template>
</xsl:stylesheet>