<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>          
    <xsl:import href="skin://services/web/pages/services/search/common/home-search.xsl"/>
    <xsl:import href="plugin:web://pages/services/search/search-default/criteria/criteria.xsl"/>
    
    <xsl:variable name="common-service-css-class-name"> agenda-actu</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <!-- BEGIN head-css-slick-carousel -->
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick-theme.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/accessible-slick-theme.css')}" type="text/css" />
        <!-- END head-css-slick-carousel -->
        
        <link rel="stylesheet" href="{ametys:skinURL('zones/agenda-actu/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="search-service-head-js"/>
        
        <script type="text/javascript" src="{ametys:skinURL('plugins/slick/slick.js')}"></script>
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/poppers.min.js')}" />
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}" />
        
        <script type="text/javascript">
            <xsl:if test="$template = 'index'">
            var newsAgendaCarouselInitialized = false;
            var nbHits = <xsl:value-of select="count(/search/hits/hit)"/>;
            
            function launchNewsAgendaCarousel_<xsl:value-of select="$uniqueId"/>(){
                
                let initialized = $j('#agenda-actu-<xsl:value-of select="$uniqueId"/> .agenda-actu-container').attr('data-carousel-initialized') == 'true'; 
                if (!initialized)
                {
                    $j('#agenda-actu-<xsl:value-of select="$uniqueId"/> .agenda-actu-container').slick({
                      regionLabel: "<i18n:text i18n:key="SKIN_SEARCH_NEWS_AGENDA_CAROUSEL_REGION_LABEL" i18n:catalogue="skin.{$skin}"/>",
                      infinite: false,
                      autoplay: false,
                      dots: true,
                      pauseOnDotsHover:true,
                      arrows: false,
                      slidesToShow: Math.min(3, nbHits),
                      slidesToScroll: Math.min(3, nbHits),
                      ametysDotsBtnPrefixLabel: "<i18n:text i18n:key="SKIN_SEARCH_NEWS_AGENDA_CAROUSEL_DOTS_PREFIX" i18n:catalogue="skin.{$skin}"/>",
                      responsive: [
                        {
                          breakpoint: 1480,
                          settings: {
                            slidesToShow: Math.min(2, nbHits),
                            slidesToScroll: Math.min(2, nbHits)
                          }
                        },
                        {
                          breakpoint: 850,
                          settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1
                          }
                        },
                        {
                          breakpoint: 500,
                          settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1
                          }
                        }
                      ]
                    });
                }
                $j('#agenda-actu-<xsl:value-of select="$uniqueId"/> .agenda-actu-container').attr('data-carousel-initialized', true);
            };
            </xsl:if>
            
            $j(document).ready(function() {
               initializeNewsAgendaSearch_<xsl:value-of select="$uniqueId"/>();
            });
            
            function initializeNewsAgendaSearch_<xsl:value-of select="$uniqueId"/>() {
                checkTags_<xsl:value-of select="$uniqueId"/>();
                
                <xsl:if test="$template = 'index'">
                launchNewsAgendaCarousel_<xsl:value-of select="$uniqueId"/>();
                </xsl:if>
            }
            
            // Tippy plugin to hide tooltip on ESC
            const hideTagTooltipOnEsc_<xsl:value-of select="$uniqueId"/> = {
              name: 'hideTagTooltipOnEsc',
              defaultValue: true,
              fn({hide}) {
                function onKeyDown(event) {
                  if (event.keyCode === 27) {
                    hide();
                  }
                }
                return {
                  onShow() {
                    document.addEventListener('keydown', onKeyDown);
                  },
                  onHide() {
                    document.removeEventListener('keydown', onKeyDown);
                  },
                };
              },
            };
            
            function checkTags_<xsl:value-of select="$uniqueId"/>() {
                 setTimeout(function () {
                     $j('.agenda-actu-item a').each(function() {
                            const infoWidth = $j(this).find('.infos').width();
                            
                            const tags = $j(this).find(".tags .tag:not('.count')");
                            const counterWidth = 53; // counter width "+X"
                            
                            let tagText = '';
                            let countTagHide = 0;
                            $j(tags).each(function(index) {
                                if (index === 0) {
                                    let tagWidth = $j(this).outerWidth(true);
                                    if (tagWidth + (tags.length > 1 ? counterWidth : 0) > infoWidth) 
                                    {
                                        const text = $j(this).text();
                                        $j(this).css('max-width', (tags.length == 1 ? infoWidth : (infoWidth - counterWidth)) + 'px');
                                        $j(this).addClass('truncated');
                                        $j(this).attr('title', text);
                                        $j(this).attr('data-tippy-content', text);
                                        //$j(this).attr('tabindex', 0);
                                    }
                                } else {
                                    $j(this).hide();
                                    tagText += $j(this).text() + ', ';
                                    countTagHide++;
                                }
                            });
                            tagText = tagText.slice(0, -2);
                            if (countTagHide > 0 &amp;&amp; !$j(this).find('.tags .tag.count').length) {
                                $j(this).find('.tags').append(`&lt;span data-tippy-content="${tagText}" class="tag count">+${countTagHide}&lt;/span>`);
                            }
                            
                            tippy('.tags [data-tippy-content]', {plugins: [hideTagTooltipOnEsc_<xsl:value-of select="$uniqueId"/>]});
                        });
             }, 30);
         }
         
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="container" id="agenda-actu-{$uniqueId}">
            <xsl:call-template name="service-header"/>
            
            <xsl:call-template name="search-results"/>
        </div>
    </xsl:template>
    
    <xsl:template name="service-header-link">
        <div class="flex-div">
            <xsl:call-template name="form-criteria"/>
            <xsl:call-template name="link"/> 
        </div>
    </xsl:template>
    
    <!-- Form criteria not supported in this view -->
    <xsl:template name="form-criteria">
        <form method="post" class="searchForm" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
        </form>
    </xsl:template>

     <xsl:template name="hits">
        <div data-ametys-search-role="hits" class="agenda-actu-container">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </div>
    </xsl:template>
    
    <xsl:template name="hit">
        <div>
            <xsl:apply-templates select="."/>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>agenda-actu-item <xsl:text> </xsl:text>
    </xsl:template>
    
</xsl:stylesheet>