<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:cms="http://ametys.org/cms/3.0"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              exclude-result-prefixes="docbook"
                              extension-element-prefixes="text resolver ametys">

	<xsl:import href="skin://stylesheets/content/document/document.xsl"/>
    <xsl:import href="skin://stylesheets/content/common-abstract.xsl"/> 
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-css-class-name">document view-abstract</xsl:variable>     
        
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body">
         <xsl:choose>
            <xsl:when test="$zone = 'default' or $zone = 'secondary'">
                <div class="ametys-cms-content {$common-content-css-class-name} wrapper">
                    <xsl:call-template name="common-content-body-title"/>
                    <xsl:call-template name="common-content-body-content"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <a href="{resolver:resolve(metadata/file/@type, metadata/file/@path, true())}">
                    <xsl:call-template name="document-link-title"/>
                    <div class="left">
                        <xsl:call-template name="document-icon"/>
                        <xsl:call-template name="document-text"/>
                    </div>
                    <xsl:call-template name="document-date"/>
                </a>        
            </xsl:otherwise>
        </xsl:choose>  
    </xsl:template>
    
    <xsl:template name="document-link-title">
        <xsl:variable name="size">
            <xsl:call-template name="format-size-in-attribute">
                <xsl:with-param name="size" select="metadata/file/@size"></xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="i18nparams"><filename><xsl:value-of select="metadata/file/@filename"/></filename><size><xsl:value-of select="$size"/></size></xsl:variable> 
        
        <xsl:attribute name="title">
            <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_DOCUMENT_DOWNLOAD_TITLE_WITH_SIZE'), $lang, $i18nparams)"/>
        </xsl:attribute>
        <xsl:attribute name="aria-label">
            <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_DOCUMENT_DOWNLOAD_TITLE_WITH_SIZE'), $lang, $i18nparams)"/>
        </xsl:attribute>
            
   </xsl:template>
    
   <xsl:template name="document-icon">
        <xsl:call-template name="file-icon">
            <xsl:with-param name="filename" select="metadata/file/@filename"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="document-text">
        <span class="title">
            <xsl:choose>
                <xsl:when test="metadata/file-text != ''"><xsl:value-of select="metadata/file-text"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="metadata/file/@filename"/></xsl:otherwise>
            </xsl:choose>
        </span>
    </xsl:template>
    
    <xsl:template name="document-date">
        <div class="date-container">
            <xsl:call-template name="dates">
                <xsl:with-param name="startDate" select="metadata/file/@lastModified"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    
</xsl:stylesheet>
