<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="ametys">

	<xsl:import href="plugin:faq://stylesheets/content/faq/faq-main.xsl"/>	
	
    <xsl:template name="common-content-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/faq/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="common-content-head-js">
        <script type="text/javascript">
            $j(document).ready(function(){
                $j("#faq-<xsl:value-of select="$uniqueId"/> .toggle .question-title button").click(function (e) {

                    var $header = $j(this).parent();
                    if ($header.next('.expandable-element').hasClass("open")) {
                        $header.removeClass('open');
                        $header.next('.expandable-element').removeClass('open');
                        $j(this).attr("aria-expanded", false);
                    } else {
                        $header.addClass('open');
                        $header.next('.expandable-element').addClass('open');
                        $j(this).attr("aria-expanded", true);
                    }

                    $j(this).next('.expandable-element').slideToggle();
                });
            });
        </script>
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
        <!-- Image -->
        <xsl:if test="not($zone = 'default') or not(ametys:pageId())">
            <xsl:call-template name="common-content-body-image-bigsize"/>    
        </xsl:if>
    
        <!-- Rich content -->
        <xsl:call-template name="common-content-body-content-rich"/>
        
        <div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
    
        <div id="faq-{$uniqueId}">
            <!-- FAQ -->
            <xsl:call-template name="faq-details"/>
        </div>
        
        <!-- Comments -->
        <xsl:call-template name="common-content-body-comments"/>     
    </xsl:template>  
    
    <xsl:template name="faq-details">
        <xsl:if test="metadata/questions/entry[question != '']">
            <xsl:call-template name="questions-list-details"/>
        </xsl:if>
    </xsl:template>
    
	<xsl:template name="questions-list-details">
        <div class="toggle">
            <xsl:apply-templates select="metadata/questions/entry[question != '']">
                <xsl:with-param name="prefix" select="concat('content-', @name)"/>
            </xsl:apply-templates>
        </div>      
    </xsl:template>
    
    <xsl:template name="question-anwser">
        <div class="expandable-element" id="faq-panel-{generate-id()}" aria-labelledby="faq-header-{generate-id()}">
	        <xsl:call-template name="common-content-body-content-rich">
	        	<xsl:with-param name="content" select="answer"/>
	        	<xsl:with-param name="level" select="2"/>
	        </xsl:call-template>
	      
	        <div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
	        
	        <xsl:call-template name="question-link"/>
	            
	        <xsl:call-template name="question-additionalinfo"/>
        </div>      
    </xsl:template>
    
    <xsl:template name="question-title">
        <h2 class="ametys-richtext-title-4 question-title">
            <button id="faq-header-{generate-id()}"
                    aria-expanded="false"
                    aria-controls="faq-panel-{generate-id()}">
                <xsl:value-of select="question"/>
                <i class="fas fa-chevron-down" aria-hidden="true"></i>
                <i class="fas fa-chevron-up" aria-hidden="true"></i>
            </button>
        </h2>  
    </xsl:template>
    
    <xsl:template match="entry">
    	<xsl:param name="prefix"/>

        <xsl:call-template name="question-title"/>
        
        <xsl:call-template name="question-anwser"/>
    </xsl:template>
	
</xsl:stylesheet>
