<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:cms="http://ametys.org/cms/3.0"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              exclude-result-prefixes="docbook"
                              extension-element-prefixes="text resolver ametys">

	<xsl:import href="flashinfo.xsl"/>
	<xsl:import href="skin://stylesheets/dates.xsl"/>
    <xsl:import href="skin://stylesheets/content/common-abstract.xsl"/> 
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-css-class-name">alerte view-abstract</xsl:variable>
    
    <xsl:template name="common-content-body-title-content"/>
    
    <xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        <xsl:choose>
            <xsl:when test="ametys:zoneItemId()">
                <!-- Default abstract view used in a page such for search service -->
                <a href="{resolver:resolve('page', $page-id, false)}">
                    <xsl:call-template name="content-image"/>
                    <div class="infos"> 
                        <div>
                            <xsl:call-template name="content-tag"/>
                            <xsl:call-template name="content-title"/>
                            <xsl:call-template name="content-abstract"/>
                        </div>
                        <xsl:call-template name="content-dates"/>
                    </div>
                </a>
                <script type="text/javascript" src="{ametys:skinURL('plugins/js/svgconvert.js')}" />
            </xsl:when>
            <xsl:when test="$page-id != '' and cms:isNotRichTextEmpty(metadata/content)">
                <!-- No zone item id, abstract view is used in input data -->
                <a href="{resolver:resolve('page', $page-id, false)}">
                    <xsl:call-template name="flash-info-content"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <!-- No zone item id, abstract view is used in input data -->
                <xsl:call-template name="flash-info-content"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="flash-info-content">
        <xsl:call-template name="flash-info-title"/>
        <xsl:call-template name="flash-info-date"/>
        <xsl:call-template name="flash-info-summary"/>
    </xsl:template>
    
    <xsl:template name="flash-info-title">
        <span class="link-info-title trunk2">
           <xsl:value-of select="metadata/title"/>    
        </span>
    </xsl:template>
    
    <xsl:template name="flash-info-date">
        <xsl:if test="(metadata/start-date != '' or metadata/end-date != '') and not(metadata/hide-date = 'true')">
            <span class="link-info-date">
                <xsl:call-template name="dates">
                    <xsl:with-param name="startDate" select="metadata/start-date"/>
                    <xsl:with-param name="endDate" select="metadata/end-date"/>
                </xsl:call-template>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="flash-info-summary">
        <span class="link-info-summary trunk3">
           <xsl:call-template name="common-utils-simpletext">
                <xsl:with-param name="text" select="metadata/text"/>                
                <xsl:with-param name="defaultText" select="metadata/content/docbook:article"/>                
                <xsl:with-param name="maxDefaultTextSize" select="'200'"/>                
            </xsl:call-template>         
        </span>
    </xsl:template>
    
    <!--  NOT USED by default but keep it for legacy purpose -->
    <!--  DO NOT insert "more" link if flash item is already in a link (incorrect html) -->
    <xsl:template name="flash-info-link">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        <xsl:if test="$page-id != '' and cms:isNotRichTextEmpty(metadata/content)">
            <a href="{resolver:resolve('page', $page-id, false)}" class="url"><i18n:text i18n:key="SKIN_ALERTS_READ_MORE" i18n:catalogue="skin.{$skin}"/></a>
        </xsl:if> 
    </xsl:template>
</xsl:stylesheet>
