<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright 2010 Anyware Services Licensed under the Apache License, Version 
	2.0 (the "License"); you may not use this file except in compliance with 
	the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 
	Unless required by applicable law or agreed to in writing, software distributed 
	under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES 
	OR CONDITIONS OF ANY KIND, either express or implied. See the License for 
	the specific language governing permissions and limitations under the License. -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:docbook="http://docbook.org/ns/docbook"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	xmlns:math="http://exslt.org/math"
	xmlns:cms="http://ametys.org/cms/3.0"
	xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
	xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
	extension-element-prefixes="math ametys resolver filenameutils cms docbook">

	<xsl:import href="plugin:job-offer://stylesheets/content/jobOffer/jobOffer-main.xsl" />
    <xsl:import href="jobOffer.xsl"/>
    
    <xsl:variable name="common-content-css-class-name">joboffer view-main service-emploi</xsl:variable>
   
    <xsl:template name="common-content-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('templates/common/js/ametys-multiselect.css')}"/> 
    </xsl:template>
    
    <xsl:template name="common-content-head-js">
        <script src="{ametys:skinURL('templates/common/js/ametys-multiselect.js')}"></script>

        <xsl:call-template name="job-application-form-js"/>
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
        <xsl:call-template name="job-refid"/>
        <xsl:call-template name="job-contract-type"/>
        
        <h2 class="ametys-richtext-title-1">
            <i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_DETAILS" i18n:catalogue="skin.{$skin}" />
        </h2>
        
        <xsl:call-template name="job-description"/>
        <xsl:call-template name="job-profile"/>
        <xsl:call-template name="job-contacts"/>
        <xsl:call-template name="job-additional-info"/>

        <div class="emploi-block">
            <xsl:call-template name="closing-date"/>
            <xsl:call-template name="start-date"/>
        </div>
        
        <script type="text/javascript">
            $j(document).ready(function() {
                var $input = $j('.apply-form form .field input');
                $input.each(function() {
                    var $this = $j(this),
                        label = $this.closest('.field').find('.label label').text();
                        
                    $this.attr('placeholder', label);
                })
            });
        </script>
    </xsl:template>
    
    <xsl:template name="job-refid">
        <xsl:if test="metadata/refId">
            <p>
                <strong>
                    <span class="content-subtitle2">
                        <i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_NUM_AVIS" i18n:catalogue="skin.{$skin}" />
                        <xsl:value-of select="metadata/refId" />
                    </span>
                </strong>
            </p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-contract-type">
         <xsl:if test="metadata/contractType/@title">
                <p class="contract-type">
                    <strong>
                        <span class="content-subtitle2">
                            <i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_CONTRACT_TYPE" i18n:catalogue="skin.{$skin}" />
                            <xsl:value-of select="metadata/contractType/@title" />
                        </span>
                    </strong>
                </p>
            </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-description">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/content)">
            <h2 class="ametys-richtext-title-2">
                <i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_DESCRIPTION" i18n:catalogue="skin.{$skin}" />
            </h2>
            <xsl:call-template name="common-content-body-content-rich" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-profile">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/requiredProfile)">
            <h2 class="ametys-richtext-title-2">
                <i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_REQUIRED_PROFILE" i18n:catalogue="skin.{$skin}" />
            </h2>
            <xsl:call-template name="common-content-body-content-rich">
                <xsl:with-param name="content" select="metadata/requiredProfile"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-contacts">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/contacts)">
            <h2 class="ametys-richtext-title-2">
                <i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_CONTACTS" i18n:catalogue="skin.{$skin}" />
            </h2>
            <xsl:call-template name="common-content-body-content-rich">
                <xsl:with-param name="content" select="metadata/contacts"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-additional-info">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/additionalInfo)">
            <h2 class="ametys-richtext-title-2">
                <i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_ADDITIONAL_INFO" i18n:catalogue="skin.{$skin}" />
            </h2>
            <xsl:call-template name="common-content-body-content-rich">
                <xsl:with-param name="content" select="metadata/additionalInfo"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="closing-date">
        <xsl:if test="metadata/closingDate">
            <div class="block limite">
                <div class="icon">
                    <svg version="1.1" id="Layer_1"
                        xmlns="http://www.w3.org/2000/svg"
                        xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                        viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;"
                        xml:space="preserve">
                    <path
                        d="M490.3,0.8l-479,156.5c-13.5,4.4-15.5,22.8-3.2,30l181,105.3c5.7,3.3,12.8,2.9,18.1-1l50.9-37.8l-37.8,50.9
                    c-3.9,5.3-4.3,12.4-1,18.1l105.3,181c7.2,12.3,25.6,10.3,30-3.2l156.5-479C515.4,8.8,503.1-3.3,490.3,0.8L490.3,0.8z M334.7,455.3
                    l-81.2-139.7l98-131.9c4.9-6.6,4.2-15.7-1.6-21.5c-5.8-5.8-15-6.5-21.5-1.6l-131.9,98L56.7,177.3l413-134.9L334.7,455.3z
                     M173.4,361.9L63.7,471.6c-6.4,6.4-16.9,6.5-23.4,0c-6.5-6.4-6.5-16.9,0-23.4l109.7-109.7c6.5-6.4,16.9-6.5,23.4,0
                    C179.9,345,179.9,355.5,173.4,361.9z M28.5,366.1c-6.5-6.5-6.5-16.9,0-23.4l43.3-43.3c6.4-6.5,16.9-6.5,23.4,0
                    c6.5,6.5,6.5,16.9,0,23.4l-43.3,43.3C45.4,372.5,35,372.5,28.5,366.1z M212.5,416.8c6.5,6.4,6.5,16.9,0,23.4l-43.3,43.3
                    c-3.2,3.2-7.5,4.8-11.7,4.8c-14.6,0-22.1-17.8-11.7-28.2l43.3-43.3C195.6,410.4,206.1,410.4,212.5,416.8L212.5,416.8z" />
                </svg>

                </div>
                <span class="title"><i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_CLOSING_DATE" i18n:catalogue="skin.{$skin}"/></span>

                <span class="value">
                    <xsl:call-template name="date-format">
                        <xsl:with-param name="date" select="metadata/closingDate" />
                    </xsl:call-template>
                </span>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="start-date">
        <xsl:if test="metadata/startDate">
            <div class="block dispo">
                <div class="icon">
                    <svg version="1.1" id="Calque_1"
                        xmlns="http://www.w3.org/2000/svg"
                        xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                        viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;"
                        xml:space="preserve">
                          <path
                        d="M467,60h-46.9c-1.4-12.7-4.7-24.5-9.5-34.1C402.3,9.2,390,0,376,0s-26.3,9.2-34.6,25.9c-4.8,9.7-8.1,21.4-9.5,34.1h-31.7
                          c-1.4-12.7-4.7-24.5-9.5-34.1C282.3,9.2,270,0,256,0s-26.3,9.2-34.6,25.9c-4.8,9.7-8.1,21.4-9.5,34.1h-31.7
                          c-1.4-12.7-4.7-24.5-9.5-34.1C162.3,9.2,150,0,136,0s-26.3,9.2-34.6,25.9c-4.8,9.7-8.1,21.4-9.5,34.1H45C20.2,60,0,80.2,0,105v362
                          c0,24.8,20.2,45,45,45h422c24.8,0,45-20.2,45-45V105C512,80.2,491.8,60,467,60z M368.2,39.3c3.8-7.7,7.3-9.3,7.8-9.3s4,1.6,7.8,9.3
                          c2.8,5.7,4.9,12.9,6.1,20.7h-27.8C363.3,52.1,365.4,45,368.2,39.3z M248.2,39.3c3.8-7.7,7.3-9.3,7.8-9.3s4,1.6,7.8,9.3
                          c2.8,5.7,4.9,12.9,6.1,20.7h-27.8C243.3,52.1,245.4,45,248.2,39.3z M128.2,39.3c3.8-7.7,7.3-9.3,7.8-9.3s4,1.6,7.8,9.3
                          c2.8,5.7,4.9,12.9,6.1,20.7h-27.8C123.3,52.1,125.4,45,128.2,39.3z M45,90h104.9c-1.2,7.9-3.3,15-6.1,20.7c-3.8,7.7-7.3,9.3-7.8,9.3
                          c-8.3,0-15,6.7-15,15s6.7,15,15,15c14,0,26.3-9.2,34.6-25.9c4.8-9.7,8.1-21.4,9.5-34.1h89.8c-1.2,7.9-3.3,15-6.1,20.7
                          c-3.8,7.7-7.3,9.3-7.8,9.3c-8.3,0-15,6.7-15,15s6.7,15,15,15c14,0,26.3-9.2,34.6-25.9c4.8-9.7,8.1-21.4,9.5-34.1h89.8
                          c-1.2,7.9-3.3,15-6.1,20.7c-3.8,7.7-7.3,9.3-7.8,9.3c-8.3,0-15,6.7-15,15s6.7,15,15,15c14,0,26.3-9.2,34.6-25.9
                          c4.8-9.7,8.1-21.4,9.5-34.1H467c8.3,0,15,6.7,15,15v76H30v-76C30,96.7,36.7,90,45,90z M467,482H45c-8.3,0-15-6.7-15-15V211h452v256
                          C482,475.3,475.3,482,467,482z" />
                          <path
                        d="M436,241H76c-8.3,0-15,6.7-15,15v181c0,8.3,6.7,15,15,15h360c8.3,0,15-6.7,15-15V256C451,247.7,444.3,241,436,241z M421,331
                          h-60v-60h60V331z M241,361v61h-60v-61H241z M181,331v-60h60v60H181z M271,361h60v61h-60V361z M271,331v-60h60v60H271z M151,271v60
                          H91v-60H151z M91,361h60v61H91V361z M361,422v-61h60v61H361z" />
                      </svg>
    
    
                </div>
                <span class="title"><i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_START_DATE"  i18n:catalogue="skin.{$skin}"/></span> 
                <span  class="value"> 
                    <xsl:call-template name="date-format"> 
                        <xsl:with-param name="date" select="metadata/startDate" />
                    </xsl:call-template>
                </span> 
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-application-form-header">
        <h2 class="ametys-richtext-title-1">
            <i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_APPLY" i18n:catalogue="skin.{$skin}"/>
        </h2>
    </xsl:template>
	
</xsl:stylesheet>