<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="ametys">

	<xsl:import href="plugin:myfavorites://stylesheets/content/myfavorites/myfavorites-main.xsl"/>	
	<xsl:import href="myfavorites.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">ametys-cms-service kiosque-section</xsl:variable>
	
    <xsl:template name="common-content-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/zone_kiosque.css')}"/>
        
        <!-- BEGIN head-css-slick-carousel -->
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick-theme.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/accessible-slick-theme.css')}" type="text/css" />
        <!-- END head-css-slick-carousel -->
    </xsl:template>
    
    <xsl:template name="common-content-head-js">
        <script type="text/javascript" src="{ametys:skinURL('plugins/slick/slick.js')}"></script>
        
        <script type="text/javascript">
            $j(document).ready(function(){
                $j('#kiosk-<xsl:value-of select="$uniqueId"/>').slick({
                      regionLabel: "<i18n:text i18n:key="SKIN_MYFAVORITES_CAROUSEL_REGION_LABEL" i18n:catalogue="skin.{$skin}"/>",
                      infinite: false,
                      autoplay: false,
                      dots: true,
                      pauseOnDotsHover:true,
                      arrows: false,
                      slidesToShow: 5,
                      slidesToScroll: 5,
                      ametysDotsBtnPrefixLabel: "<i18n:text i18n:key="SKIN_MYFAVORITES_CAROUSEL_DOTS_PREFIX" i18n:catalogue="skin.{$skin}"/>",
                      responsive: [
                    
                    {
                      breakpoint: 1480,
                      settings: {
                        slidesToShow: 4,
                        slidesToScroll: 1
                      }
                    },
                    {
                      breakpoint: 1024,
                      settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1
                      }
                    },
                    {
                      breakpoint: 700,
                      settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                      }
                    },
                    {
                      breakpoint: 500,
                      settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                      }
                    }
                  ]
                })
            });
        </script>
    </xsl:template>
    
	<xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        
        <xsl:choose>
            <xsl:when test="$template = 'index'">
                <div class="flex-title">
                    <h1 class="service-title"><xsl:value-of select="$title"/></h1>
                    
                    <xsl:if test="$subtitle">
                        <div class="ametys-content-subtitle">
    		           		<xsl:value-of select="$subtitle"/>
    		            </div>
                    </xsl:if>
                </div>
            </xsl:when>
            <xsl:when test="not($zone = 'default') or not(ametys:pageId())">
                <h1 class="ametys-content-title">
                    <xsl:value-of select="$title"/>
                </h1>
                
                <xsl:if test="$subtitle">
                    <div class="ametys-content-subtitle">
    	           		<xsl:value-of select="$subtitle"/>
    	            </div>
                </xsl:if>
            </xsl:when>
        </xsl:choose>
    </xsl:template>	
    
	<xsl:template name="common-content-body-content">
        <xsl:param name="title" select="metadata/title"/>
    
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
    	
    	<xsl:choose>
    		<xsl:when test="$template = 'fullpage' or $template = 'page'">
    			<div class="container">
    				<xsl:call-template name="entries"/>
    			</div>
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:call-template name="entries"/>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>	
	
</xsl:stylesheet>
