<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="ametys">

	<xsl:import href="plugin:multimedia://stylesheets/content/photosGallery/photosGallery-main.xsl"/>	
	
	<xsl:variable name="common-content-css-class-name">photosgallery view-main</xsl:variable>    
	
    <xsl:template name="common-content-head-css">
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/simple-lightbox.min.css')}" type="text/css" />
    </xsl:template>
    
    <xsl:template name="common-content-head-js">
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/simple-lightbox.jquery.min.js')}"/>
        <script type="text/javascript">
            $j(document).ready(function () {
                $j('#gallery-<xsl:value-of select="$uniqueId"/> a').simpleLightbox();
            });
        </script>
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
    	<!-- Image -->
    	<xsl:if test="not($zone = 'default') or not(ametys:pageId())">
    		<xsl:call-template name="common-content-body-image-bigsize"/>    
        </xsl:if>
        
        <!-- Rich content -->
        <xsl:call-template name="common-content-body-content-rich"/>
        
        <div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
            
        <!-- Photos -->            
        <xsl:call-template name="photos"/>
        
        <!-- Comments -->
        <xsl:call-template name="common-content-body-comments"/>        
    </xsl:template>	
    
	<xsl:template name="photos">
		<xsl:if test="metadata/photos/entry/image">
			<div class="service-gallery" id="gallery-{$uniqueId}">
				<div class="container-gallery">
					<xsl:for-each select="metadata/photos/entry[image]">
						<xsl:call-template name="photo"/>
					</xsl:for-each>
				</div>
			</div>
			
			<div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="photo">
		<a href="{resolver:resolve(image/@type, image/@path)}">
			
			<xsl:attribute name="rel">
				<xsl:choose>
					<xsl:when test="count(../entry[image]) &gt; 1"><xsl:text>gallery</xsl:text></xsl:when>
					<xsl:otherwise><xsl:text>single</xsl:text></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="class">
				<xsl:text>pirobox</xsl:text>
				<xsl:if test="count(../entry[image]) &gt; 1"><xsl:text>_gall_</xsl:text><xsl:value-of select="$uniqueId"/></xsl:if>
			</xsl:attribute>

			<xsl:attribute name="title">
				<xsl:choose>
					<xsl:when test="alt-text != ''"><xsl:value-of select="alt-text"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="image/@filename"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			
			<xsl:if test="$rendering-context = 'back'">
				<xsl:attribute name="internal">internal</xsl:attribute>
			</xsl:if>
			
			<img src="{resolver:resolveCroppedImage(image/@type, image/@path, 500, 500)}" alt="{alt-text}"/>
		</a>
    </xsl:template>
	
</xsl:stylesheet>
