<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                xmlns:math="http://exslt.org/math" 
                extension-element-prefixes="ametys math exslt">
    
    <xsl:import href="plugin:forms://stylesheets/forms/questions/choices-list.xsl"/>
    
    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'combobox' and additional-infos/options/@remoteData != 'true']" mode="display-fn">
        $j().ready(function() {
            $j('#<xsl:value-of select="translate(@name, ' ', '_')" />_<xsl:value-of select="$uniqueId" />').ametysMultiselect({
                multiple: "<xsl:value-of select="multiple"/>" == 'true',
                placeholder: "<xsl:value-of select="placeholder"/>",
                label: "<xsl:value-of select="title"/>",
                toggleBtnLabel: "<i18n:text i18n:key="SKIN_FORMS_MULTISELECT_TOGGLE_BTN_LABEL" i18n:catalogue="skin.{$skin}"/>"
            });
        });
    </xsl:template>
    
    <!-- Override to remove placeholder --> 
    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'combobox' and additional-infos/options/@remoteData != 'true']" mode="input">
        <xsl:param name="name" select="@name"/>
        
        <xsl:variable name="entryValues" select="entry-value/additional-infos/values" />
        <select name="{$name}" id="{translate($name, ' ', '_')}_{$uniqueId}" data-list="{$uniqueId}" onchange="onChangeFunction_{translate($name, '-', '_')}_{$uniqueId}(this)">
            <xsl:if test="multiple = 'true'">
                <xsl:attribute name="multiple" >true</xsl:attribute>
            </xsl:if>
            <xsl:if test="mandatory = 'true'">
                <xsl:attribute name="aria-required">true</xsl:attribute>
            </xsl:if>
            <xsl:if test="mandatory != 'true' and multiple != 'true'">
                <option id="empty-{translate($name, ' ', '_')}" value=""/>
            </xsl:if>
            <xsl:apply-templates select="additional-infos/options[@remoteData = 'false']/option">
                <xsl:with-param name="name" select="$name" />
                <xsl:with-param name="entryValues" select="$entryValues" />
            </xsl:apply-templates> 
        </select>
    </xsl:template>
    
</xsl:stylesheet>