<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">

	<xsl:import href="skin://stylesheets/search.xsl" />
    <xsl:import href="wa://tracking"/>
    <xsl:import href="plugin:web://stylesheets/helper/fastsearch.xsl"/>
    <xsl:import href="plugin:rocket.chat?://stylesheets/rocket.chat.xsl" />

	<!-- + 
	     | HEAD
	     + -->
	<xsl:template name="head">
		<head>
				<xsl:call-template name="head-meta-top"/>
                
   				<title><xsl:call-template name="get-title"/></title>
   				

				<xsl:call-template name="meta" />
				<xsl:call-template name="og-meta" />
                
				<xsl:call-template name="common-css" />
				<xsl:call-template name="additionnal-css" />

				<xsl:call-template name="common-rss" />
				<xsl:call-template name="additionnal-rss" />

				<xsl:call-template name="common-script" />
				<xsl:call-template name="additionnal-script" />
				
                <xsl:call-template name="web-tracking"/>
   		</head>
	</xsl:template>
	
	
	<xsl:template name="get-title">
		<xsl:choose>
			<xsl:when test="/cms/page"><xsl:value-of select="/cms/page/@long-title" /><xsl:text> - </xsl:text></xsl:when>
			<xsl:when test="/cms/html/head/title"><xsl:value-of select="/cms/html/head/title" /><xsl:text> - </xsl:text></xsl:when>
		</xsl:choose>
		<i18n:text i18n:key="SKIN_TITLE" i18n:catalogue="skin.{$skin}"/>
	</xsl:template>
	
	<!-- + 
	     | META
	     + -->
	<xsl:template name="meta">
		<meta name="author" content="Ametys V4" />
        <meta name="copyright" content="Ametys V4" />
		<meta name="language" content="{$lang}" />
		<meta name="revisit-after" content="15 days" />
	 	
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.subject']">
    	 	<meta name="subject" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.subject']/@content}"/>
    	</xsl:if>
	 	
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.description']">
    		<meta name="description" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.description']/@content}"/>
    	</xsl:if>
        
        <!-- Copy Dublin Core metadata. -->
        <xsl:copy-of select="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[starts-with(@name, 'DC.')]"/>
	</xsl:template>
	
	<!-- + 
         | OPEN GRAPH META
         + -->
	<xsl:template name="og-meta">
		<xsl:comment>
			<xsl:for-each select="/cms/page/pageContents/zone[@name = 'default']/zoneItem[information/type = 'CONTENT'][1]/html/head">
					<meta property="og:title" content="{meta[@name = 'DC.title']/@content}" />
					<xsl:if test="meta[@name = 'DC.description']">
						<meta property="og:description" content="{meta[@name = 'DC.description']/@content}" />
					</xsl:if>
					<xsl:if test="meta[@name = 'DC.type']">
						<meta property="og:type" content="{meta[@name = 'DC.type']/@content}" />
					</xsl:if>
			</xsl:for-each>
		</xsl:comment>
	</xsl:template>


	<!-- + 
         | COMMON CSS
         + -->
    <xsl:template name="head-css-jquery">
    	<link media="screen, print" rel="stylesheet" href="{ametys:skinURL('plugins/css/jquery-ui.css')}" type="text/css" />
    </xsl:template>
    
	<xsl:template name="common-css">
		<link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6-free', 'css/all.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('font/montserrat/montserrat.css')}" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('font/intranet/IntranetIcon.css')}" type="text/css" />
        
    	<link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/animate.css')}" type="text/css" />
    	<link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/multiselect.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/owl-carousel.min.css')}" type="text/css" />
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/owl-carousel-defaut-theme.min.css')}" />
	    <link rel="stylesheet" media="screen, print" href="{ametys:skinURL('plugins/css/animate.css')}" type="text/css" />	
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/custombox/custombox.min.css')}" type="text/css" />
        
        <xsl:call-template name="rocket.chat-css">
            <xsl:with-param name="only-dependencies" select="true()"/>
        </xsl:call-template>

        <xsl:call-template name="custom-css"/>
        
        <xsl:call-template name="head-css-fancybox"/>
	</xsl:template>
    
    <!-- + 
         | CUSTOM CSS / ADDITIONAL FONTS
         + -->
    <xsl:template name="custom-css">
        <!-- Insert your custom css here (ex: additional fonts )-->
    </xsl:template>

	<!-- + 
         | ADDITIONNAL CSS
         + -->
	<xsl:template name="additionnal-css"/>


	<!-- + 
         | COMMON RSS
         + -->
	<xsl:template name="common-rss"/>

	<!-- + 
         | ADDITIONNAL RSS
         + -->
	<xsl:template name="additionnal-rss"/>
		
	<!-- + 
         | COMMON SCRIPT
         + -->
	<xsl:template name="common-script">
        <!-- <script type="text/javascript" src="{ametys:skinURL('plugins/js/fontawesome.js')}"/> -->
	    <script type="text/javascript" src="{ametys:skinURL('plugins/js/owl-carousel.min.js')}" />
	    <script type="text/javascript" src="{ametys:skinURL('plugins/js/multiselect.js')}" />
	    <script type="text/javascript" src="{ametys:skinURL(concat('plugins/js/ametys-tools.', ametys:lang(), '.js'))}"></script>
	    <script type="text/javascript" src="{ametys:skinURL('plugins/custombox/custombox.min.js')}" />
	    <script type="text/javascript" src="{ametys:skinURL('plugins/hammerjs/hammer.min.js')}" />
	    <script type="text/javascript" src="{ametys:skinURL('plugins/muuri/dist/muuri.js')}" />
	    <script type="text/javascript" src="{ametys:skinURL('plugins/js/svgconvert.js')}" />
	    
        <xsl:call-template name="rocket.chat-scripts"/>

        <!-- jQuery migrate 3.3.1 -->
	    <script type="text/javascript" src="{ametys:skinURL('plugins/js/jquery-migrate/jquery-migrate.min.js')}"></script>
        
        <!-- Handle placeholder on selectmenu -->
        <script type="text/javascript"> 
        $j.widget( 'app.selectmenu', $j.ui.selectmenu, {
            _drawButton: function() {
                this._super();
                
                var selected = this.element
                        .find( '[selected]' )
                        .length,
                    placeholder = this.options.placeholder;
                
                if ( !selected &amp;&amp; placeholder ) {
                    this.buttonItem.text( placeholder );  
                    this.buttonItem.addClass("placeholder");  
                }
            }
        });
        </script>
        
        <xsl:call-template name="head-js-fancybox"/>
	
	    <script type="text/javascript" src="{ametys:pluginResourceURL('link-directory', 'js/LinkDirectoryHelper.js')}"></script>
        
        <!-- Notification links -->
        <xsl:call-template name="link-dynamic-info-js">    
            <xsl:with-param name="maxItems">4</xsl:with-param>    
            <xsl:with-param name="themes" select="/cms/inputData/linkDirectory[@id='notifications']/themes"/>    
        </xsl:call-template> 
        
        <script type="text/javascript" src="{ametys:pluginResourceURL('front-notification', 'js/FlashInfo.js')}"></script>
        
        <script type="text/javascript">
            contextPath = "<xsl:value-of select="ametys:siteUriPrefix()"/>"; 
        </script>
        
        <xsl:call-template name="header-js"/>
        <xsl:call-template name="head-fastsearch-script"/>
        <xsl:call-template name="head-js-matomo"/>
        <xsl:call-template name="head-js-subscriptions"/>
        <xsl:call-template name="main-menu-js"/>
        
        <xsl:call-template name="custom-script"/>
    </xsl:template>
    
    <!-- + 
         | CUSTOM SCRIPTS
         + -->
    <xsl:template name="custom-script">
        <!-- Insert your custom scripts here-->
    </xsl:template>
        
    <xsl:template name="header-js"/>
    
    <!-- JS to follow page button and subscriptions notifications -->
    <xsl:template name="head-js-subscriptions">
        <xsl:if test="$pageFollowEnabled = 'true'">
           <script type="text/javascript" src="{$uri-prefix}/plugins/page-subscription/resources/js/AmetysFront/UserPageSubscriptions.{ametys:lang()}.js"/>
        </xsl:if>
        <xsl:if test="$notificationCenterEnabled = 'true'">
            <script type="text/javascript" src="{$uri-prefix}/plugins/page-subscription/resources/js/AmetysFront/UserNotifications.{ametys:lang()}.js"/>
        </xsl:if>
    </xsl:template>
	
    <xsl:template name="head-js-matomo">
        <script src="{ametys:pluginResourceURL('web-analytics', 'js/AmetysMatomoHelper.js')}" type="text/javascript"/>
        <!-- Tooltip -->
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/poppers.min.js')}" />
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min')}" />
    </xsl:template>
    
	<!-- + 
         | ADDITIONNAL SCRIPT
         + -->	
	<xsl:template name="additionnal-script"/>
	
    <xsl:template name="favico">
        <xsl:choose>
            <xsl:when test="ametys:skinResources('templates/common/img/favicon/favicon.ico')">
                <link rel="icon" type="image/x-icon" href="{ametys:skinURL('templates/common/img/favicon/favicon.ico')}" />
                <link rel="shortcut icon" type="image/x-icon" href="{ametys:skinURL('templates/common/img/favicon/favicon.ico')}" />
            </xsl:when>
            <xsl:otherwise>
                <link rel="icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
                <link rel="shortcut icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
            </xsl:otherwise>
        </xsl:choose>
        <meta name="msapplication-config" content="{ametys:skinURL('templates/common/img/favicon/browserconfig.xml')}" /> 
        <meta name="theme-color" content="#ffffff" /> 
    </xsl:template>
    
	<xsl:template name="head-meta-top">
		<meta content="IE=9" http-equiv="X-UA-Compatible" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    </xsl:template>	
    
    <xsl:template name="main-menu-js">
        <script type="text/javascript">
            // Close mobile menu on escape
            const hideMobileMenuOnEscape = (event) => {
                if (event.key === "Escape") {
                    var $currentOpenMenu = $j(".second nav ul li.open");
                    if ($currentOpenMenu.length)
                    {
                        closeSubMenu($currentOpenMenu); // close opened submenu
                    }
                    else if ($j(".second.open").length)
                    {
                        closeSecondMobile(); // close main menu
                    }
                }
            };
            
            // Close submenu on escape
           const espaceKeySubmenu = (event) => {
                if (event.key === "Escape") {
                    var $currentOpenMenu = $j(".second nav ul li.open");
                    closeSubMenu($currentOpenMenu);
                }
            }
            
            // Open main menu on mobile
            function openSecondMobile(e) {
                $j(e).attr('aria-expanded', 'true');
                $j('.second').addClass('open');
                $j('.second > .close').focus();
                
                // Trap focus into menu
                AmetysFront.Accessibility.trapFocus($j('.second.open').get(0), true);
                
                // Close menu or submenu when ESCAPE key is pressed
                $j('.second.open').on('keydown', hideMobileMenuOnEscape);
            }

            // Close main menu on mobile
            function closeSecondMobile() {
                $j('.second').removeClass('open');
                
                AmetysFront.Accessibility.untrapFocus($j('.second').get(0));
                $j('.second').off('keydown', hideMobileMenuOnEscape);
    
                $j('.icons .open-menu-mobile').attr('aria-expanded', 'false');
                
                setTimeout(function() {
                    $j('.icons .open-menu-mobile').focus(); // replace focus after css animation
                }, 20);
            }
                    
            function closeSubMenu($li) {
                $li.removeClass('open');
                $li.find(".submenu").removeClass('active');
                let $btn = $li.find(".open-submenu");
                $btn.removeClass('expanded');
                $btn.attr("aria-expanded", false);
                $btn.focus();
                
                const isDesktop = $j('.second.open').length == 0;
                if (isDesktop)
                {
                    $li.off('keydown', espaceKeySubmenu);
                }
            }
            
            function closeSubMenuMobile(e) {
                closeSubMenu($j(e).closest('li'));
            }
            
            $j(document).ready(function () {
                
                // Open submenu on click
                $j('.second nav ul li .open-submenu').click(function() {
                    
                    const isDesktop = $j('.second.open').length == 0;
                    const isOpen = $j(this).attr('aria-expanded') === 'true' || false;
                    
                    if (!isOpen)
                    {
                        // Close other submenus
                        closeSubMenu($j(this).closest('ul').find('li.open'));
                        
                        // Open submenu
                        $j(this).closest('li').addClass('open');
                        $j(this).attr("aria-expanded", true);
                        $j(this).addClass("expanded");
                        $j(this).next().addClass("active");
                        
                        $j(this).closest('li').find('.submenu a').first().focus();
                        
                        if (isDesktop)
                        {
                            // Listener to close submenu on Escape key
                            $j(this).closest('li').on('keydown', espaceKeySubmenu);                      
                        }
                    }
                    else
                    {
                        closeSubMenu($j(this).parent());
                    }
                });
                
                // Close submenu on click ouside submenu
                $j(document).click(function(e) {
                    if ($j(e.target).closest('.second').length == 0 &amp;&amp; $j('.second ul li.open').length)
                    {
                        // menu is open, close it
                        closeSubMenu($j('.second ul li.open'));
                    }
                });
            });
        </script>
    </xsl:template>
    
</xsl:stylesheet>
