<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
   
   <!-- API key for OpenWeather meteo widget. See https://home.openweathermap.org/api_keys -->
   <xsl:variable name="openWeatherAPIKey" select="ametys:config('intranet.openweather-api-key')"/>
   
   <!-- +
         | METEO
         + -->
	<xsl:template name="meteo-widget">
        <xsl:if test="$openWeatherAPIKey != ''">
    		<div class="meteo">
                <div class="flex">
                    <div class="pencil">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20" height="20" viewBox="0 0 20 20">
                            <image id="pen" width="20" height="20"
                                xlink:href="data:img/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAABJklEQVQ4jaXUvyuFURgH8I8fKYtF98poE8pmsJC6ZUTuwqZMFpvJ6j/AwlV0F0RZTGS6u/zIcGMy+JHNYsDwnrdeutz3vveps5ynPn3PU89pqRamZKg8tjGJJ6ygDO0ZsBzO8IYxDKOELmw2CuZwjiEsohLOIw7w3poBe8ACNjAfeidYxlrahElsFh/h7IR+GZfoSQPWwmJEQDswh9N64F9YXOWAlXCNif9mWA8TsOkYw8tfYFrsEH0xBrXAzFgtsCnsN9g0xs/V20MvRrJiyYR5FPCJLbRlwZLgDG4xKlr43QSaGkuCReyjivEE2tkIRjTDfECWwl2MVnCP17RYnDB+7h36sYpjdIsWPjUWJyziC1cYwAXWcYTntFASHMSN6IPMhCTrG5v5YR+mS9LZAAAAAElFTkSuQmCC" />
                        </svg>
                    </div>
                    <section>
                        <span class="degree">
                            <span class="nb"></span>°
                        </span>
                        <span class="description"></span>
                    </section>
                    <div class="icon-meteo-container">
                        <img src="" class="icon-meteo" />
                    </div>
                </div>
            
                <div class="dropdown dropdown-meteo">
                    <xsl:call-template name="meteo-dropdown-title" />
                    <xsl:call-template name="meteo-dropdown-towns" />
                </div>
                
                <xsl:call-template name="meteo-js"/>
            </div>
        </xsl:if>
	</xsl:template>
    
    <xsl:template name="meteo-js">
        <script type="text/javascript">
            $j(document).ready(function () {

                var townMeteo = localStorage.getItem('townMeteo');

                if (townMeteo != null) {
                    loadTownMeteo(townMeteo);
                } else {
                    // load default
                    var defaultTown = $j('.dropdown-meteo li a[data-town-default="true"]').data('town');
                    if (!defaultTown)
                    {
                        // get first town
                        defaultTown = $j('.dropdown-meteo li a').data("town");
                    }
                    loadTownMeteo(defaultTown);
                }
            });

            function loadTownMeteo(town) {
                localStorage.setItem('townMeteo', town);
                
                $j('.link-town').removeClass('active');
                $j(`[data-town="${town}"]`).addClass('active');
                
                $j.get(`https://api.openweathermap.org/data/2.5/weather?lang=fr&amp;q=${town}&amp;appid=<xsl:value-of select="$openWeatherAPIKey"/>&amp;units=metric`, function (data) {
                    $j('.meteo .degree .nb').html(Math.round(data.main.temp));
                    $j('.meteo .description').html(data.weather[0].description);
                    $j('.meteo .icon-meteo').attr('src', `<xsl:value-of select="ametys:skinURL('templates/common/img/icon/weather/${data.weather[0].icon}.png')"/>`);
                });
            }
        
            function openDropdownMeteo() {
                $j('.meteo').find('.dropdown').addClass('open');
            }
            
            function closeDropdownMeteo() {
                $j('.meteo').find('.dropdown').removeClass('open');
            }
            
            $j('.dropdown-meteo [data-town]').on('click', function(e) {
                loadTownMeteo($j(this).data('town'));
            });
            
            $j('.dropdown-meteo').on('click', function(e) {
                e.stopPropagation();
            });
            
            $j('.meteo .pencil').on('click', function(e) {
                e.stopPropagation();
            });
            
            $j('.meteo .pencil svg').on('click', function(e) {
                openDropdownMeteo();
            });
            
            document.addEventListener("click", function (e) {
                closeDropdownMeteo();
            });
        </script>
    </xsl:template>
    
    <xsl:template name="meteo-dropdown-title">
        <h3 class="h3"><i18n:text i18n:key="SKIN_HOME_METEO_DROPDOWN_TITLE" i18n:catalogue="skin.{$skin}"/></h3>
    </xsl:template>
    
    <xsl:template name="meteo-dropdown-towns">
        <ul>
            <li><a href="#" class="link-town" data-town="Bordeaux">Bordeaux</a></li>
            <li><a href="#" class="link-town" data-town="Marseille">Marseille</a></li>
            <li><a href="#" class="link-town" data-town="Paris">Paris</a></li>
            <li><a href="#" class="link-town" data-town="Toulouse" data-town-default="true" >Toulouse</a></li>
            <li><a href="#" class="link-town" data-town="Lyon">Lyon</a></li>
        </ul>
    </xsl:template>
</xsl:stylesheet>