<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:math="java.lang.Math"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                            exclude-result-prefixes="sitemap resolver ametys user">
                            
    <xsl:template name="user-menu">
        <div class="menu-fixed">
            
            <nav role="navigation" class="left" aria-label="skin.{$skin}:SKIN_USER_MENU_PERSONAL_SPACE" i18n:attr="aria-label">
                <xsl:call-template name="user-menu-mobile"/>
                <xsl:call-template name="user-image"/>
                
                <!-- Apps metiers -->
                <xsl:call-template name="user-menu-item-app">
                    <xsl:with-param name="inputDataId" select="'appsMetiers'"/>
                    <xsl:with-param name="themeId" select="'APPS_METIERS'"/>
                    <xsl:with-param name="title"><i18n:text i18n:key="SKIN_USER_MENU_BUSINESS_APP" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="icon"><xsl:call-template name="app-metier-icon"/></xsl:with-param>
                </xsl:call-template>
                
                <!-- Apps RH -->
                <xsl:call-template name="user-menu-item-app">
                    <xsl:with-param name="inputDataId" select="'appsRh'"/>
                    <xsl:with-param name="themeId" select="'APPS_RH'"/>
                    <xsl:with-param name="title"><i18n:text i18n:key="SKIN_USER_MENU_RH_APP" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="icon"><xsl:call-template name="app-rh-icon"/></xsl:with-param>
                </xsl:call-template>
                
                <!-- Favorites -->
                <xsl:call-template name="user-menu-item-app">
                    <xsl:with-param name="inputDataId" select="'myFavorites'"/>
                    <xsl:with-param name="themeId" select="'MES_FAVORIS'"/>
                    <xsl:with-param name="title"><i18n:text i18n:key="SKIN_USER_MENU_MY_FAVORITES" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="icon"><xsl:call-template name="my-favorites-icon"/></xsl:with-param>
                </xsl:call-template>
                
                <!-- Follow pages -->
                <xsl:if test="$rendering-context = 'back' or /cms/page/pageContents/zone[@name='user-menu-followedpages']/zoneItem/html/body/node()">
                    <xsl:call-template name="user-menu-item-app">
                        <xsl:with-param name="inputDataId" select="'followedPages'"/>
                        <xsl:with-param name="title"><i18n:text i18n:key="SKIN_USER_MENU_FOLLOWED_PAGES" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                        <xsl:with-param name="icon"><xsl:call-template name="followed-pages-icon"/></xsl:with-param>
                    </xsl:call-template>
                    <xsl:call-template name="user-menu-followed-pages-js"/>
                </xsl:if>
                
                <!-- RSS feed -->
                <xsl:if test="$rendering-context = 'back' or /cms/page/pageContents/zone[@name='user-menu-1']/zoneItem/html/body/node()">
	                <xsl:call-template name="user-menu-item-app">
	                    <xsl:with-param name="inputDataId" select="'rssFeed'"/>
	                    <xsl:with-param name="title"><i18n:text i18n:key="SKIN_USER_MENU_MY_FEED" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
	                    <xsl:with-param name="icon"><xsl:call-template name="my-feed-icon"/></xsl:with-param>
	                </xsl:call-template>
	            </xsl:if>
                
                <!-- Workspaces -->
                <xsl:call-template name="user-menu-workspace-items"/>
            </nav>
        
            <div class="right" role="dialog" aria-modal="true">
                <xsl:call-template name="personnalize-theme"/>
                <xsl:call-template name="user-top"/>
                
                <!-- Apps metiers -->
                <xsl:call-template name="user-links">
                    <xsl:with-param name="title"><i18n:text i18n:key="SKIN_USER_MENU_BUSINESS_APP" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="inputDataId" select="'appsMetiers'"/>
                    <xsl:with-param name="themeId" select="'APPS_METIERS'"/>
                    <xsl:with-param name="extraLinksTitle"><i18n:text i18n:key="SKIN_USER_MENU_BUSINESS_APP_EXTRA_LINKS_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="addUserLinkTitle"><i18n:text i18n:key="SKIN_USER_MENU_BUSINESS_APP_USER_LINK_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                </xsl:call-template>
                
                <!-- Apps RH -->
                <xsl:call-template name="user-links">
                    <xsl:with-param name="title"><i18n:text i18n:key="SKIN_USER_MENU_RH_APP" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="themeId" select="'APPS_RH'"/>
                    <xsl:with-param name="inputDataId" select="'appsRh'"/>
                    <xsl:with-param name="extraLinksTitle"><i18n:text i18n:key="SKIN_USER_MENU_RH_APP_EXTRA_LINKS_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="addUserLinkTitle"><i18n:text i18n:key="SKIN_USER_MENU_RH_APP_USER_LINK_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                </xsl:call-template>
                
                <!-- Favorites -->
                <xsl:call-template name="user-links">
                    <xsl:with-param name="title"><i18n:text i18n:key="SKIN_USER_MENU_MY_FAVORITES" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="themeId" select="'MES_FAVORIS'"/>
                    <xsl:with-param name="inputDataId" select="'myFavorites'"/>
                    <xsl:with-param name="extraLinksTitle"><i18n:text i18n:key="SKIN_USER_MENU_MY_FAVORITES_EXTRA_LINKS_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="addUserLinkTitle"><i18n:text i18n:key="SKIN_USER_MENU_MY_FAVORITES_USER_LINK_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="filterFormLabelI18nKey" select="concat('skin.', $skin, ':SKIN_USER_MENU_MY_FAVORITES_FILTER_FORM_LABEL')"/>
                    <xsl:with-param name="filterInputLabelI18nKey" select="concat('skin.', $skin, ':SKIN_USER_MENU_MY_FAVORITES_FILTER_LABEL')"/>
                    <xsl:with-param name="extraFilterFormLabelI18nKey" select="concat('skin.', $skin, ':SKIN_USER_MENU_MY_FAVORITES_EXTRA_FILTER_FORM_LABEL')"/>
                    <xsl:with-param name="extraFilterInputLabelI18nKey" select="concat('skin.', $skin, ':SKIN_USER_MENU_MY_FAVORITES_EXTRA_FILTER_LABEL')"/>
                </xsl:call-template>
                
                <!-- Followed pages -->
                <div class="apps menu-followedPages"  id="menu-followedPages">
                    <a name="anchor-followedPages"/>
                    <zone name="user-menu-followedpages" level="2"/>
                </div>
                
                <!-- RSS feed -->
                <div class="apps menu-rssFeed"  id="menu-rssFeed">
                    <a name="anchor-rssFeed"/>
                    <zone name="user-menu-1" level="2"/>
                </div>
                
                <!-- Workspaces -->
                <xsl:call-template name="user-menu-workspaces-zone"/>
            </div>
            <xsl:call-template name="user-menu-js"/>
        </div>             
    </xsl:template>
    
    <xsl:template name="user-menu-workspaces-zone">
        <!-- Projects -->
        <div class="apps menu-projects" id="menu-projects">
            <zone name="user-menu-projects" level="2"/>
        </div>
        
        <!-- Activity stream -->
        <div class="apps menu-activities" id="menu-activities">
            <zone name="user-menu-activities" level="2"/>
        </div>
    </xsl:template>
    
    <!-- User menu items related to workspaces (projects and activity stream) -->
    <xsl:template name="user-menu-workspace-items">
        <xsl:variable name="catalogSiteName" select="ametys:config('workspaces.catalog.site.name')" />
        <xsl:if test="$catalogSiteName != ''">
            <!-- Projects -->
            <xsl:choose>
                <xsl:when test="$rendering-context = 'back' or /cms/page/pageContents/zone[@name='user-menu-projects']/zoneItem/html/body/node()">
                    <xsl:call-template name="user-menu-item-app">
                        <xsl:with-param name="inputDataId" select="'projects'"/>
                        <xsl:with-param name="title"><i18n:text i18n:key="SKIN_USER_MENU_MY_PROJECTS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                        <xsl:with-param name="icon"><xsl:call-template name="my-projects-icon"/></xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <!-- If collaborative spaces service is not inserted, use only a link to catalog website -->
                    <xsl:call-template name="user-menu-item-catalog"/>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- Activity stream -->
            <xsl:if test="$rendering-context = 'back' or /cms/page/pageContents/zone[@name='user-menu-activities']/zoneItem/html/body/node()">
                <xsl:call-template name="user-menu-item-app">
                    <xsl:with-param name="inputDataId" select="'activities'"/>
                    <xsl:with-param name="title"><i18n:text i18n:key="SKIN_USER_MENU_ACTIVITIES" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="icon"><xsl:call-template name="activities-icon"/></xsl:with-param>
                </xsl:call-template>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-menu-mobile">
        <button type="button" class="open-menu-mobile is-closed" onclick="openMenuMobile()">
            <div class="icon-block">
                <span class="material-icons" aria-hidden="true">expand_less</span>
                <span><i18n:text i18n:key="SKIN_USER_MENU_PERSONAL_SPACE" i18n:catalogue="skin.{$skin}"/></span>
            </div>
        </button>
        <button type="button" class="open-menu-mobile close-menu-mobile is-open" onclick="closeMenu(this)">
            <div class="icon-block">
                <span class="material-icons" aria-hidden="true">expand_more</span>
                <span><i18n:text i18n:key="SKIN_USER_MENU_CLOSE" i18n:catalogue="skin.{$skin}"/></span>
            </div>
        </button>
    </xsl:template>
    
    <xsl:template name="user-image">
        <xsl:variable name="currentUserPageId" select="user:getCurrentUserPage($lang)"/>
        <xsl:variable name="currentUser" select="ametys:user()"/>
        <a href="{resolver:resolve('page', $currentUserPageId, false)}" title="skin.{$skin}:SKIN_USER_MENU_SEE_PROFILE" i18n:attr="title">
            <div class="picture">
                <xsl:call-template name="user-profile-image">
                    <xsl:with-param name="size">100</xsl:with-param>
                    <xsl:with-param name="login" select="$currentUser/user/@login"/>
                    <xsl:with-param name="population" select="$currentUser/user/@population"/>
                </xsl:call-template>
            </div>
        </a>
    </xsl:template>
    
    <xsl:template name="user-menu-item-app">
        <xsl:param name="themeId"/>
        <xsl:param name="inputDataId"/>
        <xsl:param name="title"/>
        <xsl:param name="icon"/>
        
        <button type="button" aria-expanded="false" class="link-menu-{$inputDataId}" onclick="openMenu(this)" data-user-menu-id="{$inputDataId}" aria-controls="menu-{$inputDataId}">
            <div class="icon-block">
                <xsl:copy-of select="$icon"/>
                <span><xsl:copy-of select="$title"/></span>
                <span class="sr-only" aria-live="polite" data-count="0"></span>
            </div>
        </button>
    </xsl:template>    
    
    <xsl:template name="app-metier-icon">
        <svg aria-hidden="true" version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg"
            xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 477.9 477.9"
            style="enable-background:new 0 0 477.9 477.9;" xml:space="preserve">
            <g>
                <defs>
                    <rect id="SVGID_1_" width="477.9" height="477.9" />
                </defs>
                <clipPath id="SVGID_2_">
                    <use xlink:href="#SVGID_1_" style="overflow:visible;" />
                </clipPath>
                <path d="M119.5,0H17.1C7.6,0,0,7.6,0,17.1v102.4c0,9.4,7.6,17.1,17.1,17.1h102.4c9.4,0,17.1-7.6,17.1-17.1V17.1
           C136.5,7.6,128.9,0,119.5,0 M102.4,102.4H34.1V34.1h68.3V102.4z" />
                <path d="M290.1,0H187.7c-9.4,0-17.1,7.6-17.1,17.1v102.4c0,9.4,7.6,17.1,17.1,17.1h102.4c9.4,0,17.1-7.6,17.1-17.1
           V17.1C307.2,7.6,299.6,0,290.1,0 M273.1,102.4h-68.3V34.1h68.3V102.4z" />
                <path d="M460.8,0H358.4c-9.4,0-17.1,7.6-17.1,17.1v102.4c0,9.4,7.6,17.1,17.1,17.1h102.4c9.4,0,17.1-7.6,17.1-17.1
           V17.1C477.9,7.6,470.2,0,460.8,0 M443.7,102.4h-68.3V34.1h68.3V102.4z" />
                <path d="M119.5,170.7H17.1c-9.4,0-17.1,7.6-17.1,17.1v102.4c0,9.4,7.6,17.1,17.1,17.1h102.4c9.4,0,17.1-7.6,17.1-17.1
           V187.7C136.5,178.3,128.9,170.7,119.5,170.7 M102.4,273.1H34.1v-68.3h68.3V273.1z" />
                <path d="M290.1,170.7H187.7c-9.4,0-17.1,7.6-17.1,17.1v102.4c0,9.4,7.6,17.1,17.1,17.1h102.4c9.4,0,17.1-7.6,17.1-17.1
           V187.7C307.2,178.3,299.6,170.7,290.1,170.7 M273.1,273.1h-68.3v-68.3h68.3V273.1z" />
                <path d="M460.8,170.7H358.4c-9.4,0-17.1,7.6-17.1,17.1v102.4c0,9.4,7.6,17.1,17.1,17.1h102.4c9.4,0,17.1-7.6,17.1-17.1
           V187.7C477.9,178.3,470.2,170.7,460.8,170.7 M443.7,273.1h-68.3v-68.3h68.3V273.1z" />
                <path d="M119.5,341.3H17.1C7.6,341.3,0,349,0,358.4v102.4c0,9.4,7.6,17.1,17.1,17.1h102.4c9.4,0,17.1-7.6,17.1-17.1
           V358.4C136.5,349,128.9,341.3,119.5,341.3 M102.4,443.7H34.1v-68.3h68.3V443.7z" />
                <path d="M290.1,341.3H187.7c-9.4,0-17.1,7.6-17.1,17.1v102.4c0,9.4,7.6,17.1,17.1,17.1h102.4c9.4,0,17.1-7.6,17.1-17.1
           V358.4C307.2,349,299.6,341.3,290.1,341.3 M273.1,443.7h-68.3v-68.3h68.3V443.7z" />
                <path d="M460.8,341.3H358.4c-9.4,0-17.1,7.6-17.1,17.1v102.4c0,9.4,7.6,17.1,17.1,17.1h102.4c9.4,0,17.1-7.6,17.1-17.1
           V358.4C477.9,349,470.2,341.3,460.8,341.3 M443.7,443.7h-68.3v-68.3h68.3V443.7z" />
            </g>
        </svg>
    </xsl:template> 
    
    <xsl:template name="app-rh-icon">
        <svg aria-hidden="true" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
            xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 309.3 309.3"
            style="enable-background:new 0 0 309.3 309.3;" xml:space="preserve">
            <g>
                <path d="M212.1,142.5h-8.4v-7.4c0-2.1-1.3-3.9-3.2-4.6L170,119.9c-3.8-1.3-6.3-4.9-6.3-8.9l0-3.3c0-3.5,1.9-6.7,4.9-8.4
           c10.4-5.9,17.1-18.6,17.1-32.4c0-19.7-13.2-35.8-29.5-35.8c-16.3,0-29.5,16-29.5,35.8c0,13.9,6.7,26.6,17.1,32.5
           c2.9,1.6,4.3,5.6,4.7,7.3l0.1,0.5l0.1,3.9c0.1,3.8-2.3,7.2-5.9,8.4l-31.8,11c-2,0.7-3.3,2.6-3.3,4.7v7.4h-8.4v-7.4
           c0-5.7,3.6-10.7,8.9-12.6l31.8-11c0.2-0.1,0.3-0.2,0.2-0.4l0-2.8c-0.3-0.7-0.6-1.5-0.9-1.9c-12.8-7.4-21.1-22.9-21.1-39.6
           c0-24.3,17-44.1,37.9-44.1C177,22.8,194,42.6,194,67c0,17.1-8.2,32.3-21.3,39.7c-0.4,0.2-0.6,0.6-0.6,1.1l0,3.3
           c0,0.5,0.3,0.9,0.7,1l30.5,10.6c5.3,1.8,8.9,6.9,8.9,12.5V142.5z" />
            </g>
            <g>
                <rect x="52.7" y="251.3" width="8.4" height="25.8" />
            </g>
            <g>
                <rect x="109.6" y="251.3" width="8.4" height="25.8" />
            </g>
            <g>
                <rect x="194.8" y="251.3" width="8.4" height="25.8" />
            </g>
            <g>
                <rect x="251.7" y="251.3" width="8.4" height="25.8" />
            </g>
            <g>
                <circle cx="155.5" cy="150.2" r="6.8" />
            </g>
            <g>
                <circle cx="155.5" cy="170.3" r="6.8" />
            </g>
            <g>
                <circle cx="155.5" cy="190.4" r="6.8" />
            </g>
            <g>
                <path d="M141.3,277.2h-8.4v-35.1c0-2.1-1.3-3.9-3.2-4.6L99.2,227c-3.8-1.3-6.3-4.9-6.3-8.9l0-3.3c0-3.5,1.9-6.7,4.9-8.4
           c10.4-5.9,17.1-18.6,17.1-32.4c0-19.7-13.2-35.8-29.5-35.8c-16.3,0-29.5,16-29.5,35.8c0,13.9,6.7,26.6,17.1,32.5
           c2.9,1.6,4.3,5.6,4.7,7.3l0.1,0.5l0.1,3.9c0.1,3.8-2.3,7.2-5.9,8.4l-31.8,11c-2,0.7-3.3,2.6-3.3,4.7v35h-8.4v-35
           c0-5.7,3.6-10.7,8.9-12.6l31.8-11c0.2-0.1,0.3-0.2,0.2-0.4l0-2.8c-0.3-0.7-0.6-1.5-0.9-1.9c-12.8-7.4-21.1-22.9-21.1-39.6
           c0-24.3,17-44.1,37.9-44.1c20.9,0,37.9,19.8,37.9,44.1c0,17.1-8.2,32.3-21.3,39.7c-0.4,0.2-0.6,0.6-0.6,1.1l0,3.3
           c0,0.5,0.3,0.9,0.7,1l30.5,10.6c5.3,1.8,8.9,6.9,8.9,12.5V277.2z" />
            </g>
            <g>
                <path d="M283.6,277.2h-8.4v-35.1c0-2.1-1.3-3.9-3.2-4.6L241.6,227c-3.8-1.3-6.3-4.9-6.3-8.9l0-3.3c0-3.5,1.9-6.7,4.9-8.4
           c10.4-5.9,17.1-18.6,17.1-32.4c0-19.7-13.2-35.8-29.5-35.8c-16.3,0-29.5,16-29.5,35.8c0,13.9,6.7,26.6,17.1,32.5
           c2.9,1.6,4.3,5.6,4.7,7.3l0.1,0.5l0.1,3.9c0.1,3.8-2.3,7.2-5.9,8.4l-31.8,11c-2,0.7-3.3,2.6-3.3,4.7v35h-8.4v-35
           c0-5.7,3.6-10.7,8.9-12.6l31.8-11c0.2-0.1,0.3-0.2,0.2-0.4l0-2.8c-0.3-0.7-0.6-1.5-0.9-1.9c-12.8-7.4-21.1-22.9-21.1-39.6
           c0-24.3,17-44.1,37.9-44.1c20.9,0,37.9,19.8,37.9,44.1c0,17.1-8.2,32.3-21.3,39.7c-0.4,0.2-0.6,0.6-0.6,1.1l0,3.3
           c0,0.5,0.3,0.9,0.7,1l30.5,10.6c5.3,1.8,8.9,6.9,8.9,12.5V277.2z" />
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="my-favorites-icon">
        <svg aria-hidden="true" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 214.2 185" style="enable-background:new 0 0 214.2 185;" xml:space="preserve">
            <g>
                <path d="M196.1,185H17.5C7.8,185,0,177.1,0,167.5v-150C0,7.8,7.9,0,17.5,0h62.3C85.1,0,90,2.8,92.7,7.3l16.7,27.9c0.7,1.2,2,1.9,3.4,1.9h83.8c9.7,0,17.6,7.9,17.6,17.6v112.1C214.2,176.8,206.1,185,196.1,185z M17.5,10.2c-4,0-7.3,3.3-7.3,7.3v150c0,4,3.3,7.3,7.3,7.3h178.6c4.4,0,8-3.6,8-8V54.7c0-4.1-3.3-7.4-7.4-7.4h-83.9c-5,0-9.6-2.6-12.2-6.9L83.9,12.5c-0.9-1.4-2.4-2.3-4.1-2.3C79.8,10.2,17.5,10.2,17.5,10.2z"/>
                <path d="M196.5,42.2h-10.2V23c0-4.5-3.6-8.1-8.1-8.1H88.5V4.7h89.7c10.1,0,18.3,8.2,18.3,18.3V42.2z"/>
                <path d="M107.1,157.3"/>
                <path d="M110.7,165.7c-1.3,0-2.5-0.5-3.3-1.4l-34.3-35.8c-3.5-2.5-6.2-7-8.6-11.5l-0.1-0.1c-0.7-0.7-1.1-1.6-1.2-2.6c-1.4-3.3-2-6.8-2-10.4c0-15.1,12.2-27.3,27.3-27.3c7.4,0,14.4,3,19.5,8.2c5.1-5.1,12.1-8.2,19.5-8.2c15.1,0,27.3,12.2,27.3,27.3c0,3.8-0.7,7.4-2.2,10.8c-0.1,0.7-0.4,1.3-0.9,1.9l-0.1,0.1c-0.2,0.3-0.3,0.7-0.5,1c-1.4,2.9-3.1,6.4-5.5,8.6L114.3,164c-0.8,1-2.1,1.6-3.4,1.7C110.9,165.7,110.8,165.7,110.7,165.7z M72.3,111.9c0.1,0.1,0.1,0.2,0.2,0.3c1.1,2.2,3.8,7.3,6.2,8.9c0.3,0.2,0.6,0.4,0.8,0.7l31,32.4l28.2-34c0.2-0.2,0.4-0.4,0.5-0.6c1.1-1,2.7-4.1,3.6-6c0.3-0.6,0.5-1.1,0.8-1.6c0-0.1,0.1-0.2,0.1-0.2s0-0.1,0.1-0.1c1.2-2.5,1.8-5.1,1.8-7.8c0-10-8.1-18.1-18.1-18.1c-6.4,0-12.2,3.3-15.5,8.8c-0.8,1.4-2.3,2.2-4,2.2c-1.6,0-3.1-0.9-4-2.2c-3.3-5.5-9.1-8.8-15.5-8.8c-10,0-18.1,8.1-18.1,18.1c0,2.7,0.6,5.4,1.8,7.8C72.3,111.8,72.3,111.8,72.3,111.9z"/>
            </g>
        </svg>
    </xsl:template>   
    
    <xsl:template name="user-menu-item-catalog">
        <xsl:variable name="catalogSiteName" select="ametys:config('workspaces.catalog.site.name')" />
        
        <xsl:if test="$catalogSiteName != ''">
            <a href="{ametys:absoluteSiteUriPrefix($catalogSiteName)}/fr/index.html" target="_blank">
                <div class="icon-block icon-block-last">
                    <xsl:call-template name="ep-catalog-icon"/>
                    <span><i18n:text i18n:key="SKIN_USER_MENU_PROJECTS_CATALOG" i18n:catalogue="skin.{$skin}"/></span>
                </div>
            </a>
        </xsl:if>     
    </xsl:template>
    
    <xsl:template name="ep-catalog-icon">
        <svg aria-hidden="true" version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg"
            xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 37.3 32.1"
            style="enable-background:new 0 0 37.3 32.1;" xml:space="preserve">
            <g>
                <defs>
                    <rect id="SVGID_1_" y="0" width="37.3" height="32.1" />
                </defs>
                <clipPath id="SVGID_2_">
                    <use xlink:href="#SVGID_1_" style="overflow:visible;" />
                </clipPath>
                <path d="M16.3,32.1c-0.3,0-0.5-0.1-0.6-0.4l-5-8.5H4.4c-2.4,0-4.4-2-4.4-4.4V4.4C0,2,2,0,4.4,0h21.7
           c2.4,0,4.4,2,4.4,4.4v14.4c0,2.4-2,4.4-4.4,4.4h-7.6l-1.4,8.3c-0.1,0.3-0.3,0.6-0.6,0.6C16.4,32.1,16.4,32.1,16.3,32.1 M4.4,1.5
           c-1.6,0-2.9,1.3-2.9,2.9v14.4c0,1.6,1.3,2.9,2.9,2.9h6.7c0.3,0,0.5,0.1,0.6,0.4l4.2,7.1l1.2-6.9c0.1-0.4,0.4-0.6,0.7-0.6h8.2
           c1.6,0,2.9-1.3,2.9-2.9V4.4c0-1.6-1.3-2.9-2.9-2.9H4.4z" />
                <path d="M33,23.9h-1.5c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7H33c1.6,0,2.9-1.3,2.9-2.9V6.7
           c0-1.6-1.3-2.9-2.9-2.9h-3.1c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7H33c2.4,0,4.4,2,4.4,4.4v12.9C37.3,22,35.4,23.9,33,23.9
           " />
                <path
                    d="M26.3,32.1c0,0-0.1,0-0.1,0c-0.3-0.1-0.5-0.3-0.6-0.6L24,22.6c-0.1-0.4,0.2-0.8,0.6-0.9
           c0.4-0.1,0.8,0.2,0.9,0.6l1.2,7l4.1-6.5c0.2-0.3,0.7-0.5,1-0.2c0.3,0.2,0.5,0.7,0.2,1l-5.2,8.1C26.8,31.9,26.5,32.1,26.3,32.1" />
                <path d="M23.1,5.9L23.1,5.9l-18.7,0C4,5.9,3.7,5.5,3.7,5.1c0-0.4,0.3-0.7,0.7-0.7l18.7,0c0.4,0,0.7,0.3,0.7,0.7
           C23.9,5.5,23.5,5.9,23.1,5.9" />
                <path d="M21.2,10.2H6.3c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7h14.9C21.6,8.7,22,9,22,9.4
           C22,9.8,21.6,10.2,21.2,10.2" />
                <path d="M21.2,14.5H6.3c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7h14.9c0.4,0,0.7,0.3,0.7,0.7
           C22,14.2,21.6,14.5,21.2,14.5" />
                <path d="M23.1,18.8L23.1,18.8l-18.7,0c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7l18.7,0c0.4,0,0.7,0.3,0.7,0.7
           C23.9,18.5,23.5,18.8,23.1,18.8" />
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="my-feed-icon">
    	<svg aria-hidden="true" id="Layer_1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 511.86 512"><path d="M229.94,411.89c0-11.04,8.95-19.99,19.99-19.99h40.99c26.53,1.06,26.51,38.94,0,39.99h-40.99c-11.04,0-19.99-8.95-19.99-19.99Zm181.95-175.95h-40.99c-26.53,1.06-26.51,38.94,0,39.99h40.99c26.53-1.06,26.51-38.94,0-39.99Zm0,77.98h-40.99c-26.53,1.06-26.51,38.94,0,39.99h40.99c26.53-1.06,26.51-38.94,0-39.99ZM511.86,19.99V416.89c0,52.37-42.61,94.97-94.97,94.97,0,0-324.86,.31-326.26,0C37.91,511.86,0,466.85,0,415.57V255.93c0-11.04,8.95-19.99,19.99-19.99H149.96V19.99c0-11.04,8.95-19.99,19.99-19.99H491.87c11.04,0,19.99,8.95,19.99,19.99h0ZM149.96,275.93H39.99v139.65c0,30.61,24.9,55.08,54.99,55.3,30.19,.24,54.99-24.16,54.99-54.36v-140.59ZM471.87,39.99H189.95V416.51c0,20.16-6.23,39.33-17.77,55.36h244.71c30.32,0,54.99-24.67,54.99-54.99V39.99Zm-59.98,351.91h-40.99c-26.53,1.06-26.51,38.94,0,39.99h40.99c26.53-1.06,26.51-38.94,0-39.99Zm-161.96-37.99h40.99c26.53-1.06,26.51-38.94,0-39.99h-40.99c-26.53,1.06-26.51,38.94,0,39.99Zm0-233.94h161.96c26.53-1.06,26.51-38.94,0-39.99H249.93c-26.53,1.06-26.51,38.94,0,39.99Zm0,155.96h40.99c26.53-1.06,26.51-38.94,0-39.99h-40.99c-26.53,1.06-26.51,38.94,0,39.99Zm0-79.98h162.96c26.53-1.06,26.51-38.94,0-39.99H249.93c-26.53,1.06-26.51,38.94,0,39.99Z"/></svg>
    </xsl:template>
    
    <xsl:template name="followed-pages-icon">
        <svg xmlns="http://www.w3.org/2000/svg" width="36px" height="35px" viewBox="0 0 36 35">
          <path fill="#fff" d="M10,5.5h16.8c.22,0,.43.02.64.04l.72.08-.17-.7c-.5-2.02-2.29-3.42-4.36-3.42h-10.63c-2.08,0-3.88,1.42-4.37,3.46l-.17.72.73-.11c.26-.04.53-.07.81-.07Z"/>
          <path fill="#fff" d="M30.61,10.54l.72.08-.17-.7c-.5-2.01-2.29-3.42-4.36-3.42H10c-2.04,0-3.83,1.39-4.34,3.37l-.16.63h24.5c.21,0,.41.01.61.04Z"/>
          <path fill="#fff" d="M30,11.5H6c-2.48,0-4.5,2.02-4.5,4.5v12.69c0,2.48,2.02,4.5,4.5,4.5h24c2.48,0,4.5-2.02,4.5-4.5v-12.69c0-2.48-2.02-4.5-4.5-4.5ZM25.96,22.23c0,4.26-3.47,7.73-7.73,7.73s-7.73-3.47-7.73-7.73,3.47-7.73,7.73-7.73,7.73,3.47,7.73,7.73Z"/>
          <path fill="#fff" d="M18.23,15.5c-3.71,0-6.73,3.02-6.73,6.73s3.02,6.73,6.73,6.73,6.73-3.02,6.73-6.73-3.02-6.73-6.73-6.73ZM18.55,22.25v3c0,.28-.5.28-.5,0v-3h-3c-.14,0-.25-.11-.25-.25s.11-.25.25-.25h3v-3c0-.28.5-.28.5,0v3h3c.14,0,.25.11.25.25s-.11.25-.25.25h-3Z"/>
        </svg>
    </xsl:template>
    
    <xsl:template name="my-projects-icon">
        <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="30.62" height="35" viewBox="0 0 30.62 35">
            <defs>
            <filter id="filter" x="1071.91" y="563.156" width="30.62" height="35" filterUnits="userSpaceOnUse">
                <feFlood result="flood" flood-color="#795198"/>
                <feComposite result="composite" operator="in" in2="SourceGraphic"/>
                <feBlend result="blend" in2="SourceGraphic"/>
            </filter>
            </defs>
            <path id="_copie" data-name=" copie" class="cls-1" d="M1100.76,570.657l-11.35-6.9a4.212,4.212,0,0,0-4.4,0l-11.35,6.9a0.584,0.584,0,0,0,.01.989l13.54,8.076,13.54-8.076A0.584,0.584,0,0,0,1100.76,570.657Zm0.94,3.051-13.4,7.99V597a1.1,1.1,0,0,0,1.65.987l10.4-6.322a4.616,4.616,0,0,0,2.17-3.945V574.2A0.548,0.548,0,0,0,1101.7,573.708Zm-29.8.5v13.514a4.593,4.593,0,0,0,2.17,3.945l10.4,6.321a1.1,1.1,0,0,0,1.65-.986V581.7l-13.4-7.99A0.548,0.548,0,0,0,1071.9,574.2Z" transform="translate(-1071.91 -563.156)"/>
        </svg>  
    </xsl:template>
    
    <xsl:template name="activities-icon">
        <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="27.12" height="31" viewBox="0 0 27.12 31">
            <path id="_copie" data-name=" copie" class="cls-1" d="M1088.06,885.258a3.879,3.879,0,0,0,3.88-3.875h-7.75A3.87,3.87,0,0,0,1088.06,885.258Zm13.04-9.064c-1.17-1.257-3.35-3.148-3.35-9.342a9.562,9.562,0,0,0-7.75-9.394V856.2a1.935,1.935,0,1,0-3.87,0v1.262a9.562,9.562,0,0,0-7.75,9.394c0,6.194-2.19,8.085-3.36,9.342a1.917,1.917,0,0,0-.52,1.314,1.944,1.944,0,0,0,1.94,1.938h23.24a1.931,1.931,0,0,0,1.94-1.938A1.829,1.829,0,0,0,1101.1,876.194Z" transform="translate(-1074.5 -854.25)"/>
        </svg>    
    </xsl:template>
    
    <xsl:template name="personnalize-theme">
        <div class="personnalize">
            <span class="text"><i18n:text i18n:key="SKIN_USER_MENU_PERSONALIZE_THEME" i18n:catalogue="skin.{$skin}"/></span>
            <div class="colors">
                <button type="button" class="round color1" onclick="changeColorTheme('color1')" aria-pressed="false">
                    <span class="material-icons" aria-hidden="true">done</span>
                    <span class="sr-only"><i18n:text i18n:key="SKIN_USER_MENU_PERSONALIZE_THEME_CHOOSE_COLOR" i18n:catalogue="skin.{$skin}"/> 1</span>
                </button>
                <button type="button" class="round color2" onclick="changeColorTheme('color2')" aria-pressed="false">
                    <span class="material-icons" aria-hidden="true">done</span>
                    <span class="sr-only"><i18n:text i18n:key="SKIN_USER_MENU_PERSONALIZE_THEME_CHOOSE_COLOR" i18n:catalogue="skin.{$skin}"/> 1</span>
                </button>
                <button type="button" class="round color3" onclick="changeColorTheme('color3')" aria-pressed="false">
                    <span class="material-icons" aria-hidden="true">done</span>
                    <span class="sr-only"><i18n:text i18n:key="SKIN_USER_MENU_PERSONALIZE_THEME_CHOOSE_COLOR" i18n:catalogue="skin.{$skin}"/> 1</span>
                </button>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="user-top">
        <xsl:variable name="currentUser" select="ametys:user()"/>
        
        <xsl:if test="$currentUser">
            <div class="top">
                <span class="name">
                    <strong><xsl:value-of select="$currentUser/user/firstname"/></strong><xsl:text> </xsl:text><xsl:value-of select="$currentUser/user/lastname"/>
                </span>
                <xsl:call-template name="logout"/>
            </div>
    	</xsl:if>
    </xsl:template>
    
    <xsl:template name="logout">
        <a href="{ametys:siteUriPrefix()}/logout.html?requestedURL={ametys:siteUriPrefix()}/{$lang}/index.html">
            <span>
                <i18n:text i18n:key="SKIN_USER_MENU_LOGOUT" i18n:catalogue="skin.{$skin}"/>
            </span>
            <svg aria-hidden="true" version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg"
                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 491.2 345"
                style="enable-background:new 0 0 491.2 345;" xml:space="preserve">
                <g>
                    <defs>
                        <rect id="SVGID_1_" width="491.2" height="345" />
                    </defs>
                    <clipPath id="SVGID_2_">
                        <use xlink:href="#SVGID_1_" style="overflow:visible;" />
                    </clipPath>
                    <path d="M318.7,0c-32.7,0-64.6,9.2-92.1,26.6c-26.8,16.9-48.4,40.9-62.4,69.2l26.9,13.4C215.3,60.3,264.2,30,318.7,30
                        c78.6,0,142.5,63.9,142.5,142.5S397.3,315,318.7,315c-54.5,0-103.4-30.3-127.7-79.2l-26.9,13.4c14.1,28.3,35.7,52.3,62.4,69.2
                        c27.5,17.4,59.4,26.6,92.1,26.6c95.1,0,172.5-77.4,172.5-172.5S413.8,0,318.7,0" />
                    <polygon points="318.7,187.5 318.7,157.5 57.4,157.5 91.8,123.1 70.6,101.9 0,172.5 70.6,243.1 91.8,221.9 57.4,187.5 " />
                </g>
            </svg>
        </a>
    </xsl:template>
    
    <xsl:template name="user-links">
        <xsl:param name="title"/>
        <xsl:param name="themeId"/>
        <xsl:param name="inputDataId"/>
        <xsl:param name="extraLinksTitle"/>
        <xsl:param name="addUserLinkTitle"/>
        <xsl:param name="filterFormLabelI18nKey"/>
        <xsl:param name="filterInputLabelI18nKey"/>
        <xsl:param name="extraFilterFormLabelI18nKey"/>
        <xsl:param name="extraFilterInputLabelI18nKey"/>
        
        <script type="text/javascript">
            <xsl:call-template name="link-dynamic-info-js">   
                <xsl:with-param name="uniqueId" select="$inputDataId"/>   
                <xsl:with-param name="maxItems">4</xsl:with-param>    
                <xsl:with-param name="themes" select="/cms/inputData/linkDirectory[@id=$inputDataId]/themes"/>    
            </xsl:call-template> 
        </script>
        
        <div class="apps menu-{$inputDataId}" id="menu-{$inputDataId}">
            <a name="anchor-{$inputDataId}"/>
            <div class="flex">
                <h3 class="h3"><xsl:copy-of select="$title"/></h3>
                
                <!-- Configure button -->
                <xsl:call-template name="user-links-configure">
                    <xsl:with-param name="themeId" select="$themeId"/>
                    <xsl:with-param name="inputDataId" select="$inputDataId"/>
                </xsl:call-template>
            </div>
            
            <!-- Search filter on selected links -->
            <xsl:call-template name="user-links-search-filter">
                <xsl:with-param name="themeId" select="$themeId"/>
                <xsl:with-param name="inputDataId" select="$inputDataId"/>
                <xsl:with-param name="filterFormLabelI18nKey" select="$filterFormLabelI18nKey"/>
                <xsl:with-param name="filterInputLabelI18nKey" select="$filterInputLabelI18nKey"/>
            </xsl:call-template>
            
            <div class="ametys-tools" id="tool-ametys_{$inputDataId}">
                <input data-edit-mode-toggle="" type="checkbox" id="tool-toggle-ametys_{$inputDataId}" class="ametys-toggle__check ametys-edit-mode-checker"/>

                <!-- Selected links -->
                <div class="">
                    <p data-no-items-text="" class="ametys-tools-no-items-text"><i18n:text i18n:key="SKIN_USER_MENU_SEARCH_NO_LINK" i18n:catalogue="skin.{$skin}"/></p>

                    <div id="selected-links-ametys_{$inputDataId}" data-list-wrap="" class="ametys-tools-list-wrap ametys-animated-heigth">
                        <ul data-list="" class="ametys-tools-list ametys-tools-list_editable">
                            <xsl:apply-templates select="/cms/inputData/linkDirectory[@id=$inputDataId]/links/link[@isHidden = 'false' and themes/theme/@id = $themeId]" mode="app">
                                <xsl:with-param name="inputDataId" select="$inputDataId"/>
                            </xsl:apply-templates>
                        </ul>
                    </div>
                </div>
                
                <!-- Unselected links -->
                <xsl:call-template name="extra-links">
                    <xsl:with-param name="themeId" select="$themeId"/>
                    <xsl:with-param name="inputDataId" select="$inputDataId"/>
                    <xsl:with-param name="title" select="$extraLinksTitle"/>
                    <xsl:with-param name="addUserLinkTitle" select="$addUserLinkTitle"/>
                    <xsl:with-param name="filterFormLabelI18nKey" select="$extraFilterFormLabelI18nKey"/>
                    <xsl:with-param name="filterInputLabelI18nKey" select="$extraFilterInputLabelI18nKey"/>
                </xsl:call-template>
                
                <xsl:call-template name="user-links-modals">
                    <xsl:with-param name="themeId" select="$themeId"/>
                    <xsl:with-param name="inputDataId" select="$inputDataId"/>
                </xsl:call-template>
            </div>
            
            <xsl:call-template name="app-js">
                <xsl:with-param name="themeId" select="$themeId"/>
                <xsl:with-param name="inputDataId" select="$inputDataId"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="user-links-configure">
        <xsl:param name="themeId"/>
        <xsl:param name="inputDataId"/>
        
        <!-- Configure button -->
        <xsl:if test="/cms/inputData/linkDirectory[@id=$inputDataId]/@configurable = 'true' or /cms/inputData/linkDirectory[@id=$inputDataId]/@displayUserLinks = 'true'">
            <button type="button" onclick="toggleCheckbox_ametys_{$inputDataId}(this)">
                <span><i18n:text i18n:key="SKIN_USER_MENU_CONFIGURE" i18n:catalogue="skin.{$skin}"/></span>
                <svg
                    aria-hidden="true"
                    version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512"
                    style="enable-background:new 0 0 512 512;" xml:space="preserve">
                    <g>
                        <g>
                            <path d="M256,176c-44.1,0-80,35.9-80,80s35.9,80,80,80s80-35.9,80-80S300.1,176,256,176z M256,296c-22.1,0-40-17.9-40-40
                   s17.9-40,40-40s40,17.9,40,40S278.1,296,256,296z" />
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M502.2,315.6L450.4,276c1.5-13.7,1.4-27,0-39.9l51.8-39.7c8-6.2,10.2-17.3,5.1-26l-50.2-85c-5-8.5-15.4-12-24.6-8.4
                   l-61.4,24.2c-11.2-8-23.2-14.8-35.9-20.3l-9.2-63.6C324.5,7.3,316.1,0,306.2,0H205.8c-9.9,0-18.4,7.3-19.8,17.1l-9.2,63.6
                   c-12.7,5.5-24.7,12.3-35.9,20.3L79.5,76.9c-9.2-3.6-19.6,0-24.6,8.4l-50.2,85c-5.1,8.7-3,19.9,5.1,26L61.6,236
                   c-1.5,13.7-1.4,27,0,39.9L9.8,315.6c-8,6.2-10.2,17.3-5.1,26l50.2,85c5,8.5,15.4,12,24.6,8.4l61.4-24.2
                   c11.2,8,23.2,14.8,35.9,20.3l9.2,63.6c1.4,9.8,9.9,17.1,19.8,17.1h100.3c9.9,0,18.4-7.3,19.8-17.1l9.2-63.6
                   c12.7-5.5,24.7-12.3,35.9-20.3l61.4,24.2c9.1,3.6,19.6,0,24.6-8.4l50.2-85C512.4,333,510.2,321.8,502.2,315.6z M431.3,391.6
                   l-56-22.1c-6.7-2.6-14.3-1.5-19.9,3.1c-13.5,11-28.7,19.6-45.1,25.5c-6.9,2.5-11.9,8.6-13,15.9l-8.4,57.9h-65.7l-8.4-57.9
                   c-1.1-7.3-6-13.4-13-15.9c-16.4-6-31.6-14.5-45.1-25.5c-5.6-4.5-13.2-5.7-19.9-3.1l-56,22.1l-32.5-55l47-36
                   c5.9-4.5,8.8-11.9,7.5-19.3c-2.9-17.1-2.8-34.2,0-50.7c1.3-7.3-1.6-14.8-7.5-19.3l-47-36l32.5-55l56,22.1
                   c6.7,2.6,14.3,1.5,19.9-3.1c13.5-11,28.7-19.6,45.1-25.5c6.9-2.5,11.9-8.6,13-15.9l8.4-57.9h65.7l8.4,57.9c1.1,7.3,6,13.4,13,15.9
                   c16.4,6,31.6,14.5,45.1,25.5c5.6,4.5,13.2,5.7,19.9,3.1l56-22.1l32.5,55l-47,36c-5.9,4.5-8.8,11.9-7.5,19.3
                   c2.9,17.1,2.8,34.2,0,50.7c-1.3,7.3,1.6,14.8,7.5,19.3l47,36L431.3,391.6z" />
                        </g>
                    </g>
                </svg>
            </button>
            <script type="text/javascript">
                function toggleCheckbox_ametys_<xsl:value-of select="$inputDataId"/>(el) {
                    $j("#tool-toggle-ametys_<xsl:value-of select="$inputDataId"/>").trigger('click');
                    $j(el).toggleClass('active');
    
                    if ($j(el).hasClass('active')) {
                        $j(el).find('span').html("<i18n:text i18n:key="SKIN_USER_MENU_CLOSE_CONFIGURATION" i18n:catalogue="skin.{$skin}"/>");
                        $j(el).attr("aria-label", "<i18n:text i18n:key="SKIN_USER_MENU_CLOSE_CONFIGURATION" i18n:catalogue="skin.{$skin}"/>");
                        
                        $j(".ametys-tools-list__link")
                            .each(function () {
                                $j(this).attr('data-href', $j(this).attr('href'));
                                $j(this).attr('href', 'javascript:void(0)');
                                $j(this).removeAttr('target');
                            });
                    
                    } else {
                        $j(el).find('span').html("<i18n:text i18n:key="SKIN_USER_MENU_CONFIGURE" i18n:catalogue="skin.{$skin}"/>");
                        $j(el).attr("aria-label", "<i18n:text i18n:key="SKIN_USER_MENU_CONFIGURE" i18n:catalogue="skin.{$skin}"/>");
                        $j(".ametys-tools-list__link")
                            .each(function () {
                                $j(this).attr('href', $j(this).attr('data-href'));
                                $j(this).attr('target', '_blank');
                            });
                    }
                    
                     // Visible elements have changed, re-trap focus without changing focus
                     // Wait for slideToggle occured
                    setTimeout(function () {
                        AmetysFront.Accessibility.trapFocus($j('.menu-fixed .right').get(0), false);
                    }, 500);
                }
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="extra-links">
        <xsl:param name="themeId"/>
        <xsl:param name="inputDataId"/>
        <xsl:param name="title"/>
        <xsl:param name="addUserLinkTitle"/>
        <xsl:param name="filterFormLabelI18nKey"/>
        <xsl:param name="filterInputLabelI18nKey"/>
        
        <div id="unselected-links-ametys_{$inputDataId}" data-extra-list-wrap="" class="ametys-add-new-item" style="display: none;" role="group" aria-labelledby="unselected-links-ametys_{$inputDataId}_title">
            <xsl:if test="/cms/inputData/linkDirectory[@id=$inputDataId]/@configurable = 'true' and /cms/inputData/linkDirectory[@id=$inputDataId]/links/link[not(@userLink = 'true')]">
                <!-- Filter -->
                <xsl:call-template name="extra-links-filter">
                    <xsl:with-param name="themeId" select="$themeId"/>
                    <xsl:with-param name="inputDataId" select="$inputDataId"/>
                    <xsl:with-param name="title" select="$title"/>
                    <xsl:with-param name="filterFormLabelI18nKey" select="$filterFormLabelI18nKey"/>
                    <xsl:with-param name="filterInputLabelI18nKey" select="$filterInputLabelI18nKey"/>
                </xsl:call-template>  
                
                <!-- No extra links available -->
                <p data-extra-list-empty-text="" class="ametys-add-new-item__text">
                    <xsl:if test="/cms/inputData/linkDirectory[@id=$inputDataId]/links/link[@isHidden = 'true']">
                        <xsl:attribute name="style">display: none</xsl:attribute>
                    </xsl:if>
                    <i18n:text i18n:key="SKIN_USER_MENU_NO_EXTRA_LINKS_AVAILABLE" i18n:catalogue="skin.{$skin}"/>
                </p>
                
                <!-- Unselected links -->
                <div data-extra-list-scroll="" class="ametys-tools-list-scroll">
                    <ul data-extra-list="" class="ametys-tools-list ametys-tools-list-inline">
                        <xsl:if test="not(/cms/inputData/linkDirectory[@id=$inputDataId]/links/link[@isHidden = 'true'])">
                            <xsl:attribute name="aria-hidden">true</xsl:attribute>
                        </xsl:if>
                        
                        <xsl:apply-templates select="/cms/inputData/linkDirectory[@id=$inputDataId]/links/link[@isHidden = 'true']" mode="app"/>
                    </ul>
                    <p role="status" class="sr-only"><!-- Empty. For audio feeback --></p>
                </div>   
            </xsl:if>
            
            <!-- Add form -->
            <xsl:call-template name="add-user-link-form">
                <xsl:with-param name="themeId" select="$themeId"/>
                <xsl:with-param name="inputDataId" select="$inputDataId"/>
                <xsl:with-param name="title" select="$addUserLinkTitle"/>
            </xsl:call-template>     
        </div>
    </xsl:template>
    
    <xsl:template name="extra-links-filter">
        <xsl:param name="themeId"/>
        <xsl:param name="inputDataId"/>
        <xsl:param name="title"/>
        <xsl:param name="filterFormLabelI18nKey"/>
        <xsl:param name="filterInputLabelI18nKey"/>
        
        <div class="flex-search-list">
            <h3 class="ametys-add-new-item__title" id="unselected-links-ametys_{$inputDataId}_title">
                <xsl:choose>
                    <xsl:when test="$title"><xsl:copy-of select="$title"/></xsl:when>
                    <xsl:otherwise><i18n:text i18n:key="SKIN_USER_MENU_ADD_LINK" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
                </xsl:choose>
            </h3>
            <form class="search" role="search" i18n:attr="aria-label">
                <xsl:attribute name="aria-label">
                    <xsl:choose>
                        <xsl:when test="$filterFormLabelI18nKey"><xsl:value-of select="$filterFormLabelI18nKey"/></xsl:when>
                        <xsl:otherwise>skin.<xsl:value-of select="$skin"/>:SKIN_USER_MENU_SEARCH_EXTRA_FILTER_FORM_LABEL</xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
                <svg aria-hidden="true" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 310.4 310.4"
                    style="enable-background:new 0 0 310.4 310.4;" xml:space="preserve">
                    <g>
                        <g>
                            <path d="M273.6,215c49.1-49.1,49.1-129,0-178.1c-49.1-49.1-129-49.1-178.1,0c-41.7,41.7-48,103.6-18.9,152c0,0,2.1,3.5-0.7,6.3
            c-16.1,16.1-64.3,64.3-64.3,64.3c-12.8,12.8-15.8,30.7-4.5,42l2,2c11.3,11.3,29.2,8.3,42-4.5c0,0,48.1-48.1,64.1-64.1
            c3-3,6.4-0.9,6.4-0.9C170,262.9,231.9,256.6,273.6,215z M118.7,191.7c-36.3-36.3-36.3-95.3,0-131.6c36.3-36.3,95.3-36.3,131.6,0
            c36.3,36.3,36.3,95.3,0,131.6C214,228,155,228,118.7,191.7z" />
                            <g>
                                <path
                                    d="M126.8,118.4c-1.7,0-3.4-0.3-5.1-1c-6.6-2.8-9.7-10.4-6.9-17c17.6-41.6,65.7-61.1,107.3-43.5c6.6,2.8,9.7,10.4,6.9,17
                c-2.8,6.6-10.4,9.7-17,6.9c-28.4-12-61.2,1.3-73.2,29.7C136.6,115.4,131.8,118.4,126.8,118.4z" />
                            </g>
                        </g>
                    </g>
                </svg>
                <input type="search" class="search-app-list" id="search-app-list-{$inputDataId}" onchange="searchAppList_{$inputDataId}()" onkeyup="searchAppList_{$inputDataId}()" i18n:attr="title placeholder">
                    <xsl:attribute name="placeholder">
                        <xsl:choose>
                            <xsl:when test="$filterInputLabelI18nKey"><xsl:value-of select="$filterInputLabelI18nKey"/></xsl:when>
                            <xsl:otherwise>skin.<xsl:value-of select="$skin"/>:SKIN_USER_MENU_SEARCH_EXTRA_FILTER_PLACEHOLDER</xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                    <xsl:attribute name="title">
                        <xsl:choose>
                            <xsl:when test="$filterInputLabelI18nKey"><xsl:value-of select="$filterInputLabelI18nKey"/></xsl:when>
                            <xsl:otherwise>skin.<xsl:value-of select="$skin"/>:SKIN_USER_MENU_SEARCH_EXTRA_FILTER_PLACEHOLDER</xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                </input>
                <button type="button" class="sr-only"><i18n:text i18n:key="SKIN_USER_MENU_SEARCH_FILTER_SUBMIT" i18n:catalogue="skin.{$skin}"/></button>
            </form>
        </div>    
        <script>
            function searchAppList_<xsl:value-of select="$inputDataId"/>() {
                var search = $j('#search-app-list-<xsl:value-of select="$inputDataId"/>').val().toLowerCase();
                if (search.length > 2) {
                    $j(".ametys-tools-list-inline .ametys-tools-list__item")
                        .each(function () {
                            var stringToSearch = $j(this).find('.ametys-tools-list__title').text().toLowerCase();

                            if (stringToSearch.indexOf(search) &lt; 0) {
                                $j(this).hide();
                            } else {
                                $j(this).show();
                            }
                        });
                } else {
                    $j('.ametys-tools-list-inline .ametys-tools-list__item').show();
                }
            }
        </script>
    </xsl:template>
    
    <xsl:template name="add-user-link-form">
        <xsl:param name="themeId"/>
        <xsl:param name="inputDataId"/>
        <xsl:param name="title"/>
    
        <xsl:if test="/cms/inputData/linkDirectory[@id=$inputDataId]/@displayUserLinks = 'true'">
            <div id="data-add-new-item-form-ametys_{$inputDataId}" class="ametys-add-new-item" style="display: none;" data-add-new-item-wrap="" role="group" aria-labelledby="ametys-add-user-new-item__title_{$inputDataId}">
                <form action="" data-add-new-item-form="">
                    <h3 class="ametys-add-new-item__title" id="ametys-add-user-new-item__title_{$inputDataId}">
                        <xsl:choose>
                            <xsl:when test="$title"><xsl:copy-of select="$title"/></xsl:when>
                            <xsl:otherwise><i18n:text i18n:key="SKIN_USER_MENU_ADD_USER_LINK" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
                        </xsl:choose>
                    </h3>
    
                    <div class="ametys-field-group">
                        <input id="addLink-{$inputDataId}-url" 
                               placeholder="skin.{$skin}:SKIN_USER_MENU_ADD_USER_LINK_URL" 
                               title="skin.{$skin}:SKIN_USER_MENU_ADD_USER_LINK_URL" 
                               i18n:attr="placeholder title" 
                               class="ametys-field-group__control" 
                               name="addLink-url" 
                               type="text"
                               data-add-new-item-field-url="" />
                    </div>
                    <div class="ametys-field-group">
    
                        <input id="addLink-{$inputDataId}-title"
                               title="skin.{$skin}:SKIN_USER_MENU_ADD_USER_LINK_TITLE" 
                               placeholder="skin.{$skin}:SKIN_USER_MENU_ADD_USER_LINK_TITLE" 
                               i18n:attr="placeholder title" 
                               class="ametys-field-group__control" 
                               name="addLink-title" 
                               type="text"
                               data-add-new-item-field-title="" />
                    </div>
    
                    <div class="text-right">
                        <input id="linkId" name="linkId" type="hidden" />
                        <input id="favicon" name="favicon" type="hidden" />
                        <button class="btn" type="submit" disabled="" data-add-new-item-field-submit="">
                            <i18n:text i18n:key="SKIN_USER_MENU_ADD_USER_LINK_SUBMIT" i18n:catalogue="skin.{$skin}"/>
                        </button>
                        <p role="status" class="sr-only"><!-- Empty, used for audio feeback --></p>
                    </div>
                </form>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-links-modals">
        <xsl:param name="themeId"/>
        <xsl:param name="inputDataId"/>
        
        <!-- A CACHER SI NB ITEMS INFERIEUR a 5 -->
        <footer class="" data-footer="">
            <span class="ametys-show-more" data-toggle="" data-default-text="Voir plus d'outils"
                data-active-text="Voir moins d'outils" style="display: none;">
                <span class="ametys-show-more__text" data-toggle-text="">Voir plus d'outils</span>
                <span class="ametys-show-more__icon material-icons expand_more"></span>
            </span>
        </footer>
        
        <!-- Delete confirm -->
        <div id="data-delete-modal-ametys_{$inputDataId}" class="modal-confirm" style="display: none;"
            data-delete-modal="" aria-labelledby="delete-modal-ametys_title_{$uniqueId}" role="dialog" aria-modal="true">
            <h4 id="delete-modal-ametys_title_{$uniqueId}"><i18n:text i18n:key="SKIN_USER_MENU_DELETE_CONFIRM" i18n:catalogue="skin.{$skin}"/></h4>
            <button data-delete-modal-close="" class="close" aria-label="skin.{$skin}:SKIN_USER_MENU_CLOSE" i18n:attr="aria-label"><i aria-hidden="true" class="fas fa-times"></i></button>
            
            <div class="">
                <button class="btn full" data-delete-modal-confirm=""><span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_YES" i18n:catalogue="skin.{$skin}"/></span></button>
                <button class="btn" data-delete-modal-close=""><span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_NO" i18n:catalogue="skin.{$skin}"/></span></button>
            </div>
        </div>
    
        <!-- Deactivate confirm -->
        <div id="data-deactivate-modal-ametys_{$inputDataId}" class="modal-confirm"
            style="display: none;" data-deactivate-modal="" aria-labelledby="deactivate-modal-ametys_title_{$uniqueId}" role="dialog" aria-modal="true">
            <h4 id="deactivate-modal-ametys_title_{$uniqueId}"><i18n:text i18n:key="SKIN_USER_MENU_DEACTIVATE_CONFIRM" i18n:catalogue="skin.{$skin}"/></h4>
            <button data-deactivate-modal-close="" class="close" aria-label="skin.{$skin}:SKIN_USER_MENU_CLOSE" i18n:attr="aria-label"><i aria-hidden="true" class="fas fa-times"></i></button>
            
            <div>
                <button class="btn full" data-deactivate-modal-confirm="ametys_{$uniqueId}">
                        <span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_YES" i18n:catalogue="skin.{$skin}"/></span>
                </button>
                <button class="btn" data-deactivate-modal-close="">
                    <span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_NO" i18n:catalogue="skin.{$skin}"/></span>
                </button>
            </div>
        </div>
                        
    </xsl:template>
    
    <xsl:template match="link" mode="app">
        <xsl:param name="inputDataId"/>
        
        <li data-list-item="" class="ametys-tools-list__item">
            <xsl:if test="@userLink = 'true'">
                <xsl:attribute name="data-app-type">custom</xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled = 'true'">
                <xsl:attribute name="data-app-disabled">true</xsl:attribute>
            </xsl:if>
            
            <a data-list-link="" class="ametys-tools-list__link" data-serverid="{@id}">
               <xsl:apply-templates select="." mode="app-href-attr"/>
               <xsl:apply-templates select="." mode="app-title-attr"/>
               <xsl:apply-templates select="." mode="app-target-attr"/>
              
              <xsl:apply-templates select="." mode="app-icon"/>
                                              
              <span class="ametys-tools-list__title">
                <xsl:value-of select="@title"/>
              </span>
              
              <xsl:call-template name="link-dynamic-info">
                <xsl:with-param name="uniqueId" select="$inputDataId" />
              </xsl:call-template>
            </a>
            
            <button type="button" class="material-icons ametys-tools-list__action" aria-label="skin.{$skin}:SKIN_USER_MENU_LINK_DIRECTORY_BTN_DELETE" i18n:attr="aria-label">
                <xsl:if test="@isHidden = 'true'">
                    <xsl:attribute name="aria-label">skin.<xsl:value-of select="$skin"/>:SKIN_USER_MENU_LINK_DIRECTORY_BTN_ADD</xsl:attribute>
                </xsl:if>
                close
            </button>
        </li>
    </xsl:template>
    
    <xsl:template match="link" mode="app-href-attr">
        <xsl:attribute name="href">
            <xsl:choose>
                <xsl:when test="@disabled">javascript:void(0)</xsl:when>
                <xsl:when test="@urlType = 'PAGE'">
                    <xsl:value-of select="resolver:resolve('page', @url)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@url"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>
    
    <xsl:template match="link" mode="app-title-attr">
        <xsl:attribute name="title">
            <xsl:choose>
                <xsl:when test="@disabled"><xsl:value-of select="concat('skin.', $skin, ':SKIN_USER_MENU_LINK_DIRECTORY_INTERNAL_ONLY')"/></xsl:when>
                <xsl:when test="@alternative != ''"><xsl:value-of select="@alternative"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
        <xsl:if test="@disabled">
            <xsl:attribute name="i18n:attr">title</xsl:attribute>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="link" mode="app-target-attr">
        <xsl:if test="@urlType != 'PAGE' and not(@disabled)"><xsl:attribute name="target">_blank</xsl:attribute></xsl:if>
    </xsl:template>
    
    <xsl:template match="link" mode="app-icon">
        <xsl:choose>
            <xsl:when test="@pictureType = 'glyph'">
    			<span aria-hidden="true" class="picture link-glyph {@pictureGlyph}"></span>
    		</xsl:when>
            <xsl:when test="@pictureType != ''">
                <xsl:variable name="id">
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'resource'">
                            <xsl:value-of select="@pictureId"/>
                        </xsl:when>
                        <xsl:when test="@pictureType = 'external'">
                            <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
        
                <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $id, 35, 35)}" alt="{@pictureAlternative}"/>
            </xsl:when>
            <xsl:otherwise>
                <img class="svg" src="{ametys:skinURL('templates/common/img/icon/ICON-ROUE.svg')}" alt="" max-width="35px" height="35px"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="user-links-search-filter">
        <xsl:param name="themeId"/>
        <xsl:param name="inputDataId"/>
        <xsl:param name="filterFormLabelI18nKey"/>
        <xsl:param name="filterInputLabelI18nKey"/>
        
        <form action="#" class="search" onsubmit="searchApp_{$inputDataId}(); return false;" role="search" i18n:attr="aria-label">
            <xsl:attribute name="aria-label">
                <xsl:choose>
                    <xsl:when test="$filterFormLabelI18nKey"><xsl:value-of select="$filterFormLabelI18nKey"/></xsl:when>
                    <xsl:otherwise>skin.<xsl:value-of select="$skin"/>:SKIN_USER_MENU_SEARCH_FILTER_FORM_LABEL</xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <svg aria-hidden="true" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg"
                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 310.4 310.4"
                style="enable-background:new 0 0 310.4 310.4;" xml:space="preserve">
                <g>
                    <g>
                        <path d="M273.6,215c49.1-49.1,49.1-129,0-178.1c-49.1-49.1-129-49.1-178.1,0c-41.7,41.7-48,103.6-18.9,152c0,0,2.1,3.5-0.7,6.3
                    c-16.1,16.1-64.3,64.3-64.3,64.3c-12.8,12.8-15.8,30.7-4.5,42l2,2c11.3,11.3,29.2,8.3,42-4.5c0,0,48.1-48.1,64.1-64.1
                    c3-3,6.4-0.9,6.4-0.9C170,262.9,231.9,256.6,273.6,215z M118.7,191.7c-36.3-36.3-36.3-95.3,0-131.6c36.3-36.3,95.3-36.3,131.6,0
                    c36.3,36.3,36.3,95.3,0,131.6C214,228,155,228,118.7,191.7z" />
                        <g>
                            <path
                                d="M126.8,118.4c-1.7,0-3.4-0.3-5.1-1c-6.6-2.8-9.7-10.4-6.9-17c17.6-41.6,65.7-61.1,107.3-43.5c6.6,2.8,9.7,10.4,6.9,17
                        c-2.8,6.6-10.4,9.7-17,6.9c-28.4-12-61.2,1.3-73.2,29.7C136.6,115.4,131.8,118.4,126.8,118.4z" />
                        </g>
                    </g>
                </g>
            </svg>
            <input type="search" class="search-app" id="search-{$inputDataId}" onchange="searchApp_{$inputDataId}()" onkeyup="searchApp_{$inputDataId}()" i18n:attr="title placeholder">
                <xsl:attribute name="placeholder">
                    <xsl:choose>
                        <xsl:when test="$filterInputLabelI18nKey"><xsl:value-of select="$filterInputLabelI18nKey"/></xsl:when>
                        <xsl:otherwise>skin.<xsl:value-of select="$skin"/>:SKIN_USER_MENU_SEARCH_FILTER_PLACEHOLDER</xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:choose>
                        <xsl:when test="$filterInputLabelI18nKey"><xsl:value-of select="$filterInputLabelI18nKey"/></xsl:when>
                        <xsl:otherwise>skin.<xsl:value-of select="$skin"/>:SKIN_USER_MENU_SEARCH_FILTER_PLACEHOLDER</xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
            </input>

            <button type="submit" class="sr-only"><i18n:text i18n:key="SKIN_USER_MENU_SEARCH_FILTER_SUBMIT" i18n:catalogue="skin.{$skin}"/></button>
        </form>
        <script type="text/javascript">
            let appFilterTimeout_<xsl:value-of select="$inputDataId"/> = null;
            
            function searchApp_<xsl:value-of select="$inputDataId"/>() {
                
                var search = $j('#search-<xsl:value-of select="$inputDataId"/>').val().toLowerCase();
                if (search.length > 2) {
                    $j(".apps.menu-<xsl:value-of select="$inputDataId"/> .ametys-tools-list_editable .ametys-tools-list__item")
                        .each(function () {
                            var stringToSearch = $j(this).find('.ametys-tools-list__title').text().toLowerCase();

                            if (stringToSearch.indexOf(search) &lt; 0) {
                                $j(this).hide();
                            } else {
                                $j(this).show();
                            }
                        });
                        
                } else {
                    $j(".apps.menu-<xsl:value-of select="$inputDataId"/> .ametys-tools-list_editable .ametys-tools-list__item").show();
                }
                
                // Refresh muuri grid
                clearTimeout(appFilterTimeout_<xsl:value-of select="$inputDataId"/>);
                appFilterTimeout_<xsl:value-of select="$inputDataId"/> = setTimeout(function () {
                    $j('#tool-ametys_<xsl:value-of select="$inputDataId"/>').HSAmetysTools('update');
                }, 100);
                
            }
        </script>
    </xsl:template>
    
    <xsl:template name="app-js">
        <xsl:param name="themeId"/>
        <xsl:param name="inputDataId"/>
        
        <script type="text/javascript">
            function deactivateLink_ametys_<xsl:value-of select="$inputDataId"/>(event, target) {
                saveUserPrefs_ametys_<xsl:value-of select="$inputDataId"/>();
            };
                    
            function getSelectedLinks_ametys_<xsl:value-of select="$inputDataId"/>() {
                var orderedItems = $j("#selected-links-ametys_<xsl:value-of select="$inputDataId"/> li").map(function () {
                    var $this = $j(this);
                    return {
                        offset: $this.offset(),
                        servid: $this.find("a[data-serverid]").attr("data-serverid")
                    };
                }).get();

                orderedItems.sort(function (a, b) {
                    if (a.offset.top != b.offset.top) {
                        return a.offset.top - b.offset.top;
                    }
                    else {
                        return a.offset.left - b.offset.left;
                    }
                });
                var orderedItemsIds = [];
                for (var i in orderedItems) {
                    orderedItemsIds.push(orderedItems[i].servid);
                }

                return orderedItemsIds;
            }
            
            function getHiddenLinks_ametys_<xsl:value-of select="$inputDataId"/>() {
                return $j("#unselected-links-ametys_<xsl:value-of select="$inputDataId"/> li>a[data-serverid]").map(function () { return $j(this).attr("data-serverid"); }).get();
            }

            var orderedItemIds_ametys_<xsl:value-of select="$inputDataId"/> = getSelectedLinks_ametys_<xsl:value-of select="$inputDataId"/>();
            var hiddenItemIds_ametys_<xsl:value-of select="$inputDataId"/> = getHiddenLinks_ametys_<xsl:value-of select="$inputDataId"/>();

            function saveUserPrefs_ametys_<xsl:value-of select="$inputDataId"/>() {
                var orderedItemsIds = getSelectedLinks_ametys_<xsl:value-of select="$inputDataId"/>();

                var hidden = getHiddenLinks_ametys_<xsl:value-of select="$inputDataId"/>();

                if (orderedItemsIds.toString() != orderedItemIds_ametys_<xsl:value-of select="$inputDataId"/>.toString() || hidden.toString() != hiddenItemIds_ametys_<xsl:value-of select="$inputDataId"/>.toString()) {
                    orderedItemIds_ametys_<xsl:value-of select="$inputDataId"/> = orderedItemsIds;
                    hiddenItemIds_ametys_<xsl:value-of select="$inputDataId"/> = hidden;

                    var siteUriPrefix = '<xsl:value-of select="ametys:siteUriPrefix()" />';
                    var zoneItemId = '<xsl:value-of select="$inputDataId" />';
                    var lang = '<xsl:value-of select="ametys:lang()"/>';
                    AmetysHelperLinkDirectory.saveUserPrefs(orderedItemsIds, hidden, siteUriPrefix, lang, zoneItemId, null, null);
                }
            }
            
            function reinitModalFocus_<xsl:value-of select="$inputDataId"/>(e, removeEl, addedEl)
            {
                $j(addedEl).find('.ametys-tools-list__action').focus();
                AmetysFront.Accessibility.trapFocus($j('.menu-fixed .right').get(0), addedEl ? false : true);
            }
            
            function addUserLink_ametys_<xsl:value-of select="$inputDataId"/>(title, url, color) {
                $j.ajax({
                    url: '<xsl:value-of select="ametys:siteUriPrefix()"/>/_plugins/link-directory/add-user-link',
                    data: {
                        siteName: "<xsl:value-of select="ametys:site()"/>",
                        lang: "<xsl:value-of select="ametys:lang()"/>",
                        title: title,
                        url: url,
                        color: color,
                        themes: "<xsl:value-of select="$themeId" />"
                    },
                    method: 'POST',
                    success: addUserLinkCb_ametys_<xsl:value-of select="$inputDataId"/>,
                    error: function(data) {alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_ADD_USER_LINK_DIALOG_ERROR" i18n:catalogue="plugin.link-directory"/>");}
                });
            };
            
            function addUserLinkCb_ametys_<xsl:value-of select="$inputDataId"/>(data) {
                var result = typeof data === 'object' ? data : JSON.parse(data);
                var error = result.error;

                switch (error) {
                    case "none":
                        $j(".ametys-tools .ametys-tools-list__item a[data-href='" + result.url + "'] svg").remove();
                        if (result.picture.viewUrl)
                        {
                            $j(".ametys-tools .ametys-tools-list__item a[data-href='" + result.url + "']").prepend("&lt;img alt=\"\" src=\"" + result.picture.viewUrl + "\"/&gt;");
                        }
                        else
                        {
                            // default icon
                            $j(".ametys-tools .ametys-tools-list__item a[data-href='" + result.url + "']").prepend("&lt;img alt=\"\" class=\"svg\" src=\"<xsl:value-of select="ametys:skinURL('templates/common/img/icon/ICON-ROUE.svg')"/>\" max-width=\"35px\" height=\"35px\"/&gt;")
                        }
                        
                        //var form = $j("#data-add-new-item-form-ametys_<xsl:value-of select="$inputDataId"/> [data-add-new-item-form]");
                        //form.find("input[name='linkId']").val(result.id);
                        //form.find("input[name='linkId']").trigger("change");
                        //form.find("input[name='favicon']").val(result.picture.viewUrl);
                        //form.find("input[name='favicon']").trigger("change");
                        //form.submit();

                        break;
                    case "already-exists":
                        // TODO delete item
                        alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_LINK_ERROR_ALREADY_EXISTS" i18n:catalogue="plugin.link-directory"/>");
                        break;
                    default:
                        // TODO delete item
                        alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_LINK_ERROR_CREATE" i18n:catalogue="plugin.link-directory"/>");
                }
            }
            
            function deleteLink_ametys_<xsl:value-of select="$inputDataId"/>(event, target) {
                var linkId = $j(target).find("a[data-serverid]").attr("data-serverid");
                if (linkId != null &amp;&amp; linkId != "")
                {
                    AmetysHelperLinkDirectory.removeUserLinks([linkId], "<xsl:value-of select="ametys:siteUriPrefix()"/>", null, null, null);
                }
            };

            function deactivateLink_ametys_<xsl:value-of select="$inputDataId"/>(event, target) {
                saveUserPrefs_ametys_<xsl:value-of select="$inputDataId"/>();
            };
            
            function activateLink_ametys_<xsl:value-of select="$inputDataId"/>(event, target) {
                saveUserPrefs_ametys_<xsl:value-of select="$inputDataId"/>();
            };

            function moveLink_ametys_<xsl:value-of select="$inputDataId"/>(event, target) {
                saveUserPrefs_ametys_<xsl:value-of select="$inputDataId"/>();
            };
            
            $j('#data-add-new-item-form-ametys_<xsl:value-of select="$inputDataId"/> button[data-add-new-item-field-submit]').on('click', function (event) {
                var form = $j("#data-add-new-item-form-ametys_<xsl:value-of select="$inputDataId"/> [data-add-new-item-form]");
                form.find("input[name='linkId']").val("");//reset the ID
                form.find("input[name='favicon']").val("");//reset the favicon

                
                var href = form.find("input[data-add-new-item-field-url]").val();
                var title = form.find("input[data-add-new-item-field-title]").val();
                var color = form.find("input:checked[data-add-new-item-field-color]").attr("data-color-id");
                addUserLink_ametys_<xsl:value-of select="$inputDataId"/>(title, href, color);
                event.preventDefault();
                return false;
            });
        </script>   
    </xsl:template>
        
    <xsl:template name="user-menu-js">
        <script type="text/javascript">
             var openedMenus = [];
             
             const closeMenuOnEscapeKey = (event) => {
                if (event.key === "Escape") {
                  closeMenu();
                }
            };
            
            function openMenu(btn) 
            {
                let $btn = $j(btn);
                var currentOpenMenuId = $j(".icon-block.active").parent().data("user-menu-id");
                if (currentOpenMenuId == 'activities' &amp;&amp;  window.VEvent)
                {
                    window.VEvent.fire("activity-stream-closed");
                }
                else if (currentOpenMenuId == 'projects' &amp;&amp;  window.VEvent)
                {
                    window.VEvent.fire("projects-closed");
                }
                else if (currentOpenMenuId == 'followedPages' &amp;&amp;  window.VEvent)
                {
                    window.VEvent.fire("followed-pages-closed");
                }
                
                var menuId = $btn.data("user-menu-id");
                
                $j(".menu-fixed").addClass('opened');
                
                if ($j(".menu-fixed").hasClass('active') === false) {
                    $j(".menu-fixed").addClass('active');
                    $j('.overlay.user-menu').addClass('active');
                }
    
                $j('.icon-block').removeClass('active');
                $j('.menu-fixed .apps').hide();
                $j('.menu-fixed .left button').attr("aria-expanded", false);
                
                $btn.find('.icon-block').addClass('active');
                $btn.attr("aria-expanded", true);
                $j('.menu-fixed .menu-' + menuId).show();
                
                // Trap focus and put on first focusable element
                AmetysFront.Accessibility.trapFocus($j('.menu-fixed .right').get(0), true);
    
                if (menuId == 'activities' &amp;&amp;  window.VEvent)
                {
                    // Activity stream is opened
                    window.VEvent.fire("activity-stream-opened");
                }
                else if (menuId == 'projects' &amp;&amp;  window.VEvent)
                {
                    // Projects is opened
                    window.VEvent.fire("projects-opened");
                }
                else if (menuId == 'followedPages' &amp;&amp;  window.VEvent)
                {
                    // Followed pages is opened
                    window.VEvent.fire("followed-pages-opened");
                }
                
                var inputDataId = menuId;
                if ($j.inArray(inputDataId, openedMenus) == -1)
                {
                    setTimeout(function () {
                        var $tool = $j('#tool-ametys_' + inputDataId);
                        
                        if ($tool.length > 0){
	                        $tool.HSAmetysTools($j('#tool-ametys_' + inputDataId).data('settings'));
	    
                            $tool.on('elementDeactivated', eval('deactivateLink_ametys_' + inputDataId));
                            $tool.on('elementDeactivated', eval('reinitModalFocus_' + inputDataId));
	                        $tool.on('elementActivated', eval('activateLink_ametys_' + inputDataId));
                            $tool.on('elementActivated', eval('reinitModalFocus_' + inputDataId));
	                        $tool.on('elementMoved', eval('moveLink_ametys_' + inputDataId));
	                        $tool.on('elementDeleted', eval('deleteLink_ametys_' + inputDataId));
                            $tool.on('elementDeleted', eval('reinitModalFocus_' + inputDataId));
	                        
	                        $j(window).on('resize', function () {
	                            $j('#tool-ametys_' + inputDataId).HSAmetysTools('update');
	                        });
	                    }
                    }, 200);
                    openedMenus.push(inputDataId);
                }
                else
                {
                    $j('#tool-ametys_' + inputDataId).HSAmetysTools('update');
                }
                
                $j('.menu-fixed').get(0).addEventListener('keydown', closeMenuOnEscapeKey);
            }
            
            function openMenuMobile() {
                $j('.menu-fixed').addClass('opened');
                $j('.overlay.user-menu').addClass('active');
            }
            
            function closeMenuMobile() {
                $j('.menu-fixed').removeClass('opened').removeClass('active');
                $j(".overlay.user-menu").removeClass('active');
            }
    
            function closeMenu() {
                let $currentOpenMenu = $j(".icon-block.active").parent();
                var currentOpenMenuId = $currentOpenMenu.data("user-menu-id");
                if (currentOpenMenuId == 'activities')
                {
                    // Activity stream was opened
                    window.VEvent.fire("activity-stream-closed");
                }
                
                $j('.apps').hide();
                $j(".icon-block").removeClass('active');
                $j('.menu-fixed').removeClass('opened').removeClass('active');
                $j('.menu-fixed .left button').attr('aria-expanded', false);
                $j('.navinterieur-menu').removeClass('open');
                $j(".overlay.user-menu").removeClass('active');
                
                $j('.menu-fixed').get(0).removeEventListener('keydown', closeMenuOnEscapeKey);
                
                AmetysFront.Accessibility.untrapFocus($j('.menu-fixed .right').get(0));
                
                if ($currentOpenMenu.css('visibility') == 'hidden' || !$currentOpenMenu.is(':visible'))
                {
                    // mobile mode: user menu is closed => replace focus on button to open user menu in mobile
                    $j('.menu-fixed .open-menu-mobile.is-closed').focus();
                }
                else
                {
                    $currentOpenMenu.focus();
                }
            }
            
            function changeColorTheme(color) {
                $j(".personnalize .round").removeClass('active');
                $j(".personnalize .round").attr('aria-pressed', false);
    
                $j(".personnalize ." + color).addClass('active');
                $j(".personnalize ." + color).attr('aria-pressed', true);
    
                $j(".menu-fixed").removeClass('color1').removeClass('color2').removeClass('color3');
                localStorage.setItem('color', color);
                $j(".menu-fixed").addClass(color);
            }
            
            $j(document).ready(function () {
                const color = localStorage.getItem('color');
    
                if (color != null) {
                    $j('.menu-fixed').addClass(color);
                    $j(".personnalize ." + color).addClass('active');
                    $j(".personnalize ." + color).attr('aria-pressed', true);
                } else {
                    $j(".personnalize .blue").addClass('active');
                    $j(".personnalize ." + color).attr('aria-pressed', true);
                }
    
            });
        </script>
    </xsl:template>
    
    <xsl:template name="user-menu-followed-pages-js">
        <xsl:variable name="pageFollowRefreshDelay" select="ametys:siteParameter('page-follow-refresh-delay') * 60000"/>
        <script>
            <xsl:if test="$pageFollowEnabled = 'true'">
            function updateFollowedPagesNotification()
            {
                AmetysFront.UserPageSubscriptions.getUnreadPages(null, function(unreadPages) {
                    var oldCount = Number($j('[data-user-menu-id=followedPages] [aria-live]').attr('data-count'));
                    var count = unreadPages.length;
                    
                    if (count != oldCount)
                    {
                        // Update aria-live area
                        $j('[data-user-menu-id=followedPages] [aria-live]').attr("data-count", count);
                        $j('[data-user-menu-id=followedPages] [aria-live]').html(count == 0 ? "<i18n:text i18n:key="SKIN_USER_MENU_FOLLOWED_PAGES_NO_UNREAD_PAGE" i18n:catalogue="skin.{$skin}"/>" : count + (count > 1 ? "<i18n:text i18n:key="SKIN_USER_MENU_FOLLOWED_PAGES_UNREAD_PAGES" i18n:catalogue="skin.{$skin}"/>" : "<i18n:text i18n:key="SKIN_USER_MENU_FOLLOWED_PAGES_UNREAD_PAGE" i18n:catalogue="skin.{$skin}"/>"));
                    }
                    if (count > 0)
                    {
                        $j('[data-user-menu-id=followedPages] .icon-block').addClass('has-notif');
                    }
                    else
                    {
                        $j('[data-user-menu-id=followedPages] .icon-block').removeClass('has-notif');
                    }
                });
            }
            $j(document).ready(function(){
                updateFollowedPagesNotification();
                setInterval(updateFollowedPagesNotification, <xsl:value-of select="$pageFollowRefreshDelay"/>);
            });
            </xsl:if>
        </script>
    </xsl:template>
    
</xsl:stylesheet>   