<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:datetime="http://ametys.org/datetime/4.2"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:exslt="http://exslt.org/common" 
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys datetime resolver">

	<xsl:import href="skin://stylesheets/main.xsl" />
    <xsl:import href="skin://stylesheets/dates.xsl" />
	<xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
	<xsl:import href="plugin:socialnetworking://stylesheets/helpers/sendByMail.xsl" />
    
    <xsl:variable name="deactivateFOEditionToolbar" select="ametys:templateParameter('deactivateFOEditionToolbar')"/>
    
    <!-- Number of likers display with their fullname in likes/unlike button tooltip -->
    <xsl:variable name="maxLikersInTooltip">3</xsl:variable>
    
    <xsl:template name="additionnal-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/page_interieur.css')}" />
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
    </xsl:template>
    
    <xsl:template name="additionnal-script">
        <!-- FO edition -->
        <xsl:call-template name="ametys-front-edition-head">
            <xsl:with-param name="start">load</xsl:with-param>
            <xsl:with-param name="editActionId">2</xsl:with-param>
            <xsl:with-param name="insertAttachmentActionId">2</xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="true()"/>
        </xsl:call-template>
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/fo-toolbar.css')}" />
        
        <!-- Likes -->
        <xsl:call-template name="content-likes-script"/>
    </xsl:template>
    
    <xsl:template name="content-likes-script">
        <xsl:variable name="mainContent" select="/cms/page/pageContents/zone[@name='default']/zoneItem[1][information/type = 'CONTENT']"/>
        
        <xsl:if test="$mainContent and $mainContent/html/head/meta[@name = 'likes']/@content = 'true'">
            <script type="text/javascript" src="{concat(ametys:uriPrefix(), '/plugins/cms/resources/js/AmetysFront/ContentReactions.', ametys:lang(), '.js')}"/>
            
            <script type="text/javascript" src="{ametys:skinURL('plugins/js/poppers.min.js')}" />
            <script type="text/javascript" src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}" />
            
            <script type="text/javascript">
                // Tippy plugin to hide tooltip on ESC
                const hideContentLikesTooltipOnEsc = {
                  name: 'hideOnEsc',
                  defaultValue: true,
                  fn({hide}) {
                    function onKeyDown(event) {
                      if (event.keyCode === 27) {
                        hide();
                      }
                    }
                    return {
                      onShow() {
                        document.addEventListener('keydown', onKeyDown);
                      },
                      onHide() {
                        document.removeEventListener('keydown', onKeyDown);
                      },
                    };
                  },
                };
                    
                function updateContentLikes(contentId, likers)
                {
                    let $likesEl = $j("[data-ametys-content-likes='" + contentId + "']");
                    let $btn = $likesEl.find("button");
                    let nbLikes = likers.length;
                    let maxNbLikers = <xsl:value-of select="$maxLikersInTooltip"/>;
                    let ownLiker = false;
                    
                    // Update count
                    $likesEl.find("[data-ametys-content-likes-count]").html(nbLikes);
                    if (nbLikes==0)
                    {
                        $likesEl.find("[data-ametys-content-likes-count]").hide();
                    }
                    else
                    {
                        $likesEl.find("[data-ametys-content-likes-count]").show();
                    }
                    
                    // Destroy tooltip
                    if ($btn.get(0)._tippy)
                    {
                        $btn.get(0)._tippy.destroy();
                    }
                                    
                    // Update likers
                    let likerTooltips = "";
                    $j.each(likers, function(i, liker) {
                        if (ametysUser &amp;&amp; liker.login == ametysUser.login &amp;&amp; liker.populationId == ametysUser.populationId)
                        {
                            ownLiker = true;
                        }
                        
                        if (i &lt; maxNbLikers)
                        {
                            likerTooltips += "&lt;span class='like'>" + liker.fullname + "&lt;/span>"
                        }
                    });
                    
                    let otherCount = nbLikes - maxNbLikers;
                    if (otherCount == 1)
                    {
                        likerTooltips += "&lt;span class='like'><i18n:text i18n:key="PLUGINS_CMS_CONTENT_LIKE_OTHER_TOOLTIP" i18n:catalogue="plugin.cms"/>&lt;/span>"
                    }
                    else if (otherCount &gt; 1)
                    {
                        likerTooltips += "&lt;span class='like'>" + "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_LIKE_OTHERS_TOOLTIP" i18n:catalogue="plugin.cms"/>".replace(/\{0}/, otherCount) + "&lt;/span>";
                    }
                    
                    if (likerTooltips)
                    {
                        $likesEl.find("[role=tooltip]").html(likerTooltips);
                        
                        // Tooltip
                        tippy("[data-ametys-content-likes='" + contentId + "'] button", {
                            allowHTML: true,
                            content: $likesEl.find("[role=tooltip]").html(),
                            plugins: [hideContentLikesTooltipOnEsc]
                        });
                    }
                    
                    $btn.attr("data-ametys-content-own-liker", ownLiker);
                    
                    if (ownLiker)
                    {
                        $btn.addClass("active");
                        $btn.attr("title", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_UNLIKE_TITLE" i18n:catalogue="plugin.cms"/>");
                        $btn.attr("aria-pressed", "true");
                    }
                    else
                    {
                        $btn.removeClass("active");
                        $btn.attr("title", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_LIKE_TITLE" i18n:catalogue="plugin.cms"/>");
                        $btn.attr("aria-pressed", "false");
                    }
                }
                
                function likeOrUnlikeContentCb(contentId, result, liked)
                {
                    if (result.updated)
                    {
                        updateContentLikes(contentId, result.actors);
                    }
                }
                
                $j(document).ready(function(){
                    AmetysFront.ContentReactions.getLikes('<xsl:value-of select="$mainContent/information/contentId"/>', updateContentLikes);
                });
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-zone">
        <main role="main" id="main-content">
            <xsl:call-template name="navinterieur"/>
            
            <article class="page-interieur">
                <xsl:call-template name="main-zone-top"/>
                <xsl:call-template name="main-zone-content"/>
            </article>
             
            <xsl:if test="not($deactivateFOEditionToolbar = 'true')">
                <xsl:call-template name="fo-toolbar-page"/>
            </xsl:if>
        </main>
    </xsl:template>
    
    <xsl:template name="fo-toolbar-page">
        <xsl:call-template name="ametys-front-edition-page-toolbar">
            <xsl:with-param name="add-contents-config">[
                {"contentType": "org.ametys.web.default.Content.article", "icon": "fas fa-file-alt", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FO_TOOLBAR_ADD_CONTENT_TO_DEFAULT" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.web.default.Content.article", "icon": "fas fa-file-alt", "zoneName": "secondary", "label": "<i18n:text i18n:key="SKIN_FO_TOOLBAR_ADD_CONTENT_TO_SECONDARY" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.web.default.Content.article", "icon": "fas fa-file-alt", "zoneName": "right", "label": "<i18n:text i18n:key="SKIN_FO_TOOLBAR_ADD_CONTENT_TO_RIGHT" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.plugins.news.Content.news", "icon": "fas fa-file-alt", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FO_TOOLBAR_ADD_NEWS_TO_DEFAULT" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.plugins.news.Content.news", "icon": "fas fa-file-alt", "zoneName": "secondary", "label": "<i18n:text i18n:key="SKIN_FO_TOOLBAR_ADD_NEWS_TO_SECONDARY" i18n:catalogue="skin.{$skin}"/>"}
            ]</xsl:with-param>
            <xsl:with-param name="add-page-config">{                 
               "default-pagetype" : "template",                 
               "default-template" : "page",                 
               "default-pagecontent-type" : "contenttype",   
               "pagetype-card-template-filter": ["page", "fullpage"]       
               }</xsl:with-param> 
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="main-zone-top">
        <div class="top">
            
            <xsl:call-template name="quick-access"/>
            
            <div class="container">
                <xsl:call-template name="breadcrumb"/>
                <xsl:call-template name="actions"/>
                
                <xsl:call-template name="main-title"/>
                <a name="content"></a>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="actions">
        <div class="actions-print">
          <xsl:call-template name="matomo-stats"/>
          
          <xsl:if test="ametys:renderingContext() = 'front' and $pageFollowEnabled = 'true' and not($deactivatePageSubscription = 'true')">
                <xsl:call-template name="page-subscription"/>
          </xsl:if>
          
		  <a href="javascript:window.print();" title="skin.{$skin}:SKIN_PAGE_PRINT" i18n:attr="title">
            <xsl:call-template name="action-print-icon"/>
          </a>
          
          <xsl:call-template name="delimiter-actions"/>
            
          <xsl:call-template name="sendByMailForm">
              <xsl:with-param name="link-content"><xsl:call-template name="action-contact-icon"/></xsl:with-param>
          </xsl:call-template>

        </div>
    </xsl:template>
    
     <xsl:template name="delimiter-actions">
          <div class="delimiter-actions"></div>
     </xsl:template>
    
    <xsl:template name="action-print-icon">
    	<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="17.44" height="17.531" viewBox="0 0 17.44 17.531">
            <path id="action-print" class="action-print"
                d="M1603.47,271.36h-9.28v-3.44a1.085,1.085,0,0,1,.31-0.76,1.018,1.018,0,0,1,.75-0.32h4.82a1.9,1.9,0,0,1,1.46.62l1.34,1.34a1.883,1.883,0,0,1,.6,1.44v1.12Zm-13.03,9.86a1.081,1.081,0,0,1-.31-0.76v-6.78a1.049,1.049,0,0,1,.31-0.75,1.035,1.035,0,0,1,.75-0.31h15.28a1.041,1.041,0,0,1,.76.31,0.983,0.983,0,0,1,.32.75v6.78a1.04,1.04,0,0,1-.31.76,1.011,1.011,0,0,1-.77.32h-1.84v-3.72h-11.6v3.72h-1.84A1.014,1.014,0,0,1,1590.44,281.22Zm1.66-6.81a1.079,1.079,0,0,0-.33.79,1.109,1.109,0,0,0,.33.8,1.072,1.072,0,0,0,.79.34,1.056,1.056,0,0,0,.79-0.34,1.109,1.109,0,0,0,.33-0.8A1.117,1.117,0,0,0,1592.1,274.41Zm11.29,9.79a0.5,0.5,0,0,1-.38.16h-8.36a0.534,0.534,0,0,1-.38-0.16,0.546,0.546,0,0,1-.16-0.38v-4.94h9.44v4.94A0.507,0.507,0,0,1,1603.39,284.2Zm-7.23-2.99a0.594,0.594,0,0,0-.19.33v0.08a0.545,0.545,0,0,0,.16.38,0.534,0.534,0,0,0,.38.16h4.64a0.546,0.546,0,0,0,.54-0.54v-0.08a0.541,0.541,0,0,0-.19-0.33,0.509,0.509,0,0,0-.35-0.13h-4.64A0.527,0.527,0,0,0,1596.16,281.21Z"
                transform="translate(-1590.12 -266.844)" />
        </svg>
    </xsl:template>
    
    <xsl:template name="action-contact-icon">
    	<svg title="plugin.socialnetworking:PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_INFO" alt="plugin.socialnetworking:PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_INFO" i18n:attr="alt title" xmlns="http://www.w3.org/2000/svg" width="17.5" height="12.688" viewBox="0 0 17.5 12.688">
                <path id="action-mail" class="action-mail"
                    d="M1653.07,277.24q4.56-2.28,8.06-3.98a0.278,0.278,0,0,1,.31-0.01,0.32,0.32,0,0,1,.13.29v7.92a0.446,0.446,0,0,1-.15.34,0.483,0.483,0,0,1-.35.14h-16.48a0.485,0.485,0,0,1-.35-0.15,0.479,0.479,0,0,1-.15-0.35v-7.92a0.288,0.288,0,0,1,.44-0.28q1.125,0.54,6.5,3.18c0.79,0.387,1.34.66,1.66,0.82a0.465,0.465,0,0,0,.38,0h0Zm-8.84-5.66a1.079,1.079,0,0,0-.09-0.1,0.2,0.2,0,0,1-.05-0.1v-1.64a0.512,0.512,0,0,1,.14-0.35,0.463,0.463,0,0,1,.34-0.15h16.52a0.478,0.478,0,0,1,.36.14,0.465,0.465,0,0,1,.14.36v0.52q-0.015.821,0,1.1a0.211,0.211,0,0,1-.14.22l-8.44,4.16a0.462,0.462,0,0,1-.15.02,0.262,0.262,0,0,1-.15-0.04q-4.2-2.04-6.3-3.08Z"
                    transform="translate(-1644.09 -269.25)" />
            </svg>
    </xsl:template>
    
    <xsl:template name="main-title">
        <xsl:variable name="firstZoneItem" select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]"/>
        
        <xsl:choose>
            <xsl:when test="$firstZoneItem/information/type = 'CONTENT'">
                <div class="title">
                    <!-- Tags -->
                    <xsl:call-template name="main-content-tags">
                        <xsl:with-param name="mainContent" select="$firstZoneItem"/>
                    </xsl:call-template>
                    <!-- Title -->
                    <xsl:call-template name="main-content-title">
                    	<xsl:with-param name="title" select="$firstZoneItem/html/head/title"/>
                    </xsl:call-template>
                    <!-- Subtitle -->
                    <xsl:call-template name="main-content-subtitle">
                    	<xsl:with-param name="subtitle" select="$firstZoneItem/html/head/meta[@name = 'document-subtitle']/@content"/>
                    </xsl:call-template>
                    <!-- Dates / Export / Likes-->
                    <xsl:call-template name="main-content-dates">
                        <xsl:with-param name="mainContent" select="$firstZoneItem"/>
                    </xsl:call-template>
                </div>
                
                <xsl:call-template name="main-content-img">
                    <xsl:with-param name="mainContent" select="$firstZoneItem"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="/cms/page/pageContents/zone[@name='default']/zoneItem[1]/html/head/title">
                <div class="title-classic">
                    <h1><xsl:value-of select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]/html/head/title"/></h1>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="title-classic">
                    <h1><xsl:value-of select="/cms/page/@title"/></h1>
                </div>
            </xsl:otherwise>
            
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="main-content-title">
    	<xsl:param name="title"/>
    	
    	<h1><xsl:value-of select="$title"/></h1>
    </xsl:template>
    
    <xsl:template name="main-content-subtitle">
    	<xsl:param name="subtitle"/>
    	
    	<xsl:if test="$subtitle">
            <div>
    	      	<span class="subtitle">
    	      		<xsl:value-of select="$subtitle"/>
    	      	</span>
            </div>
	    </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-content-tags">
        <xsl:param name="maxSize">3</xsl:param>
        <xsl:param name="mainContent" select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]"/>
        
        <xsl:variable name="mainTags">
            <tags>
                <xsl:for-each select="$mainContent/html/head/meta[contains(@name, 'tags/') and not(contains(@name, ';parent'))]">
                    <xsl:variable name="tagId" select="substring-after(@name, 'tags/')"/>
                    <xsl:variable name="tagPath" select="ametys:tagPath($site, $tagId)"/>
                    <xsl:variable name="tagColor" select="ametys:tagColor($site, $tagId)"/>
                    
                    <xsl:if test="contains($tagPath, 'CONTENT_CATEGORIES')">
                        <tag bgColor="{$tagColor/main}" textColor="{$tagColor/text}"><xsl:value-of select="@content"/></tag>
                    </xsl:if>
                </xsl:for-each>
            </tags>
        </xsl:variable>
        
        <xsl:if test="exslt:node-set($mainTags)/tags/tag">
            <div class="tags">
                <xsl:for-each select="exslt:node-set($mainTags)/tags/tag[position() &lt;= $maxSize]">
                	<span class="tag blue">
                        <xsl:if test="$useTagColor and @bgColor">
                            <xsl:attribute name="style">background-color: <xsl:value-of select="@bgColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
                        </xsl:if>
                        <xsl:value-of select="."/>
                    </span>
                </xsl:for-each>
            </div>
        </xsl:if>   
    </xsl:template>
    
    <xsl:template name="main-content-dates">
        <xsl:param name="mainContent" select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]"/>
        
        <xsl:param name="cTypeId" select="$mainContent/information/type-information/@id"/>
        
        <xsl:choose>
            <xsl:when test="($cTypeId = 'org.ametys.plugins.news.Content.news' or $cTypeId = 'org.ametys.plugins.front-notification.Content.flashinfo')
                        and ($mainContent/html/head/meta[@name = 'start-date']/@content != '' or $mainContent/html/head/meta[@name = 'end-date']/@content != '')
                        and not($mainContent/html/head/meta[@name = 'hide-date']/@content = 'true')">
                <div class="white-date">
                    <div class="date-container">
                        <div class="date-container-bis">
                            <xsl:call-template name="dates">
                                <xsl:with-param name="startDate" select="$mainContent/html/head/meta[@name = 'start-date']/@content"/>
                                <xsl:with-param name="endDate" select="$mainContent/html/head/meta[@name = 'end-date']/@content"/>
                            </xsl:call-template>
                        </div>
                        <xsl:if test="$cTypeId = 'org.ametys.plugins.news.Content.news'">
                            <xsl:call-template name="export-ical">
                                <xsl:with-param name="content" select="$mainContent"></xsl:with-param>
                            </xsl:call-template>
                        </xsl:if>
                        <!-- Likes -->
                        <xsl:call-template name="main-content-likes">
                            <xsl:with-param name="mainContent" select="$mainContent"/>
                        </xsl:call-template>
                    </div>
                </div>                                       
            </xsl:when>
            <xsl:when test="$cTypeId = 'org.ametys.plugins.classified.ads.Content.ads'">
                <div class="white-date">
                    <div class="date-container">
                        <xsl:call-template name="dates">
                            <xsl:with-param name="startDate" select="$mainContent/html/head/meta[@name = 'createdAtRaw']/@content"/>
                        </xsl:call-template>
                   </div>
                 </div>
            </xsl:when>
            <xsl:when test="$mainContent/html/head/meta[@name = 'likes']/@content = 'true'">
                <div class="white-date">
                    <div class="date-container no-date">
                        <!-- Likes -->
                        <xsl:call-template name="main-content-likes">
                            <xsl:with-param name="mainContent" select="$mainContent"/>
                        </xsl:call-template>
                   </div>
                 </div>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="main-content-likes">
        <xsl:param name="mainContent" select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]"/>
        
        <xsl:if test="$mainContent/html/head/meta[@name = 'likes']/@content = 'true'">
            <span data-ametys-content-likes="{$mainContent/information/contentId}" class="ametys-content-likes">
                <button 
                    type="button"
                    onclick="AmetysFront.ContentReactions.likeOrUnlike('{$mainContent/information/contentId}', $j(this).attr('data-ametys-content-own-liker') == 'true', likeOrUnlikeContentCb)"
                    title="plugin.cms:PLUGINS_CMS_CONTENT_LIKE_TITLE"
                    i18n:attr="title"
                    data-ametys-content-own-liker="false" 
                    aria-pressed="false" 
                    aria-describedby="ametys-content-likes-tooltip"
                    class="ametys-content-likes__btn">
                    <span aria-hidden="true" class="icon like far fa-heart"></span>
                    <span aria-hidden="true" class="icon unlike fas fa-heart"></span>
                </button>
                <span id="ametys-content-likes-tooltip" role="tooltip" class="sr-only">
                    <!-- tootip content with likers-->
                </span>
                <span data-ametys-content-likes-count="true" class="ametys-content-likes__count"></span>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="export-ical">
        <xsl:param name="mainContent" select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]"/>
        <xsl:variable name="contentName" select="$mainContent/information/contentName"/>
        
        <a href="{$site-uri-prefix}/_content/{$contentName}.ics" class="export">
            <span class="icon"><img class="svg" src="{ametys:skinURL('templates/common/img/image/icon-export.svg')}" alt=""/></span>
            <i18n:text i18n:key="SKIN_NEWS_ICS_EXPORT" i18n:catalogue="skin.{$skin}"/>
        </a>
    </xsl:template>
    
    <xsl:template name="main-content-img">
        <xsl:param name="mainContent" select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]"/>
        
        <xsl:param name="cTypeId" select="$mainContent/information/type-information/@id"/>
        
        <xsl:variable name="attributePath">
            <xsl:choose>
                <xsl:when test="$cTypeId = 'org.ametys.plugins.classified.ads.Content.ads'">illustrations/image1</xsl:when>
                <xsl:otherwise>illustration/image</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="attributeAltPath">
            <xsl:choose>
                <xsl:when test="$cTypeId = 'org.ametys.plugins.classified.ads.Content.ads'"></xsl:when>
                <xsl:otherwise>illustration/alt-text</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="imgUri" select="$mainContent/html/head/meta[@name = concat($attributePath, ';uri')]/@content"/>
        <xsl:variable name="hideIllustration" select="ametys:templateParameter('hideIllustration')" />
        
        <xsl:if test="$imgUri and not($hideIllustration = 'true')">
            <xsl:variable name="imgType" select="$mainContent/html/head/meta[@name = concat($attributePath, ';type')]/@content"/>   
            <xsl:variable name="altText" select="$mainContent/html/head/meta[@name = $attributeAltPath]/@content"/>
            
            <div class="image-article">
                <xsl:call-template name="main-content-img-image">
                    <xsl:with-param name="imgType" select="$imgType"/>
                    <xsl:with-param name="imgUri" select="$imgUri"/>
                    <xsl:with-param name="altText" select="$altText"/>
                </xsl:call-template>
            </div>
            
            <xsl:call-template name="main-content-img-js"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-content-img-image">
        <xsl:param name="imgType"/>
        <xsl:param name="imgUri"/>
        <xsl:param name="altText"/>
        
        <picture>
            <source srcset="{resolver:resolveCroppedImage($imgType, $imgUri, 350, 490)}" media="(max-width: 540px)" /><!-- ratio 7:5-->
            <source srcset="{resolver:resolveCroppedImage($imgType, $imgUri, 400, 1100)}" media="(max-width: 1150px)" /><!-- ratio 11:4 -->
            <img src="{resolver:resolveCroppedImage($imgType, $imgUri, 500, 700)}" alt="{$altText}"/><!-- ratio 7:5-->
        </picture>
        
    </xsl:template>
    
    <xsl:template name="main-content-img-js">
        <script type="text/javascript">
            function ajustImage() {
                
                // reset
                $j('.cut-image').removeClass('cut-image');
                $j('.image-article').removeClass('center');
                $j('.sidebar').removeAttr('style');
                $j('.fixedMarginTop').removeAttr('style');
                $j('.fixedMarginTop').removeClass('fixedMarginTop');
                
                var imgArticleHeight = $j('.image-article img').height();
                var topHeight = $j('article .top').height() - 100;
                var diff = imgArticleHeight - topHeight - 120;
                
                if (topHeight > imgArticleHeight) {
                    if ($j(window).width() > 1150) {
                        $j('.image-article').addClass('center');
                    }
                } else {
                    $j('.sidebar').css('padding-top', diff + 'px');
                    
                    // Position of the left/bottom corner of the image
                    var imgPos = $j('.image-article img').offset().top + imgArticleHeight;
                    
                    // All children whose position is lower that imgPos will be cut  
                    $j('.content .ametys-cms-content').children().each(function (i) {
                        var topPos = $j(this).offset().top;
                        
                        if (topPos &lt;= imgPos) {
                        
                            if (($j(this).attr('id') || '').indexOf('faq-') == 0)
                            {
                                // Do not cut FAQ ! Apply margin top instead
                                // Get margin top of first child (.toggle)
                                let firstChild = $j(this).children().first();
                                var marginTop = parseInt(firstChild.css('margin-top').replace("px", "")); 
                                $j(this).css('margin-top', marginTop + 'px');
                                topPos = $j(this).offset().top; // recompute top position with margin top
                                marginTop += imgPos - topPos + marginTop; 
                                $j(this).css('margin-top', marginTop + 'px');
                            }
                            else
                            {
                                $j(this).addClass('cut-image');
                            }
                        }
                    });
                    
                    // Apply margin top for each services' containers whose position is lower that imgPos
                    $j('.content .leftContent .ametys-cms-service').each(function (i) {
                        var topPos = $j(this).offset().top;
                        if (topPos &lt;= imgPos) 
                        {
                            // get margin top of first child
                            let firstChild = $j(this).children().first();
                            var marginTop = parseInt(firstChild.css('margin-top').replace("px", ""));
                            $j(this).css('margin-top', marginTop + 'px');
                            topPos = $j(this).offset().top; // recompute top position with margin top
                            marginTop += imgPos - topPos + marginTop; // reapply initial margin top
                            $j(this).css('margin-top', marginTop + 'px');
                        }
                    });
                }
            }
            
            $j(document).ready(function () {
                $j('article .top').addClass('has-img');
                
                window.setTimeout(ajustImage, 1);
                
                $(window).on('resize', function(){
                    ajustImage();
                });
            });
        </script>
    </xsl:template>
        
    <xsl:template name="main-zone-content">
	    <div class="full-screen">
			<div class="content">
				<div class="left leftContent">
					<zone name="default" level="2"/>
					
					<zone name="secondary" level="2"/>
					
	                <zone name="bottom" level="2"/>
				</div>
				<div class="right sidebar">
					<zone name="right" level="2"/>
				</div>
				
			</div>
		</div>
	</xsl:template>
    
    <xsl:template name="quick-access">
        <xsl:choose>
            <xsl:when test="/cms/inputData/linkDirectory[@id='quickAccess']/links/link">
                <div class="sticky-container">
                    <div class="sticky-menu">
                        <div class="access">
                            <h2><strong><i18n:text i18n:key="SKIN_QUICK_ACCESS_TITLE" i18n:catalogue="skin.{$skin}"/><br/></strong></h2>
                            <ul>
                                <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='quickAccess']/links/link" mode="quick-access"/>
                            </ul>
                         </div>
                    </div>
                </div>
            </xsl:when>
            <xsl:when test="$rendering-context = 'back'">
                <div class="sticky-container">
                    <div class="sticky-menu">
                        <div class="access">
                            <span class="empty-hint"><i18n:text i18n:key="SKIN_QUICK_ACCESS_BO_EMPTY" i18n:catalogue="skin.{$skin}"/></span>
                        </div>
                    </div>
                 </div>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="quick-access-js">
        (function() 
        {
            var position = $j('.sticky-menu').offset();
           
            $j(window).scroll(function () {
                var scroll = $j(window).scrollTop() + 108;
                if (scroll >= position.top) {
                    $j('.sticky-menu').addClass('fixed');
                } else {
                    $j('.sticky-menu').removeClass('fixed');
                }
            });
        })();
    </xsl:template>
    
    <xsl:template name="zone-item-before">
      <xsl:param name="position"/>
      <xsl:param name="count"/>
      <xsl:param name="zone-name"/>
      <xsl:param name="level"/>
      <xsl:param name="inherited"/>
      <xsl:param name="id"/>
      <xsl:param name="type"/>
      <xsl:param name="content-id"/>
      <xsl:param name="service"/>
      <xsl:param name="content-type"/>
      
      <xsl:if test="$type = 'CONTENT' and not($deactivateFOEditionToolbar = 'true')">       
          <xsl:choose>
            <xsl:when test="$zone-name = 'right'">
                <!-- Small version of toolbar -->
                <xsl:call-template name="ametys-front-edition-content-toolbar">
                    <xsl:with-param name="content-id" select="$content-id"/>
                    <xsl:with-param name="zone-name" select="$zone-name"/>
                    <xsl:with-param name="zone-item-id" select="@id"/>
                    <xsl:with-param name="items">[{type: 'edit', label: ''}, 'current-step', {type: 'menu', label: '', icon: 'fas fa-ellipsis-v', items: ['workflow-action-3', 'workflow-action-4', 'workflow-action-7', 'workflow-action-10', 'tag', 'move', 'remove']}]</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$zone-name = 'default' or $zone-name = 'secondary'">
                <!-- Default toolbar for default zone -->
                <xsl:call-template name="ametys-front-edition-content-toolbar">
                    <xsl:with-param name="content-id" select="$content-id"/>
                    <xsl:with-param name="zone-name" select="$zone-name"/>
                    <xsl:with-param name="zone-item-id" select="@id"/>
                 </xsl:call-template>
            </xsl:when>
          </xsl:choose> 
      </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>