<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl ametys resolver">
    
    <xsl:import href="plugin:forms://pages/services/display/display_1.0.xsl"/>
    
    <xsl:template name="common-service-head-other-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/forms/scss/main.css')}"/>
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('templates/common/js/ametys-multiselect.css')}"/> 
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="head-scripts"/>
        <script src="{ametys:skinURL('templates/common/js/ametys-multiselect.js')}"></script>
    </xsl:template>
    
    <!-- Override to use service title first -->
    <xsl:template name="common-service-head-title">
        <xsl:variable name="title">
            <xsl:choose>
                <xsl:when test="$preview = 'true'"><xsl:value-of select="form/title"/></xsl:when>
                <xsl:when test="$service-title != ''"><xsl:value-of select="$service-title"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="form/title"/></xsl:otherwise>    
            </xsl:choose>
        </xsl:variable>
        
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$title"/>
        </xsl:call-template>
    </xsl:template>
    
</xsl:stylesheet>
