<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="ametys resolver">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">zone-abo</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/abonnements/scss/main.css')}" media="screen, print, handheld"/>
    </xsl:template> 
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{concat(ametys:uriPrefix(), '/plugins/page-subscription/resources/js/AmetysFront/UserPageSubscriptions.', ametys:lang(), '.js')}"/>    
        <!-- TOOLTIP -->
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/poppers.min.js')}" />
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min')}" />
        
        <script>
            const closeActionMenuOnEscapeKey_<xsl:value-of select="$uniqueId"/> = (event) => {
                if (event.key === "Escape") {
                  closeActionMenu_<xsl:value-of select="$uniqueId"/>();
                }
            };
            
            function openActionMenu_<xsl:value-of select="$uniqueId"/>(el) {
              $j(".action-modal").hide();
              let $modal = $j(el).next(".action-modal");
              $modal.show();
              $modal.addClass("opened");
              $j(el).attr("aria-expanded", true);
              
              $modal.on('keydown', closeActionMenuOnEscapeKey_<xsl:value-of select="$uniqueId"/>);
              $modal.find("ul li button").first().trigger('focus');
            }
            
            function editSubscriptionCb_<xsl:value-of select="$uniqueId"/>(subscriptionId) {
                let $subscriptionEl = $j('[data-ametys-subscription-id="' + subscriptionId + '"]');
                updateSubscriptionTooltip_<xsl:value-of select="$uniqueId"/>($subscriptionEl);
                closeActionMenu_<xsl:value-of select="$uniqueId"/>();
            }
            
            function closeActionMenu_<xsl:value-of select="$uniqueId"/>() {
              $j(".action-modal").hide();
              $j(".action-modal").prev('button').attr("aria-expanded", false);
              $j(".action-modal.opened").prev('button').trigger('focus');
              $j(".action-modal").removeClass("opened");
              $j(".action-modal").off('keydown', closeActionMenuOnEscapeKey_<xsl:value-of select="$uniqueId"/>);
            }
            
            $j(document).on('click', function (event) {
              if (
                !$j(event.target).is(".action-modal") &amp;&amp;
                !$j(event.target).is(".action-modal *") &amp;&amp;
                !$j(event.target).is(".actions") &amp;&amp;
                !$j(event.target).is(".actions *")
              ) {
                $j(".action-modal").hide();
              }
            });
            
            // Tippy plugin to hide tooltip on ESC
            const hideFrequencyTooltipOnEsc = {
              name: 'hideFrequencyTooltipOnEsc',
              defaultValue: true,
              fn({hide}) {
                function onKeyDown(event) {
                  if (event.keyCode === 27) {
                    hide();
                  }
                }
                return {
                  onShow() {
                    document.addEventListener('keydown', onKeyDown);
                  },
                  onHide() {
                    document.removeEventListener('keydown', onKeyDown);
                  },
                };
              },
            };
            
            function updateSubscriptionTooltip_<xsl:value-of select="$uniqueId"/>($subscriptionEl)
            {
                let smartLabel = $subscriptionEl.find('[data-ametys-subscription-page-role="smart-frequency"]').text();
                let $target = $subscriptionEl.find('[data-ametys-subscription-page-role="frequency"]').parent();
                
                // Destroy tooltip
                if ($target.get(0)._tippy)
                {
                    $target.get(0)._tippy.destroy();
                }
                    
                // Create tooltip
                $target.attr("data-tippy-content", smartLabel);
                tippy($target.get(0), {plugins: [hideFrequencyTooltipOnEsc]});
            }
            
            $j(function(){
                if ($j('[data-ametys-subscriptions="<xsl:value-of select="$uniqueId"/>"] [data-ametys-subscription-id]').length == 0)
                {
                    $j('[data-ametys-subscriptions="<xsl:value-of select="$uniqueId"/>"] [data-ametys-subscription-page-role="no-result"]').show();
                }
                // Tooltip
                $j('[data-ametys-subscriptions="<xsl:value-of select="$uniqueId"/>"] [data-ametys-subscription-id]').each(function() {
                    updateSubscriptionTooltip_<xsl:value-of select="$uniqueId"/>($j(this));
                });
            });
            
          </script>
                  
    </xsl:template>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
   </xsl:template>
   
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <div data-ametys-subscriptions="{$uniqueId}">
            <p class="subtitle">
              <i18n:text i18n:key="SERVICE_PAGE_SUBSCRIPTION_INTRO" i18n:catalogue="skin.{$skin}"/>
            </p>
            <p data-ametys-subscription-page-role="no-result" class="noresult" style="display: none"><i18n:text i18n:key="SERVICE_PAGE_SUBSCRIPTION_NOSUBSCRIPTION" i18n:catalogue="skin.{$skin}"/></p>
            
            <ul class="abonnements" data-ametys-subscription-page-role="results">
                <xsl:apply-templates select="/subscriptions/subscription"/>                
            </ul>
            <p class="sr-only" role="status" data-ametys-subscription-page-role="status"></p> 
            <script>
                <xsl:if test="count(/subscriptions/subscription) = 0">
                    $j("#page-subscription-<xsl:value-of select="$uniqueId"/> .noresult").show();
                </xsl:if>
            </script>
        </div>
    </xsl:template>
    
    <xsl:template match="subscription">
        <li class="abonnement-item" data-ametys-subscription-id="{@id}">
            <xsl:apply-templates select="." mode="info"/>
            <xsl:apply-templates select="." mode="actions"/>
        </li>
    </xsl:template>
    
    <xsl:template match="subscription" mode="info">
        <div class="infos">
          <span class="breadcrumb">
            <xsl:if test="ametys:pageExists($site, $lang, 'index')">
                <xsl:value-of select="ametys:pageTitle($site, $lang, 'index')"/>
            </xsl:if>
            <xsl:variable name="breadcrumb" select="ametys:breadcrumb(page/@id)"/>
            <xsl:for-each select="$breadcrumb[position() &lt;= 2]">
                <xsl:text> / </xsl:text>
                <xsl:value-of select="ametys:pageTitle(.)"/>
            </xsl:for-each>
            <xsl:if test="count($breadcrumb) &gt; 2">
                <xsl:if test="count($breadcrumb) &gt; 3"><xsl:text> / ...</xsl:text></xsl:if>
                <xsl:text> / </xsl:text>
                <xsl:value-of select="ametys:pageTitle($breadcrumb[position() = last()])"/>
            </xsl:if>
          </span>
            
            <a href="{resolver:resolve('page', page/@id, false)}"><xsl:value-of select="page"/></a>
        </div>
    </xsl:template>
    
    <xsl:template match="subscription" mode="actions">
        <div class="actions">
            <button type="button" aria-expanded="false" aria-label="skin.{$skin}:SERVICE_PAGE_SUBSCRIPTION_OPEN_MENU" i18n:attr="aria-label" onclick="openActionMenu_{$uniqueId}(this)">
                <xsl:call-template name="menu-icon"/>
            </button>
            
            <div class="action-modal action-modal__large">
                <button type="button" class="close" aria-label="skin.{$skin}:SERVICE_PAGE_SUBSCRIPTION_CLOSE_MENU" i18n:attr="aria-label" onclick="closeActionMenu_{$uniqueId}(this)">
                    <xsl:call-template name="menu-icon"/>
                </button>
            
                <xsl:apply-templates select="." mode="menu-actions"/>
            </div>
            
            <xsl:apply-templates select="." mode="frequency"/>
        </div>
    </xsl:template>
    
    <xsl:template match="subscription" mode="menu-actions">
        <ul id="{@id}">
            <xsl:call-template name="menu-item-nomail">
                <xsl:with-param name="subscriptionId" select="@id"/>
            </xsl:call-template>
            <xsl:apply-templates select="/subscriptions/frequencies/frequency" mode="menu-item">
                <xsl:with-param name="subscriptionId" select="@id"/>
            </xsl:apply-templates>
            <xsl:call-template name="menu-item-delete">
                <xsl:with-param name="subscriptionId" select="@id"/>
            </xsl:call-template>
        </ul>
    </xsl:template>
    
    <xsl:template name="menu-item-nomail">
        <xsl:param name="subscriptionId"/>
        <li>
            <button type="button" onclick="AmetysFront.UserPageSubscriptions.editSubscription('{$uniqueId}', '{$subscriptionId}', null, ['SITE'], editSubscriptionCb_{$uniqueId})">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                    class="lucide lucide-bell-off" aria-hidden="true">
                    <path d="M8.7 3A6 6 0 0 1 18 8a21.3 21.3 0 0 0 .6 5" />
                    <path d="M17 17H3s3-2 3-9a4.67 4.67 0 0 1 .3-1.7" />
                    <path d="M10.3 21a1.94 1.94 0 0 0 3.4 0" />
                    <path d="m2 2 20 20" />
                </svg>
                <i18n:text i18n:key="SERVICE_PAGE_SUBSCRIPTION_ACTION_NOMAIL" i18n:catalogue="skin.{$skin}"/>
            </button>
        </li>
    </xsl:template>
    
    <xsl:template name="menu-item-delete">
        <xsl:param name="subscriptionId"/>
        
        <li>
            <button type="button" onclick="AmetysFront.UserPageSubscriptions.unsubscribe('{$uniqueId}', '{$subscriptionId}')">
                <svg width="12px" height="13px" viewBox="0 0 11 13" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true">
                    <g id="Ametys-Intranet" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="Intranet-Cards---Preferences" transform="translate(-1498, -614)" fill="#505767" fill-rule="nonzero">
                            <g id="ABOS" transform="translate(424, 195)">
                                <g id="tooltip" transform="translate(1054, 348)">
                                    <g id="icon-delete" transform="translate(20, 71.5)">
                                        <path
                                            d="M3.75,9.375 C3.734375,9.609375 3.609375,9.734375 3.375,9.75 C3.140625,9.734375 3.015625,9.609375 3,9.375 L3,4.5 C3.015625,4.265625 3.140625,4.140625 3.375,4.125 C3.609375,4.140625 3.734375,4.265625 3.75,4.5 L3.75,9.375 Z M5.625,9.375 C5.609375,9.609375 5.484375,9.734375 5.25,9.75 C5.015625,9.734375 4.890625,9.609375 4.875,9.375 L4.875,4.5 C4.890625,4.265625 5.015625,4.140625 5.25,4.125 C5.484375,4.140625 5.609375,4.265625 5.625,4.5 L5.625,9.375 Z M7.5,9.375 C7.484375,9.609375 7.359375,9.734375 7.125,9.75 C6.890625,9.734375 6.765625,9.609375 6.75,9.375 L6.75,4.5 C6.765625,4.265625 6.890625,4.140625 7.125,4.125 C7.359375,4.140625 7.484375,4.265625 7.5,4.5 L7.5,9.375 Z M7.453125,0.5859375 L8.296875,1.875 L9.9375,1.875 C10.28125,1.90625 10.46875,2.09375 10.5,2.4375 C10.46875,2.78125 10.28125,2.96875 9.9375,3 L9.75,3 L9.75,10.125 C9.734375,10.65625 9.5546875,11.1015625 9.2109375,11.4609375 C8.8515625,11.8046875 8.40625,11.984375 7.875,12 L2.625,12 C2.09375,11.984375 1.6484375,11.8046875 1.2890625,11.4609375 C0.9453125,11.1015625 0.765625,10.65625 0.75,10.125 L0.75,3 L0.5625,3 C0.21875,2.96875 0.03125,2.78125 0,2.4375 C0.03125,2.09375 0.21875,1.90625 0.5625,1.875 L2.203125,1.875 L3.0703125,0.5859375 C3.3359375,0.2109375 3.6953125,0.015625 4.1484375,0 L6.3515625,0 C6.8046875,0.015625 7.171875,0.2109375 7.453125,0.5859375 L7.453125,0.5859375 Z M3.5625,1.875 L6.9609375,1.875 L6.515625,1.21875 C6.46875,1.15625 6.4140625,1.125 6.3515625,1.125 L4.1484375,1.125 C4.0703125,1.125 4.0234375,1.15625 4.0078125,1.21875 L3.5625,1.875 Z M1.875,10.125 C1.875,10.34375 1.9453125,10.5234375 2.0859375,10.6640625 L2.0859375,10.6640625 C2.2265625,10.8046875 2.40625,10.875 2.625,10.875 L7.875,10.875 C8.09375,10.875 8.2734375,10.8046875 8.4140625,10.6640625 C8.5546875,10.5234375 8.625,10.34375 8.625,10.125 L8.625,3 L1.875,3 L1.875,10.125 Z"
                                            id="Shape"></path>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
                <i18n:text i18n:key="SERVICE_PAGE_SUBSCRIPTION_ACTION_DELETE" i18n:catalogue="skin.{$skin}"/>
            </button>
        </li>
    </xsl:template>
    
    <xsl:template match="frequency" mode="menu-item">
        <xsl:param name="subscriptionId"/>
        <li>
            <button type="button" onclick="AmetysFront.UserPageSubscriptions.editSubscription('{$uniqueId}', '{$subscriptionId}', '{@name}', ['SITE', 'MAIL'], editSubscriptionCb_{$uniqueId})">
                <xsl:apply-templates select="." mode="menu-item-icon"/>
                <xsl:value-of select="label"/>
            </button>
        </li>
    </xsl:template>
    
    <xsl:template match="frequency" mode="menu-item-icon">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
            class="lucide lucide-bell" aria-hidden="true">
            <path d="M6 8a6 6 0 0 1 12 0c0 7 3 9 3 9H3s3-2 3-9" />
            <path d="M10.3 21a1.94 1.94 0 0 0 3.4 0" />
        </svg>
    </xsl:template>
    
    <xsl:template name="menu-icon">
        <svg aria-hidden="true" width="18px" height="5px" viewBox="0 0 18 5" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Ametys-Intranet" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Intranet-Cards---Preferences" transform="translate(-1560, -327)" fill="#989898" fill-rule="nonzero">
                    <g id="ABOS" transform="translate(424, 195)">
                        <g id="Group-12-Copy" transform="translate(0, 103)">
                            <g id="icon-settings" transform="translate(1136.3125, 29.3125)">
                                <path
                                    d="M4.375,2.1875 C4.34895833,2.8125 4.140625,3.33333333 3.75,3.75 L3.75,3.75 C3.33333333,4.140625 2.8125,4.34895833 2.1875,4.375 C1.5625,4.34895833 1.04166667,4.140625 0.625,3.75 C0.234375,3.33333333 0.0260416667,2.8125 0,2.1875 C0.0260416667,1.5625 0.234375,1.04166667 0.625,0.625 C1.04166667,0.234375 1.5625,0.0260416667 2.1875,0 C2.8125,0.0260416667 3.33333333,0.234375 3.75,0.625 C4.140625,1.04166667 4.34895833,1.5625 4.375,2.1875 Z M10.625,2.1875 C10.5989583,2.8125 10.390625,3.33333333 10,3.75 L10,3.75 C9.58333333,4.140625 9.0625,4.34895833 8.4375,4.375 C7.8125,4.34895833 7.29166667,4.140625 6.875,3.75 C6.484375,3.33333333 6.27604167,2.8125 6.25,2.1875 C6.27604167,1.5625 6.484375,1.04166667 6.875,0.625 C7.29166667,0.234375 7.8125,0.0260416667 8.4375,0 C9.0625,0.0260416667 9.58333333,0.234375 10,0.625 C10.390625,1.04166667 10.5989583,1.5625 10.625,2.1875 Z M12.5,2.1875 C12.5260417,1.5625 12.734375,1.04166667 13.125,0.625 L13.125,0.625 C13.5416667,0.234375 14.0625,0.0260416667 14.6875,0 C15.3125,0.0260416667 15.8333333,0.234375 16.25,0.625 C16.640625,1.04166667 16.8489583,1.5625 16.875,2.1875 C16.8489583,2.8125 16.640625,3.33333333 16.25,3.75 C15.8333333,4.140625 15.3125,4.34895833 14.6875,4.375 C14.0625,4.34895833 13.5416667,4.140625 13.125,3.75 C12.734375,3.33333333 12.5260417,2.8125 12.5,2.1875 Z"
                                    id="Shape"></path>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template match="subscription" mode="frequency">
        <span>
            <svg width="18px" height="13px" viewBox="0 0 18 13" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                <g id="Ametys-Intranet" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <g id="Intranet-Cards---Preferences" transform="translate(-1384, -366)" fill="#989898" fill-rule="nonzero">
                        <g id="ABOS" transform="translate(424, 195)">
                            <g id="Group-12-Copy" transform="translate(0, 103)">
                                <g id="mail" transform="translate(960, 64)">
                                    <g id="icon-abo" transform="translate(0, 4.904)">
                                        <path
                                            d="M15.732,0 C15.732,0.924 15.732,1.848 15.732,2.772 L15.732,3.888 C15.732,3.936 15.726,3.966 15.714,3.978 C15.702,3.99 15.672,3.99 15.624,3.978 C15.168,3.858 14.772,3.99 14.436,4.374 C14.412,4.326 14.406,4.266 14.418,4.194 L14.418,3.312 C14.406,2.556 14.406,1.992 14.418,1.62 C14.418,1.548 14.406,1.497 14.382,1.467 C14.358,1.437 14.304,1.428 14.22,1.44 C13.332,1.536 12.594,1.65 12.006,1.782 C11.214,1.962 10.506,2.214 9.882,2.538 C9.786,2.598 9.72,2.658 9.684,2.718 C9.648,2.778 9.63,2.868 9.63,2.988 C9.642,3.84 9.642,5.124 9.63,6.84 L9.63,9 C9.654,9.024 9.69,9.024 9.738,9 C10.95,8.556 12.39,8.25 14.058,8.082 C14.118,8.082 14.16,8.091 14.184,8.109 C14.208,8.127 14.22,8.166 14.22,8.226 C14.196,8.61 14.244,8.958 14.364,9.27 C14.388,9.33 14.388,9.369 14.364,9.387 C14.34,9.405 14.304,9.414 14.256,9.414 L14.238,9.414 C13.59,9.462 12.924,9.552 12.24,9.684 C11.244,9.876 10.446,10.116 9.846,10.404 C9.282,10.656 8.706,10.656 8.118,10.404 C7.602,10.176 7.026,9.984 6.39,9.828 C5.886,9.708 5.292,9.6 4.608,9.504 L3.726,9.414 C3.666,9.414 3.63,9.402 3.618,9.378 C3.606,9.354 3.612,9.318 3.636,9.27 C3.744,8.934 3.792,8.604 3.78,8.28 C3.768,8.208 3.777,8.157 3.807,8.127 C3.837,8.097 3.894,8.088 3.978,8.1 C5.646,8.268 7.086,8.574 8.298,9.018 C8.322,8.994 8.328,8.946 8.316,8.874 L8.316,8.838 C8.316,6.198 8.322,4.218 8.334,2.898 C8.334,2.766 8.274,2.664 8.154,2.592 C7.374,2.16 6.372,1.836 5.148,1.62 C4.836,1.572 4.368,1.512 3.744,1.44 C3.66,1.428 3.606,1.437 3.582,1.467 C3.558,1.497 3.546,1.554 3.546,1.638 L3.546,4.338 C3.354,4.146 3.15,4.023 2.934,3.969 C2.718,3.915 2.484,3.93 2.232,4.014 L2.214,3.888 L2.214,0.144 L2.232,0 L2.538,0 C2.562,0.024 2.598,0.036 2.646,0.036 L2.682,0.036 C3.63,0.072 4.53,0.168 5.382,0.324 C6.774,0.552 7.932,0.936 8.856,1.476 C8.904,1.5 8.946,1.509 8.982,1.503 C9.018,1.497 9.06,1.482 9.108,1.458 C9.564,1.206 9.99,1.014 10.386,0.882 C10.974,0.666 11.628,0.492 12.348,0.36 C12.924,0.252 13.596,0.162 14.364,0.09 C14.448,0.078 14.574,0.072 14.742,0.072 C15.042,0.06 15.264,0.036 15.408,0 L15.732,0 Z M1.998,4.752 C1.89,5.64 1.74,6.48 1.548,7.272 L1.548,7.308 C1.536,7.38 1.536,7.437 1.548,7.479 C1.56,7.521 1.596,7.548 1.656,7.56 C1.716,7.572 1.758,7.563 1.782,7.533 C1.806,7.503 1.824,7.458 1.836,7.398 L1.854,7.362 C1.926,7.062 2.01,6.6 2.106,5.976 L2.196,5.436 L2.214,5.292 C2.226,5.16 2.238,5.064 2.25,5.004 C2.274,4.86 2.328,4.749 2.412,4.671 C2.496,4.593 2.598,4.56 2.718,4.572 C2.838,4.584 2.937,4.635 3.015,4.725 C3.093,4.815 3.138,4.926 3.15,5.058 L3.15,6.48 C3.138,7.248 3.138,7.83 3.15,8.226 C3.15,8.754 3.024,9.21 2.772,9.594 C2.4,10.182 2.16,10.794 2.052,11.43 C2.04,11.502 2.016,11.544 1.98,11.556 C1.944,11.568 1.89,11.562 1.818,11.538 C1.074,11.274 0.516,11.082 0.144,10.962 C0.072,10.938 0.027,10.911 0.009,10.881 C-0.009,10.851 0,10.8 0.036,10.728 C0.228,10.344 0.342,9.918 0.378,9.45 C0.414,9.066 0.396,8.628 0.324,8.136 C0.276,7.704 0.252,7.38 0.252,7.164 C0.24,6.756 0.372,6.384 0.648,6.048 C0.852,5.82 1.17,5.502 1.602,5.094 L1.908,4.806 C1.92,4.794 1.95,4.776 1.998,4.752 Z M15.984,4.734 C16.08,4.794 16.2,4.902 16.344,5.058 L16.452,5.166 C16.524,5.226 16.626,5.322 16.758,5.454 C16.89,5.586 16.992,5.682 17.064,5.742 C17.376,5.994 17.58,6.3 17.676,6.66 C17.772,6.984 17.784,7.356 17.712,7.776 C17.64,8.268 17.604,8.658 17.604,8.946 C17.592,9.378 17.634,9.768 17.73,10.116 C17.826,10.404 17.904,10.614 17.964,10.746 C17.988,10.806 17.997,10.851 17.991,10.881 C17.985,10.911 17.958,10.932 17.91,10.944 L16.128,11.556 C16.032,11.592 15.978,11.562 15.966,11.466 C15.87,10.866 15.582,10.164 15.102,9.36 C14.934,9.096 14.85,8.784 14.85,8.424 L14.85,5.094 C14.85,4.866 14.931,4.71 15.093,4.626 C15.255,4.542 15.414,4.554 15.57,4.662 C15.678,4.746 15.744,4.89 15.768,5.094 C15.864,5.91 15.978,6.624 16.11,7.236 L16.128,7.272 C16.14,7.32 16.146,7.356 16.146,7.38 L16.164,7.398 C16.176,7.458 16.197,7.503 16.227,7.533 C16.257,7.563 16.296,7.572 16.344,7.56 C16.464,7.548 16.5,7.464 16.452,7.308 L16.218,6.192 L16.182,5.976 C16.098,5.436 16.032,5.022 15.984,4.734 Z M7.452,3.924 C7.452,4.092 7.446,4.203 7.434,4.257 C7.422,4.311 7.389,4.338 7.335,4.338 C7.281,4.338 7.17,4.314 7.002,4.266 C6.258,4.026 5.562,3.852 4.914,3.744 C4.854,3.732 4.812,3.711 4.788,3.681 C4.764,3.651 4.752,3.606 4.752,3.546 C4.776,3.354 4.776,3.168 4.752,2.988 C4.752,2.904 4.767,2.85 4.797,2.826 C4.827,2.802 4.878,2.802 4.95,2.826 C5.85,3.006 6.534,3.174 7.002,3.33 C7.17,3.378 7.281,3.417 7.335,3.447 C7.389,3.477 7.422,3.522 7.434,3.582 C7.446,3.642 7.452,3.756 7.452,3.924 Z M7.452,5.49 C7.452,5.67 7.446,5.787 7.434,5.841 C7.422,5.895 7.389,5.919 7.335,5.913 C7.281,5.907 7.17,5.88 7.002,5.832 C6.438,5.652 5.742,5.478 4.914,5.31 C4.854,5.298 4.812,5.283 4.788,5.265 C4.764,5.247 4.752,5.208 4.752,5.148 C4.776,4.944 4.776,4.734 4.752,4.518 C4.752,4.458 4.767,4.419 4.797,4.401 C4.827,4.383 4.866,4.38 4.914,4.392 C5.754,4.56 6.558,4.764 7.326,5.004 C7.41,5.016 7.452,5.07 7.452,5.166 L7.452,5.49 Z M10.494,3.906 C10.494,3.738 10.5,3.627 10.512,3.573 C10.524,3.519 10.557,3.477 10.611,3.447 C10.665,3.417 10.776,3.378 10.944,3.33 C11.424,3.174 12.114,3.006 13.014,2.826 C13.086,2.802 13.137,2.802 13.167,2.826 C13.197,2.85 13.209,2.895 13.203,2.961 C13.197,3.027 13.194,3.114 13.194,3.222 C13.218,3.438 13.206,3.582 13.158,3.654 C13.134,3.714 13.08,3.75 12.996,3.762 C12.948,3.786 12.87,3.801 12.762,3.807 C12.654,3.813 12.576,3.822 12.528,3.834 C11.832,4.002 11.226,4.17 10.71,4.338 C10.626,4.374 10.566,4.38 10.53,4.356 C10.494,4.332 10.482,4.278 10.494,4.194 C10.506,4.158 10.506,4.098 10.494,4.014 L10.494,3.906 Z M10.494,5.49 C10.494,5.322 10.5,5.211 10.512,5.157 C10.524,5.103 10.557,5.061 10.611,5.031 C10.665,5.001 10.776,4.962 10.944,4.914 C11.484,4.734 12.174,4.56 13.014,4.392 C13.086,4.38 13.137,4.386 13.167,4.41 C13.197,4.434 13.206,4.482 13.194,4.554 L13.194,4.698 C13.182,4.842 13.182,4.944 13.194,5.004 C13.206,5.112 13.191,5.19 13.149,5.238 C13.107,5.286 13.032,5.322 12.924,5.346 C12.204,5.466 11.466,5.658 10.71,5.922 C10.614,5.958 10.551,5.961 10.521,5.931 C10.491,5.901 10.482,5.844 10.494,5.76 C10.506,5.724 10.506,5.664 10.494,5.58 L10.494,5.49 Z M7.452,7.11 C7.452,7.278 7.446,7.389 7.434,7.443 C7.422,7.497 7.389,7.521 7.335,7.515 C7.281,7.509 7.17,7.482 7.002,7.434 C6.234,7.206 5.55,7.038 4.95,6.93 C4.878,6.906 4.827,6.879 4.797,6.849 C4.767,6.819 4.752,6.768 4.752,6.696 C4.776,6.492 4.776,6.294 4.752,6.102 C4.752,6.018 4.8,5.982 4.896,5.994 C5.544,6.114 6.354,6.312 7.326,6.588 C7.422,6.624 7.464,6.69 7.452,6.786 L7.452,7.11 Z"
                                            id="Shape"></path>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </svg>
            <span data-ametys-subscription-page-role="frequency"><xsl:value-of select="frequency/label" /></span>
        </span>
        <span class="frequency-tooltip sr-only" data-ametys-subscription-page-role="smart-frequency"><xsl:value-of select="frequency/smartLabel" /></span>
    </xsl:template>
    
</xsl:stylesheet>
