<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

    <xsl:import href="plugin:web://pages/services/search/search-default/results/pagination.xsl"/>
    
    <xsl:template name="pagination">
           <nav class="pagination" role="navigation" aria-label="skin.{$skin}:SKIN_SEARCH_NAV_PAGINATION_LABEL" i18n:attr="aria-label">
           
               <xsl:call-template name="common-utils-pagination-results">
                   <xsl:with-param name="i18nkey" select="'plugin.web:PLUGINS_WEB_SERVICE_SEARCH_VIEW_RESULTS'" />
                   <xsl:with-param name="pagination-start" select="/search/pagination/@start + 1" />
                   <xsl:with-param name="pagination-end" select="/search/pagination/@end" />
                   <xsl:with-param name="hits-total" select="/search/hits/@total" />
               </xsl:call-template>
           
               <ul>
                   <xsl:apply-templates select="ametys:pagination(/search/pagination/@total + 0, /search/pagination/@current + 0, 0, 5, 0)" mode="search-pagination">
                       <xsl:with-param name="original-context-node" select="/"/>
                   </xsl:apply-templates>
               </ul>
           </nav>
    </xsl:template>
    
    <xsl:template match="page" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:variable name="i18nparams"><page><xsl:value-of select="."/></page></xsl:variable> 
        
        <li class="page">
            <button>
                <xsl:attribute name="onclick">
                    <xsl:call-template name="search-js-page">
                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
                        <xsl:with-param name="page" select="."/>
                    </xsl:call-template>
                </xsl:attribute>
                <xsl:attribute name="aria-label">
                    <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_SEARCH_NAV_GO_TO_PAGE_LABEL'), $lang, $i18nparams)"/>
                </xsl:attribute>
                <xsl:value-of select="."/>
            </button>                           
        </li>
    </xsl:template>
    
    <xsl:template match="current" mode="search-pagination">
        <li class="page active" aria-current="true"><xsl:value-of select="."/></li>
    </xsl:template>
    
    <xsl:template match="gotopreviouspage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <li class="page prec">
                <button aria-label="plugin.web:FRONT_MODULE_SEARCH_NAV_PRECEDE_TITLE" i18n:attr="aria-label">
                    <xsl:attribute name="onclick">
                        <xsl:call-template name="search-js-page">
                            <xsl:with-param name="original-context-node" select="$original-context-node"/>
                            <xsl:with-param name="page" select="."/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <i18n:text i18n:key="SKIN_SERVICE_SEARCH_PREV_BTN" i18n:catalogue="skin.{$skin}"/>                         
                </button>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="gotonextpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <li class="page suiv">
                <button aria-label="plugin.web:FRONT_MODULE_SEARCH_NAV_NEXT_TITLE" i18n:attr="aria-label">
                    <xsl:attribute name="onclick">
                        <xsl:call-template name="search-js-page">
                            <xsl:with-param name="original-context-node" select="$original-context-node"/>
                            <xsl:with-param name="page" select="."/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <i18n:text i18n:key="SKIN_SERVICE_SEARCH_NEXT_BTN" i18n:catalogue="skin.{$skin}"/>                 
                </button>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="gotofirstpage" mode="search-pagination"/>
    <xsl:template match="gotolastpage" mode="search-pagination"/>
    <xsl:template name="common-utils-pagination-results"/>
    
    <!-- Override to use button instead of input and changing css class -->
    <xsl:template name="pagination-more-results">
        <xsl:if test="/search/pagination/@total > 1">
            <div data-ametys-search-role="show-more" class="button">
                <button class="btn">
                    <xsl:attribute name="onclick"><xsl:call-template name="search-js-next-page"/></xsl:attribute>
                    <span class="plus" aria-hidden="true">+</span>
                    <span><i18n:text i18n:key="PLUGINS_WEB_SERVICE_SEARCH_VIEW_BUTTON_MORE_RESULTS" i18n:catalogue="plugin.web"/></span>
                </button>
            </div>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
