<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:cms="http://ametys.org/cms/3.0"
    xmlns:docbook="http://docbook.org/ns/docbook" 
    extension-element-prefixes="cms"
    exclude-result-prefixes="ametys resolver docbook">    
    
    <!-- Template used to display the content body -->
    <xsl:template name="common-content-body">
        <table border="0" cellpadding="0" cellspacing="0" width="100%" class="emailBlockActuParent">
            <tr>
               <td valign="top" class="padding-t-30">
                    <table border="0" cellpadding="20" cellspacing="0" width="100%" class="emailBlockActu">
                        <tr>
			                <xsl:call-template name="common-content-body-image-bigsize">
			                    <xsl:with-param name="maxWidth">200</xsl:with-param>
			                    <xsl:with-param name="maxHeight">121</xsl:with-param>
			                    <xsl:with-param name="type">cropped</xsl:with-param>
			                </xsl:call-template>
	                       
                            <xsl:call-template name="common-content-body-content"/>
                        </tr>
                    </table>
               </td>
             </tr>
       </table>
    </xsl:template>
    
    <!-- Template used to display the content title -->
    <xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        
        <h3 class="ametys-richtext-title-2">
            <xsl:value-of select="$title"/>
        </h3>
    </xsl:template>
    
    <!-- Template use to read more -->
    <xsl:template name="common-content-body-readmore-newsletter">
    <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        <xsl:if test="$page-id != ''">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" style="max-width:100%; margin-top: 10px;">  
                <tr>
                    <td align="right">
                        <a href="{resolver:resolve('page', $page-id, false)}" class="email-link">
                            <i18n:text i18n:key="SKIN_CONTENT_NEWSLETTER_READ_MORE" i18n:catalogue="skin.{$skin}"/>
                        </a>
                    </td>
                </tr>
            </table>
        </xsl:if> 
    </xsl:template>
    
    <!-- Template used to display the content illustration -->
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth"/>
        <xsl:param name="maxHeight"/>
        <xsl:param name="class"/>
        <xsl:param name="type"/>
        
        <xsl:if test="$image">
            <td valign="top" class="td-image">
                <img alt="{$alternative}">
                    <xsl:attribute name="src">
                        <xsl:choose>
                            <xsl:when test="$type = 'cropped'"><xsl:value-of select="resolver:resolveCroppedImage($image/@type, $image/@path, $maxHeight, $maxWidth)"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="resolver:resolveBoundedImage($image/@type, $image/@path, $maxHeight, $maxWidth)"/></xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                </img>
            </td>
        </xsl:if>        
    </xsl:template>  
    
</xsl:stylesheet>