<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
			    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
			    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
			    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
			    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
			    exclude-result-prefixes="ametys resolver">    
    
    <xsl:import href="plugin:web://stylesheets/content/common.xsl"/>
    
    <!-- Use full ajax comments -->
    <xsl:import href="skin://pages/comments/helper/comments.xsl"/>

    <xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        
        <xsl:if test="not($zone = 'default') or not(ametys:pageId())">
            <h1 class="ametys-content-title">
                <xsl:value-of select="$title"/>
            </h1>
            
            <xsl:if test="$subtitle">
                <div class="ametys-content-subtitle">
               		<xsl:value-of select="$subtitle"/>
                </div>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-content-body-image-bigsize">
        <xsl:param name="image" select="metadata/illustration/image"/>
        <xsl:param name="alternative" select="metadata/illustration/alt-text"/>
        <xsl:param name="maxWidth" select="'700'"/>
        <xsl:param name="maxHeight" select="'500'"/>
        <xsl:param name="class" select="'big'"/>
        <xsl:param name="type" select="'bounded'"/>
        
        <xsl:call-template name="common-content-body-image">
            <xsl:with-param name="image" select="$image"/>
            <xsl:with-param name="alternative" select="$alternative"/>
            <xsl:with-param name="maxWidth" select="$maxWidth"/>
            <xsl:with-param name="maxHeight" select="$maxHeight"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="type" select="$type"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Contact, Publish date... -->
    <xsl:template name="common-content-body-meta"/>
    
</xsl:stylesheet>    