<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							xmlns:docbook="http://docbook.org/ns/docbook"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:exslt="http://exslt.org/common" 
							exclude-result-prefixes="ametys docbook resolver exslt">

    <xsl:import href="plugin:news://stylesheets/content/news/news-link.xsl"/>   
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    <xsl:import href="skin://stylesheets/dates.xsl"/>
    
    <xsl:variable name="common-content-css-class-name">agenda-list-carousel-el</xsl:variable>

	<xsl:template name="common-content-body-content">
		<xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <xsl:choose>
        	<xsl:when test="$page-id != ''">
        		<a href="{resolver:resolve('page', $page-id, false)}" class="agenda-list-carousel-el">
        			<xsl:call-template name="common-content-body-content-home-rendering"/>
        		</a>
        	</xsl:when>
        	<xsl:otherwise>
        		<a href="#" class="agenda-list-carousel-el">
        			<xsl:call-template name="common-content-body-content-home-rendering"/>
        		</a>
        	</xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="common-content-body-content-home-rendering">
        <xsl:call-template name="content-tag"/>
        <xsl:call-template name="content-title"/>
        <xsl:call-template name="content-dates"/>
    </xsl:template>
    
     <xsl:template name="content-tag">
        <xsl:variable name="tags"><xsl:call-template name="get-content-tags"/></xsl:variable>
        
        <xsl:for-each select="exslt:node-set($tags)/tag[position() &lt;= 1]">
           <div class="agenda-list-carousel-el_tag">
                <xsl:if test="$useTagColor and @bgColor">
                    <xsl:attribute name="style">background-color: <xsl:value-of select="@bgColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
                </xsl:if>
                <xsl:value-of select="." />
           </div>
        </xsl:for-each>
     </xsl:template>
     
     <xsl:template name="content-title">
        <div class="agenda-list-carousel-el_title">
        	<xsl:value-of select="metadata/title"/>
        </div>
     </xsl:template>
     
     <xsl:template name="content-dates">
        <!-- Dates -->
        <xsl:if test="metadata/start-date or metadata/end-date">
        	<div class="agenda-list-carousel-el_date">
	            <xsl:call-template name="dates">
	                <xsl:with-param name="startDate" select="metadata/start-date"/>
	                <xsl:with-param name="endDate" select="metadata/end-date"/>
                    <xsl:with-param name="showTime">false</xsl:with-param>
	            </xsl:call-template>
	        </div>
        </xsl:if> 
    </xsl:template>
</xsl:stylesheet>
