(function ($) {
 
    $.fn.ametysMultiselect = function(options) {
        
        var settings = $.extend({
            // These are the defaults.
            
            multiple: false, // enable multi selection
            search: false, // include option search box
            uniqueId: ("" + Math.random()).substring(2),
            
            // Texts
            label: "Select",
            placeholder: "Select an option",
            toggleBtnLabel: "Select an option",
            searchLabel: "Filter",
            
            // Listener
	        onChange: null
        }, options );
        
        var $select = $(this);
        
        // Draw custom multiselect box
        loadMultiSelect(this, settings, $select.val());
        
        // Hide select input
        $j(this).hide();
        
        // Activate listeners for keyboard navigation
        const $cbox = $(this).siblings(".ametys-multiselect-wrap").find("[role=combobox]");;
        const $lbox = $cbox.siblings(".ametys-multiselect-dropdown").find("[role=listbox]");
        const $btn = $cbox.children("button");
        
        const $options = $('li', $lbox);
                
        $cbox.on('click', function(e) {
            toggleDropdown($cbox);
            e.stopPropagation();
        });
                
        var altPressed = false;
      
        $cbox.on('keydown', function (e) {
            switch (e.which) {
                case 18:
                    altPressed = true;
                    break;
                case 9:
                    if (isOpenDropdown($cbox)) {
                        closeDropdown($cbox);
                    }
                    break;
                case 13:
                case 32:
                    toggleDropdown($cbox);
                    if (isOpenDropdown($cbox)) {
                        $lbox.trigger('focus');
                    }
                    e.preventDefault();
                    break;
                case 38:
                    if (altPressed == true) {
                        closeDropdown($cbox);
                    } else if (!isOpenDropdown($cbox)) {
                        openDropdown($cbox);       
                        $lbox.trigger('focus')
                        setActiveDescendant(getDefaultOption($lbox));
                        e.preventDefault();                 
                    }               
                    break;
                case 40:
                    if (!isOpenDropdown($cbox)) {
                        openDropdown($cbox);                           
                    }               
                    $lbox.trigger('focus')
                    setActiveDescendant(getDefaultOption($lbox));
                    e.preventDefault();
                    break;
                default:
                    return true;
            }
            
        });
                
        $lbox.on('keydown', function (e) {
            switch (e.which) {
                case 18:
                    altPressed = true;
                    break;
                case 9:
                    if (isOpenDropdown($cbox)) {
                        closeDropdown($cbox);
                    }
                    break;
               case 27:
                    if (isOpenDropdown($cbox)) {
                        closeDropdown($cbox);
                        $cbox.trigger('focus');
                    }
                    break;
                case 32:
                    onSelectOptions(getActiveDescendant($(this)), $select, settings);
                    e.preventDefault();
                    break;
                case 38: /* arrow up */
                    setActiveDescendant(getPreviousOption($(this)));
                    e.preventDefault(); 
                    break;   
                case 40: /* arrow down */
                    setActiveDescendant(getNextOption($(this)));
                    e.preventDefault();     
                    break;
                default:
                    return true;
            }
        });
      
        $btn.on('click', function(e) {
            toggleDropdown($cbox);
            $cbox.trigger('focus');
            e.stopPropagation();
        })
        
        $options.on('click', function(e) {
            onSelectOptions($(this), $select, settings);
            setActiveDescendant($(this));
            //e.stopProgation();
        });
        
        $cbox.next().find('.ametys-multiselect-dropdown-search input').on("keyup", filterOptions);
        
        $(document).on('keydown', function (e) {
            if (e.which == 27 && isOpenDropdown($cbox)) {
                closeDropdown($cbox);
            } 
        }).on('click', function (e) {
            if( !$(e.target).closest('.ametys-multiselect-dropdown').length ) {
                closeDropdown($cbox);
            }
        });
                
        return this;
    };
    
    // Load custom multiselect
    // =======================
    function loadMultiSelect(element, options)
    {
        // add option container
        $(element).after(`<div class="ametys-multiselect-wrap"></div>`);
        
        var $select = $(element).siblings('.ametys-multiselect-wrap');
        $select.append(`<div aria-controls="listbox-${options.uniqueId}"
                       aria-expanded="false"
                       aria-haspopup="listbox"
                       aria-label="${options.label}"
                       class="ametys-multiselect"
                       id="combo-${options.uniqueId}}"
                       role="combobox"
                       tabindex="0">
                       <div id="textbox-${options.uniqueId}" role="textbox" aria-readonly="true" aria-multiline="false" aria-autocomplete="none" aria-controls="listbox-${options.uniqueId}}" class="placeholder">${options.placeholder}</div>
                       <button type="button" class="ametys-multiselect-toggle" tabindex="-1" aria-label="${options.toggleBtnLabel}"></button>
                  </div>`);
                  
         var $cbox = $select.children('[role="combobox"]');
         var $btn = $cbox.children('button');
         
         // Insert list options
         $select.append(`<div class="ametys-multiselect-dropdown" style="display: none"><ul class="ametys-multiselect-dropdown-list" id="listbox-${options.uniqueId}" role="listbox" tabindex="-1"></div>`);
        
         // Insert search filter
         if (options.search)
         {
            $cbox.siblings(".ametys-multiselect-dropdown").prepend(`<div class="ametys-multiselect-dropdown-search"><input type="search" title="${options.searchLabel}" placeholder="${options.searchLabel}"></div>`);
         }
         
         var $optionsList = $cbox.siblings(".ametys-multiselect-dropdown").find('> ul');
         
         $(element).children().each(function(index){
            if( this.nodeName == 'OPTION' ) {
                let name  = $(this).text(),
                    value = $(this).val(),
                    checked = $(this).prop( 'selected');
                
                $optionsList.append(`<li class="ametys-multiselect-dropdown-item ${options.multiple ? '' : ' single-mode'}" role="option" aria-selected="${checked}" id="${options.uniqueId}-opt-${index}">
                                ${options.multiple ? '<span class="check" aria-hidden="true"></span>' : ''}
                                <span>${name}</span>
                            </li>`);
                
                $j(`#${options.uniqueId}-opt-${index}`).attr("data-value", value);            
            }
        });
        
        var labels = [];
        var $selectedOpts = $optionsList.find('li[aria-selected="true"]')
        $selectedOpts.each(function (index) {
            labels.push($(this).text());
        });
        
        if (labels.length)
        {
            const $textbox = $cbox.find("[role=textbox]");
            $textbox.text(labels.join(", "));
            $textbox.removeClass('placeholder');
        }
    }
    
    // Open or close combobox
    // -----------------------
    function toggleDropdown($cbox) {
	    if (isOpenDropdown($cbox)) {
	        closeDropdown($cbox);
	        $cbox.trigger('focus');
	    } else {
	        openDropdown($cbox);
	    }
	}

	function isOpenDropdown($cbox) {
	    return $cbox.attr('aria-expanded') == 'true';
	}
	
    // Open list options
    // ==================
	function openDropdown($cbox) {
	    // close all open combobox
	    closeDropdown($('.user-account form [role=combobox]'));
	    
	    $cbox.attr('aria-expanded', true);
	    $cbox.siblings(".ametys-multiselect-dropdown").show()
	    $cbox.children('button').addClass("active");
	}
	
    // Close list options
    // ===================
	function closeDropdown($cbox) {
	    $cbox.attr('aria-expanded', false);
	    $cbox.siblings(".ametys-multiselect-dropdown").hide();
	    $cbox.children('button').removeClass("active");
	    clearActiveDescendant($cbox.siblings(".ametys-multiselect-dropdown").find('[role="listbox"]'));
	}
    
    // Filter list options
    // ===================
    function filterOptions() {
        var value = $j(this).val().toLowerCase();
        $j(this)
            .parent()
            .parent()
            .find(".ametys-multiselect-dropdown-item")
            .filter(function () {
                $j(this).toggle($j(this).text().toLowerCase().indexOf(value) > -1);
            });
    }

	// Listener on select option
    // ==========================
	function onSelectOptions($option, $select, settings) {
	    const $dropdownList = $option.closest(".ametys-multiselect-dropdown");
	    if ($option.attr('aria-selected') == 'false') {
	        $option.attr('aria-selected', 'true');
	    } else {
	        $option.attr('aria-selected', 'false');
	    }
	    const optValue = $option.attr("data-value");
	    const $cbox = $dropdownList.parent().find("[role=combobox]");
	    const $textbox = $cbox.find("[role=textbox]");
	    const $input = $dropdownList.closest('.ametys-multiselect-wrap').prev("select");
        const $allOpt = $dropdownList.find("[data-value='']");
	
	    if (settings.multiple)
	    {
            if ($allOpt.attr("aria-selected") == 'true' 
                    && $option.attr('aria-selected') == 'true' 
                    && $option.attr("id") != $allOpt.attr("id")) 
            {
                // unselect "all" option
                $allOpt.attr('aria-selected', 'false');
            }
            
            if ($allOpt.attr("aria-selected") == 'true')
            {
                // unselect all other options if check "all" option
                $('li[aria-selected="true"]', $dropdownList).not('[data-value=""]').attr('aria-selected', 'false');
                $textbox.text(settings.placeholder);
                $textbox.addClass('placeholder');
                $input.val("");
            }
            else
            {
                let $selectedOpts = $('li[aria-selected="true"]', $dropdownList);
	            if ($selectedOpts.length == 0) {
	                // no option selected => check 'all' option
	                $textbox.text(settings.placeholder);
	                $textbox.addClass('placeholder');
	                $input.val("");
	            } else {
	                var count = $dropdownList.find("input:checked").length;
	    
	                var vals = [];
	                var labels = [];
	                $selectedOpts.each(function (index) {
	                    vals.push($(this).attr("data-value"));
	                    labels.push($(this).text());
	                });
	                
                    $('li[data-value=""]', $dropdownList).attr('aria-selected', 'false');
                    $textbox.text(labels.join(", "));
                    $textbox.removeClass('placeholder');
                    $input.val(vals);
	            }
            }
	    }
	    else
	    {
	        if ($option.attr('aria-selected') == 'true') {
	            // Unselect all other options
	            $('li[aria-selected="true"]', $dropdownList).not($option).attr('aria-selected', 'false');
	            if (optValue)
	            {
	                $textbox.text($option.text());
                    $textbox.removeClass('placeholder');
	                $input.val(optValue);
	            }
	            else
	            {
	                $textbox.text(settings.placeholder);
                    $textbox.addClass('placeholder');
	                $input.val("");
	            }
	        } else {
	            // No option selected
	            $textbox.text(settings.placeholder);
                $textbox.addClass('placeholder');
	            $input.val("");
	        }
            
            // Close dropdown
            closeDropdown($cbox);
            $cbox.trigger('focus');
	    }
        
        // Trigger change event
        $select.trigger('change', $select);
	}

    // Get the currently active option
    // =================================
	function getActiveDescendant($lbox) {
	    if ($lbox.attr('aria-activedescendant')) {
	        return $('#' + $lbox.attr('aria-activedescendant'));
	    }
	}
    
    // Set the currently active option
    // =================================
	function setActiveDescendant($option) {
	    let $lbox = $option.parent();
	    if (getActiveDescendant($lbox)) {
	        getActiveDescendant($lbox).removeClass('activedescendant');
	    } 
	    $lbox.attr('aria-activedescendant', $option.attr('id'));
	    getActiveDescendant($lbox).addClass('activedescendant');
	}
    
    // Clear selection
    // =================================
	function clearActiveDescendant($lbox) {
	    if (getActiveDescendant($lbox)) {
	        getActiveDescendant($lbox).removeClass('activedescendant');
	    }       
	    $lbox.attr('aria-activedescendant', '');
	}

    // Get the default option in list
    // ================================
	function getDefaultOption($lbox) {
	    if ($('li[aria-selected="true"]', $lbox).length > 0) {
	        return $('li[aria-selected="true"]', $lbox).eq(0);
	    } else {
	        return $('li:first-child', $lbox);
	    }
	}
    
    // Get the next option in list
    // ================================
	function getNextOption($lbox) {
	    if (getActiveDescendant($lbox)) {
	        var ad_index = getActiveDescendant($lbox).index();
	        if (ad_index == $('li', $lbox).length - 1) {
	            return $('li:first-child', $lbox);
	        } else {
	            return $('li', $lbox).eq(ad_index + 1);
	        }
	    } else {
	        return getDefaultOption($lbox);
	    }
	}

	// Get the previous option in list
	// ================================
	function getPreviousOption($lbox) {
	    if (getActiveDescendant($lbox)) {
	        var ad_index = getActiveDescendant($lbox).index();
	        if (ad_index === 0) {
	            return $('li:last-child', $lbox);
	        } else {
	            return $('li', $lbox).eq(ad_index - 1);
	        }
	    } else {
	        return getDefaultOption($lbox);
	    }
	}
 
}( jQuery ));





