<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:math="http://exslt.org/math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="resolver math ametys">

    <xsl:import href="plugin:calendar://pages/services/calendar/list_1.3.xsl"/>

    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name"> search view-main </xsl:variable>
    
   <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
    	<div class="service-search">
    		<div class="content">
	    		<div class="results">
			        <xsl:if test="/events/contents/event/view/content">     
			        	<ul class="result-list">       
			            	<xsl:apply-templates select="/events/contents/event/view/content"/>
			            </ul>
			        </xsl:if>
			    </div>
			</div>
		</div>
    </xsl:template>
    
    <xsl:template match="content">
    	<li class="classic-item">
            <xsl:apply-templates select="html/body/node()" mode="move-hierarchy">
                <xsl:with-param name="level" select="2"/>
            </xsl:apply-templates>
        </li>
    </xsl:template>
    
</xsl:stylesheet>
