<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" >
    
    <xsl:template name="theme-template">
        <template id="tag-subscription-template-{$uniqueId}">
            <xsl:call-template name="theme-subscription-template"/>
        </template>
        
        <template id="subscription-broadcast-channel-template-{$uniqueId}">
            <xsl:call-template name="subscription-broadcast-channel-template"/>
        </template>
    </xsl:template>
    
    <xsl:template name="theme-subscription-template">
        <tr>
            <td>
                <span>%%tag.label%%</span>
            </td>
<!--             <td data-ametys-subscription-broadcast-channels="%%id%%"> -->
<!--                 Fill with template subscription-broadcast-channel-template -->
<!--             </td> -->
            <td>
                <span title="%%frequency.smartLabel%%">%%frequency.fullLabel%%</span>
            </td>
            <td>
                <button type="button" onclick="AmetysFront.UserTagSubscriptions.openSubscription('{$uniqueId}', '%%id%%')" ><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_SERVICE_SUBSCRIPTION_EDIT_BUTTON" i18n:catalogue="plugin.page-subscription"/></button>
            </td>
            <td>
                <button type="button" onclick="AmetysFront.UserTagSubscriptions.unsubscribe('{$uniqueId}', '%%id%%')"><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_SERVICE_SUBSCRIPTION_REMOVE_BUTTON" i18n:catalogue="plugin.page-subscription"/></button>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="subscription-broadcast-channel-template">
        <span class="%%name%%">%%label%%</span>
    </xsl:template>
    
</xsl:stylesheet>
