<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>          
    <xsl:import href="skin://services/web/pages/services/search/common/home-search.xsl"/>
    <xsl:import href="plugin:web://pages/services/search/search-default/criteria/criteria.xsl"/>
    
    <xsl:variable name="common-service-css-class-name"> actu-perso</xsl:variable>
    
    <xsl:variable name="callback-function">initializeNewsPersoSearch_<xsl:value-of select="$uniqueId"/></xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <!-- BEGIN head-css-slick-carousel -->
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick-theme.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/accessible-slick-theme.css')}" type="text/css" />
        <!-- END head-css-slick-carousel -->
        
        <link rel="stylesheet" href="{ametys:skinURL('zones/actu-perso/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="search-service-head-js"/>
        
        <script type="text/javascript" src="{ametys:skinURL('plugins/slick/slick.js')}"></script>
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/poppers.min.js')}" />
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}" />
        
        <script type="text/javascript">
            <xsl:if test="$template = 'index'">
            var newsPersoCarouselInitialized = false;
            function launchNewsPersoCarousel_<xsl:value-of select="$uniqueId"/>(){
                
                let initialized = $j('#actu-perso-<xsl:value-of select="$uniqueId"/> .actu-perso-container').attr('data-carousel-initialized') == 'true'; 
                if (!initialized)
                {
                    $j('#actu-perso-<xsl:value-of select="$uniqueId"/> .actu-perso-container').slick({
                      regionLabel: "<i18n:text i18n:key="SKIN_SEARCH_ACTUS_PERSONNALIZE_CAROUSEL_REGION_LABEL" i18n:catalogue="skin.{$skin}"/>",
                      infinite: false,
                      autoplay: false,
                      dots: true,
                      pauseOnDotsHover:true,
                      arrows: false,
                      slidesToShow: 5,
                      slidesToScroll: 5,
                      ametysDotsBtnPrefixLabel: "<i18n:text i18n:key="SKIN_SEARCH_ACTUS_PERSONNALIZE_CAROUSEL_DOTS_PREFIX" i18n:catalogue="skin.{$skin}"/>",
                      responsive: [
                        {
                          breakpoint: 1480,
                          settings: {
                            slidesToShow: 4,
                            slidesToScroll: 4
                          }
                        },
                        {
                          breakpoint: 1024,
                          settings: {
                            slidesToShow: 3,
                            slidesToScroll: 3
                          }
                        },
                        {
                          breakpoint: 700,
                          settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2
                          }
                        },
                        {
                          breakpoint: 500,
                          settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1
                          }
                        }
                      ]
                    });
                }
                $j('#actu-perso-<xsl:value-of select="$uniqueId"/> .actu-perso-container').attr('data-carousel-initialized', true);
            };
            </xsl:if>
            
            function openDropdownPersonnalize_<xsl:value-of select="$uniqueId"/>(el) {
                $j(el).next().show();
                $j(el).attr("aria-expanded", "true");
                $j(el).next().find(".close").trigger('focus');
                // Close dropdown when ESCAPE key is pressed
                $j(el).next().on('keydown', hideDropdownPersonnalizeOnEscape_<xsl:value-of select="$uniqueId"/>);
            }
    
            const hideDropdownPersonnalizeOnEscape_<xsl:value-of select="$uniqueId"/> = (event) => {
                if (event.key === "Escape") {
                  closeDropdownPersonnalize_<xsl:value-of select="$uniqueId"/>();
                }
            };

            function closeDropdownPersonnalize_<xsl:value-of select="$uniqueId"/>(el) {
                if (el)
                {
                    $j(el).closest('.dropdown-personnalize').hide();
                    $j(el).closest('.dropdown-personnalize').prev().attr("aria-expanded", "false");
                    $j(el).closest('.dropdown-personnalize').off('keydown', hideDropdownPersonnalizeOnEscape_<xsl:value-of select="$uniqueId"/>);
                }
                else
                {
                    $j('#actu-perso-<xsl:value-of select="$uniqueId"/> .dropdown-personnalize').hide();
                    $j('#actu-perso-<xsl:value-of select="$uniqueId"/> .dropdown-personnalize').prev().attr("aria-expanded", "false");
                    $j('#actu-perso-<xsl:value-of select="$uniqueId"/> .dropdown-personnalize').off('keydown', hideDropdownPersonnalizeOnEscape_<xsl:value-of select="$uniqueId"/>);
                }
            }
                
            $j(document).on('click', function (e) {
                if ( $j(e.target).closest(".actu-personnalize-menu").length === 0) {
                    // close all opened dropdown
                    closeDropdownPersonnalize_<xsl:value-of select="$uniqueId"/>();
                }
            });
            
            $j(function() {
               initializeNewsPersoSearch_<xsl:value-of select="$uniqueId"/>();
            });
            
            function initializeNewsPersoSearch_<xsl:value-of select="$uniqueId"/>() {
                checkTags_<xsl:value-of select="$uniqueId"/>();
                
                <xsl:if test="$template = 'index'">
                launchNewsPersoCarousel_<xsl:value-of select="$uniqueId"/>();
                </xsl:if>
            }
            
            // Tippy plugin to hide tooltip on ESC
            const hideTagTooltipOnEsc_<xsl:value-of select="$uniqueId"/> = {
              name: 'hideTagTooltipOnEsc',
              defaultValue: true,
              fn({hide}) {
                function onKeyDown(event) {
                  if (event.keyCode === 27) {
                    hide();
                  }
                }
                return {
                  onShow() {
                    document.addEventListener('keydown', onKeyDown);
                  },
                  onHide() {
                    document.removeEventListener('keydown', onKeyDown);
                  },
                };
              },
            };
            
             function checkTags_<xsl:value-of select="$uniqueId"/>() {
                function cropTextToMaxWidth(text, maxWidth) {
                    const offScreenElement = document.createElement('span');
                    offScreenElement.style.visibility = 'hidden';
                    offScreenElement.style.position = 'absolute';
                    offScreenElement.style.whiteSpace = 'nowrap';
                    offScreenElement.style.font = 'inherit';
                    offScreenElement.textContent = text;
                    document.body.appendChild(offScreenElement);
    
                    const textWidth = offScreenElement.offsetWidth;
    
                    document.body.removeChild(offScreenElement);
    
                    if (textWidth > maxWidth) {
                        const croppedText = text.slice(0, Math.floor((maxWidth / textWidth) * text.length));
                        return croppedText + '...';
                    }
    
                    return text;
                }
            
                 setTimeout(function () {
                     $j('.actu-perso-item a').each(function() {
                            const tags = $j(this).find(".tags .tag:not('.count')");
                            if (tags.length === 0) {
                                return;
                            }
                            const widthItem = $j(this).width();
                            const maxTextWith = 145; // available width of tag text
                            
                            
                            const counterWidth = 53; // counter width "+X"
                            
                            let widthTags = $j(this).find(".tags").position().left; // left position of tags
                            $j(tags).each(function() {
                                widthTags += $j(this).outerWidth(true); // width with padding and margin including
                            });
                            
                            if (widthTags > widthItem) {
                                let tagText = '';
                                let widthTagIncrement = $j(this).find(".tags").position().left;
                                let countTagHide = 0;
                                $j(tags).each(function(index) {
                                    widthTagIncrement += $j(this).outerWidth(true); // width with padding and margin including
                                    if (widthTagIncrement + counterWidth > widthItem) {
                                        if (index === 0 &amp;&amp; tags.length == 1) {
                                            const text = $j(this).text();
                                            $j(this).text(cropTextToMaxWidth(text, maxTextWith));
                                            $j(this).attr('data-tippy-content', text);
                                            // $j(this).attr('tabindex', 0);
                                        } else if (index === 0 &amp;&amp; tags.length > 1) {
                                            const text = $j(this).text();
                                            $j(this).text(cropTextToMaxWidth(text, maxTextWith - counterWidth));
                                            $j(this).attr('data-tippy-content', text);
                                            // $j(this).attr('tabindex', 0);
                                        } else {
                                            $j(this).hide();
                                            tagText += $j(this).text() + ', ';
                                            countTagHide++;
                                        }
                                    }
                                });
                                tagText = tagText.slice(0, -2);
                                if (countTagHide > 0 &amp;&amp; !$j(this).find('.tags .tag.count').length) {
                                    $j(this).find('.tags').append(`&lt;span data-tippy-content="${tagText}" class="tag count">+${countTagHide}&lt;/span>`);
                                }
                                
                                tippy('.tags [data-tippy-content]', {plugins: [hideTagTooltipOnEsc_<xsl:value-of select="$uniqueId"/>]});
                            }
                        });
             }, 30);
         }
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="container" id="actu-perso-{$uniqueId}">
            <xsl:call-template name="service-header"/>
            
            <xsl:call-template name="search-results"/>
        </div>
    </xsl:template>
    
    <xsl:template name="service-header-link">
        <div class="flex-div">
            <xsl:call-template name="form-criteria"/>
            <xsl:call-template name="link"/> 
        </div>
    </xsl:template>
    
    <!-- Override to add css class -->
    <xsl:template name="form-criteria">    
        <xsl:call-template name="js-sumit-bo"/>
        <form action="{$site-uri-prefix}/{/search/url}#nav" method="post" class="search" role="search" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
            <div class="actu-personnalize-menu">
                <xsl:call-template name="form-search"/>
            </div>
        </form>
    </xsl:template>

    <!-- Override form-search: only tag criteria is supported ! -->
    <xsl:template name="form-search">
        <xsl:if test="/search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$tags')]">
             <xsl:call-template name="form-criteria-header"/>
             
             <div class="dropdown-personnalize" aria-labelledby="dropdown-personnalize-title_{$uniqueId}">
                <xsl:call-template name="criteria-dropdown-icon"/>
                <div class="dropdown-content">
                    <xsl:apply-templates select="/search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$tags')]" mode="field">
                        <xsl:with-param name="value" select="/search/form/values/criterion[@name = /search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$tags')]/@name]"/>
                    </xsl:apply-templates>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="form-criteria-header">
        <button type="button" aria-expanded="false" onclick="openDropdownPersonnalize_{$uniqueId}(this)" class="personnalize-link">
          <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
                <xsl:attribute name="style">display: none;</xsl:attribute>
            </xsl:if>
            <xsl:call-template name="form-criteria-icon"/>
            <i18n:text i18n:key="SKIN_SEARCH_ACTUS_PERSONNALIZE_LINK" i18n:catalogue="skin.{$skin}"/>
        </button>
    </xsl:template>
    
    <xsl:template name="criteria-dropdown-icon">
        <div class="dropdown-icons">
            <i class="fas fa-ellipsis-h" aria-hidden="true"></i>
            <button class="close" onclick="closeDropdownPersonnalize_{$uniqueId}(this)" aria-label="skin.{$skin}:SKIN_SEARCH_ACTUS_PERSONNALIZE_CLOSE_FILTER" i18n:attr="aria-label"><i class="fa fa-times close" aria-hidden="true"></i></button>
        </div>
    </xsl:template>
    
    <xsl:template name="form-criteria-icon">
        <svg id="icon-reglages" xmlns="http://www.w3.org/2000/svg" width="46" height="46"
            viewBox="-3 -3 46 46" aria-hidden="true">
            <defs>
            </defs>
            <rect id="Rectangle_arrondi_560_copie" data-name="Rectangle arrondi 560 copie" class="cls-1"
                width="40" height="40" rx="20" ry="20" />
            <path id="reglages" class="cls-2"
                d="M1286.18,1241.36a3.1,3.1,0,1,0-3.09,3.09A3.094,3.094,0,0,0,1286.18,1241.36Zm4.47-3.1a3.1,3.1,0,1,0,3.09,3.1A3.094,3.094,0,0,0,1290.65,1238.26Zm-15.13,0a3.1,3.1,0,1,0,3.1,3.1A3.094,3.094,0,0,0,1275.52,1238.26Z"
                transform="translate(-1263 -1221)" />
        </svg>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/criteria.xsl : only tag criteria is supported ! -->
    <xsl:template match="criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$tags')]" mode="field">
        <xsl:param name="value"/>
        
        <fieldset class="list-checkbox">
            <xsl:apply-templates select="." mode="field-label"/>
            <xsl:apply-templates select="." mode="field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </fieldset>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/criteria.xsl : only tag criteria is supported ! -->
    <xsl:template match="criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$tags')]" mode="field-label">
        <legend class="dropdown-title" id="dropdown-personnalize-title_{$uniqueId}"><i18n:text i18n:key="SKIN_SEARCH_ACTUS_PERSONNALIZE_THEMATIQUES" i18n:catalogue="skin.{$skin}"/></legend>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/criteria.xsl : only tag criteria is supported ! -->
    <xsl:template match="criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$tags')]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="criterion-name" select="@name"/>
        
             <xsl:for-each select="enumeration/item">
                <xsl:sort select="label" />
                
                <div class="item-checkbox">
                     <xsl:variable name="id-checkbox"><xsl:call-template name="criterion-id"/></xsl:variable>
                     <xsl:variable name="onclick">
                        <xsl:call-template name="search-js-submit-button"/>
                    </xsl:variable>
                
                    <input class="sr-only" onchange="{$onclick}" id="{$id-checkbox}-{position()}" type="checkbox" name="{../../@name}" value="{@value}">
                      <xsl:if test="$value = @value">
                            <xsl:attribute name="checked">checked</xsl:attribute>
                      </xsl:if>
                    </input>
                        
                   <label for="{$id-checkbox}-{position()}" class="checked">
                       <xsl:value-of select="label"/>
                   </label>
                </div>
            </xsl:for-each>
    </xsl:template>
    
     <xsl:template name="hits">
        <div data-ametys-search-role="hits" class="actu-perso-container">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </div>
    </xsl:template>
    
    <xsl:template name="hit">
        <div>
            <xsl:apply-templates select="."/>
        </div>
    </xsl:template>
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <a class="btn">
                <xsl:attribute name="href">
                    <xsl:call-template name="link-href"/>
                </xsl:attribute>
                <span class="plus" aria-hidden="true">+</span>
                <xsl:call-template name="link-attribute"/>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>actu-perso-item <xsl:text> </xsl:text>
    </xsl:template>
    
    
</xsl:stylesheet>