<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="ametys">

	<xsl:import href="plugin:multimedia://stylesheets/content/video/video-abstract.xsl"/>	
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>	
		
    <xsl:template name="content-image">
        <div class="picture">
            <xsl:choose>
                <xsl:when test="metadata/illustration/image">
                    <xsl:call-template name="common-content-body-image-bigsize">
                        <xsl:with-param name="maxWidth" select="'300'"/>
                        <xsl:with-param name="maxHeight" select="'200'"/>
                        <xsl:with-param name="type" select="'cropped'"/>
                    </xsl:call-template>    
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="content-default-image"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <img class="svg" src="{ametys:skinURL('templates/common/img/icon/recherche/video.svg')}"/>
    </xsl:template>
</xsl:stylesheet>
