<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:math="java.lang.Math" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:str="http://exslt.org/strings"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                exclude-result-prefixes="xalan math str ametys resolver user">  
    
    <xsl:template name="footer">
        <footer class="footer" role="contentinfo">
            <div class="columns">
                <xsl:call-template name="footer-column-1"/>
                
                <xsl:call-template name="footer-column-2"/>
                
                <xsl:call-template name="footer-column-3"/>
                
                <xsl:call-template name="footer-column-4"/>
            </div>
        </footer>
    </xsl:template>
    
    <xsl:template name="footer-column-1">
        <div class="column">
            <xsl:call-template name="footer-title"/>
            
            <xsl:call-template name="footer-address"/>
            
            <xsl:call-template name="footer-logo"/>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-column-2">
        <div class="column">
            <xsl:call-template name="footer-contact-title"/>
            <xsl:call-template name="footer-contact"/>
            
            <xsl:call-template name="footer-contact-links"/>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-column-3">
        <div class="column">
            <xsl:call-template name="footer-highlight-links"/>
            <xsl:call-template name="footer-others-links"/>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-column-4">
        <div class="column">
            <xsl:call-template name="footer-social-links-title"/>
            <xsl:call-template name="footer-social-links"/>
        </div>
    </xsl:template>
        
    <xsl:template name="footer-title">
        <h2 class="title">
            Ametys Intranet
        </h2>
    </xsl:template>
    
    <xsl:template name="footer-address">
        <span class="info">
            40 rue du village d'entreprise<br/>
            31670 Labège Cedex
        </span>
    </xsl:template>
    
    <xsl:template name="footer-logo">
        <a href="{$site-uri-prefix}/{$lang}/index.html">
            <img src="{ametys:skinURL('templates/common/img/logo-white.png')}" class="logo" alt="{ametys:siteParameter('title')}" />
        </a>
    </xsl:template>
    
    <xsl:template name="footer-contact-title">
        <h2 class="title">
            <i18n:text i18n:key="SKIN_FOOTER_CONTACT_TITLE" i18n:catalogue="skin.{$skin}" />
        </h2>
    </xsl:template>
    
    <xsl:template name="footer-contact">
        <span class="info">
            <i18n:text i18n:key="SKIN_FOOTER_CONTACT_TEXT" i18n:catalogue="skin.{$skin}" />
        </span>
    </xsl:template>
    
    <xsl:template name="footer-contact-links">
        <xsl:if test="/cms/inputData/sitemap//page[@PLUGIN_TAGS_FOOTER_LINKS_CONTACTS]/page">
            <ul>
                <xsl:apply-templates select="/cms/inputData/sitemap//page[@PLUGIN_TAGS_FOOTER_LINKS_CONTACTS]/page" mode="footer-link"/>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="footer-highlight-links">
        <xsl:if test="/cms/inputData/sitemap//page[@PLUGIN_TAGS_FOOTER_LINKS_HIGHLIGHT]">
            <ul class="partenaires">
                <xsl:apply-templates select="/cms/inputData/sitemap//page[@PLUGIN_TAGS_FOOTER_LINKS_HIGHLIGHT]" mode="footer-link-tag"/>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="footer-others-links">
        <xsl:if test="/cms/inputData/sitemap//page[@PLUGIN_TAGS_FOOTER_LINKS_OTHERS]/page">
            <ul>
                <xsl:apply-templates select="$sitemap//page[@PLUGIN_TAGS_FOOTER_LINKS_OTHERS]/page" mode="footer-link" />
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="page" mode="footer-link-tag">
        <li>
            <a href="{$site-uri-prefix}/{$lang}/{@sitemap:path}.html" class="title title-tag">
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes">
                        <xsl:with-param name="title" select="@sitemap:title"/>
                        <xsl:with-param name="className">title title-tag</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
                <xsl:value-of select="@sitemap:title" />
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="footer-link">
        <li>
            <a href="{$site-uri-prefix}/{$lang}/{@sitemap:path}.html">
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes">
                        <xsl:with-param name="title" select="@sitemap:title"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:apply-templates select="."  mode="footer-link-icon"/>
                <span class="link"><xsl:value-of select="@sitemap:title" /></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="footer-link-icon">
        <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                    width="45.312" height="32.78" viewBox="0 0 45.312 32.78">
            <defs>
                <filter id="filter" filterUnits="userSpaceOnUse">
                    <feFlood result="flood" flood-color="#fff" />
                    <feComposite result="composite" operator="in" in2="SourceGraphic" />
                    <feBlend result="blend" in2="SourceGraphic" />
                </filter>
            </defs>
            <g id="FLECHE">
                <path id="Rectangle_arrondi_15" data-name="Rectangle arrondi 15"
                    d="M281.062,1213.33a2.307,2.307,0,0,1,3.276,0l12.283,12.28a2.318,2.318,0,1,1-3.276,3.28l-12.283-12.29A2.31,2.31,0,0,1,281.062,1213.33Z"
                    transform="translate(-253.5 -1211.16)" />
                <path id="Rectangle_arrondi_15_copie" data-name="Rectangle arrondi 15 copie"
                    d="M279.505,1238.48l12.283-12.28a2.318,2.318,0,0,1,3.276,3.28l-12.284,12.28A2.318,2.318,0,0,1,279.505,1238.48Z"
                    transform="translate(-253.5 -1211.16)" />
                <circle cx="20.031" cy="16.655" r="4.125" />
                <circle id="Ellipse_2_copie" data-name="Ellipse 2 copie" cx="5.625" cy="16.655"
                    r="4.125" />
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="footer-social-links-title">
        <xsl:if test="/cms/inputData/linkDirectory[@id='socialNetworks']/links/link">
            <h2 class="title">
                <i18n:text i18n:key="SKIN_FOOTER_SOCIAL_LINKS_TITLE" i18n:catalogue="skin.{$skin}" />
            </h2>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="footer-social-links">
        <xsl:if test="/cms/inputData/linkDirectory[@id='socialNetworks']/links/link">
            <ul>
                <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='socialNetworks']/links/link" mode="social-link"/>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="link" mode="social-link">
        <li>
            <a href="{@url}" target="_blank">
                <xsl:call-template name="external-link-attributes">
                    <xsl:with-param name="title" select="@title"/>
                    <xsl:with-param name="className"></xsl:with-param>
                </xsl:call-template>
                <div class="img-social-container">
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'glyph'">
                            <span aria-hidden="true" class="picture link-glyph {@pictureGlyph}"></span>
                        </xsl:when>
                        <xsl:otherwise>
                             <xsl:variable name="imgId">
                                <xsl:choose>
                                    <xsl:when test="@pictureType = 'resource'">
                                        <xsl:value-of select="@pictureId" />
                                    </xsl:when>
                                    <xsl:when test="@pictureType = 'external'">
                                        <xsl:value-of select="concat(@picturePath, '?objectId=', @id)" />
                                    </xsl:when>
                                </xsl:choose>
                            </xsl:variable>
                            <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $imgId, 0, 0)}" alt="{@pictureAlternative}" />
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
                <span class="link">
                    <xsl:value-of select="@title" />
                </span>
            </a>
        </li>
    </xsl:template>
</xsl:stylesheet>    