<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:math="java.lang.Math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="math ametys resolver">
        
    <xsl:template name="input-file-js">
        <script type="text/javascript">
            function changeFile($event, id) {
            
                var input = $event;
                var url = $j($event).val()
                var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
                var parts = url.split("\\");
                var fileName = parts[parts.length - 1];
                $j('.download-' + id).find('label span').html(fileName);

                if(fileName == '') {
                    $j($event).val('');
                    $j('.download-' + id).find('label span').html("<i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/>");
                    $j('.download-' + id).find('.close').fadeOut();
                } else {
                    $j('.download-' + id).find('.close').fadeIn();
                }
            }

            function removeFile(e) {
                const parent = $j(e).parent();
                $j(parent).find('input').val('');
                $j(parent).children('label').children('span').html("<i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/>");
                $j(parent).find('.close').fadeOut();
            }
        </script>
    </xsl:template>
    
    <xsl:template name="input-image-file-js">
        <script type="text/javascript">
            function changePhoto($event, id) {
                var input = $event;
                var url = $j($event).val()
                var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
                if (input.files &amp;&amp; input.files[0] &amp;&amp; (ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg")) {
                    var reader = new FileReader();
        
                    reader.onload = function (e) {
                        $j('.preview-' + id).find('img').attr('src', e.target.result);
                        $j('.preview-' + id).next('.add-photo').hide();
                        $j('.preview-' + id).show();
                        $j('#photo-' + id).val(e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }
        
            function closePreview(e) {
                var preview = $j(e).parent();
        
                $j(preview).hide();
                $j(preview).next('.add-photo').show();
                $j(preview).next('.add-photo').find('input').val('');
            }
        </script>        
    </xsl:template>
    
    <xsl:template name="input-select-js">
        <script type="text/javascript">
            $j(function () {
                var $select = $j("form .field select");
                $select.each(function() {
                    var $this = $j(this);
                    $this.ametysMultiselect({
                        multiple: $this.attr('multiple') != null,
                        placeholder: $this.closest('.field').find('.label label').text(),
                        label: $this.closest('.field').find('.label label').text(),
                        toggleBtnLabel: "<i18n:text i18n:key="SKIN_FORMS_MULTISELECT_TOGGLE_BTN_LABEL" i18n:catalogue="skin.{$skin}"/>"
                    });
                });
            });
        </script>
    </xsl:template>
    
    <xsl:template name="download-icon">
        <svg version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512"
                    style="enable-background:new 0 0 512 512;" xml:space="preserve">
                    <g id="Solid">
                        <path
                            d="M239,385c9.4,9.4,24.6,9.4,33.9,0c0,0,0,0,0,0l90.5-90.5c9.4-9.4,9.4-24.6,0-33.9c-9.4-9.4-24.6-9.4-33.9,0L280,310.1V48
c0-13.3-10.7-24-24-24c-13.3,0-24,10.7-24,24v262.1l-49.5-49.5c-9.4-9.4-24.6-9.4-33.9,0c-9.4,9.4-9.4,24.6,0,33.9L239,385z"
                                                fill="#FC7D85" />
                        <path d="M464,232c-13.3,0-24,10.7-24,24v184H72V256c0-13.3-10.7-24-24-24s-24,10.7-24,24v192c0,22.1,17.9,40,40,40h384
c22.1,0,40-17.9,40-40V256C488,242.7,477.3,232,464,232z" fill="#FC7D85" />
                    </g>
                </svg>
    </xsl:template>
    
    <xsl:template name="photo-icon">
        <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" 
             xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
             viewBox="0 0 420.8 420.8" style="enable-background:new 0 0 420.8 420.8;" 
             xml:space="preserve">
            <g>
                <g>
                    <g>
                        <path d="M406.8,96.4c-8.4-8.8-20-14-33.2-14h-66.4v-0.8c0-10-4-19.6-10.8-26c-6.8-6.8-16-10.8-26-10.8h-120
                            c-10.4,0-19.6,4-26.4,10.8c-6.8,6.8-10.8,16-10.8,26v0.8h-66c-13.2,0-24.8,5.2-33.2,14c-8.4,8.4-14,20.4-14,33.2v199.2
                            C0,342,5.2,353.6,14,362c8.4,8.4,20.4,14,33.2,14h326.4c13.2,0,24.8-5.2,33.2-14c8.4-8.4,14-20.4,14-33.2V129.6
                            C420.8,116.4,415.6,104.8,406.8,96.4z M400,328.8h-0.4c0,7.2-2.8,13.6-7.6,18.4s-11.2,7.6-18.4,7.6H47.2
                            c-7.2,0-13.6-2.8-18.4-7.6c-4.8-4.8-7.6-11.2-7.6-18.4V129.6c0-7.2,2.8-13.6,7.6-18.4s11.2-7.6,18.4-7.6h77.2
                            c6,0,10.8-4.8,10.8-10.8V81.2c0-4.4,1.6-8.4,4.4-11.2s6.8-4.4,11.2-4.4h119.6c4.4,0,8.4,1.6,11.2,4.4c2.8,2.8,4.4,6.8,4.4,11.2
                            v11.6c0,6,4.8,10.8,10.8,10.8H374c7.2,0,13.6,2.8,18.4,7.6s7.6,11.2,7.6,18.4V328.8z"/>
                        <path d="M210.4,130.8c-27.2,0-52,11.2-69.6,28.8c-18,18-28.8,42.4-28.8,69.6s11.2,52,28.8,69.6c18,18,42.4,28.8,69.6,28.8
                            s52-11.2,69.6-28.8c18-18,28.8-42.4,28.8-69.6s-11.2-52-28.8-69.6C262.4,142,237.6,130.8,210.4,130.8z M264.8,284
                            c-14,13.6-33.2,22.4-54.4,22.4S170,297.6,156,284c-14-14-22.4-33.2-22.4-54.4s8.8-40.4,22.4-54.4c14-14,33.2-22.4,54.4-22.4
                            s40.4,8.8,54.4,22.4c14,14,22.4,33.2,22.4,54.4C287.6,250.8,278.8,270,264.8,284z"/>
                        <circle cx="352.8" cy="150" r="19.6"/>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
</xsl:stylesheet>       