/**
 * Toggle Favorite wrapper.
 *
 * @author Htmlstream
 * @version 1.0
 *
 */
;(function ($) {
	'use strict';
	
	$.HSCore.components.HSToggleFavorite = {
		/**
		 *
		 *
		 * @var Object _baseConfig
		 */
		_baseConfig: {
			activeClass: 'active'
		},
		
		/**
		 *
		 *
		 * @var jQuery pageCollection
		 */
		pageCollection: $(),
		
		/**
		 * Initialization of Toggle Favorite wrapper.
		 *
		 * @param String selector (optional)
		 * @param Object config (optional)
		 *
		 * @return jQuery pageCollection - collection of initialized items.
		 */
		
		init: function (selector, config) {
			
			this.collection = selector && $(selector).length ? $(selector) : $();
			if (!$(selector).length) return;
			
			this.config = config && $.isPlainObject(config) ?
				$.extend({}, this._baseConfig, config) : this._baseConfig;
			
			this.config.itemSelector = selector;
			
			this.initToggleFavorite();
			
			return this.pageCollection;
			
		},
		
		initToggleFavorite: function () {
			//Variables
			var $self = this,
				config = $self.config,
				collection = $self.pageCollection,
                isInWishList = config.isInWishList,
                itemId = config.itemId,
                itemTitle = config.itemTitle,
                callback = config.callback;
			
			//Actions
			this.collection.each(function (i, el) {
				//Variables
				var $this = $(el),
					$text = $this.find('[data-tf-text]'),
					defaultText = $this.data('tf-default-text'),
					activeText = $this.data('tf-active-text'),
					$icon = $this.find('[data-tf-icon]'),
					defaultIcon = $this.data('tf-default-icon'),
					activeIcon = $this.data('tf-active-icon'),
					activeIconColor = $this.data('tf-active-icon-color');
				
				if (isInWishList) {
					
					$this.addClass('active');
					
                    $self.updateEl($this, true);
				}
                
                if (ODFCart)
                {
                    ODFCart.registerListener(function() {
                        ODFCart.hasItem(itemId, function(answer) {
                            $self.updateEl($this, answer);
                        });
                    });
                }
				
				if (!(/iPhone|iPad|iPod|Android/i.test(navigator.userAgent))) {
					
					$this.on('mouseenter', function () {
						
						if (!$this.hasClass(config.activeClass)) {
							
							$self.removeIcon($icon, defaultIcon, activeIcon);
							
						}
						
					});
					
					$this.on('mouseleave', function () {
						
						if (!$this.hasClass(config.activeClass)) {
							
							$self.addIcon($icon, defaultIcon, activeIcon);
							
						}
						
					});
					
				}
				
				$this.on('click touchstart', function (e) {
					
					e.preventDefault();
					
					$this.toggleClass('active');
                    
                    var isInWishlist = $this.data('tf-is-in-wishlist') === 'in';
                    $self.updateEl($this, !isInWishlist);
                    
                    if (ODFCart)
                    {
                        if (isInWishlist)
                        {
	                        ODFCart.removeItem(itemId, callback);
                        }
                        else
                        {
                            ODFCart.addItem(itemId, itemTitle, callback);
                        }
                    }
				});
				
				//Actions
				collection = collection.add($this);
			});
		},
        
        onCartModified: function(itemId, el)
        {
            ODFCart.hasItem(itemId, function(isInWishlist) {
                
            });
        },
        
        updateEl: function(el, isInWishlist)
        {
            var $self = this,
                $this = el,
                $text = $this.find('[data-tf-text]'),
                defaultText = $this.data('tf-default-text'),
                activeText = $this.data('tf-active-text'),
                $icon = $this.find('[data-tf-icon]'),
                defaultIcon = $this.data('tf-default-icon'),
                activeIcon = $this.data('tf-active-icon'),
                activeIconColor = $this.data('tf-active-icon-color');
                
            if (isInWishlist)
            {
                if (activeText) {
                    
                    $text.text(activeText);
                    
                }
                
                if (activeIcon) {
                        
                    $icon.removeClass(defaultIcon).addClass(activeIcon);
                    
                }
                    
                if (activeIconColor) {
                    
                    $icon.addClass(activeIconColor);
                }
                
                if ((/iPhone|iPad|iPod|Android/i.test(navigator.userAgent))) {
                    
                    $self.removeIcon($icon, defaultIcon, activeIcon);
                }
                
                $this.data('tf-is-in-wishlist', 'in');
                
            }
            else
            {
                if (defaultText) {
                            
                    $text.text(defaultText);
                    
                }
                
                if (activeIcon) {
                        
                    $icon.removeClass(activeIcon).addClass(defaultIcon);
                    
                }
                
                if (activeIconColor) {
                    
                    $icon.removeClass(activeIconColor);
                    
                }
                
                if ((/iPhone|iPad|iPod|Android/i.test(navigator.userAgent))) {
                    
                    $self.addIcon($icon, defaultIcon, activeIcon);
                    
                }
                
                $this.data('tf-is-in-wishlist', 'out');
            }
        },
		
		removeIcon: function (el, def, act) {
			
			el.removeClass(def);
			el.addClass(act);
			
		},
		
		addIcon: function (el, def, act) {
			
			el.removeClass(act);
			el.addClass(def);
			
		}
	};
})(jQuery);
