;(function ($) {
	'use strict';
	
	var AmetysExpandable = window.AmetysExpandable || {};
	
	AmetysExpandable = (function () {
		
		function AmetysExpandable(element, options) {
			
			var $self = this;
			
			/**
			 * Current element.
			 *
			 * @public
			 */
			this.$element = $(element);
			
			/**
			 * Current options set by the caller including defaults.
			 *
			 * @public
			 */
			$self.options = $.extend(true, {}, AmetysExpandable.defaults, options);
			
			this.initialize();
			
		}
		
		return AmetysExpandable;
		
	}());
	
	AmetysExpandable.defaults = {
		invokerSelector: null,
		invokerOpenedText: null,
		invokerClosedText: null,
		invokerTextChangeSelector: null,
		
		itemsInRow: null,
		
		targetContentWrapper: null,
		targetContentWrapperChild: null,
		
		targetContentIndex: null,
		targetContentCurrant: null
	};
	
	/**
	 * Initialization of the plugin.
	 *
	 * @protected
	 */
	AmetysExpandable.prototype.initialize = function () {
		// vars
		var $self = this,
			initialWidth = window.innerWidth;
		
		$self.options.containerSelector = '#' + $self.$element[0].id;
		
		$self.options.invokerSelector = $self.options.containerSelector + ' [data-exp-target]';
		$self.options.invokerTextChangeSelector = $self.options.containerSelector + ' [data-exp-text-change]';
		
		function reset() {
			
			$self.options.targetContentWrapperChild.slideUp(400, function () {
				
                if ($self.options.targetContentCurrant)
                {
					$self.options.targetContentCurrant.slick('unslick');
					
					$self.options.targetContentCurrant.hide().insertAfter($($self.options.containerSelector));
                }
				
                if ($self.options.targetContentWrapper)
                {
					$self.options.targetContentWrapper.remove();
					
					$self.options.targetContentWrapper = null;
                }
				
				$self.options.targetContentIndex = null;
				
				$self.options.targetContentCurrant = null;
				
			});
			
		}
		
		$(window).on('resize', function () {
			
			if (window.innerWidth < 768) {
				
				$self.options.itemsInRow = 1;
				
			} else if (window.innerWidth < 992) {
				
				$self.options.itemsInRow = 2;
				
			} else {
				
				$self.options.itemsInRow = 3;
				
			}
			
		});
		
		$(window).on('resize', function () {
			
			if (window.innerWidth !== initialWidth) {
				
				if ($self.options.targetContentWrapperChild) {
					
					$($self.options.invokerTextChangeSelector).text($self.options.invokerClosedText);
					
					$($self.options.invokerSelector).removeClass('active');
					
					reset();
					
					initialWidth = window.innerWidth;
					
					return false;
					
				}
				
			}
			
		});
		
		$(document).on('click', 'body', function (e) {
			
			var $target = $(e.target).parents($self.options.containerSelector);
			
			if (($target.length === 1)) {
				
				return 0;
				
			} else {
				
				if ($self.options.targetContentWrapperChild) {
					
					$($self.options.invokerTextChangeSelector).text($self.options.invokerClosedText);
					
					$($self.options.invokerSelector).removeClass('active');
					
					reset();
					
					initialWidth = window.innerWidth;
					
					return false;
					
				}
				
			}
			
		});
		
		$(window).trigger('resize');
		
		$($self.options.invokerSelector).on('click', function (e) {
			e.preventDefault();
			
			var $this = $(this),
				target = $this.data('exp-target');
			
			if ($this.hasClass('active')) {
				
				$this.find('[data-exp-text-change]').text($self.options.invokerClosedText);
				
				$this.removeClass('active');
				
				reset();
				
				return false;
				
			}
			
			if ($self.options.targetContentIndex !== closestItem()) {
				
				if ($self.options.targetContentWrapper) {
					
					$self.options.targetContentWrapperChild.slideUp(400, function () {
						
						$self.options.targetContentWrapper.remove();
						
						insertWrapper();
						
					});
					
				} else {
					
					insertWrapper();
					
				}
				
			} else {
				
				initCarousel();
				
			}
			
			function closestItem() {
				
				for (var i = $this.index() + 1; i <= $($self.options.invokerSelector).length; i++) {
					
					if (($this.index() + 1) % $self.options.itemsInRow === 0) return $this.index() + 1;
					
					if (i > ($this.index() + 1) && i % $self.options.itemsInRow === 0) {
						
						return i;
						
					}
					
					if (i === $($self.options.invokerSelector).length) {
						
						return $($self.options.invokerSelector).length;
						
					}
					
				}
				
			}
			
			function insertCarousel() {
				
				$($self.options.invokerTextChangeSelector).text($self.options.invokerClosedText);
				
				$($self.options.invokerSelector).removeClass('active');
				
				$this.find('[data-exp-text-change]').text($self.options.invokerOpenedText);
				
				$this.addClass('active');
				
				$self.options.targetContentCurrant = $(target);
				
				$self.options.targetContentCurrant.appendTo($self.options.targetContentWrapperChild).show();
				
				$self.options.targetContentCurrant.on('init', function () {
					
					$self.options.targetContentWrapperChild.addClass('initialized');
					
				});
				
				$.HSCore.components.HSCarousel.init($self.options.targetContentCurrant);
				
			}
			
			function initCarousel() {
				
				if (!$self.options.targetContentCurrant) {
					
					insertCarousel();
					
				} else {
					
					$self.options.targetContentCurrant.slick('unslick');
					
					$self.options.targetContentWrapperChild.removeClass('initialized');
					
					$self.options.targetContentCurrant.hide().insertAfter($($self.options.containerSelector));
					
					insertCarousel();
					
				}
				
			}
			
			function insertWrapper() {
				
				$self.options.targetContentWrapper = $('<div class="ametys-courses-expandable-wrap"><div class="ametys-courses-expandable"><div class="ametys-courses-expandable-inner"></div></div></div>').insertAfter($($self.options.invokerSelector).eq(closestItem() - 1));
				
				$self.options.targetContentWrapperChild = $($self.options.targetContentWrapper[0].firstElementChild);
				
				$self.options.targetContentWrapper.show();
				
				$self.options.targetContentWrapperChild.slideDown(400);
				
				initCarousel();
				
				$self.options.targetContentIndex = closestItem();
				
			}
			
		});
		
		return this;
		
	};
	
	$.fn.HSAmetysExpandable = function () {
		
		var _ = this,
			opt = arguments[0],
			args = Array.prototype.slice.call(arguments, 1),
			l = _.length,
			i,
			ret;
		
		for (i = 0; i < l; i++) {
			if (typeof opt == 'object' || typeof opt == 'undefined') {
				
				_[i].AmetysExpandable = new AmetysExpandable(_[i], opt);
				
			} else {
				
				ret = _[i].AmetysExpandable[opt].apply(_[i].AmetysExpandable, args);
				
			}
			
			if (typeof ret != 'undefined') {
				
				return ret;
				
			}
		}
		
		return _;
		
	};
	
})(jQuery);