<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="exslt">
    
    <xsl:import href="plugin:odf-web://pages/services/program-list/program-list_1.3.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:variable name="maxOfPreviewCards">3</xsl:variable>
    
    <xsl:template name="common-service-head-css">
		<link rel="stylesheet" href="{ametys:skinURL('zones/courses/scss/main.css')}"/>
		<link rel="stylesheet" href="{ametys:skinURL('zones/courses/scss/print.css')}"/>
    	<link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/slick-carousel/slick/slick.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
    	<xsl:if test="$secondLevel != ''">
    		<script type="text/javascript" src="{ametys:skinURL('zones/courses/js/ametys-expandable.js')}"></script>
    	</xsl:if>
		<script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/slick-carousel/slick/slick.js')}"/>
		<script type="text/javascript" src="{ametys:skinURL('zones/courses/js/components/hs.carousel.js')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="programs-list-one-level">
    
    	<!-- Program refs node set-->
        <xsl:variable name="program-refs-rtf">
            <xsl:for-each select="/xml/programs/program[metadata[@path = $firstLevel]/value != '']">
                <xsl:variable name="refid" select="generate-id()" />
                
                <xsl:for-each select="metadata[@path = $firstLevel]/value">
                    <xsl:if test=". != ''">
                        <first value="{.}">
                            <program-ref refid="{$refid}" />
                        </first>
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="program-refs" select="exslt:node-set($program-refs-rtf)" />
        
        <xsl:variable name="firstLevelItems" select="/xml/items[@metadataPath = $firstLevel]/item" />
        
        <xsl:if test="$firstLevelItems[1]">
            <xsl:apply-templates select="$firstLevelItems" mode="one-level">
                <xsl:with-param name="program-refs" select="$program-refs"/>
            </xsl:apply-templates>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="programs-list-two-levels">
        <!-- Program refs node set-->
        <xsl:variable name="program-refs-rtf">
            <xsl:for-each select="/xml/programs/program[metadata[@path = $firstLevel]/value != '' and metadata[@path = $secondLevel]/value != '']">
                <xsl:variable name="refid" select="generate-id()" />
                
                <xsl:for-each select="metadata[@path = $firstLevel]/value">
                    <xsl:if test=". != ''">
                        <first value="{.}">
                            <xsl:for-each select="../../metadata[@path = $secondLevel]/value">
                                <second value="{.}">
                                    <program-ref refid="{$refid}" />
                                </second>
                            </xsl:for-each>
                        </first>
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="program-refs" select="exslt:node-set($program-refs-rtf)" />
        
        <xsl:variable name="firstLevelItems" select="/xml/items[@metadataPath = $firstLevel]/item" />
        <xsl:variable name="secondLevelItems" select="/xml/items[@metadataPath = $secondLevel]/item" />
    
        <xsl:if test="$firstLevelItems[1] and $secondLevelItems[1]">
            <xsl:apply-templates select="$firstLevelItems">
                <xsl:with-param name="program-refs" select="$program-refs"/>
                <xsl:with-param name="secondLevelItems" select="$secondLevelItems"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="item" mode="one-level">
    	<xsl:param name="program-refs" select="/.." /> <!-- default value is empty node set -->
        
        <xsl:variable name="first" select="$program-refs/first[@value = current()/@id]"/>
        <xsl:variable name="refs" select="$first/program-ref" />
        
        <xsl:if test="$refs[1]">
        	<div class="ametys-courses-heading">
				<h2 class="ametys-courses-heading__title"><xsl:value-of select="."/></h2>
			</div>
			
			<xsl:call-template name="card-carousel">
				<xsl:with-param name="carouselId" select="concat('category-', generate-id())"/>
				<xsl:with-param name="refs" select="$refs"/>
				<xsl:with-param name="hidden" select="false()"/>
				<xsl:with-param name="carouselCls">ametys-courses-list ametys-courses-carousel mb-5</xsl:with-param>
				<xsl:with-param name="arrowsCls">ametys-courses-carousel-arrow ametys-courses-carousel-arrow--alt</xsl:with-param>
			</xsl:call-template> 
		     
		     <script type="text/javascript">
				$.HSCore.components.HSCarousel.init('#category-<xsl:value-of select="generate-id()"/>');
			</script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="item">
    	<xsl:param name="program-refs" select="/.." /> <!-- default value is empty node set -->
        <xsl:param name="secondLevelItems" select="/.." /> <!-- default value is empty node set -->
        
        <xsl:variable name="first" select="$program-refs/first[@value = current()/@id]"/>
        <xsl:variable name="uniqueId" select="generate-id()"/>
                
    	<xsl:if test="$first/second/@value = $secondLevelItems/@id">
    		<div class="ametys-courses-heading">
				<h2 class="ametys-courses-heading__title"><xsl:value-of select="."/></h2>
			</div>
			
			<ul id="category-{$uniqueId}" class="ametys-courses-list mb-5">
				<xsl:for-each select="$secondLevelItems">
					<xsl:variable name="refs" select="$first/second[@value = current()/@id]/program-ref" />
					<xsl:if test="$refs[1]">

						<li class="ametys-courses-list__item" data-exp-target="#category-{$uniqueId}-{generate-id()}">
						
							<div class="ametys-courses-list__item-inner">
								
                                <!-- Iterate on first cards to show a preview behind the front card-->
								<xsl:apply-templates select="/xml/programs/program[$refs/@refid = generate-id()][position() &lt;= $maxOfPreviewCards]" mode="card"/> 
								
								<xsl:call-template name="front-card">
                                    <xsl:with-param name="refs" select="$refs"/>
                                </xsl:call-template>
							</div>
						</li>
						
					</xsl:if>
				</xsl:for-each>
			</ul>
			
			<xsl:for-each select="$secondLevelItems">
				<xsl:variable name="refs" select="$first/second[@value = current()/@id]/program-ref" />
				<xsl:if test="$refs[1]">
					<xsl:call-template name="card-carousel">
						<xsl:with-param name="carouselId" select="concat('category-', $uniqueId, '-', generate-id())"/>
						<xsl:with-param name="refs" select="$refs"/>
					</xsl:call-template>
		    	</xsl:if>
    		</xsl:for-each>
    		
    		<script>
				$('#category-<xsl:value-of select="$uniqueId"/>').HSAmetysExpandable({
					invokerOpenedText: '<i18n:text i18n:key="SKIN_ODF_PROGRAM_GRID13_HIDE_COURSES" i18n:catalogue="skin.{$skin}"/>',
					invokerClosedText: '<i18n:text i18n:key="SKIN_ODF_PROGRAM_GRID13_SHOW_COURSES" i18n:catalogue="skin.{$skin}"/>'
				});
			</script>
    	</xsl:if>
  	</xsl:template>
    
    <xsl:template name="front-card">
        <xsl:param name="refs"/>
        
        <div class="ametys-courses-front-card">
            <div class="ametys-courses-front-card-body">
                <span class="ametys-courses-front-card__counter"><xsl:value-of select="count(/xml/programs/program[$refs/@refid = generate-id()])"/></span>

                <h4 class="ametys-courses-front-card__title"><xsl:value-of select="."/></h4>
                
                <div class="text-right">
                    <a class="ametys-courses-front-card__btn" href="#" data-exp-text-change="">
                        <i18n:text i18n:key="SKIN_ODF_PROGRAM_GRID13_SHOW_COURSES" i18n:catalogue="skin.{$skin}"/>
                    </a>
                </div>
            </div>
        </div>
    </xsl:template>
  	
  	<xsl:template name="card-carousel">
  		<xsl:param name="refs"/>
  		<xsl:param name="carouselId"/>
  		<xsl:param name="carouselCls">ametys-courses-list ametys-courses-carousel</xsl:param>
  		<xsl:param name="arrowsCls">ametys-courses-carousel-arrow</xsl:param>
  		<xsl:param name="hidden" select="true()"/>
  		
  		<div id="{$carouselId}" class="{$carouselCls}"
						     data-slides-show="1"
						     data-slides-scroll="1"
						     data-rows="2"
						     data-slides-per-row="3"
						     data-adaptive-height="1"
						     data-arrows-classes="{$arrowsCls}"
						     data-arrow-left-classes="ametys-courses-carousel-arrow--left fas fa-angle-left"
						     data-arrow-right-classes="ametys-courses-carousel-arrow--right fas fa-angle-right">
						     <xsl:attribute name="data-responsive">[{
					              "breakpoint": 992,
					              "settings": {
					                "slidesPerRow": 2
					              }
					            }, {
					              "breakpoint": 768,
					              "settings": {
					                "slidesPerRow": 1
					              }
					            }]
					            </xsl:attribute>
				<xsl:if test="$hidden"><xsl:attribute name="style">display:none;</xsl:attribute></xsl:if>
           
           	<xsl:apply-templates select="/xml/programs/program[$refs/@refid = generate-id()]" mode="card-details"/> 
	    </div>
  	</xsl:template>
  	
  	<xsl:template match="program" mode="card">
  		<div class="ametys-courses-card">
        
            <xsl:apply-templates select="." mode="card-header"/>
            
            <xsl:apply-templates select="." mode="card-body"/>
		</div>
  	</xsl:template>
    
  	<xsl:template match="program" mode="card-details">
  		<div class="ametys-courses-list__item">
			<div class="ametys-courses-list__item-inner">
				<a class="ametys-courses-card ametys-courses-card--detail" href="{resolver:resolve('odf', @id)}">
					<xsl:apply-templates select="." mode="card-header"/>
					<xsl:apply-templates select="." mode="card-body"/>
				</a>
			</div>
		</div>
  	</xsl:template>
    
    <xsl:template match="program" mode="card-header">
        <header class="ametys-courses-card-header ametys-courses-card-header--img">
            <xsl:variable name="imgSrc">
                <xsl:call-template name="program-image-url">
                    <xsl:with-param name="contentId" select="@id"/>
                </xsl:call-template>
            </xsl:variable>
            <img class="ametys-courses-card-header__img" src="{$imgSrc}" alt="" />
        </header>
    </xsl:template>
    
    <xsl:template match="program" mode="card-body">
        <div class="ametys-courses-card-body">
			<h4 class="ametys-courses-card__title"><xsl:value-of select="@title"/></h4>
			
			<xsl:variable name="domainId" select="ametys:contentAttribute(@id, 'domain')/@id"/>
			<xsl:if test="$domainId != ''">
				<div class="ametys-courses-card__category">
					<span class="ametys-courses-card__category-icon ametys-icon-graduation-cap-alt"></span>
					<xsl:value-of select="ametys:contentAttribute($domainId, 'title', ametys:lang())"/>
				</div>
			</xsl:if>
		</div>
    </xsl:template>
    
</xsl:stylesheet>
