<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:odf="org.ametys.odf.OdfXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="resolver exslt">
    
    <xsl:import href="service:odf-web://pages/services/schema/schema-with-but.xsl"/>
    <xsl:import href="service:odf-web://pages/services/schema/schema-health_1.3.xsl"/>
    
    <xsl:template name="canvas">
        <div class="d-none d-md-block">
            <svg width="1135px" height="432px" viewBox="0 0 1135 432" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                    <xsl:call-template name="background-with-but"/>
                    <xsl:call-template name="general-studies-with-but"/>
                    <xsl:call-template name="health-studies-with-but"/>
                    <xsl:call-template name="base-with-but"/>
                    <xsl:call-template name="texts-with-but"/>
            </svg>
        </div>
        
       <div class="d-md-none">
			<svg width="379px" height="419px" viewBox="0 0 379 419" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                <xsl:call-template name="background-mobile-with-but"/>
                <xsl:call-template name="general-studies-mobile-with-but"/>
                <xsl:call-template name="texts-mobile-with-but"/>
            </svg>
		</div>
        
        <div class="d-md-none g-mt-50">
            <svg version="1.1" id="Calque_3" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                 viewBox="0 0 480 513" style="enable-background:new 0 0 480 513;" xml:space="preserve">
                <xsl:call-template name="background-mobile"/>
                <xsl:call-template name="health-studies"/>
                <xsl:call-template name="base-mobile"/>
            </svg>
        </div>
        
        <xsl:call-template name="search-forms" />
    </xsl:template>
    
    <xsl:template name="search-forms">
        <xsl:call-template name="general-studies-search-forms"/>
        <xsl:call-template name="health-studies-search-forms"/>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">but</xsl:with-param>
            <xsl:with-param name="domainId" select="$but"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="base-with-but">
        <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_CM" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-cm').submit(); return false;">
            <g id="700px" transform="translate(34.000000, 371.000000)">
                <rect class="st24" id="Rectangle-Copy-6" x="0" y="0" width="1100" height="61"></rect>
            </g>
        </a>
    </xsl:template>
    
    <xsl:template name="general-studies-with-but">
        <g id="normal" transform="translate(474.000000, 41.000000)">
            <!-- Licence -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCE" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licence').submit(); return false;">
                <path d="M0,206 L338,206 C346.284271,206 353,212.715729 353,221 L353,329 L353,329 L0,329 L0,206 Z" id="260px" class="st6"></path>
            </a>
            <!-- BUT -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_BUT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-but').submit(); return false;">
                <g id="80px" transform="translate(508.000000, 206.000000)">
                    <rect id="Rectangle-Copy-5" class="st5"  x="0.968152866" y="0" width="151.031847" height="123"></rect>
                    <path d="M0,2.84217094e-14 L136.031847,2.84217094e-14 C144.316118,2.68999135e-14 151.031847,6.71572875 151.031847,15 L151.031847,123 L151.031847,123 L0,123 L0,2.84217094e-14 Z" id="Rectangle-Copy-6" class="st9"></path>
                </g>
            </a>
            <!-- DEUST -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_NA" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-na').submit(); return false;">
                <g id="80px" transform="translate(353.000000, 247.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="0" y="0" width="156" height="82"></rect>
                    <rect id="Rectangle-Copy-6" class="st13" x="0" y="0" width="156" height="82"></rect>
                </g>
            </a>
            <!-- Master -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_MASTER" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-master').submit(); return false;">
                <g id="110px" transform="translate(150.000000, 122.000000)">
                    <rect id="Rectangle-Copy" class="st5" x="0" y="0" width="152" height="84"></rect>
                    <rect id="Rectangle-Copy-3" class="st15" x="0" y="0" width="152" height="84"></rect>
                </g>
            </a>
            <!-- Ecole d'ingenieur -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DI" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-di').submit(); return false;">
                <g id="110px" transform="translate(0.000000, 122.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="0" y="0" width="151" height="126"></rect>
                    <path d="M0,0 L136,0 C144.284271,-1.52179594e-15 151,6.71572875 151,15 L151,126 L151,126 L0,126 L0,0 Z" id="Rectangle-Copy-6" class="st16"></path>
                </g>
            </a>
            <!-- Doctorat -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DOCTORAT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-doctorat').submit(); return false;">
                <g id="110px" transform="translate(151.000000, 0.000000)">
                    <rect id="Rectangle-Copy-2" class="st5" x="0" y="0" width="151" height="122"></rect>
                    <path d="M0,0 L136,0 C144.284271,-1.52179594e-15 151,6.71572875 151,15 L151,122 L151,122 L0,122 L0,0 Z" id="Rectangle-Copy-4" class="st17"></path>
                </g>
            </a>
            <!-- Licence pro -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCEP" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licencepro').submit(); return false;">
                <g id="200px" transform="translate(302.000000, 206.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="0" y="0" width="207" height="41"></rect>
                    <rect id="Rectangle-Copy-6" class="st18" x="0" y="0" width="207" height="41"></rect>
                </g>
            </a>
        </g>
    </xsl:template>
    
    <xsl:template name="health-studies-with-but">
        <g id="sante" transform="translate(34.000000, 0.000000)">
            <!-- PACES -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_PACES" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-CY').submit(); return false;">
                <g id="320px" transform="translate(0.000000, 329.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="0" y="9" width="440" height="32"></rect>
                    <rect id="Rectangle-Copy-6" class="st19" x="0" y="0" width="440" height="41"></rect>
                </g>
            </a>
            <!-- Medecine -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DISM" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-YJ').submit(); return false;">
                <g id="80px" transform="translate(330.000000, 0.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="0" y="55" width="110" height="275"></rect>
                    <path d="M0,0 L95,0 C103.284271,-1.52179594e-15 110,6.71572875 110,15 L110,330 L110,330 L0,330 L0,0 Z" id="Rectangle-Copy-6" class="st20"></path>
                </g>
            </a>
            <!-- Pharmacie -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DISP" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-YL').submit(); return false;">
                <g id="80px" transform="translate(220.000000, 124.000000)">
                    <rect id="Rectangle-Copy-5" class="st5"  x="0" y="34" width="110" height="172"></rect>
                    <path d="M0,0 L95,0 C103.284271,-5.07450962e-15 110,6.71572875 110,15 L110,206 L110,206 L0,206 L0,0 Z" id="Rectangle-Copy-6" class="st21"></path>
                </g>
            </a>
            <!-- Odontologie -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DERSO" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-JF').submit(); return false;">
                <g id="80px" transform="translate(110.000000, 124.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="-9.09494702e-13" y="34" width="110" height="172"></rect>
                    <path d="M-9.09494702e-13,0 L95,0 C103.284271,-5.07450962e-15 110,6.71572875 110,15 L110,206 L110,206 L-9.09494702e-13,206 L-9.09494702e-13,0 Z" id="Rectangle-Copy-6" class="st22"></path>
                </g>
            </a>
            <!-- Sage-femme -->
            <a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DESF" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-PE').submit(); return false;">
                <g id="80px" transform="translate(0.000000, 165.000000)">
                    <rect id="Rectangle-Copy-5" class="st5" x="0" y="28" width="110" height="137"></rect>
                    <path d="M0,0 L95,0 C103.284271,-1.52179594e-15 110,6.71572875 110,15 L110,165 L110,165 L0,165 L0,0 Z" id="Rectangle-Copy-6" class="st23"></path>
                </g>
            </a>
        </g>
    </xsl:template>
    
    <xsl:template name="texts-with-but">
        <g id="textes" transform="translate(0.000000, 45.000000)">
            <text id="Licence">
                <tspan x="623.285156" y="289" class="st7 st1 st8">Licence</tspan>
            </text>
            <text id="DEUST-Diplôme-d’étud">
                <tspan x="874.640625" y="265.03125" class="st7 st1 st8">DEUST</tspan>
                <tspan x="932.273438" y="268" class="st7 st1 st2"></tspan>
                <tspan x="860.478516" y="285" class="st7 st1 st12" line-spacing="15">Diplôme d’études </tspan>
                <tspan x="834.691406" y="300" class="st7 st1 st12" line-spacing="15">universitaires scientifiques </tspan>
                <tspan x="871.078125" y="315" class="st7 st1 st12" line-spacing="15">et techniques </tspan>
                <tspan x="946.910156" y="315" class="st7 st1 st12" line-spacing="15"> </tspan>
            </text>
            <text id="BUT-Bachelor-univers" line-spacing="17">
                <tspan x="1040.23047" y="250.03125" class="st7 st1 st8">BUT</tspan>
                <tspan x="1078.68359" y="253" font-size="14" class="st7 st1 st2"></tspan>
                <tspan x="1002.689453" y="271" font-size="12" class="st7 st1 st12">Bachelor universitaire </tspan>
                <tspan x="1023.88477" y="288" font-size="12" class="st7 st1 st12">de technologie</tspan>
            </text>
            <text id="Master">
                <tspan x="674.832031" y="165" class="st7 st1 st8">Master</tspan>
            </text>
            <text id="Ecole-d’ingénieur" line-spacing="19" >
                <tspan x="530.589844" y="177" class="st7 st1 st8">Ecole </tspan>
                <tspan x="509.789062" y="196" class="st7 st1 st8">d’ingénieur</tspan>
            </text>
            <text id="Doctorat">
                <tspan x="668.867188" y="62" class="st7 st1 st8">Doctorat</tspan>
            </text>
            <text id="Licence-professionne">
                <tspan x="794.398438" y="227" class="st7 st1 st8">Licence professionnelle</tspan>
            </text>
            <text id="PACES">
                <tspan x="229.328125" y="309" class="st7 st1 st8">PACES</tspan>
            </text>
            <text id="Médecine">
                <tspan x="384.195312" y="136" class="st7 st1 st8">Médecine</tspan>
            </text>
            <text id="Pharmacie">
                <tspan x="271.109375" y="157" class="st7 st1 st8">Pharmacie</tspan>
            </text>
            <text id="Odontologie">
                <tspan x="155.160156" y="183" class="st7 st1 st8">Odontologie</tspan>
            </text>
            <text id="Sage-femme" line-spacing="19">
                <tspan x="71.0585938" y="203"  class="st7 st1 st8">Sage</tspan>
                <tspan x="64" y="223"  class="st7 st1 st8">femme</tspan>
            </text>
            <text id="Baccalauréat---Capac">
                <tspan x="260.082031" y="356" class="st7 st1 st8">Baccalauréat  -  Capacité en médecine   -  Capacité en droit  -  DAEU  -  Diplôme équivalent</tspan>
            </text>
            <text id="Bac">
                <tspan x="0" y="355" class="st0 st1 st2">Bac</tspan>
            </text>
            <text id="+2">
                <tspan x="0" y="258" class="st0 st1 st2">+2</tspan>
            </text>
            <text id="+4">
                <tspan x="0" y="175" class="st0 st1 st2">+4</tspan>
            </text>
            <text id="+6">
                <tspan x="0" y="94" class="st0 st1 st2">+6</tspan>
            </text>
            <text id="+8">
                <tspan x="0" y="13" class="st0 st1 st2">+8</tspan>
            </text>
        </g>
    </xsl:template>
    
</xsl:stylesheet>