<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:odf="org.ametys.odf.OdfXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="resolver exslt">
    
    <xsl:import href="plugin:odf-web://pages/services/schema/schema_1.3.xsl"/>
    
    <xsl:variable name="searchPageId" select="ametys:serviceParameter('search-page')"/>
    <xsl:variable name="searchPagePath" select="resolver:resolve('page', $searchPageId)"/>
    <xsl:variable name="searchInputName">user.input.facet.ContentReturnable$ProgramSearchable$indexingField$org.ametys.plugins.odf.Content.program$degree</xsl:variable>
    <xsl:variable name="formSuffixeUniqueId" select="concat('search-form-', $suffixeUniqueId)"/>
    
    <xsl:variable name="na" select="odf:getEntryId('odf-enumeration.Degree', 'NA')"/><!-- DAEU -->
    
    <!-- Note : 3 general studies formats : general-studies, general-studies-mobile and general-studies displayed with health studies -->
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/odf-schema/scss/main.css')}"/>
    </xsl:template>
    
    <xsl:template name="odf-schema">
    	<div class="ametys-certificates">
            <div class="container">
                <div class="ametys-certificates-inner" style="display: block;">
				    <xsl:call-template name="canvas"/> 						
                </div>
            </div>
    	</div>
    </xsl:template>
    
    <xsl:template name="canvas">
		<div class="d-none d-md-block">
			<svg version="1.1" id="Calque_3" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
				 viewBox="0 0 1134 513" style="enable-background:new 0 0 1134 513;" xml:space="preserve">
				<xsl:call-template name="background"/>
				<xsl:call-template name="general-studies"/>
				<xsl:call-template name="base"/>
			</svg>
		</div>
		<div class="d-md-none">
			<svg version="1.1" id="Calque_3" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
				 viewBox="0 0 480 513" style="enable-background:new 0 0 480 513;" xml:space="preserve">
				<xsl:call-template name="background-mobile"/>
				<xsl:call-template name="general-studies-mobile"/>
				<xsl:call-template name="base-mobile"/>
			</svg>
		</div>
        
        <xsl:call-template name="search-forms" />
    </xsl:template>
    
    <xsl:template name="background">
    	<g id="background">
			<text transform="matrix(1 0 0 1 0 401)" class="st0 st1 st2">Bac</text>
			<path id="Line-7-Copy" class="st3" d="M37,329.5h1096"/>
			<path id="Line-7-Copy-2" class="st3" d="M37,288.5h1096"/>
			<path id="Line-7-Copy-3" class="st3" d="M37,247.5h1096"/>
			<path id="Line-7-Copy-4" class="st3" d="M37,206.5h1096"/>
			<path id="Line-7-Copy-5" class="st3" d="M37,165.5h1096"/>
			<path id="Line-7-Copy-6" class="st3" d="M37,124.5h1096"/>
			<path id="Line-7-Copy-7" class="st3" d="M37,83.5h1096"/>
			<path id="Line-7-Copy-8" class="st3" d="M37,42.5h1096"/>
			<path id="Line-7-Copy-9" class="st3" d="M37,1.5h1096"/>
			<g>
				<text transform="matrix(1 0 0 1 0 304)" class="st0 st1 st2">+2</text>
				<path id="Line-7-Copy-22" class="st4" d="M0,285.5h22"/>
			</g>
			<g>
				<text transform="matrix(1 0 0 1 0 221)" class="st0 st1 st2">+4</text>
				<path id="Line-7-Copy-20" class="st4" d="M0,206.5h22"/>
			</g>
			<g>
				<text transform="matrix(1 0 0 1 0 140)" class="st0 st1 st2">+6</text>
				<path id="Line-7-Copy-18" class="st4" d="M0,125.5h22"/>
			</g>
			<g>
				<text transform="matrix(1 0 0 1 0 59)" class="st0 st1 st2">+8</text>
				<path id="Line-7-Copy-16" class="st4" d="M0,44.5h22"/>
			</g>
		</g>
	</xsl:template>
	<xsl:template name="background-mobile">
		<g id="background2">
			<text transform="matrix(1 0 0 1 0.5 427.0499)" class="st0 st1 st2">Bac</text>
			<path id="Line-7-Copy" class="st3" d="M37.5,329.5h457.1"/>
			<path id="Line-7-Copy-2" class="st3" d="M37.5,288.5h457.1"/>
			<path id="Line-7-Copy-3" class="st3" d="M37.5,247.5h457.1"/>
			<path id="Line-7-Copy-4" class="st3" d="M37.5,206.5h457.1"/>
			<path id="Line-7-Copy-5" class="st3" d="M37.5,165.5h457.1"/>
			<path id="Line-7-Copy-6" class="st3" d="M37.5,124.5h457.1"/>
			<path id="Line-7-Copy-7" class="st3" d="M37.5,83.5h457.1"/>
			<path id="Line-7-Copy-8" class="st3" d="M37.5,42.5h457.1"/>
			<path id="Line-7-Copy-9" class="st3" d="M37.5,1.5h457.1"/>
			<g>
				<text transform="matrix(1 0 0 1 0.5 304.0499)" class="st0 st1 st2">+2</text>
				<path id="Line-7-Copy-22" class="st4" d="M0.5,285.5h22"/>
			</g>
			<g>
				<text transform="matrix(1 0 0 1 0.5 221.0499)" class="st0 st1 st2">+4</text>
				<path id="Line-7-Copy-20" class="st4" d="M0.5,206.5h22"/>
			</g>
			<g>
				<text transform="matrix(1 0 0 1 0.5 140.0499)" class="st0 st1 st2">+6</text>
				<path id="Line-7-Copy-18" class="st4" d="M0.5,125.5h22"/>
			</g>
			<g>
				<text transform="matrix(1 0 0 1 0.5 59.0499)" class="st0 st1 st2">+8</text>
				<path id="Line-7-Copy-16" class="st4" d="M0.5,44.5h22"/>
			</g>
		</g>
	</xsl:template>
    
    <xsl:template name="general-studies-mobile">
    	<g>
    		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCE" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licence').submit(); return false;">
	    		<g>
					<path id="Licence_1_" class="st5" d="M34.2,247h220.2c5.4,0,9.8,6.7,9.8,15v108h-230V247z"/>
					<path id="Licence_2_" class="st6" d="M34.2,247h220.2c5.4,0,9.8,6.7,9.8,15v108h-230V247z"/>
					<text transform="matrix(1 0 0 1 127.3203 333.5655)" class="st7 st1 st8">Licence</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_NA" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-na').submit(); return false;">
				<g>
					<rect id="Rectangle-Copy-5" x="362.6" y="288" class="st5" width="101.6" height="82"/>
					<rect id="Rectangle-Copy-6" x="362.8" y="288" class="st9" width="101.6" height="82"/>
					<text transform="matrix(1 0 0 1 389.9193 333.5655)" class="st7 st1 st8">DEUST</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DUT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-dut').submit(); return false;">
				<g>
					<rect id="Rectangle-Copy-5_1_" x="264.2" y="288" class="st5" width="99" height="82"/>
					<rect id="Rectangle-Copy-6_1_" x="264.3" y="288" class="st13" width="99" height="82"/>
					<text transform="matrix(1 0 0 1 297.3841 333.5655)" class="st7 st1 st8">DUT</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_MASTER" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-master').submit(); return false;">
				<g>
					<rect id="Rectangle-Copy" x="132" y="163" class="st5" width="99" height="84"/>
					<rect id="Rectangle-Copy-3" x="132.7" y="163" class="st15" width="98.2" height="84"/>
					<text transform="matrix(1 0 0 1 157.3203 210.0499)" class="st7 st1 st8">Master</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DI" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-di').submit(); return false;">
				<g>
					<path id="Rectangle-Copy-6_2_" class="st5" d="M34.2,163h88.6c5.4,0,9.8,6.7,9.8,15v111H34.2V163z"/>
					<path id="Rectangle-Copy-6_14_" class="st16" d="M34.2,163h88.6c5.4,0,9.8,6.7,9.8,15v111H34.2V163z"/>
					<text transform="matrix(1 0 0 1 62.7266 222.0499)" class="st7 st1 st8">Ecole </text>
					<text transform="matrix(1 0 0 1 42.9336 241.0499)" class="st7 st1 st8">d’ingénieur</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DOCTORAT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-doctorat').submit(); return false;">
				<g>
					<rect id="Rectangle-Copy-2" x="132.6" y="41" class="st5" width="98.4" height="122"/>
					<path id="Rectangle-Copy-4" class="st17" d="M132.6,41h88.6c5.4,0,9.8,6.7,9.8,15v107h-98.4V41z"/>
					<text transform="matrix(1 0 0 1 150.7383 107.0499)" class="st7 st1 st8">Doctorat</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCEP" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licencepro').submit(); return false;">
				<g>
					<path id="Rectangle-Copy-6_3_" class="st5" d="M231,247h223.4c5.4,0,9.8,6.7,9.8,15v26H231V247z"/>
					<path id="Rectangle-Copy-6_16_" class="st18" d="M231,247h223.4c5.4,0,9.8,6.7,9.8,15v26H231V247z"/>
					<text transform="matrix(1 0 0 1 260.3711 272.0499)" class="st7 st1 st8">Licence professionnelle</text>
				</g>
			</a>
    	</g>
    </xsl:template>
    
    <xsl:template name="general-studies">
    	<g>
    		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCE" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licence').submit(); return false;">
		    	<g>
					<path id="Licence_1_" class="st5" d="M33.7,247h563.3c13.8,0,25,6.7,25,15v108H33.7V247z"/>
					<path id="Licence_2_" class="st6" d="M33.7,247h563.3c13.8,0,25,6.7,25,15v108H33.7V247z"/>
					<text transform="matrix(1 0 0 1 332.8203 334)" class="st7 st1 st8">Licence</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_NA" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-na').submit(); return false;">
				<g>
					<rect id="Rectangle-Copy-5" x="873.7" y="288" class="st5" width="260" height="82"/>
					<rect id="Rectangle-Copy-6" x="874.4" y="288" class="st9" width="260" height="82"/>
					<g>
						<rect x="942.9" y="319.9" class="st10" width="147" height="47"/>
						<text transform="matrix(1 0 0 1 970.1459 328.8898)"><tspan x="0" y="0" class="st7 st11 st12">Diplôme d’études </tspan><tspan x="-25.1" y="16" class="st7 st11 st12">universitaires scientifiques </tspan><tspan x="10.3" y="32" class="st7 st11 st12">et techniques</tspan></text>
					</g>
					<text transform="matrix(1 0 0 1 989.4193 310.7734)" class="st7 st1 st8">DEUST</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DUT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-dut').submit(); return false;">
				<g>
					<rect id="Rectangle-Copy-5_1_" x="622.1" y="288" class="st5" width="253.3" height="82"/>
					<rect id="Rectangle-Copy-6_1_" x="622.4" y="288" class="st13" width="253.3" height="82"/>
					<rect x="690.2" y="326.9" class="st14" width="126" height="43"/>
					<text transform="matrix(1 0 0 1 696.9954 335.8898)"><tspan x="0" y="0" class="st7 st11 st12">Diplôme universitaire </tspan><tspan x="16.9" y="16" class="st7 st11 st12">de technologie</tspan></text>
					<text transform="matrix(1 0 0 1 736.8841 315.7734)" class="st7 st1 st8">DUT</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_MASTER" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-master').submit(); return false;">
				<g>
					<rect id="Rectangle-Copy" x="283.7" y="163" class="st5" width="253.3" height="84"/>
					<rect id="Rectangle-Copy-3" x="285.7" y="163" class="st15" width="251.3" height="84"/>
					<text transform="matrix(1 0 0 1 384.8203 210)" class="st7 st1 st8">Master</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DI" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-di').submit(); return false;">
				<g>
					<path id="Rectangle-Copy-6_2_" class="st5" d="M33.7,163h226.7c13.8,0,25,6.7,25,15v111H33.7V163z"/>
					<path id="Rectangle-Copy-6_14_" class="st16" d="M33.7,163h226.7c13.8,0,25,6.7,25,15v111H33.7V163z"/>
					<text transform="matrix(1 0 0 1 140.2266 222)" class="st7 st1 st8">Ecole </text>
					<text transform="matrix(1 0 0 1 119.4336 241)" class="st7 st1 st8">d’ingénieur</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DOCTORAT" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-doctorat').submit(); return false;">
				<g>
					<rect id="Rectangle-Copy-2" x="285.4" y="41" class="st5" width="251.7" height="122"/>
					<path id="Rectangle-Copy-4" class="st17" d="M285.4,41h226.7c13.8,0,25,6.7,25,15v107H285.4V41z"/>
					<text transform="matrix(1 0 0 1 378.2383 107)" class="st7 st1 st8">Doctorat</text>
				</g>
			</a>
			<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCEP" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-licencepro').submit(); return false;">
				<g>
					<path id="Rectangle-Copy-6_3_" class="st5" d="M537.1,247h571.7c13.8,0,25,6.7,25,15v26H537.1V247z"/>
					<path id="Rectangle-Copy-6_16_" class="st18" d="M537.1,247h571.7c13.8,0,25,6.7,25,15v26H537.1V247z"/>
					<text transform="matrix(1 0 0 1 739.8711 272)" class="st7 st1 st8">Licence professionnelle</text>
				</g>
			</a>
		</g>
    </xsl:template>
    
    <xsl:template name="health-studies"/>
    
    <xsl:template name="base">
    	<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_CM" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-cm').submit(); return false;">
	    	<g>
				<rect id="Rectangle-Copy-6_9_" x="33.7" y="371" class="st24" width="1100" height="61"/>
				<text id="Baccalauréat_-_Capacité_en_médecine_-_Capacité_en_droit_-_DAEU_-_Diplôme_équivalent" transform="matrix(1 0 0 1 276.0391 401)" class="st7 st1 st8">Baccalauréat - Capacité en médecine - Capacité en droit - DAEU - Diplôme équivalent </text>
			</g>
		</a>
	</xsl:template>
	<xsl:template name="base-mobile">
		<a title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_CM" i18n:attr="title" href="#" onclick="$j('#{$formSuffixeUniqueId}-cm').submit(); return false;">
			<g>
				<rect xmlns="http://www.w3.org/2000/svg" id="Rectangle-Copy-6_9_" x="34.2" y="371" class="st24" width="430" height="102.1"/>
				<text transform="matrix(1 0 0 1 114.5203 412.6404)"><tspan x="0" y="0" class="st7 st1 st8">Baccalauréat - Capacité en médecine - </tspan><tspan x="12" y="24" class="st7 st1 st8">Capacité en droit - DAEU - Diplôme </tspan><tspan x="101.8" y="48" class="st7 st1 st8">équivalent </tspan></text>
			</g>
		</a>
    </xsl:template>
    
    <xsl:template name="search-forms">
        <xsl:call-template name="general-studies-search-forms"/>
    </xsl:template>
    
    <xsl:template name="general-studies-search-forms">
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">licence</xsl:with-param>
            <xsl:with-param name="domainId" select="$licence"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">master</xsl:with-param>
            <xsl:with-param name="domainId" select="$master"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">doctorat</xsl:with-param>
            <xsl:with-param name="domainId" select="$doctorat"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">licencepro</xsl:with-param>
            <xsl:with-param name="domainId" select="$licencepro"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">deust</xsl:with-param>
            <xsl:with-param name="domainId" select="$deust"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">dut</xsl:with-param>
            <xsl:with-param name="domainId" select="$dut"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">di</xsl:with-param>
            <xsl:with-param name="domainId" select="$di"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">cm</xsl:with-param>
            <xsl:with-param name="domainId" select="$cm"/>
        </xsl:call-template>
        
        <xsl:call-template name="search-form">
            <xsl:with-param name="domainName">na</xsl:with-param>
            <xsl:with-param name="domainId" select="$na"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="search-form">
        <xsl:param name="domainName"/>
        <xsl:param name="domainId"/>
        
        <form id="{$formSuffixeUniqueId}-{$domainName}" action="{$searchPagePath}" method="POST">
            <input type="hidden" name="{$searchInputName}" value="{$domainId}"/>
            <input type="hidden" name="submit-form" value="{$submitFormId}"/>
        </form>
    </xsl:template>
    
</xsl:stylesheet>