<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="resolver"
                exclude-result-prefixes="ametys">

    <xsl:import href="plugin:web://pages/frontoffice-login/login.xsl"/>
    
    <xsl:variable name="skin" select="ametys:skin()"/>
    
    <xsl:template name="body">
	    <div class="ametys-authorization-checkout">
		    <xsl:call-template name="body-title"/>
		
			<div class="connect-account">
				<xsl:call-template name="body-existingaccount-title"/>
				
				<xsl:call-template name="show-hint"/>
				<xsl:call-template name="show-errors"/>
				<xsl:call-template name="login"/>
	        </div>
	        
            <xsl:if test="$public-signup = 'true' and $signup-page != ''">
		        <p class="ametys-authorization__bottom-text">
                    <xsl:call-template name="body-createaccount-title"/>
		        	<br />
		        	<a href="{resolver:resolve('page', $signup-page)}"><i18n:text i18n:key="SKIN_FO_LOGIN_PUBLIC_SIGNUP_LINK" i18n:catalogue="skin.{$skin}"/></a>
		        </p>
		    </xsl:if>
        </div>
	</xsl:template>
	<xsl:template name="body-existingaccount-title"/>
	<xsl:template name="show-hint"/>
	
	<xsl:template name="body-title">
        <h1 class="ametys-authorization__title"><i18n:text i18n:key="SKIN_FO_LOGIN_TITLE" i18n:catalogue="skin.{$skin}"/></h1>
    </xsl:template>
    
    <xsl:template name="login-user-populations-standalone">
        <xsl:if test="not(/LoginScreen/CredentialProviders/CredentialProvider) or (count(LoginScreen/CredentialProviders/CredentialProvider) = 1 and /LoginScreen/CredentialProviders/CredentialProvider[not(@isForm = 'true')])">
            <form method="post">
                <input type="hidden" name="CredentialProviderIndex" value="-1"/>
            
                <xsl:call-template name="login-user-populations"/>

                <xsl:call-template name="login-user-populations-submit"/>
            </form>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="login-user-populations-select-wrapper">
        <xsl:param name="placeholder"/>
        <xsl:param name="hint"/>
        
        <div class="form-group">
		    <xsl:call-template name="login-user-populations-select-label-internal"/>
	        <xsl:if test="$placeholder != ''">
	            <xsl:attribute name="placeholder"><xsl:value-of select="$placeholder"/></xsl:attribute>
	            <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
	        </xsl:if>
            <xsl:call-template name="login-user-populations-select-internal"/>
        </div>
	</xsl:template>
	<xsl:template name="login-user-populations-select-label-internal"/>
    
    <xsl:template name="login-user-populations-select-internal">
	        <select id="population-{$uniqueId}" name="UserPopulation" autofocus="true" required="" class="ametys-form-control-with-icon"
			        data-placeholder="Population"
			        data-field-icon="fas fa-folder-open"
			        data-open-icon="fa fa-angle-down"
			        data-close-icon="fa fa-angle-up">
	            <xsl:for-each select="/LoginScreen/UserPopulations/UserPopulation">
	                <xsl:sort select="label"/>
	               
	                <option value='{@id}'>
	                    <xsl:if test="../@currentValue = @id"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>    
	                    <xsl:copy-of select="label" />
	                </option>
	            </xsl:for-each>
	        </select>
	        <xsl:if test="not(/LoginScreen/UserPopulations/@currentValue)">
		        <script type="text/javascript">
		            var cls = ' login-input-wrapper-userpopulation-select-empty';
		            var select = document.getElementById('Population');
		            select.selectedIndex = -1;
                    select.parentNode.parentNode.className += cls;
		            window.addEventListener('load', function() {
  	                    if (select.selectedIndex != -1)
  	                    {
  	                        // BACK was done
			                select.onchange();
			            }
			        });
		            select.onchange = function() {
		               this.parentNode.parentNode.className = this.parentNode.parentNode.className.replace(cls, '')
		            }
		        </script>
		    </xsl:if>
		    <script>
				$.HSCore.components.HSSelect.init('select.ametys-form-control-with-icon');
			</script>
    </xsl:template>
    
    <xsl:template name="login-form-inputs-username-wrapper">
        <xsl:param name="placeholder"/>
        <xsl:param name="hint"/>

        <xsl:variable name="autocomplete">
            <xsl:choose>
                <xsl:when test="/LoginScreen/LoginForm/autocomplete = 'true'">on</xsl:when>
                <xsl:otherwise>off</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <div class="form-group">
        	<xsl:call-template name="login-form-inputs-username-label-internal" />
        	<div class="ametys-form-control-with-icon-wrap">
				<span class="field-icon fas fa-envelope"></span>
	            <input class="ametys-form-control-with-icon" type="text" name="Username" id="Username" autocomplete="{$autocomplete}" autofocus="true" value="{$login}" onFocus="this.select();">
	                <xsl:if test="$placeholder != ''">
	                    <xsl:attribute name="placeholder"><xsl:value-of select="$placeholder"/></xsl:attribute>
	                    <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
	                </xsl:if>
	            </input>
	        </div>
        </div>
    </xsl:template>
    <xsl:template name="login-form-inputs-username-label-internal" />
    
    <xsl:template name="login-form-inputs-password-wrapper">
        <xsl:param name="placeholder"/>
        <xsl:param name="hint"/>

        <xsl:variable name="autocomplete">
            <xsl:choose>
                <xsl:when test="/LoginScreen/LoginForm/autocomplete = 'true'">on</xsl:when>
                <xsl:otherwise>off</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        
        <div class="form-group">
        	<xsl:call-template name="login-form-inputs-password-label-internal" />
        	<div class="ametys-form-control-with-icon-wrap">
				<span class="field-icon fas fa-lock"></span>
		        <input class="ametys-form-control-with-icon" type="password" name="Password" id="Password" autocomplete="{$autocomplete}">
		            <xsl:if test="$placeholder != ''">
		                <xsl:attribute name="placeholder"><xsl:value-of select="$placeholder"/></xsl:attribute>
		                <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
		            </xsl:if>
		        </input>
		    </div>
	    </div>
    </xsl:template>  
    <xsl:template name="login-form-inputs-password-label-internal" />
    
    <xsl:template name="login-form-inputs">
    	<xsl:if test="/LoginScreen/LoginForm">
		    <div class="login-form-inputs">
		        <xsl:call-template name="login-form-inputs-errors"/>
		         
		        <xsl:call-template name="login-form-inputs-username"/>
		        
                <xsl:call-template name="login-form-inputs-password"/>

                <xsl:if test="/LoginScreen/LoginForm/useCaptcha = 'true'">
                    <xsl:call-template name="login-form-inputs-captcha"/>
                </xsl:if>
                
                <div class="form-group d-md-flex align-items-md-center mb-5">
	            	<xsl:if test="/LoginScreen/LoginForm/rememberMe = 'true'">
	                    <xsl:call-template name="login-form-inputs-rememberme"/>
	            	</xsl:if>
                    <xsl:if test="/LoginScreen/LoginForm/displayForgottenLink = 'true'">
                        <xsl:call-template name="login-form-inputs-forgotten"/>
                    </xsl:if>
	            </div>
			</div>
		</xsl:if>
    </xsl:template>
    
     <xsl:template name="login-form-inputs-rememberme-internal">
        <xsl:param name="label"/>
        
       	<div class="ametys-checkbox ametys-checkbox--light ametys-checkbox--lg mb-md-0">
           <input class="ametys-checkbox__control" type="checkbox" name="rememberMe" id="rememberMe" value="true"/>
           <xsl:if test="$label != ''">
              <label class="ametys-checkbox__label" for="rememberMe"><i18n:text i18n:key="{substring-after($label, ':')}" i18n:catalogue="{substring-before($label, ':')}"/></label>
           </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="login-form-inputs-forgotten-internal">
        <xsl:param name="label"/>
        <xsl:param name="url"/>
    
        <a href="{$url}" class="ametys-authorization__link ml-auto"><xsl:copy-of select="$label"/></a>
    </xsl:template>
    
    <xsl:template name="login-user-populations-submit">
        <button type="submit" class="btn btn-primary btn-lg btn-block btn-shadow rounded-0"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_CONTINUE' i18n:catalogue='plugin.core-ui'/></button>
    </xsl:template>
    
    <xsl:template name="login-form-submit">
        <button type="submit" class="btn btn-primary btn-lg btn-block btn-shadow rounded-0">
            <i18n:translate>
                <i18n:text i18n:key="PLUGINS_CORE_AUTHENTICATION_BLOCKING_CONNECTION_LABEL" i18n:catalogue="plugin.core-impl"/>
                <i18n:param>
                    <xsl:choose>
                        <xsl:when test="/LoginScreen/LoginForm/additionalLabel"><xsl:value-of select="/LoginScreen/LoginForm/additionalLabel"/></xsl:when>
                        <xsl:otherwise><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_SUBMIT' i18n:catalogue='plugin.core-ui'/></xsl:otherwise>
                    </xsl:choose>
                </i18n:param>
            </i18n:translate>
        </button>
    </xsl:template>
    
    <xsl:template name="body-createaccount-title">
        <i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_NO_ACCOUNT" i18n:catalogue="plugin.web"/>
    </xsl:template>
    
    <xsl:template name="login-back">
        <xsl:if test="not(/LoginScreen/UserPopulations)">
            <form method="post">
               <input type="hidden" name="UserPopulation" value=""/>
               <button type="submit" class="my-3 g-brd-0 g-bg-transparent g-color-primary"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_BACK' i18n:catalogue='plugin.core-ui'/></button>
            </form>
        </xsl:if>
    </xsl:template>
	
</xsl:stylesheet>
