<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:exslt="http://exslt.org/common"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        exclude-result-prefixes="ametys resolver escaper"> 
        
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:variable name="mapUniqueId" select="concat('search-map-', substring-after(ametys:zoneItemId(), '://'))"/>
    
    <xsl:template name="search-map">
        <div class="ametys-map-invoker mb-5">
            <span class="ametys-map-invoker__img">
                <img src="{ametys:skinURL('zones/search/img/map.png')}" alt=""/>
            </span>
            <a id="{$mapUniqueId}-invoker" class="ametys-map-invoker__btn" href="javascript:;">
                <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_SEE_ON_MAP" i18n:catalogue="skin.{$skin}"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="search-top-mobile-map">
        <button id="{$mapUniqueId}-mobile-invoker" class="ametys-map-mobile-invoker" type="button">
            <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_SEE_ON_MAP" i18n:catalogue="skin.{$skin}"/>
        </button>
    </xsl:template>
    
    <xsl:template name="search-map-js">
        <script type="text/javascript">
            var results = [];
            
            <xsl:for-each select="/search/hits/hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']">
            
                <xsl:variable name="imgSrc">
                    <xsl:call-template name="program-image-url">
                        <xsl:with-param name="contentId" select="id"/>
                        <xsl:with-param name="maxWidth" select="'130'"/>
                        <xsl:with-param name="maxHeight" select="'90'"/>
                    </xsl:call-template>
                </xsl:variable>
            
                results.push({
                    id: '<xsl:value-of select="id"/>',
                    title: "<xsl:value-of select="ametys:escapeJS(title)"/>",
                    excerpt: "<xsl:value-of select="ametys:escapeJS(excerpt[1])"/>",
                    imgSrc: "<xsl:value-of select="$imgSrc"/>",
                    uri: "<xsl:value-of select="concat($site-uri-prefix, '/', uri, '.html')"/>",
                    markers: <xsl:call-template name="get-js-markers"/>
                });
            </xsl:for-each>     
            
            var hasMarkers = false;
            for (let i = 0; i &lt; results.length; i++) {
                if(results[i].markers.length &gt; 0)
                {
                    hasMarkers = true;
                    break;
                }
            }
            
            if (hasMarkers)
            {
	            $j('#<xsl:value-of select="$mapUniqueId"/>-invoker').HSAmetysResultMap({
	                results: results,
	                searchMapDialogId: '<xsl:value-of select="$mapUniqueId"/>-dialog'
	            });
	            
	            $j('#<xsl:value-of select="$mapUniqueId"/>-mobile-invoker').HSAmetysResultMap({
	                results: results,
	                searchMapDialogId: '<xsl:value-of select="$mapUniqueId"/>-dialog'
	            });
            }
            else
            {
                $j('#<xsl:value-of select="$mapUniqueId"/>-invoker').parents('.ametys-map-invoker').hide();
                $j('#<xsl:value-of select="$mapUniqueId"/>-mobile-invoker').parents('.ametys-map-invoker').hide();
            }
        </script>
    </xsl:template>
    
    <xsl:template name="search-map-dialog">
        <div id="{$mapUniqueId}-dialog">
             <div data-search-map="" style="height:100%"></div>
        </div>
    </xsl:template>
    
    <xsl:template name="get-js-markers">
         <xsl:variable name="rawMarkers">
            <xsl:call-template name="content-geocode-marker">
                <xsl:with-param name="data" select="content"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="markers" select="exslt:node-set($rawMarkers)"/>
        
        <xsl:text>[</xsl:text>        
        <xsl:if test="$markers/markers/marker">
            <xsl:choose>
               <xsl:when test="$markers/markers/marker[@holder = 'geoCode']">
                    {lat: <xsl:value-of select="$markers/markers/marker[@holder = 'geoCode']/@lat"/>, lng: <xsl:value-of select="$markers/markers/marker[@holder = 'geoCode']/@lng"/>}
               </xsl:when>
               <xsl:when test="$markers/markers/marker[@holder = 'campus']">
                    <xsl:for-each select="$markers/markers/marker[@holder = 'campus']">
		                {lat: <xsl:value-of select="@lat"/>, lng: <xsl:value-of select="@lng"/>}
		                <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
		            </xsl:for-each>
               </xsl:when>
               <xsl:when test="$markers/markers/marker[@holder = 'place']">
                    <xsl:for-each select="$markers/markers/marker[@holder = 'place']">
                        {lat: <xsl:value-of select="@lat"/>, lng: <xsl:value-of select="@lng"/>}
                        <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
                    </xsl:for-each>
               </xsl:when>
            </xsl:choose>     
        </xsl:if>
        <xsl:text>]</xsl:text>       
    </xsl:template>
       
</xsl:stylesheet>