<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="math ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/user-password/password_3.5.xsl"/>
    
    <xsl:template name="common-service-head-css">
    	<link rel="stylesheet" href="{ametys:skinURL('zones/profile/scss/main.css')}"/>
		<link rel="stylesheet" href="{ametys:skinURL('zones/profile/scss/print.css')}"/>
	</xsl:template>
	
	<xsl:template name="common-service-head-js">
		<script src="{ametys:skinURL('templates/common/plugins/jquery-validation/dist/jquery.validate.js')}"></script>
		<script src="{ametys:skinURL('templates/common/plugins/chosen/chosen.jquery.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/components/hs.select.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/components/hs.validation.js')}"></script>
        
        <xsl:call-template name="strong-password-head-js"/>
	</xsl:template>
	
	<xsl:template name="common-service-body-nonempty-content-title"/>
    
   <xsl:template name="common-service-body-nonempty-content-content">
        <div class="ametys-profile-content pb-0">
            <xsl:choose>
                <xsl:when test="$status = 'success' and $step != 'password'">
                	<div class="container">
    					<div class="tab-content mt-5">
                    		<xsl:call-template name="success-message"/>
                    	</div>
                    </div>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="pwd-form"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="pwd-form">
				
		<h1 class="ametys-page-title"><xsl:value-of select="$header"/></h1>
		
    	<xsl:call-template name="pwd-form-hint-message"/>
        
        <xsl:call-template name="global-error-messages"/>
        
        <xsl:call-template name="error-messages"/>
		
		<!-- $step = 'no-form' => Only error messages. -->
    				<xsl:if test="$step != 'no-form'">
			<form method="post" id="password-{$uniqueId}-form">
                <xsl:if test="$current-page-id != ''">
                    <xsl:attribute name="action">
                        <xsl:value-of select="resolver:resolve('page', $current-page-id)"/>
                    </xsl:attribute>
                </xsl:if>
                
                <xsl:choose>
                       <xsl:when test="$step = 'lost-password' or $step = 'lost-password-change'">
                           <xsl:call-template name="lost-password-fields">
                               <xsl:with-param name="uniqueId" select="$uniqueId"/>
                           </xsl:call-template>
                       </xsl:when>
                       <xsl:when test="$step = 'change-password'  or $step = 'change-password-change'">
                           <xsl:call-template name="connected-change-password-fields">
                               <xsl:with-param name="uniqueId" select="$uniqueId"/>
                           </xsl:call-template>
                       </xsl:when>
                       <xsl:otherwise>
                           <xsl:call-template name="password-form-fields">
                               <xsl:with-param name="uniqueId" select="$uniqueId"/>
                               <xsl:with-param name="login" select="/user-password/@login"/>
                               <xsl:with-param name="population" select="/user-password/@population"/>
                               <xsl:with-param name="token" select="/user-password/@token"/>
                           </xsl:call-template>
                       </xsl:otherwise>
                   </xsl:choose>
                   
                   <!-- Template common for submit button -->
                   <div class="text-center">
                    <xsl:call-template name="common-utils-input-submit">
                        <xsl:with-param name="class-name">btn btn-primary btn-lg btn-wide-alt btn-shadow rounded-0</xsl:with-param>
                        <xsl:with-param name="i18nkey">
                            <xsl:choose>
                                <xsl:when test="$step = 'change-password' or $step = 'change-password-change'">plugin.web:PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_ACTION_CHANGE_PASSWORD</xsl:when>
                                <xsl:otherwise>plugin.web:PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_SUBMIT</xsl:otherwise>
                            </xsl:choose>
                        </xsl:with-param>
                    </xsl:call-template>
				</div>
			</form>
		</xsl:if>
	</xsl:template>
	
    <xsl:template name="population-field">
        <xsl:param name="value"/>
        
        <xsl:variable name="countPopulations" select="count(/user-password/UserPopulations/UserPopulation)"/>
        <xsl:choose>
            <xsl:when test="$countPopulations = 1">
                <input type="hidden" id="population-{$uniqueId}" name="population" value="{/user-password/UserPopulations/UserPopulation/@id}"/>
            </xsl:when>
            <xsl:otherwise>
                <div class="form-group mb-0">
                    <div class="sr-only">
                        <label for="population-{$uniqueId}">
                            <i18n:text i18n:key="plugin.web:PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_POPULATION" i18n:catalogue="plugin.web"/>
                            
                            <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                        </label>
                    </div>
                
                    <xsl:choose>
                        <xsl:when test="$countPopulations > 0">
                            <select id="population-{$uniqueId}" name="population" 
                            	data-placeholder="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_POPULATION"
                                i18n:attr="data-placeholder"
						        data-field-icon="fas fa-folder-open"
						        data-open-icon="fa fa-angle-down"
						        data-close-icon="fa fa-angle-up">
						        <xsl:attribute name="class">
		                           <xsl:text>ametys-form-control-with-icon ametys-form-control--line ametys-form-control--lg</xsl:text>
		                           <xsl:if test="/user-signup/errors/field[@name = 'population']/error"> invalid</xsl:if>
		                       </xsl:attribute>
		                       
                                <xsl:for-each select="/user-password/UserPopulations/UserPopulation">
                                	<xsl:sort select="label"/>
                                	
                                    <option value="{@id}">
                                        <xsl:if test="@id = $value"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
                                        <xsl:copy-of select="label"/>
                                    </option>
                                </xsl:for-each>
                            </select>
                            
                            <script>
								$.HSCore.components.HSSelect.init('select.ametys-form-control-with-icon');
							</script>
                        </xsl:when>
                        <xsl:otherwise>
                            <input type="text" id="population-{$uniqueId}" name="population" value="{$value}"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="login-or-email-field">
        <xsl:param name="value"/>
        
        <div class="form-group mb-10">
            <xsl:if test="/user-signup/errors/field[@name = 'email']/error">
                <xsl:call-template name="error-field" >
                    <xsl:with-param name="error" select="/user-signup/errors/field[@name = 'email']/error" />
                </xsl:call-template>
            </xsl:if>
            
            <div class="sr-only">
                <label for="email-{$uniqueId}">
                    <i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_LOGIN_OR_EMAIL" i18n:catalogue="plugin.web"/>
                    
                    <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                </label>
            </div>
        
            <div>
                <xsl:attribute name="class">
                    <xsl:text>ametys-form-control-with-icon-wrap ametys-form-control-with-icon-wrap--lg</xsl:text>
                    <xsl:if test="/user-signup/errors/field[@name = 'email']/error"> invalid</xsl:if>
                </xsl:attribute>
                <span class="field-icon fas fa-envelope"></span>
                
                <input type="text" id="email-{$uniqueId}" name="email" value="{$value}" class="ametys-form-control-with-icon ametys-form-control--line ametys-form-control--lg" placeholder="plugin.web:PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_EMAIL" i18n:attr="placeholder"/>
            </div>
        </div>
    </xsl:template>
	
	<xsl:template name="password-field">
        <xsl:param name="id"/>
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        <xsl:param name="i18nKey"/>
        <xsl:param name="confirm" select="false()"/>
        <xsl:param name="errors" select="/user-password/errors"/>
        
        <div>
        	<xsl:attribute name="class">
        		<xsl:text>form-group</xsl:text>
        		<xsl:choose>
        			<xsl:when test="$confirm = false()"> mb-0</xsl:when>
        			<xsl:otherwise> mb-10</xsl:otherwise>
        		</xsl:choose>
        	</xsl:attribute>
            <div class="sr-only">
                <label for="{$id}">
                    <i18n:text i18n:key="{$i18nKey}" i18n:catalogue="plugin.web"/>
                    <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                </label>
            </div>
            <div>
                <xsl:attribute name="class">
                    <xsl:text>ametys-form-control-with-icon-wrap ametys-form-control-with-icon-wrap--lg</xsl:text>
                    <xsl:if test="$errors/field[@name = $name]/error"> invalid</xsl:if>
                </xsl:attribute>
                <xsl:choose>
                	<xsl:when test="$confirm = true()">
                		<span class="field-icon fas fa-check"></span>
                	</xsl:when>
                	<xsl:otherwise>
                		<span class="field-icon fas fa-lock"></span>
                	</xsl:otherwise>
                </xsl:choose>
                <input type="password" id="{$id}" name="{$name}" autocomplete="new-password" class="ametys-form-control-with-icon ametys-form-control--line ametys-form-control--lg">
                	<xsl:if test="$i18nKey != ''">
			            <xsl:attribute name="placeholder"><xsl:value-of select="$i18nKey"/></xsl:attribute>
			            <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
			        </xsl:if>
               		<xsl:if test="$value != ''"><xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute></xsl:if>
                </input>
            </div>
        </div>
    </xsl:template>
	
	<xsl:template name="global-error-messages">
        <xsl:if test="count(/user-password/errors/global/error) > 0">
            <div class="g-color-red">
                <ul class="list-unstyled">
                    <xsl:if test="count(/user-password/errors/global/error[@type != 'general-error']) > 0">
                        <xsl:variable name="error-type" select="/user-password/errors/global/error[@type != 'general-error']/@type"/>
                        <li class="media">
	        				<i class="fas fa-window-close mr-3"></i>
	        				<div class="media-body">
                            	<i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_CHANGE_PASSWORD_ERROR_{$error-type}" i18n:catalogue="plugin.web"/>
                            </div>
                        </li>
                    </xsl:if>
                    <xsl:if test="/user-password/errors/global/error[@type = 'general-error']">
                        <li class="media">
	        				<i class="fas fa-window-close mr-3"></i>
	        				<div class="media-body">
                            	<i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_CHANGE_PASSWORD_ERROR_GENERAL" i18n:catalogue="plugin.web"/>
                            </div>
                        </li>
                    </xsl:if>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="error-messages">
        <xsl:if test="count(/user-password/errors/field/error) > 0">
            <div class="g-color-red">
                <p>
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_WEB_USER_SIGNUP_FORM_ERROR_TITLE" i18n:catalogue="plugin.web"/>
                        <i18n:param><xsl:value-of select="count(/user-password/errors/field/error)"/></i18n:param>
                    </i18n:translate>
                </p>
                <ul class="list-unstyled">
                    <xsl:for-each select="/user-password/errors/field[@name = 'password' or @name = 'password-confirmation']/error">
                        <li class="media">
	        				<i class="fas fa-window-close mr-3"></i>
	        				<div class="media-body">
	        					<xsl:value-of select="."/>
	        				</div>
	        			</li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
	
</xsl:stylesheet>
